var _cacheDataSelecionada = [];
var _examesDoAtendimento = [];
$(function () {
  var coni_codigo = $("#coni_codigo").val();
  var esp_codigo = $("#esp_codigo_sessao").val();
  var usr_codigo = $("#usr_codigo").val();
  var tat_codigo = $("#tat_codigo").val();
  var proc_codigo = $("#proc_codigo_sessao").val();

  if (esp_codigo != "") {
    mostraEspecialidade();
  }
  if (usr_codigo != "") {
    getTipoAtendimentos();
    getTipoMedico();
    setTimeout(function () {
      mostraTipoConsulta();
    }, 1000)
  }

  if ($("#fiusu_codigo").val() != "") {

    $.ajax({
      url: baseUrl + "/filaespera/filas-usuario/getdado/fiusu_codigo/" + $('#fiusu_codigo').val(),
      type: "POST",
      success: function (txt) {
        if (txt) {

          $("#usu_nome").val(txt.usu_nome);
          $("#usu_codigo").val(txt.usu_codigo);
          return true;
        }
      }


    });
  }

  $("#salvar-agenda").ajaxForm(afterSubmit);

  $("#med_nome").buscar({
    url: baseUrl + '/agenda/convenio/buscar/',
    categoria: 'categoria',
    template: function (ul, item) {
      return $("<li/>").data("item.autocomplete", item).append(
        "<a>" + item.label + "</a>").appendTo(ul);
      },
      callback: mostraMedico
    });

    $("#data").change(function () {
      var usr_codigo = $("#usr_codigo").val();
      if (usr_codigo) {
        $("#atualizar-grid").removeClass("ui-state-disabled");
      } else {
        $("#atualizar-grid").addClass("ui-state-disabled");
      }
    });

    $("#atualizar-grid").click(carregarCalendario);

    $("#esp").change(function () {
      var coni_codigo = $(this).val();
      $("#coni_codigo").val(coni_codigo);
      $.ajax({
        url: baseUrl + "/agendamento/agendamento/buscar-especialidade-por-coni/",
        type: "POST",
        data: {
          coni_codigo: coni_codigo
        },
        success: function (json) {
          for (var i in json) {
            $("#esp_codigo_config").val(json[i]);
          }
        }
      });

      carregarCalendario();
    });

    $(".detalhes").click(function () {
      if ($("#sem-tamanho").val() <= 4) {
        $(".divRolagem").css("height", "auto");
      } else {
        $(".divRolagem").css("height", "250px");
      }
      $("#historico").show("normal");
    });

    $(".detalhes").click(function () {
      if ($("#historico").hasClass("hide")) {
        $("#historico").show("slow");
        $("#historico").removeClass("hide");
      } else {
        $("#historico").hide("slow");
        $("#historico").addClass("hide");
      }
    });

    $(".paciente").click(function () {
      var usu_codigo = $("#usu_codigo").val();
      if (usu_codigo > 1) {
        var link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
      } else {
        link = baseUrl + "/default/paciente/form-paciente/poupup/1";
      }
      window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });

  });

  function carregarHistoricoDoPaciente() {
    $("#botao_historico").show("slow");
    $("#historico").addClass("hide");
    fecharMensagemSemOk("excluindo-agei");
    habilitarOuNaoBotaoSalvar();
    $("#em-historico").html("<img class=\"loading\" src=\"" + baseUrl + "/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando...\" />");
    var url = baseUrl + "/agendamento/agendamento/historico/usu/" + $("#usu_codigo").val();
    $("#historico").load(url, onHistoricoLoad);
  }

  function onHistoricoLoad() {
    // verifica se atendimento já foi usando
    var ate_codigo = $("#ate_codigo").val();
    if (ate_codigo) {
      var usado = $("tr[data-ate_codigo='" + ate_codigo + "'] td")
      .addClass("ui-state-highlight")
      .size();

      if (usado) {
        mensagem("Atenção:", "Este código de atendimento já foi usado.<br /><br />Os itens deste agendamento estão destacados no histórico abaixo.", 400, 180);
      }
    }
    megaBind("#historico");
    // bind do excluir

    $("#em-historico").html(""); // tira img loading
  }

  function excluirAgei(agei_codigo) {
    mensagemSemOk("excluindo-agei", "Excluindo...", "Excluindo exame...", 280, 80);

    $.ajax({
      url: baseUrl + "/agenda/agenda/excluir/",
      type: "POST",
      data: {
        agei_codigo: agei_codigo
      },
      success: carregarHistoricoDoPaciente
    });
  }

  function mostraMedico() {
    $('#escondida').show();
    var conv_codigo = $("#conv_codigo").val();
    $("#usr_nome").buscar({
      url: baseUrl + '/default/usuarios/buscar-profissionais-saude/conv_codigo/' + conv_codigo,
      template: function (ul, item) {
        return $("<li/>").data("item.autocomplete", item).append(
          "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (txt) {
          mostraEspecialidade();
          getTipoMedico();
          setTimeout(
            function () {
              getTipoAtendimentos();
            }, 1000
          );
          setTimeout(
            function () {
              mostraTipoConsulta();
            }, 1000
          );
          return true;
        }
      });
    }

    function getTipoMedico() {
      var usr_codigo = $("#usr_codigo").val();
      $.ajax({
        url: baseUrl + "/default/usuarios/get-tipo-usuario/",
        type: "POST",
        data: {
          usr_codigo: usr_codigo
        },
        success: function (txt) {
          $("#usr_tipo_medico").val(txt);
        }
      });
    }

    function mostraTipoConsulta() {
      var usrTipoMedico = $("#usr_tipo_medico").val();
      var tipoAtendimento = $("#tat_codigo option:selected").val();
      if (usrTipoMedico == "D" && tipoAtendimento != "4") {
        // Se for tipo de atendimento urgência, remove consulta de retorno
        if (tipoAtendimento == "6") {
          $("#tp_consulta2").remove();
        } else {
          if (!$("#tp_consulta2").length) {
            $("#tp_cod").append("<option value=\"2\" id=\"tp_consulta2\">" + " CONSULTA DE RETORNO EM ODONTOLOGIA " + "</option>");
          }
        }
        $("#tipo_consulta").show();
      } else {
        $("#tipo_consulta").hide();
        $("#tp_cod").val('');
      }
    }

    function getTipoAtendimentos() {
      var usrTipoMedico = $("#usr_tipo_medico").val();
      $.ajax({
        url: baseUrl + "/default/usuarios/get-tipo-atendimentos/",
        type: "POST",
        data: {
          usrTipoMedico: usrTipoMedico
        },
        success: function (json) {
          $("#tat_codigo").html("");
          $.each(json, function (key, value) {
            var tipoatendimento = value['tat_codigo'];
            $("#tat_codigo").append("<option title=\"" + value['tat_tipo'] + "\"  value=\"" + value['tat_codigo'] + "\" onclick=\"mostraTipoConsulta()\">" + value['tat_tipo'] + "</option>");
          });
        }
      });
    }

    function mostraEspecialidade() {
      var conv_codigo = $("#conv_codigo").val();
      var usr_codigo = $("#usr_codigo").val();
      var esp_codigo_sessao = $("#esp_codigo_sessao").val();
      var esp_codigo_selecionado = $("#esp_codigo_selecionado").val();
      if (esp_codigo_sessao != null || esp_codigo_sessao != "") {
        var selected = "selected=selected";
      } else {
        var selected = "";
      }
      $.ajax({
        url: baseUrl + '/agenda/convenio-itens/carrega-especialidade-por-convenio',
        type: "POST",
        data: {
          conv_codigo: conv_codigo,
          usr_codigo: usr_codigo
        },
        success: function (json) {
          $("#esp").html("");
          $.each(json, function (key, value) {
            var especialidade = value['esp_codigo'];
            $("#esp_codigo_config").val(especialidade);
            $("#esp").append("<option title=\"" + value['esp_nome'] + "\"  value=\"" + value['coni_codigo'] + "\" " + selected + ">" + value['esp_nome'] + "</option>");
            $("#med_esp").show('slow');
            $("#esp_proc").show('slow');
          });
          var coni_codigo = $('#esp').find('option').filter(':selected').val();
          $("#coni_codigo").val(coni_codigo);

          notificaAgendamento();

          if ($("#coni_codigo").val() == "" || !$("#coni_codigo").val()) {
            $("#med_esp").show('slow');
            $("#med_esp").html("<em>O profissional selecionado não possui especialidade</em>");
            return false;
          } else {
            carregarCalendario();
            mostraProcedimento();
          }
        }
      });

    }

    function mostraProcedimento() {
      var esp_codigo = $("#esp_codigo_config").val();
      $.ajax({
        url: baseUrl + '/agendamento/agendamento/buscar-procedimento-por-especialidade',
        type: "POST",
        data: {
          esp_codigo: esp_codigo
        },
        success: function (json) {
          $("#proc").html("");
          json.forEach(function (valor) {
            $("#proc").append("<option title=\"" + valor['proc_nome'] + "\"  value=\"" + valor['proc_codigo'] + "\">" + valor['proc_nome'] + "</option>");
          });
        }
      });
    }

    function salvarAgendamento() {
      if ($(".salvar").hasClass("ui-state-disabled") == false) {
        mensagemSemOk("salvando-age", "Salvando...", "Salvando Agendamento ...", 280, 80);
      }
    }

    function afterSubmit(json) {
      fecharMensagemSemOk("salvando-age");

      if (!json.success) {
        mensagem(json.titulo, json.mensagem, 300, 150, function () {
          carregarCalendario
        });
        return;
      } else {
        $("body").append("<div id=\"mensagem-dialog\" title=\"Sucesso\">Paciente agendado com sucesso!<br /><br />Deseja imprimir a guia de agendamento?</div>");
        $("#mensagem-dialog").dialog({
          modal: true,
          width: 290,
          height: 180,
          close: function () {
            if ($('#fiusu_codigo').val() != "") {
              window.location.href = baseUrl + "/filaespera/filas-usuario/buscar/fila/" + json.fila_codigo;
            } else {
              window.location.href = baseUrl + "/agendamento/index/";
            }
            $(this).remove();
          },
          buttons: {
            Sim: function () {
              var p_horario = "";
              if ($("#imprimir_primeiro_horario").val() == 1) {
                p_horario = $("#primeiro_horario").val();
              }
              popup(baseUrl + "/agendamento/agendamento/imprimir/age/" + json.age_codigo + "/p_horario/" + p_horario, "imprimir-agenda", 600, 500);
              $(this).dialog('close');
            },
            "Não": function () {
              $(this).dialog('close');
            }
          }
        });

        // $.ajax({
        //   url: baseUrl + "/agendamento/agendamento/get-dados-agendamento-interno/age_codigo/" + json.age_codigo,
        //   type: "POST",
        //   success: function (txt) {
        //     $.ajax({
        //       url: './rest/saude/agentic/agendamento/cadastrar',
        //       type: 'POST',
        //       data: {
        //         access_token: txt.access_token,
        //         dataAlteracao: txt.dataAlteracao,
        //         dataCadastro: txt.dataCadastro,
        //         dataAgendamento: txt.dataAgendamento,
        //         celular: txt.celular,
        //         hora: txt.hora,
        //         tipo: txt.tipo,
        //         status: txt.status,
        //         realizada: txt.realizada,
        //         codigoEmpresa: txt.codigoEmpresa,
        //         codigoPaciente: txt.codigoPaciente,
        //         codigoMedico: txt.codigoMedico,
        //         codigoPrestador: txt.codigoPrestador
        //       },
        //       success: function(resp) {
        //         if (resp.response.mensagem === 'OK') {
        //           console.log('funfou');
        //         }
        //       }
        //     });
        //   }
        // });
      }
    }

    function carregarCalendario() {
      // desabilitar btn salvar
      $(".salvar").addClass("ui-state-disabled");
      $("#horario").hide("fast");
      var selecionado = $("#usr_codigo").val();
      var coni_codigo = $("#coni_codigo").val();
      if (selecionado.length == 1 && selecionado[0] == 0) {
        $("#calendario").html("<em>Selecione algum Profissional</em>");
        return;
      }

      $("#calendario").html(imgCarregando());
      var url = baseUrl + "/agendamento/agendamento/selecionar-data/prof/" + selecionado + "/de/" + brToSql($("#data").val()) + "/coni_codigo/" + coni_codigo;
      $("#calendario").load(url, bindCalendario);
    }

    function carregarHorario() {
      // desabilitar btn salvar

      $(".salvar").addClass("ui-state-disabled");

      var selecionado = $("#usr_codigo").val();
      var coni_codigo = $("#coni_codigo").val();
      var conv_codigo = $("#conv_codigo").val();
      var data_selecionada = $(".hidden-coni").val();

      if (selecionado.length == 1 && selecionado[0] == 0) {
        return;
      }

      $("#horario").html(imgCarregando());

      var url = baseUrl + "/agendamento/agendamento/selecionar-horario/prof/" + selecionado + "/ds/" + brToSql(data_selecionada) + "/coni_codigo/" + coni_codigo + "/conv_codigo/" + conv_codigo;

      $("#horario").load(url, bindHorario);
    }

    /**
    * Adicionar eventos no grid
    */
    function bindHorario() {
      $("#grade tr td[data-hora]").hover(function () {
        var data = $(this).data("hora");
        $("td[data-hora=" + data + "]").addClass("destaque");

      }, function () {
        var data = $(this).data("hora");
        $("td[data-hora=" + data + "]").removeClass("destaque");

      })
      .click(marcarHora)
      .disableSelection();

      $(".sem-vaga").each(function () {
        var obj = $(this);
        var index = obj.data("index");
        var paciente = $(this).data("paciente");
        if ($(this).hasClass("sem-vaga") && paciente != null) {
          var html = "<div><strong>Pacientes: </strong>" + paciente + "<br />";
          obj.easyTooltip({
            content: html
          });
        }
      });
      carregaValoresAntigos();
    }

    function bindCalendario() {
      $("#grade tr th").slice(1, 2).html("Selec.");

      $("[data-dow='0'],[data-dow='6']").each(function () {// cada domingo e sábado
        var index = $(this).data("index");
        var dow = $(this).data("dow");

        $("[data-index='" + index + "']:not(.com-vaga)").addClass("dow" + dow);
      })

      $("#grade tr td[data-dia]").hover(function () {
        var data = $(this).data("dia");
        $("td[data-dia=" + data + "]").addClass("destaque");

      }, function () {
        var data = $(this).data("dia");
        $("td[data-dia=" + data + "]").removeClass("destaque");

      })
      .click(marcarDia)
      .disableSelection();

      $(".com-vaga,.sem-vaga").each(function () {
        var obj = $(this);
        var index = obj.data("index");
        var dow = $("[data-dow][data-index='" + index + "']").data("dow");
        var semana = ["Domingo", "Segunda", "Terça", "Quarta", "Quinta", "Sexta", "Sábado"];
        var proc_nome = obj.parents("tr").find("th").html();

        var vagas = obj.data("vagas");
        vagas = (vagas == -1) ? "&infin; ilimitadas" : vagas;

        var html = "<div><strong>Profissional: </strong>" + proc_nome + "<br />";
        html += "<strong>Data: </strong>" + dataToBr(obj.data("dia")) + " (" + semana[dow].toLowerCase() + ")<br />";
        html += "<strong>Vagas: </strong>" + vagas + "</div>";

        obj.easyTooltip({
          content: html
        });
      });

      carregaValoresAntigos();
    }

    function carregaValoresAntigos() {
      $.each(_cacheDataSelecionada, function (coni_codigo, data) {
        if (coni_codigo) {
          $("#coni_" + coni_codigo).val(data);
          var dataSql = brToSql(data);
          $("[data-dia='" + dataSql + "'][data-coni='" + coni_codigo + "']").html("<img src=\"" + baseUrl + "/public/images/icons/accept.png\" width=\"12px\" />");
        }
      });

      habilitarOuNaoBotaoSalvar()
    }

    function marcarDia() {
      $("#horario").show("fast");
      if ($(this).hasClass("sem-vaga")) {
        return;
      }

      if ($(this).hasClass("com-vaga")) {
        var coni = $(this).data("coni");
        var data = $(this).data("dia");

        $("[data-coni=" + coni + "]").html("&nbsp;"); // limpa todos da mesma linha
        $("#coni_" + coni).val(dataToBr(data)); // salva a data em um input hidden (está junto do nome do exame)
        $("#age_data").val(data);
        _cacheDataSelecionada[coni] = dataToBr(data);
        $(this).html("<img src=\"" + baseUrl + "/public/images/icons/accept.png\" width=\"12px\" />");
        var coni_codigo = $("#coni_codigo_selecionado").val();
        carregarHorario();
      }
    }

    function habilitarOuNaoBotaoSalvar() {
      var tudo_ok = true;

      // verificar se há paciente seleciondo:
      if ($("#usu_codigo").val() == "") {
        tudo_ok = false;
      }

      if ($("#tat_codigo").val() == "") {
        tudo_ok = false;
      }

      // verificar se há médico solicitante seleciondo:
      if ($("#usr_codigo").val() == "") {
        tudo_ok = false;
      }

      if ($("#conv_codigo").val() == "") {
        tudo_ok = false;
      }

      // verificar se há procedimentos selecionados:

      // verifica se há data selecionada para todos os exames escolhidos
      $(".hidden-coni").each(function () {
        if ($(this).val() == "" || $(this).val() == "1") {
          tudo_ok = false;
        }
      });

      if ($(".marcada").html() == null) {
        tudo_ok = false;
      }

      if ($("#tat_codigo").val() == "") {
        tudo_ok = false;

      }

      if ($("#usr_tipo_medico").val() == "D") {
        if ($("#tp_cod").val() == "" && $("#tat_codigo").val() == 2) {
          tudo_ok = false;
        }
      }

      if (tudo_ok) {
        $(".salvar").removeClass("ui-state-disabled");
      } else {
        $(".salvar").addClass("ui-state-disabled");
      }
    }

    function getProcedimentosSelecionados() {
      var selecionados = [];

      $("#procedimentos-selecionados option").each(function () {
        selecionados.push($(this).val());
      });

      return selecionados;
    }

    function marcarHora() {
      if ($(this).hasClass("sem-vaga")) {
        return;
      }

      if ($(this).hasClass("encaixe")) {
        $("#horario_de_encaixe").val("S");
      } else {
        $("#horario_de_encaixe").val("N");
      }

      if ($(this).hasClass("com-vaga")) {
        var coni = $(this).data("coni");
        var data = $(this).data("hora");

        $("[data-coni=" + coni + "]").html("&nbsp;"); // limpa todos da mesma linha
        $("#coni_" + coni).val(dataToBr(data)); // salva a data em um input hidden (está junto do nome do exame)
        _cacheDataSelecionada[coni] = dataToBr(data);

        $(".hora_per").each(function (i) {
          $(this).html($(this).data("hora").replace("_", ":"));
          $(this).addClass("com-vaga");
          if ($(this).hasClass("remover_encaixe")) {
            $(this).addClass("encaixe");
          }
          $(this).removeClass("marcada");
        });

        data = data.replace("_", ":");
        $(this).html(data);
        $(this).addClass("marcada");
        $(this).removeClass("com-vaga");
        $(this).removeClass("encaixe");
        $("#age_horario").val(data);
      }
      habilitarOuNaoBotaoSalvar();
    }

    function retornaPac(usu_codigo, usu_nome) {
      $("#usu_codigo").val(usu_codigo);
      $("#usu_nome").val(usu_nome);
    }
