var atend = 0;
var ciap = 0;
var tipoAtend = "";
$(function () {

    exibeInfoPaciente();
    exibeEstratificacaoRadio('diabetico', 'estrat_diabetes', 'risco_diabetes');
    exibeEstratificacaoRadio('gestante', 'estrat_gestante', 'risco_gestacao');
    exibeEstratificacaoRadio('hipertensao', 'estrat_hipertensao', 'risco_hipertensao');
    exibeEstratificacaoIdade();
    carregarDadosEspeciaisPaciente($('#usu_codigo').val());
    checaSexoGestante();

    $("#erro").hide();
    $("#uni_desc").focus();
    $("#cid_principal_erro").hide();
    $("#A").hide();
    $("#V").hide();
    $("#P").hide();
    $("#atetipo_label").hide();
    $("#A_label").hide();
    $("#B_label").hide();
    $("#C_label").hide();

    if ($("#tipo_atendimento").val() == "V") {
        $('#V').attr("checked", "checked");
    } else if ($("#tipo_atendimento").val() == "A") {
        $('#A').attr("checked", "checked");
    } else if ($("#tipo_atendimento").val() == "P") {
        $('#P').attr("checked", "checked");
    }

    $("#div_tipo_imovel").hide();
    $("#st_fora_area_div").hide();
    $("#st_visita_compartilhada_div").hide();
    verificaTipoAtentimento('#tipo_atendimento');
    carregaEspecialidade();
    ValidaTipoImovel();

    $("#ds_ciap").buscar({
        url: baseUrl + '/prontuario/atendimento/buscar-ciap/',
        suffix: '_2',
        search: function () {
            $("#ciap").empty();
        },
        template: function (ul, item) {
            ul.hide();
            $("<option />").val(item.id).html(item.label).appendTo("#ciap");
            return false;
        },
        callback: function (event, ui) {
            $("#ciap").focus();
        }
    });

    $("#ciap")
        .bind('dblclick', selecionarCiap)
        .bind('keydown', selecionarCiap);

    $("#ciap-selecionados")
        .bind('dblclick', deselecionarCiap)
        .bind('keydown', deselecionarCiap);

    $.validator.addMethod("validaVisitaDesfecho", function (validaVisitaDesfecho, element) {
        if ($("input[name=ate_tipo_atendimento]:checked").val() != "V") {
            return true;
        }
        if ($("input[name=visita_desfecho]:checked").val() == "1" || $("input[name=visita_desfecho]:checked").val() == "2" || $("input[name=visita_desfecho]:checked").val() == "3") {
            if ($("input[name=visita_desfecho]:checked").val() != "1") {
                $("#vd_peso").val("");
                $("#vd_altura").val("");
            }
            return true;
        }
        return false;
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaVisitaMotivo", function (validaVisitaDesfecho, element) {
        if ($("input[name=ate_tipo_atendimento]:checked").val() == "V") {
            var count = $('input:checkbox:checked').length;
            if ($("input[name=visita_desfecho]:checked").val() == 1) {
                if (count > 0) {
                    return true;
                }
                return false;
            }
            return true;
        }
        return true;
    }, "Campo Obrigatório!");

    if ($("#tipo_atendimento").val() == "A") {
        $("#ate-simplificado").validate({
            rules: {
                conf_visita: {required: true},
                conf_cond: {required: true},
                uni_codigo: {required: true},
                usu_codigo: {required: true},
                usr_codigo: {required: true},
                proc_codigo: {required: true},
                conf_desfecho: {required: true},
                cd10_codigo: {
                    required: function () {
                        selecionarTodosOsCiapSelecionados();
                        //console.log("ciap-selecionados = " + $("#ciap-selecionados option:first").val());
                        if ($("#ciap-selecionados option:first").val() != '0' && $("#ciap-selecionados option:first").val() != undefined) {
                            $("#erro").html('');
                            $("#erro").hide();
                            return false;
                        } else {
                            if (atend > 0) {
                                $("#erro").html('');
                                $("#erro").hide();
                                return false;
                            } else {
                                $("#erro").html('Selecione um CID atendimento ou CIAP.');
                                $("#erro").show();
                            }
                        }
                        return true;

                    }
                },
                data_valida: {required: true},
                cod_equipe: {
                    required: function () {
                        return obrigatoriedadeEquipe();
                    }
                }
            },
            messages: {
                conf_visita: {required: "Selecione o motivo da visita."},
                conf_cond: {required: "Selecione uma Conduta."},
                uni_codigo: {required: "Selecione uma Unidade."},
                usu_codigo: {required: "Selecione um Paciente."},
                usr_codigo: {required: "Selecione um Profissional."},
                proc_codigo: {required: "Selecione um Procedimento."},
                cd10_codigo: {required: ""},
                data_valida: {required: "Data inválida."},
                cod_equipe: {required: "Selecione uma Equipe."}
            }
        });
    }
    else if ($("#tipo_atendimento").val() == "V") {
        $("#ate-simplificado").validate({
            rules: {
                conf_visita: {required: true},
                conf_ciap: {required: true},
                conf_cond: {required: true},
                uni_codigo: {required: true},
                usu_codigo: {required: true},
                usr_codigo: {required: true},
                proc_codigo: {required: true},
                conf_desfecho: {required: true},
                cd10_codigo: {required: true},
                data_valida: {required: true},
                cod_equipe: {
                    required: function () {
                        return obrigatoriedadeEquipe();
                    }
                },
                usu_microarea: {
                    required: function () {
                        return obrigatoriedadeMicroarea();
                    }
                }
            },
            messages: {
                conf_visita: {required: "Selecione o motivo da visita."},
                conf_ciap: {required: "Selecione um Ciap."},
                conf_cond: {required: "Selecione uma Conduta."},
                uni_codigo: {required: "Selecione uma Unidade."},
                usu_codigo: {required: "Selecione um Paciente."},
                usr_codigo: {required: "Selecione um Profissional."},
                proc_codigo: {required: "Selecione um Procedimento."},
                conf_desfecho: {required: "Selecione um Desfecho."},
                data_valida: {required: "Data inválida."},
                cod_equipe: {required: "Selecione uma Equipe."},
                usu_microarea: {required: "Selecione uma Microarea ou marque Fora de Area."}
            }
        });
    }
    else if ($("#tipo_atendimento").val() == "P") {
        $("#ate-simplificado").validate({
            rules: {
                conf_visita: {required: true},
                conf_ciap: {required: true},
                conf_cond: {required: true},
                uni_codigo: {required: true},
                usu_codigo: {required: true},
                usr_codigo: {required: true},
                conf_desfecho: {required: true},
                cd10_codigo: {required: true},
                data_valida: {required: true},
                cod_equipe: {
                    required: function () {
                        return obrigatoriedadeEquipe();
                    }
                },
                proc_codigo: {
                    required: function () {
                        return verificaProcedimentoFicha();
                    }
                }
            },
            messages: {
                conf_visita: {required: "Selecione o motivo da visita."},
                conf_ciap: {required: "Selecione um Ciap."},
                conf_cond: {required: "Selecione uma Conduta."},
                uni_codigo: {required: "Selecione uma Unidade."},
                usu_codigo: {required: "Selecione um Paciente."},
                usr_codigo: {required: "Selecione um Profissional."},
                conf_desfecho: {required: "Selecione um Desfecho."},
                data_valida: {required: "Data inválida."},
                cod_equipe: {required: "Selecione uma Equipe."},
                proc_codigo: {required: "Selecione um procedimento ou marque um procedimento da ficha."}
            }
        });
    }
    else {
        $("#ate-simplificado").validate({
            rules: {
                conf_visita: {required: true},
                conf_ciap: {required: true},
                conf_cond: {required: true},
                uni_codigo: {required: true},
                usu_codigo: {required: true},
                usr_codigo: {required: true},
                proc_codigo: {required: true},
                conf_desfecho: {required: true},
                cd10_codigo: {required: true},
                data_valida: {required: true},
                cod_equipe: {
                    required: function () {
                        return obrigatoriedadeEquipe();
                    }
                }
            },
            messages: {
                conf_visita: {required: "Selecione o motivo da visita."},
                conf_ciap: {required: "Selecione um Ciap."},
                conf_cond: {required: "Selecione uma Conduta."},
                uni_codigo: {required: "Selecione uma Unidade."},
                usu_codigo: {required: "Selecione um Paciente."},
                usr_codigo: {required: "Selecione um Profissional."},
                proc_codigo: {required: "Selecione um Procedimento."},
                conf_desfecho: {required: "Selecione um Desfecho."},
                data_valida: {required: "Data inválida."},
                cod_equipe: {required: "Selecione uma Equipe."}
            }
        });
    }

    $(".ate_tipo_atendimento").change(function () {
    });

    $(".paciente").click(function () {
        var usu_codigo = $("#usu_codigo").val();
        if (usu_codigo > 1) {
            var link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
        } else {
            link = baseUrl + "/default/paciente/form-paciente/poupup/1";
        }
        window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });

    //Habilita ou desabilita checkboxes do motivo da visita de acordo com o desfecho
    $(".desfecho").change(function () {
        if ($(this).val() == 2 || $(this).val() == 3) {
            $(".motivo_checkbox").each(function () {
                $(this).prop("checked", false);
                $(this).attr("disabled", true);
                $("#conf_visita").val("1");
            });
        } else {
            $(".motivo_checkbox").each(function () {
                $(this).removeAttr("disabled");
            });
            validaMotivoVisita();
            ValidaTipoImovel();
        }
    });

    if ($("#visita_desfecho").is(':visible')) {
        if ($("input[name=visita_desfecho]:checked").val() == 2 || $("input[name=visita_desfecho]:checked").val() == 3) {
            $(".motivo_checkbox").each(function () {
                $(this).prop("checked", false);
                $(this).attr("disabled", true);
                $("#conf_visita").val("1");
            });
        } else {
            $(".motivo_checkbox").each(function () {
                $(this).removeAttr("disabled");
            });
            validaMotivoVisita();
            ValidaTipoImovel();
        };
    };

    //Habilita ou desabilita checkboxes do motivo de acordo com o tipo de imóvel
    $("#tipo_imovel").change(function () {
        ValidaTipoImovel();
    });

    $("#cid").change(function () {
        $.ajax({
            url: baseUrl + '/prontuario/cid/search-cid',
            data: {cd10_codigo: $("#cid").val()},
            success: function (txt) {
                var descricaocid = txt["cd10_descricao"];
                var codigocid = txt["cd10_codigo_cid"];
                $("#procAtendSimp" + $("#proc_codigo").val()).append("\n\
              <div class='procAtendSimp' id='procCidAtendSimp" + $("#proc_codigo").val() + "' " + cidVisible() + ">\n\
                    <span class='titProcAtendSimp'>\n\
                    CID: " + codigocid + " - " + descricaocid.substr(0, 42) + "...\n\
                    </span>\n\
                </div>\n\
                ");
                $("#cid").html("<option value='0'>-- Selecione um procedimento --</option>");
                $("#cid").attr("disabled", "disabled");
                limparCampos();
            }
        });
    });

    $("#usr_nome").change(function () {
        carregaIne();
    });

    if ($("#usr_nome").val() != "") {
        carregaIne();
    }
    ;

    validaConduta();
});

function obrigatoriedadeEquipe() {
    if ($('#cod_equipe:selected').val() == '' || $('#cod_equipe:selected').val() == undefined) {
        return true;
    } else {
        return false;
    }
}

function obrigatoriedadeMicroarea() {
    if (($('#st_fora_area:selected').val() == '' || $('#st_fora_area:selected').val() == undefined) &&
        ($('#st_fora_area:checked').val() == 't' || $('#st_fora_area:checked').val() == undefined)) {
        return true;
    } else {
        return false;
    }
}

function ValidaTipoImovel() {
    var desabilita = ["2", "3", "4", "5", "6", "12"];
    var valor = $("#tipo_imovel option:selected").val();
    for (var i = 0; i < desabilita.length; i++) {
        if (valor == desabilita[i]) {
            $(".motivo_checkbox").each(function () {
                $(this).attr("disabled", true);
            });
            $("#visita_motivo_1").attr("disabled", false);
            $("#visita_motivo_34").attr("disabled", false);
            $("#visita_motivo_35").attr("disabled", false);
            $("#visita_motivo_36").attr("disabled", false);
            $("#visita_motivo_37").attr("disabled", false);
            $("#visita_motivo_27").attr("disabled", false);
            $("#visita_motivo_28").attr("disabled", false);
            $("#visita_motivo_31").attr("disabled", false);
            break;
        } else {
            $(".motivo_checkbox").each(function () {
                $(this).attr("disabled", false);
            });
        }
    }
}

function buscaProfissional() {
    var tipo_atend = $("#tipo_atendimento").val();
    var uni_codigo = $("#uni_codigo").val();
    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar/tipo/' + tipo_atend + '/unidade/' + uni_codigo + '/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            carregaEspecialidade();
        }
    });
}


function cidVisible() {
    if ($("#cid").val() > 0) {
        return '';
    }
    return 'style="display: none;"';
}

function selecionarTodosOsCiapSelecionados() {
    var optionlist = document.getElementById('ciap-selecionados').options;
    if (optionlist.length > 0) {
        validaData();
        ciap = 0;
        for (var option = 0; option < optionlist.length; option++) {
            if (option == 1) {
                $("#conf_ciap").val("1");
            }
            optionlist[option].selected = true;
            ciap++;
        }
    }

}

function verificaTipoAtentimento(e) {
    if ($(e).val() == "V") {
        $("#visita_domiciliar").show();
        $("#div_tat_codigo").hide();
        $("#conduta").hide();
        $("#ciap-div").hide();
        $("#div_local").hide();
        $("#conf_ciap").val("1");
        $("#nasf-div").hide();
        $("#conf_cond").val("1");
        $("#tipo_atendimento").val("V");
        $("#div_tipo_imovel").show();
        $("#microarea").show();
        $("#equipe").show();
        $("#st_visita_compartilhada_div").show();
        $("#div_exames").hide();
        tipoAtend = "V";
        validaMotivoVisita();
        validaDesfecho();
    } else if ($(e).val() == "A") {
        $("#div_local").show();
        $("#visita_domiciliar").hide();
        $("#div_tat_codigo").show();
        $("#conduta").show();
        $("#ciap-div").show();
        $("#conf_ciap").val("");
        $("#conf_cond").val("");
        $("#conf_visita").val("1");
        $("#conf_desfecho").val("1");
        $("#tipo_atendimento").val("A");
        $("#nasf-div").show();
        $("#div_tipo_imovel").hide();
        $("#microarea").hide();
        $("#equipe").hide();
        $("#st_visita_compartilhada_div").hide();
        $("#div_exames").show();
        tipoAtend = "A";
        validaTipoConduta();
    } else if ($(e).val() == "P") {
        $("#nasf-div").hide();
        $("#conduta").hide();
        $("#visita_domiciliar").hide();
        $("#ciap-div").hide();
        $("#div_local").show();
        $("#div_tat_codigo").hide();
        $("#conf_ciap").val("1");
        $("#conf_cond").val("1");
        $("#conf_visita").val("1");
        $("#conf_desfecho").val("1");
        $("#tipo_atendimento").val("P");
        $("#div_tipo_imovel").hide();
        $("#microarea").hide();
        $("#equipe").hide();
        $("#st_visita_compartilhada_div").hide();
        $("#div_exames").hide();
        tipoAtend = "P";
    }

    if ($("#conf_ciap_controle").val() == '1') {
        $("#conf_ciap").val("1");
    }
}

function verificaTipoAtentimentoAoCarregar(e) {
    if (e === "V") {
        $("#visita_domiciliar").show();
        $("#div_tat_codigo").hide();
        $("#conduta").hide();
        $("#ciap-div").hide();
        $("#div_local").hide();
        $("#conf_ciap").val("1");
        $("#nasf-div").hide();
        $("#conf_cond").val("1");
        $("#tipo_atendimento").val("V");
        $("#div_tipo_imovel").show();
        $("#st_fora_area_div").show();
        $("#st_visita_compartilhada_div").show();
        $("#div_exames").hide();
        validaMotivoVisita();
        validaDesfecho();
    } else if (e === "A") {
        $("#div_local").show();
        $("#visita_domiciliar").hide();
        $("#div_tat_codigo").show();
        $("#conduta").show();
        $("#ciap-div").show();
        $("#conf_ciap").val("");
        $("#conf_cond").val("");
        $("#conf_visita").val("1");
        $("#conf_desfecho").val("1");
        $("#tipo_atendimento").val("A");
        $("#nasf-div").show();
        $("#div_tipo_imovel").hide();
        $("#st_fora_area_div").hide();
        $("#st_visita_compartilhada_div").hide();
        $("#div_exames").show();
        validaTipoConduta();
    } else if (e === "P") {
        $("#nasf-div").hide();
        $("#conduta").hide();
        $("#visita_domiciliar").hide();
        $("#ciap-div").hide();
        $("#div_local").show();
        $("#div_tat_codigo").hide();
        $("#conf_ciap").val("1");
        $("#conf_cond").val("1");
        $("#conf_visita").val("1");
        $("#conf_desfecho").val("1");
        $("#tipo_atendimento").val("P");
        $("#div_tipo_imovel").hide();
        $("#st_fora_area_div").hide();
        $("#st_visita_compartilhada_div").hide();
        $("#div_exames").hide();
    }

    if ($("#conf_ciap_controle").val() == '1') {
        $("#conf_ciap").val("1");
    }
}

function validaMotivoVisita() {
    var cont = 0;
    $("#visita_domiciliar").find("input[type=checkbox][name='visita_motivo[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_visita").val("");
    } else {
        $("#conf_visita").val(cont);
    }
}

function validaDesfecho() {
    var cont = 0;
    $("#visita_domiciliar").find("input[type=radio][name='visita_desfecho']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_desfecho").val("");
    } else {
        $("#conf_desfecho").val(cont);
    }
}

function validaTipoConduta() {
    var cont = 0;
    $("#conduta").find("input[type=checkbox][name='conduta[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_cond").val("");
    } else {
        $("#conf_cond").val(cont);
    }
}

function selecionarCiap(e) {


    $("#conf_ciap").val("1");
    // só pode ser a tecla 39 (seta para direita)
    if (e.keyCode && e.keyCode != 39 || e.charCode)
        return;

    if (!$("#ciap option:selected").size())
        return;

    // se o primeiro for 0, limpar select
    if ($("#ciap-selecionados option:first").val() == "0") {
        $("#ciap-selecionados").empty();
    }

    $("#ciap-selecionados").append(
        $("#ciap option:selected")
    );
}

function deselecionarCiap(e) {
    // só pode ser a tecla 39 (seta para esquerda)
    if (e.keyCode && e.keyCode != 37 || e.charCode)
        return;

    $("#ciap-selecionados option:selected").remove();

    if ($("#ciap-selecionados option").size() == 0) {
        $("#ciap-selecionados").empty().append('<option value="0" disabled="disabled">Nenhum ciap selecionado</option>');
        $("#conf_ciap").val("");
    }
}

function buscaPaciente() {
    var tipo_busca = $("#tipo_busca").val();
    $("#usu_nome").buscar({
        url: baseUrl + '/paciente/buscar/tipo_busca/' + tipo_busca,
        callback: function () {
            return true;
        }
    });
}

function buscarExames() {

    if ($("#exame_solicitado" + $("#exame_codigo").val()).prop("checked") == false &&
        $("#exame_avaliado" + $("#exame_codigo").val()).prop("checked") == false &&
        $("#exame_codigo").val() != '') {
        alert('Para selecionar mais um exame, deve-se informar se o selecionado é solicitado ou avaliado!');
        return;
    }

    $("#exame_nome").buscar({
        url: baseUrl + "/procedimento/buscar-exames/",
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            adicionarExames();
            limparCamposExame();
        }
    });
}

function validaExames(e) {

    var b = $('[id*="exame_solicitado"]');
    b.each(function () {
        if ($("#" + this.id).prop("checked") == false && $("#" + this.id.replace("exame_solicitado", "exame_avaliado")).prop("checked") == false) {
            alert('Para selecionar mais um exame, deve-se informar se o selecionado é solicitado ou avaliado!');
            e.preventDefault();
            e.stopPropagation();
            return false;
        }
    });

    return true;

}

function adicionarExames() {

    $("#dadosExames").append("\
        <div id='procExamSimp" + $("#exame_codigo").val() + "'>\n\
            <div class='procAtendSimp' style='width: 416px; float: left'>\n\
                <span class='titProcAtendSimp'>\n\
                    " + $("#exame_cod_sus").val() + " - " + $("#exame_nome").val().substr(0, 32) + " ..\n\
                </span>\n\
                <div class='excProcAtendSimp'>\n\
                    <img src='" + baseUrl + "/public/images/icons/excluir.png' onclick='excluiExame(" + $("#exame_codigo").val() + ")' style='cursor: pointer' />\n\
                    <input type='hidden' name='exame[]' value='" + $("#exame_codigo").val() + "' />\
                </div>\
            </div>\
            <div style='width: 100% !important; text-align: right; display: inline-block;'>\
                <input style=' height:24px; vertical-align: middle;' type='checkbox' id='exame_solicitado" + $("#exame_codigo").val() + "' name='exame_solicitado[" + $("#exame_codigo").val() + "]' value='S" + $("#exame_codigo").val() + "'/> <small>Solicitado</small>\
                <input style=' height:24px; vertical-align: middle;' type='checkbox' id='exame_avaliado" + $("#exame_codigo").val() + "' name='exame_avaliado[" + $("#exame_codigo").val() + "]' value='A" + $("#exame_codigo").val() + "'/> <small>Avaliado</small>\
            </div>\
        </div>"
    );
}

function limparCamposExame() {
    $("#exame_nome").val("");
}

function validacoesExamesCk(idElemento) {
    if (idElemento == 'exame_solicitado') {
        if ($("#exame_solicitado").prop("checked")) {
            $("#exame_avaliado").attr("checked", false);
        }
    } else {
        if ($("#exame_avaliado").prop("checked")) {
            $("#exame_solicitado").attr("checked", false);
        }
    }
}

function buscaProcedimentos() {
    $("#proc_nome").buscar({
        url: baseUrl + "/procedimento/buscar/esp/" + $("#esp_codigo").val() + "/",
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            var url = baseUrl + "/prontuario/cid/procedimento/id/" + $("#proc_codigo").val();
            $("#cid")
                .attr("disabled", "disabled")
                .html("<option value=\"0\">Carregando...</option>")
                .load(url, function (r) {
                    if (r == "") {
                        adicionaProcedimentos();
                        limparCampos();
                    } else {
                        $("#cid").removeAttr("disabled").focus();
                        $("#cid").prepend("<option value=\"\" selected=selected>--SELECIONE--</option>")
                        $("#cid").change(function () {
                            adicionaProcedimentos();
                        });
                    }
                });
            return true;
        }
    });
}

function adicionaProcedimentos() {
    if ($("#procAtendSimp" + $("#proc_codigo").val()).length == 0) {

        $("#dadosProcAtendSimp").append("\
            <div id='procAtendSimp" + $("#proc_codigo").val() + "'>\n\
                <div class='procAtendSimp' >\n\
                    <span class='titProcAtendSimp'>\n\
                        " + $("#proc_codigo_sus").val() + " - " + $("#proc_nome").val().substr(0, 32) + " ...\n\
                    </span>\n\
                    <div class='excProcAtendSimp'>\n\
                        <img src='" + baseUrl + "/public/images/icons/excluir.png' onclick='excluiProcedimento(" + $("#proc_codigo").val() + ")' title='Excluir Horários' alt='Clique aqui para excluir os horários do dia' style='cursor: pointer' />\n\
                        <input type='hidden' name='procedimento[]' value='" + $("#proc_codigo").val() + "' />\n\
                        <input type='hidden' name='cid[]' value='" + $("#cid").val() + "' />\n\
                    </div>\n\
                </div>\n\
            </div>");
    }
}

function excluiProcedimento(procCodigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        $("#procAtendSimp" + procCodigo).remove();

        var cont = 0;
        $("#dadosProcAtendSimp").children("[class='procAtendSimp']").each(function () {
            cont++;
        });
        if (cont == 0) {
            $("#proc_codigo").val("");
        } else {
            $("#proc_codigo").val(cont);
        }
    });
}

function excluiExame(procCodigo) {
    $("#procExamSimp" + procCodigo).remove();
}

function limparCampos() {
    $("#proc_nome").val("");
}

function carregaEspecialidade() {
    if ($("#usr_codigo").val() && $("#uni_codigo").val()) {
        $("#especialidade").show();
        $.ajax({
            url: baseUrl + "/default/especialidade/lista-especialidade-por-profissional",
            type: "POST",
            data: {
                usrCodigo: $("#usr_codigo").val(),
                uni_codigo: $("#uni_codigo").val()
            },
            success: function (txt) {
                $("#esp_codigo").html("");
                $.each(txt, function (key, value) {
                    if (value['esp_codigo'] == $("#esp_codigo_editar").val()) {
                        $("#esp_codigo").append("<option selected = '" + "selected" + "' title=\"" + value['esp_nome'] + "\" value=\"" + value['esp_codigo'] + "\">" + value['esp_nome'] + "</option>");
                    } else {
                        $("#esp_codigo").append("<option title=\"" + value['esp_nome'] + "\" value=\"" + value['esp_codigo'] + "\">" + value['esp_nome'] + "</option>");
                    }
                });
            }
        });
    }
}

function buscaUnidade() {
    $("#usr_nome").val('');
    $("#usr_codigo").val('');
    $("#uni_desc").buscar({
        url: baseUrl + "/unidade/buscar",
        minLength: 3,
        template: function (ul, item) {
            $("#uni_tipo").val(item.tipo);
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }, callback: function () {
            validaConduta();
        }
    });
}

function validaConduta() {
    var uni_tipo = $("#uni_tipo").val();
    if (tipoAtend == "A") {
        if (uni_tipo == "H") {
            $("#conduta").hide();
            $("#ciap-div").hide();
            $("#nasf-div").hide();
            $("#conf_cond").val("1");
            $("#conf_ciap").val("1");
            $('#ciap-selecionados').html('');
            $("#conduta").find("input[type=checkbox][name='conduta[]']:checked").each(function () {
                $('input[type=checkbox][name=conduta[]]').attr("checked", false);
            });
        } else {
            $("#conduta").show();
            $("#ciap-div").show();
            $("#nasf-div").show();
            $("#conf_cond").val("");
            $("#conf_ciap").val("");
        }
    }
}

function retornaPac(usu_codigo, usu_nome) {
    $("#usu_codigo").val(usu_codigo);
    $("#usu_nome").val(usu_nome);
}

function buscarCiap() {
    selecionarTodos();
    $("#ciap_busca").buscar({
        url: baseUrl + '/prontuario/atendimento/novo-buscar-ciap/selecionados/' + $("#ciap-selecionados").val() + '/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a><strong>" + item.codigoCiap + " - " + item.label + "</strong><br>\n\
                        <font size=\"1\"> Inlc: " + item.ds_inclusao + " \n\
                        <br>\n\
                        Excl: " + item.ds_exclusao + "  \n\
                        <br>\n\
                        </font></a>").appendTo(ul);
        },
        callback: function (event, ui) {
            if (ui.item.id != 0) {
                if ($("#ciap-selecionados option:first").val() == "0") {
                    $("#ciap-selecionados").empty();
                    $("#conf_ciap").val("1");
                }
                $('#ciap-selecionados').append("<option select=\"selected\" value=" + ui.item.id + ">" + ui.item.label + "</option>");
            }
            $('#ciap_busca').val("");
            selecionarTodos();
        }
    });
}

function selecionarTodos() {
    $("#ciap-selecionados option").each(function () {
        $(this).attr('selected', 'selected')
    });
}

function validaData() {
    var data = $("#data_atendimento").val();
    var dataFormatada = data.split('/');
    var dataFormatada = new Date(dataFormatada[2], dataFormatada[1] - 1, dataFormatada[0]);
    var dataHoje = new Date();

    if (dataFormatada <= dataHoje) {
        $("#data_valida").val(true);
    } else {
        $("#data_valida").val('');
    }
}


function validaDataAtendimento() {
    var dataAtual = $('#data_atual').val();
    var dataAtualFormatada = dataAtual.split('/');
    var dataAtualFormatada = new Date(dataAtualFormatada[2], dataAtualFormatada[1] - 1, dataAtualFormatada[0]);

    var mesAtual = dataAtualFormatada.getMonth();
    var diaAtual = dataAtualFormatada.getDate();
    var anoAtual = dataAtualFormatada.getFullYear();

    var dataMinima = new Date(anoAtual, mesAtual - 12, diaAtual);

    var dataInformada = $("#data_atendimento").val();
    var dataInformadaFormatada = dataInformada.split('/');
    var dataInformadaFormatada = new Date(dataInformadaFormatada[2], dataInformadaFormatada[1] - 1, dataInformadaFormatada[0]);

    if (dataInformadaFormatada < dataMinima) {
        alert('A data do atendimento deve constar dentro do período de 1 ano!');
        $("#data_atendimento").val('');
    }
}


var metodo = "";

function buscaCid() {
    if ($("#ate_codigo").val() != "") {
        metodo = adicionaCidBanco;
    } else {
        metodo = adicionaCid;
    }

    $("#buscar").buscar({
        url: baseUrl + '/prontuario/cid/buscar/',
        delay: 10,
        minLength: 3,
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: metodo
    });
}

//var num_registros = 0;
function adicionaCidBanco() {
    var nomeCid = $("#buscar").val();
    var codCid = $("#cd10_codigo_cid").val();

    if ($(".tb_cids_" + $("#cd10_codigo").val()).length == 0) {
        if ($('.tb_cids tr').length < 3) {
            $.ajax({
                url: baseUrl + "/prontuario/atendimento/atualizar-cids/",
                type: "POST",
                data: {
                    ate_codigo: $("#ate_codigo").val(),
                    cd10_codigo: $("#cd10_codigo").val()
                },
                success: function (txt) {
                    $(".tb_cids").show();
                    $(".tb_cids").append("<tr class='rowID tb_cids_" + $("#cd10_codigo").val() + "'>\n\
                                            <td>\n\
                                                " + (nomeCid.indexOf(codCid) == "-1" ? codCid : "") + " " + nomeCid + "\n\
                                                <input type='hidden' name='cid_codigo[]' value='" + $("#cd10_codigo").val() + "' /> \n\
                                            </td>\n\
                                            <td>\n\
                                                <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCid(" + $("#cd10_codigo").val() + ")\" \>\n\
                                            </td>\n\
                                        </tr>");
                    atend++;
                }
            });
        } else {
            $(".ui-state-error").remove();
            $("#erro").prepend("<span class='ui-state-error'>Máximo de 3 CID(s) por atendimento!</span>");
        }
    }
    $("#buscar").val("");
}

function excluiCidBanco(cidCodigo) {
    $.ajax({
        url: baseUrl + "/prontuario/atendimento/excluir-cids/",
        type: "POST",
        data: {
            ate_codigo: $("#ate_codigo").val(),
            cd10_codigo: cidCodigo
        },
        success: function (txt) {
            $(".ui-state-error").remove();
            $(".tb_cids_" + cidCodigo).remove();
            if ($('.tb_cids tr').length == 0) {
                $(".tb_cids").hide();
            }
        }
    });

}


//var num_registros = 0;
function adicionaCid() {
    var nomeCid = $("#buscar").val();
    var codCid = $("#cd10_codigo_cid").val();
    if ($(".tb_cids_" + $("#cd10_codigo").val()).length == 0) {
        if ($('.tb_cids tr').length < 3) {
            $(".tb_cids").show();
            $(".tb_cids").append("<tr class='tb_cids_" + $("#cd10_codigo").val() + "'>\n\
                                    <td>\n\
                                        " + (nomeCid.indexOf(codCid) == "-1" ? codCid : "") + " " + nomeCid + "\n\
                                        <input type='hidden' name='cid_codigo[]' value='" + $("#cd10_codigo").val() + "' /> \n\
                                    </td>\n\
                                    <td>\n\
                                        <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCid(" + $("#cd10_codigo").val() + ")\" \>\n\
                                    </td>\n\
                                </tr>");
            atend++;
        } else {
            $(".ui-state-error").remove();
            $("#erro").prepend("<span class='ui-state-error'>Máximo de 3 CID(s) por atendimento!</span>");
        }
    }
    $("#buscar").val("");
}

function excluiCid(cidCodigo) {
    $(".ui-state-error").remove();
    $(".tb_cids_" + cidCodigo).remove();
    if ($('.tb_cids tr').length == 0) {
        $(".tb_cids").hide();
    }
    atend--;
}


var codsCid = "";

function carregaCid(codAtend) {
    $.ajax({
        url: baseUrl + "/prontuario/atendimento/lista-cids-atendimento",
        type: "POST",
        data: {
            codAtend: codAtend
        },
        success: function (txt) {
            $(".tb_cids").show();
            if (txt["cd10_codigo"] != null) {
                $(".tb_cids").append("<tr class='tb_cids_" + txt["cd10_codigo"] + "'>\n\
                                         <td>\n\
                                             " + (txt["cd10_codigo_desc"].indexOf(txt["cd10_codigo_cid"]) == "-1" ? txt["cd10_codigo_cid"] : "") + " " + txt["cd10_codigo_desc"] + "\n\
                                             <input type='hidden' name='cid_codigo[]' value='" + txt["cd10_codigo"] + "' /> \n\
                                         </td>\n\
                                         <td>\n\
                                             <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCidBanco(" + txt["cd10_codigo"] + ")\" \>\n\
                                         </td>\n\
                                     </tr>");
            }
            if (txt["cd10_codigos"] != null) {
                $(".tb_cids").append("<tr class='tb_cids_" + txt["cd10_codigos"] + "'>\n\
                                         <td>\n\
                                             " + (txt["cd10_codigos_desc"].indexOf(txt["cd10_codigos_cid"]) == "-1" ? txt["cd10_codigos_cid"] : "") + " " + txt["cd10_codigos_desc"] + "\n\
                                             <input type='hidden' name='cid_codigo[]' value='" + txt["cd10_codigos"] + "' /> \n\
                                         </td>\n\
                                         <td>\n\
                                             <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCidBanco(" + txt["cd10_codigos"] + ")\" \>\n\
                                         </td>\n\
                                     </tr>");
            }
            if (txt["cd10_codigot"] != null) {
                $(".tb_cids").append("<tr class='tb_cids_" + txt["cd10_codigot"] + "'>\n\
                                         <td>\n\
                                             " + (txt["cd10_codigot_desc"].indexOf(txt["cd10_codigot_cid"]) == "-1" ? txt["cd10_codigot_cid"] : "") + " " + txt["cd10_codigot_desc"] + "\n\
                                             <input type='hidden' name='cid_codigo[]' value='" + txt["cd10_codigot"] + "' /> \n\
                                         </td>\n\
                                         <td>\n\
                                             <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCidBanco(" + txt["cd10_codigot"] + ")\" \>\n\
                                         </td>\n\
                                     </tr>");
            }
        }
    });
}

function trim(str) {
    if (str != null) {
        return str.replace(/^\s+|\s+$/g, "");
    }
}

function checaSexoGestante() {
    var tipoMedicoBloqueio = ["P", "A", "F", "B"];

    if ($('#usu_sexo').val() == 'M' || (tipoMedicoBloqueio.indexOf($('#usr_tipo_medico').val()) != -1 && $('#usr_digitador').val() != 'S')) {

        $('#gestante').attr('disabled', true);
        $('#gestante:checked').attr('disabled', true);
        $('#gestante').attr('value', "f");
        $('#div_gestante').hide();
        return true;
    } else {
        if ($('#datanascimento').val() !== '' && $('#datanascimento').val() !== 'undefined') {

            if (getIdade() >= 9 && getIdade() <= 60) {
                $('#gestante').removeAttr("disabled");
                $('#gestante:checked').removeAttr("disabled");
                $('#div_gestante').show();
                exibeEstratificacaoRadio('gestante', 'pergunta_pre_natal');
                if ($('#gestante:checked').val() == 't') {
                    $('#pergunta_puerperio').hide();
                }
                return true;
            } else {
                $('#pergunta_puerperio').hide();
                $('#gestante').attr('disabled', true);
                $('#gestante:checked').attr('disabled', true);
                $('#gestante').attr('value', "f");
                if ($('#gestante').is(":checked") && !$('#gestante').is(":disabled")) {
                    mensagem("Atenção", "Idade do usuário incompatível com o status de Gestante! Deve estar entre 9 e 60 anos. ", 300, 150);
                    return false;
                }
                return true;
            }
        } else {

            $('#gestante').attr('disabled');
            $('#gestante:checked').attr('disabled');
            $('#div_gestante').hide();

        }
        return true;
    }
}

function getIdade() {
    var parts = $('#datanascimento').val().split('/');
    var dataNascimento = new Date(parts[2], parts[1] - 1, parts[0]);

    var parts = $('#dataatual').val().split('/');
    var dataAtual = new Date(parts[2], parts[1] - 1, parts[0]);

    var idade = dataAtual.getFullYear() - dataNascimento.getFullYear();
    var m = dataAtual.getMonth() - dataNascimento.getMonth();
    if (m < 0 || (m = 0 && dataAtual.getDate() < dataNascimento.getDate())) {
        idade--;
    }

    return idade;
}

function exibeEstratificacaoRadio(idRadio, idDiv, idCampoRisco) {
    if ($("#" + idRadio + ":checked").val() == 't') {
        $("#" + idDiv).show();
    } else {
        $("#" + idDiv).hide();
        $("#" + idCampoRisco).val("");
    }
}

function carregaIne() {
    setTimeout(function () {
        $("#cod_equipe option").remove();
        $("#cod_equipe").show();
        $.ajax({
            url: baseUrl + "/default/usuarios/carrega-equipes",
            type: "POST",
            data: {
                uni_codigo: $("#uni_codigo").val(),
                usr_codigo: $("#usr_codigo").val()
            },
            success: function (txt) {
                if (txt.length > 0) {
                    $("#equipe").show();
                    $("#cod_equipe").rules("add", "required");
                    var codIne = $("#cod_equipe_ine").val();
                    $.each(txt, function (key, value) {
                        var selectedIne = '';
                        if (codIne == value['co_seq_equipe']) {
                            selectedIne = "selected='selected'";
                        }
                        $("#cod_equipe").append("<option " + selectedIne + " value=\"" + value['co_seq_equipe'] + "\" onclick='carregaMicroarea()'>" + value['nu_ine'] + " - " + value['no_equipe'] + "\</option>");
                    })
                    if ($("#dom_microarea_fa:checked").val() != 't') {
                        carregaMicroarea();
                    }
                } else {

                    $("#cod_equipe").rules("remove", "required");
                    $("#equipe").hide();

                    carregaMicroarea();

                }
            }
        });
    }, 150);
}

function carregaMicroarea() {
    setTimeout(function () {
        $("#usu_microarea option").remove();
        $("#usu_microarea").show();
        var cod_equipe = $("#cod_equipe option:selected").val();
        var uni_codigo = $("#uni_codigo").val();
        $.ajax({
            url: baseUrl + "/default/especialidade/carrega-microarea",
            type: "POST",
            async: false,
            data: {
                co_seq_equipe: cod_equipe,
                uni_codigo: uni_codigo
            },
            success: function (txt) {
                $("#usu_microarea").append("<option value=\"\">Selecione</option>");
                var codMa = $("#usu_microarea_codigo").val();
                $.each(txt, function (key, value) {
                    var selectedMa = '';
                    if (codMa == value['mic_codigo']) {
                        selectedMa = "selected='selected'";
                    }
                    $("#usu_microarea").append("<option " + selectedMa + " value=\"" + value['mic_codigo'] + "\" onclick=''>" + value['mic_descricao'] + ' - ' + value['nu_ine'] + "\</option>");
                })
                validaForaArea();
            }
        })
    }, 150);
}

function validaForaArea() {
    var checado = false;
    if ($("#st_fora_area").attr("checked") == "checked") {
        checado = true;
    } else {
        checado = false;
    }
    if (checado) {
        $("#usu_microarea").prop('selectedIndex', 0);
        $("#usu_microarea").css("text-decoration", "none");
        $("#usu_microarea").attr("disabled", true);
    } else {
        $("#usu_microarea").attr("disabled", false);
    }

}

function exibeEstratificacaoIdade() {
    if (getIdade() >= 60) {
        $("#estrat_idoso").show();
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
    } else if (getIdade() < 12 && $('#usr_tipo_medico').val() !== 'P') {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").show();
    } else {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
    }
}

function exibeInfoPaciente() {
    if ($('#usu_codigo').val() == '') {
        $('#dados_paciente').hide();
    } else {
        $('#dados_paciente').show();
        exibeEstratificacaoRadio('gestante', 'pergunta_pre_natal');
        exibeEstratificacaoRadio('gestante', 'pergunta_idade_gestacional');

    }
}

function verificaProcedimentoFicha() {
    if($("#curativo_especial:checked").val() == "" && $("#teste_olhinho:checked").val() == "" && $("#teste_proteinuria:checked").val() == ""
        && $("#adm_intramuscular:checked").val() == "" && $("#adm_endovenosa:checked").val() == "" && $("#adm_topica:checked").val() == ""
        && $("#adm_penicilina:checked").val() == "" && $("#adm_subcutanea:checked").val() == ""){
        return true;
    }
    return false;
}

function imprimeProntuario(){
    var usu_codigo = $('#usu_codigo').val();
    if(usu_codigo == ""){
        mensagem("Atenção","Selecione um paciente!");
        return false;
    }
    window.open(baseUrl + "/relatorio/usuario/prontuario/age_codigo/1/usu_codigo/"+usu_codigo);
    return false;
}