$(function () {

    $('#agee_situacao').change(function () {
        DataObrigatoria();
    });

    DataObrigatoria();

    //$("#salvar-agendamento-externo").ajaxForm(afterSubmit(txt));

    if ($("#fiusu_codigo").val() != "") {

        $.ajax({
            url: baseUrl + "/filaespera/filas-usuario/getdado/fiusu_codigo/" + $('#fiusu_codigo').val(),
            type: "POST",
            success: function (txt) {
                if (txt) {
                    //console.log(txt);
                    if (txt.usr_codigo) {
                        $("#usr_codigo").val(txt.usr_codigo);
                        $("#buscar5").val(txt.usr_nome);
                        $("#interno").val(1);
                    } else {
                        $("#usr_codigo").val(txt.med_codigo);
                        $("#buscar5").val(txt.med_nome);
                        $("#interno").val(0);
                    }
                    $("#usu_nome").val(txt.usu_nome);
                    $("#usu_mae").val(txt.usu_mae);
                    $("#usu_prontuario").val(txt.usu_prontuario);
                    $("#usu_codigo").val(txt.usu_codigo);
                    $("#rua_nome").val(txt.rua_nome);
                    $("#usu_datanasc").val(dataToBr(txt.usu_datanasc));
                    $("#usu_cartao_sus").val(txt.usu_cartao_sus);
                    $("#esp_codigo").val(txt.esp_codigo);
                    $("#buscar2").val(txt.esp_nome);
                    $("#proc_codigo").val(txt.proc_codigo);
                    $("#buscar4").val(txt.proc_nome);
                    $("#agee_data_pedido").val(dataToBr(txt.fiusu_data_pedido));

                    carregaEstratificacaoPaciente(txt.usu_codigo);

                    switch (txt.fipr_codigo){
                        case 1:
                            document.getElementById('grau_risco').value = "A";
                            break;
                        case 2:
                            document.getElementById('grau_risco').value = "M";
                            break;
                        case 3:
                            document.getElementById('grau_risco').value = "B";
                            break;
                    }

                    return true;
                }
            }


        });
        carregaEstratificacaoPaciente($('#usu_codigo').val());

    }

    //carregarHistoricoUltimoPaciente('1');

    // se já houver usu_codigo quando abrir a página (editar ou erro) já carrega o historico
    if ($("#usu_codigo").val() != "")
        carregarItens(false);


    if ($("#imprimir").size() && $("#imprimir").val() != "") {
        popup(baseUrl + "/agendamento-externo/imprimir/id/" + $("#imprimir").val(), "agendamento-externo", 600, 450);
        $("#imprimir").val("");
    }


    // Buscar pacientes
    $("#buscar1").buscar({
        url: baseUrl + '/paciente/buscar/',
        callback: function () {
            carregarItens(false);
            carregaEstratificacaoPaciente($('#usu_codigo').val());
            return false;
        }
    });

    // Buscar especialidades
    $("#buscar2").buscar({
        url: baseUrl + '/especialidade/buscar/',
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

    // Buscar médico externo (destino)
    $("#buscar3").buscar({
        url: baseUrl + '/medico-externo/buscar/',
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

    // Buscar procedimento
    $("#buscar4").buscar({
        url: baseUrl + '/procedimento/buscar/',
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

    // Solicitante: Buscar médicos internos (usr) ou externos (med)
    $("#buscar5").buscar({
        url: baseUrl + '/default/usuarios/buscar/externo/1',
        categoria: 'categoria',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

    // Buscar prestradores de serviço
    $("#buscar6").buscar({
        url: baseUrl + '/medico-externo/buscar/prestador/L/prestador/H/prestador/O',
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

    $(".paciente").click(function () {
        var usu_codigo = $("#usu_codigo").val();
        if (usu_codigo > 1) {
            var link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
        } else {
            link = baseUrl + "/default/paciente/form-paciente/poupup/1";
        }
        window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });

    $("#busca-medico").click(function () {
        var med_codigo = $("#med_codigo_M").val();
        var med_nome = $("#buscar3").val();
        if (med_codigo && med_nome) {
            var link = baseUrl + "/medicos/cadastro-medicos/form-fisico/id/" + med_codigo;
        } else {
            link = baseUrl + "/medicos/cadastro-medicos/form-fisico/";
        }
        window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
        window.onmessage = function (e) {
            if(e.data){
                $("#med_codigo_M").val(e.data.med_codigo);
                $("#buscar3").val(e.data.med_nome.toUpperCase());
            }
        };
    });

});

function carregarItens(codUsuario) {
    if (codUsuario === false) {
        codUsuario = $("#usu_codigo").val();
    }
    $("#itens")
        .html("<img src=\"" + baseUrl + "/public/images/load.gif\" alt=\"Carregando histórico\" title=\"Carregando\" />")
        .load(baseUrl + "/agendamento-externo/itens/usu_codigo/" + codUsuario, function () {
            bind();
        });
}

function bind() {
    $("#itens .excluir")
        .unbind("click")
        .bind("click", function (e) {
            e.preventDefault();
            e.stopPropagation();

            var link = $(this);
            confirme("Confirme", "Deseja realmente excluir este item?", 300, 120, function () {
                $.ajax({
                    url: link.attr("href"),
                    success: function () {
                        link.parents("tr").slideUp("normal", function () {
                            $(this).remove();
                        });
                    }
                });
            });
        });

}

function retornaPac(usu_codigo, usu_nome) {
    $("#usu_codigo").val(usu_codigo);
    $("#usu_nome").val(usu_nome);
}

function carregarHistoricoUltimoPaciente(codUser) {
    if (codUser !== "") {
        $.ajax({
            url: baseUrl + "/default/paciente/busca-ultimo-agendado",
            type: "POST",
            dataType: "JSON",
            async: true,
            data: {codUser: codUser},
            error: function () {
                console.log('erro');
            },
            success: function (data) {
                //console.log(data.usu_codigo);
                carregarItens(data.usu_codigo);
            }

        });
    } else {
        return false;
    }
}

function salvarAgendamentoExterno(evt) {
    var usu_nome = $('#usu_nome').val();
    var prioridade = $('#grau_risco').val();
    var estabelecimento_destino = $('#med_codigo_L').val();
    var situacao = $('#agee_situacao').find(":selected").val();
    var data_agendamento = $('#agee_data').val();
    var hora_agendamento = $('#agee_hora').val();
    var fiusu_codigo = $('#fiusu_codigo').val();
    var valoresForm = $('#salvar-agendamento-externo').serialize();


    if (usu_nome == "") {
        alert('Selecione um paciente!');
        document.getElementById('buscar1').focus();
        evt.preventDefault();
        return false;
    }

    if (prioridade == "") {
        alert('Selecione a prioridade!');
        evt.preventDefault();
        return false;
    }

    if (estabelecimento_destino == "") {
        alert('Selecione o estabelecimento de destino!');
        document.getElementById('buscar6').focus();
        evt.preventDefault();
        return false;
    }

    if (situacao == 0 || situacao == 2) {
        if(data_agendamento == "") {
            alert('Preencha a data do agendamento!');
            document.getElementById('agee_data').focus();
            evt.preventDefault();
            return false;
        }
        if(hora_agendamento == "") {
            alert('Preencha a hora do agendamento!');
            document.getElementById('agee_hora').focus();
            evt.preventDefault();
            return false;
        }
    }


    mensagemSemOk("salvando-age", "Salvando...", "Salvando Agendamento Externo ...", 280, 80);
    $.ajax({
        url: baseUrl + "/agendamento-externo/salvar",
        type: "POST",
        data: valoresForm,
        success: function (txt) {
            if (txt.success) {
                afterSubmit(txt);
                return true;
            }
        }
    });
}

function afterSubmit(json) {
    fecharMensagemSemOk("salvando-age");
        $("<div id='dialog-1'>" +
            "<span>Agendamento externo realizado com sucesso!</span>" +
            "<br/>" +
            "<span>Deseja imprimir o comprovante de agendamento?</span>" +
            "</div>").dialog({
            autoOpen: true,
            modal: true,
            resizable: false,
            closeOnEscape: true,
            position: ['top', 'center'],
            width: 400,
            height: 150,
            title: "Aviso:",
            close: function () {
                if ($('#fiusu_codigo').val() != "") {
                    window.location.href = baseUrl + "/filaespera/filas-usuario/buscar/fila/" + json.fila_codigo;
                } else {
                    window.location.href = baseUrl + "/agendamento-externo/index/";
                }
                $(this).remove();
            },
            buttons: {
                "Imprimir em 1 via": function () {
                    // imprimir
                    var url = baseUrl + "/agendamento-externo/imprimir/copias/1/id/" + json.agee_codigo;
                    window.open(url);
                    $(this).dialog('close');
                },
                "Imprimir em 2 vias": function () {
                    // imprimir
                    var url = baseUrl + "/agendamento-externo/imprimir/copias/2/id/" + json.agee_codigo;
                    window.open(url);
                    $(this).dialog('close');
                },
                "Não": function () {
                    // não imprimir
                    $(this).dialog('close');
                }
            }
        });
}

function DataObrigatoria() {
    var situacao = $('#agee_situacao').find(":selected").val();

    if (situacao == 0 || situacao == 2) {
        $('#data_hora_agendamento').html("Data e Hora do Agendamento:<span class=\"obrigatorio\">*<span>");
    } else {
        $('#data_hora_agendamento').html("Data e Hora do Agendamento:");
    }
}