$(function(){
	
	// antes de enviar deve selecionar todas os itens do select
	$(".salvar-icon").bind("click",function(e){
		e.preventDefault();
		$("#duplicados option").attr("selected","selected");		
		$(this).parents("form").trigger("submit");
	});
	
	$("#bai_nome").buscar({
            url: baseUrl+'/bairro/buscar/',
            template : function(ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                    "<a>" + item.label + ""
                    + "<br/><strong>Código: </strong>"+ item.data.bai_codigo
                    + "<br/><strong>Cidade: </strong>"+ item.data.cid_nome
                    + "<br/><strong>Distrito: </strong>"+ item.data.dis_nome
                    + "</a>&nbsp;").appendTo(ul);
            }, 
            callback: function(){
                    // se o item selecionado como bairro certo já estiver na lista de bairros duplicados, deve ser removido
                    $("#duplicados option[value="+$("#bai_codigo").val()+"]").remove();
            }
	});
	
	$("#bai_nome_2").buscar({
		url: baseUrl+'/bairro/buscar/',
		suffix: '_2',
		search: function(){
			$("#busca").empty();
		},
		template : function(ul, item) {
			if($("#bai_codigo").val() == item.id || jaEstaSelecionado(item.data))
				return;
			
			ul.hide();			
			$("<option />").val(item.id).html(item.label+" - "+item.data.cid_nome).appendTo("#busca").attr({title: item.label+" - "+item.data.cid_nome});
			return false;
		},
		callback: function(event, ui){
			$("#busca").focus();
		}
	});
	
	$("#busca").dblclick(function(){		
		adicionar($("option:selected", this));		
	}).keydown(function(e){
		
		if(e.keyCode && e.keyCode != 39 || e.charCode){
			return 
		}
		
		e.preventDefault();
		adicionar($("option:selected", this));	
	});
	
	$("#duplicados").dblclick(function(){		
		$("option:selected", this).appendTo($("#busca"));	
		$("#busca").val('');
	}).keydown(function(e){
		
		if(e.keyCode && e.keyCode != 37 || e.charCode){
			return 
		}
		
		e.preventDefault();
		$("option:selected", this).appendTo($("#busca"));	
		$("#busca").val('');		
	});
	
});

// adiciona os itens no select
function adicionar(obj){	
	if(!obj.size())
		return;

	var data = {};
	data.bai_codigo = obj.val();
	data.bai_nome = obj.html();
		
	if( ehOItemCerto(data) || jaEstaSelecionado(data))
		return false;
	else {
		$("#duplicados").append("<option value=\""+data.bai_codigo	+"\">"+data.bai_nome+"</option>");
		obj.remove();
		return true;
	}
	
}

function jaEstaSelecionado(data){
	
	var retorno = false;
	$("#duplicados option").each(function(){
		if($(this).val() == data.bai_codigo ){
			window.console && console.log("o item já está selecionado");
			retorno = true;
		}
		
	});
	
	return retorno;
}

function ehOItemCerto(data){
	var retorno = data.bai_codigo == $("#bai_codigo").val();
	window.console && console.log("É o item certo? "+retorno);
	return retorno;
}