function fechaPopup() {
  window.close();
  window.opener.atualizaFabricante();
}

function validaValorFinalCnpj() {
  var cnpj = $('#fab_cnpj').val();
  if (cnpj != '' && !cnpjValido(cnpj)) {
    $('#salvar').attr('class', 'ui-button salvar ui-corner-bl ui-corner-tr ui-state-disabled');
    $('#fab_cnpj').focus();
    alert('CNPJ Inválido!');
  } else {
    $('#salvar').attr('class', 'ui-button salvar ui-corner-bl ui-corner-tr');
  }
}

function cnpjValido(c) {
  var b = [6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];

  if ((c = c.replace(/[^\d]/g,"")).length != 14)
    return false;

  if(/0{14}/.test(c))
    return false;

  for (var i = 0, n = 0; i < 12; n += c[i] * b[++i]);
  if(c[12] != (((n %= 11) < 2) ? 0 : 11 - n))
    return false;

  for (var i = 0, n = 0; i <= 12; n += c[i] * b[i++]);
  if(c[13] != (((n %= 11) < 2) ? 0 : 11 - n))
    return false;

  return true;
}

function mascaraCnpj(event) {
  if (bloqueiaLetrasCnpj(event)) {
    var cnpjSize = $('#fab_cnpj').val().length;

  	if (cnpjSize == 2 || cnpjSize == 6){
      $('#fab_cnpj').val($('#fab_cnpj').val() + ".")
  	}
  	if (cnpjSize == 10){
      $('#fab_cnpj').val($('#fab_cnpj').val() + "/")
  	}
  	if (cnpjSize == 15){
      $('#fab_cnpj').val($('#fab_cnpj').val() + "-")
  	}
  }
}

function bloqueiaLetrasCnpj(e) {
  if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
    $('#fab_cnpj').val(
      $('#fab_cnpj').val().replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/g,"\$1.\$2.\$3\/\$4\-\$5")
    );
    e.preventDefault();
    return false
  }

  return true;
}

function bloqueiaCnpj() {
  if ($('#fab_internacional').is(':checked')) {
    $('#fab_cnpj').val('');
    $('#fab_cnpj').prop('disabled', true);
    $('#fab_cnpj').css('background', '#eae7e7');
  } else {
    $('#fab_cnpj').prop('disabled', false);
    $('#fab_cnpj').css('background', '#dfeffc');
  }
}

$(function () {
  if ($("#sucesso").val() == 1) {
    alert('Fabricante salvo com sucesso!!');
    fechaPopup();
  }
});

function excluir(id) {
  $("html").append("<div id=\"excluir-dialog\" title=\"Confirmação\">Deseja realmente excluir este item?</div>");
  $("#excluir-dialog").dialog({
    modal: true,
    width: 300,
    height: 140,
    buttons: {
      Sim: function () {
        $(this).dialog('close');
        $.ajax({
          url: baseUrl + "/default/fabricante/excluir",
          type: "POST",
          data: {
            id: id
          },
          success: function (txt) {
            if (txt == 0) {
              window.location.href = baseUrl + '/default/fabricante/index'
            } else {
              $("body").append("<div id=\"mensagem-dialog\" title=\"Erro\">Erro ao excluir este fabricante!</div>")
              $("#mensagem-dialog").dialog({
                modal: true,
                close: function () {
                  $(this).remove();
                },
                buttons: {
                  "Ok": function () {
                    $(this).dialog('close');
                  }
                }
              });
            }
          }
        });
      },
      "Não": function () {
        $("#excluir-dialog").dialog("destroy").remove();
      }
    }
  })
}
