$(function () {
    mensagem("Atenção", "Clique na tecla F11 do teclado para maximizar a tela!", 300, 250, function () {
        $('#page').fullscreen();
    });
    carregaDadosIniciais();
});

function carregaDadosIniciais() {
    $.ajax({
        url: baseUrl + "/default/guiche/carrega-dados-iniciais",
        type: 'GET',
        success: function (dados) {
            $.cookie('uni_codigo', dados.uni_codigo);
            $.cookie('uni_desc', dados.uni_desc);
            $.cookie('uni_endereco', dados.uni_endereco);
            $.cookie('uni_numero', dados.uni_numero);
            $.cookie('uni_bairro', dados.uni_bairro);
            $.cookie('cid_nome', dados.cid_nome);
            $.cookie('uf_sigla', dados.uf_sigla);

            var tpl = "<h1>" + $.cookie('uni_desc') + "</h1>"
                + "<p>" + $.cookie('uni_endereco') + ", " + $.cookie('uni_numero') + "</p>"
                + "<p>" + $.cookie('uni_bairro') + " " + $.cookie('cid_nome') + " - " + $.cookie('uf_sigla') + "</p>"
            $('#unidade').html(tpl);

            startTime();

            carregaVideos();

            verificaAlteracoes($.cookie('uni_codigo'));
            setInterval(function () {
                verificaAlteracoes($.cookie('uni_codigo'));
            }, 3000);

        }
    });
}

var data_hora = "";
var passou = false;

function verificaAlteracoes(uni_codigo) {
    $.ajax({
        url: baseUrl + "/default/guiche/get-last-index/uni_codigo/" + uni_codigo,
        type: 'GET',
        success: function (txt) {
            console.log();
            if (txt.max !== null) {
                if (data_hora !== txt.max) {
                    data_hora = txt.max;
                    buscarChamadas(uni_codigo);
                }
            } else {
                if (!passou) {
                    var tpl = (txt.max !== null ? txt : "<h1><p class='medico'>Não há pacientes na lista de espera.</p></h1>")
                    $(".chamada").html(tpl);
                    passou = true;
                }
            }
        }
    })
}

function buscarChamadas(uni_codigo) {
    $("<audio id='chatAudio'>"
        + "<source src='" + baseUrl + '/public/sounds/chamada.mp3' + "' type='audio/ogg'>"
        + "</audio>").appendTo('body');
    $('#chatAudio')[0].play();
    $.ajax({
        url: baseUrl + "/default/guiche/buscar-chamadas/uni_codigo/" + uni_codigo,
        type: 'GET',
        success: function (dados) {
            var templateAtual = "";
            if (dados.length > 0) {
                //Chamada atual
                templateAtual = "<h1>" +
                    "    <span class='label' style='background-color: " + dados[0].cor + "'>" + dados[0].cha_usu_prontuario + "</span>" +
                    "    <p class='paciente'>" + dados[0].cha_paciente + "</p>" +
                    "    <p class='medico'>" + dados[0].cha_profissional + "</p>" +
                    "    <p class='setor'>" + dados[0].cha_setor + "</p>"
                "</h1>";


                //Chamadas anteriores
                var templateAnteriores = "<ul class='event-list'>";
                $.each(dados, function (index, chamada) {
                    if (index > 0) {
                        templateAnteriores += "<li>"
                            + "   <time style='background-color: " + chamada.cor + ";'>"
                            + "       <span class='month'>" + chamada.cha_usu_prontuario + "</span>"
                            + "   </time>"
                            + "   <div class='info'>"
                            + "       <h2 class='title'>" + chamada.cha_paciente + "</h2>"
                            + "       <p class='desc'>" + chamada.cha_profissional + " - " + chamada.cha_setor + "</p>"
                            + "   </div>"
                            + "   <div class='social'>"
                            + "<ul>"
                            + "<li><i class='fa fa-2x fa-" + (chamada.cha_status == 'C' ? 'thumbs-o-up text-primary' : 'thumbs-o-down text-danger' ) + "'></i></li>"
                            + "</ul>"
                            + "   </div>"
                            + " </li>";
                    }
                });
                templateAnteriores += "</ul>";
                $(".ultimas-chamadas").html(templateAnteriores);
            } else {
                templateAtual = "<p class='paciente'>Não há pacientes na fila no momento.</p>"
            }
            $(".chamada").html(templateAtual);
        }
    })
}

function getDadosTempo(cid_nome) {
    var cidade = cid_nome ? cid_nome : "Maringá";
    var pais = "BR"; //Two digit country code
    var keyCode = "1892706d77b2369fc4871b985552e60d";
    $('.city').html(cidade);
    $('.graus').html('');
    $('.tempo').html('');
    $.ajax({
        url: "http://api.openweathermap.org/data/2.5/weather?q=" + cidade + "," + pais + "&units=metric&cnt=7&lang=pt&APPID=" + keyCode,
        type: 'GET',
        success: function (dados) {
            var grau = parseFloat(dados.main.temp);
            $('.img-tempo').attr('src', "http://openweathermap.org/img/w/" + dados.weather[0].icon + ".png");
            $('.graus').append(dados.main.temp.toFixed(1));
            $('.tempo').append(dados.weather[0].description);
        }
    });
}

//************* Vídeo ******************//
var videos = [];

function carregaVideos() {
    $.ajax({
        url: baseUrl + "/default/guiche/retorna-video",
        type: 'GET',
        success: function (dados) {
            videos = dados;
            $('#player-video').attr('src', dados[0]);
            //Dados do Tempo a cada 2 minutos
            getDadosTempo($.cookie('cid_nome'));
            setInterval(function () {
                getDadosTempo($.cookie('cid_nome'));
            }, 120000);
        }
    });
}

function videoEnded() {
    var number = Math.floor(Math.random() * videos.length);
    $('#player-video').get(0).src = videos[number];
    $('#player-video').get(0).load();
    $('#player-video').get(0).play();
}

//Utils
function startTime() {
    var today = new Date();
    var h = today.getHours();
    var m = today.getMinutes();
    var s = today.getSeconds();
    m = checkTime(m);
    s = checkTime(s);
    $('#hora').html(h + ":" + m);
    setTimeout(startTime, 500);
}

function checkTime(i) {
    if (i < 10) {
        i = "0" + i
    }
    ;  // add zero in front of numbers < 10
    return i;
}