function salvarAnexo(event) {
    var nome = $('#ua_descricao').val();
    var tipo = $('#td_codigo option:selected').val();
    var anexo = $('#ua_anexo').val();
    var form = document.getElementById('form_anexar');
    var formData = new FormData(form);

    if(tipo == ""){
        alert("Selecione um tipo de documento");
        return false;
    }
    if(nome == ""){
        alert("Descrição é obrigatória!");
        return false;
    }
    if(anexo == ""){
        alert("Selecione um anexo!");
        return false;
    }
    mensagemSemOk("salvando-ane", "Salvando...", "Salvando Anexo ...", 280, 80);
    $.ajax({
        url: baseUrl + "/paciente/salvar-anexo",
        type: "POST",
        data: formData,
        async: false,
        success: function (txt) {
            if (txt.success) {
                fecharMensagemSemOk("salvando-ane");
                mensagem("Atenção.",txt.mensagem, 300,150, function () {
                    window.location.reload();
                });

            } else{
                fecharMensagemSemOk("salvando-ane");
                event.preventDefault();
                mensagem("Erro.",txt.mensagem, 300,150, function () {
                    return false;
                });

            }
        },
        cache: false,
        contentType: false,
        processData: false
    });
}

function excluirAnexo(ua_codigo){
    confirme("Atenção", "Deseja realmente excluir este arquivo?", 300, 150, function () {
        $.ajax({
            url: baseUrl + "/paciente/excluir-anexo/ua_codigo/"+ua_codigo,
            success: function (txt) {
                if(txt.success){
                    mensagem("Atenção.",txt.mensagem, 300,150, function () {
                        window.location.reload();
                    });
                }
            }
        });
    });
}

function visualizarAnexo(ua_codigo){
    $.ajax({
        url: baseUrl + "/paciente/visualizar-anexo/ua_codigo/"+ua_codigo,
        success: function (txt) {
            if(txt.success){
                window.open(txt.arquivo);
            } else{
                mensagem("Erro.",txt.mensagem, 300,150, function () {
                });
            }
        }
    });
}