var valida = 0;
$(function () {

    exibeEstratificacaoRadio('usu_tem_diabete', 'estrat_diabetes', 'risco_diabetes');
    exibeEstratificacaoRadio('usu_esta_gestante1', 'estrat_gestante', 'risco_gestacao');
    exibeEstratificacaoRadio('usu_tem_hipertensao', 'estrat_hipertensao', 'risco_hipertensao');
    exibeEstratificacaoIdade();
    habilitaCidade();
    $("#pep_email").change(function () {
        IsEmail($("#pep_email").val());
    });

    $("#pep_sexo").change(function () {
        if ($("#pep_sexo").val() == 'M') {
            document.getElementById("usu_esta_gestante1").disabled = true;
            document.getElementById("usu_esta_gestante2").disabled = true;
            document.getElementById("usu_esta_gestante2").checked = true;
        }
        if ($("#pep_sexo").val() == 'F') {
            document.getElementById("usu_esta_gestante1").disabled = false;
            document.getElementById("usu_esta_gestante2").disabled = false;
        }

    });

    $('.masterTooltip').hover(function () {
        var title = $(this).attr('title');
        $(this).data('tipText', title).removeAttr('title');
        $('<p class="tooltip"></p>')
            .text(title)
            .appendTo('body')
            .fadeIn('slow');
    }, function () {
        $(this).attr('title', $(this).data('tipText'));
        $('.tooltip').remove();
    }).mousemove(function (e) {
        var mousex = e.pageX + 20;
        var mousey = e.pageY + 10;
        $('.tooltip')
            .css({top: mousey, left: mousex})
    });

    $("#estc_codigo").change(function () {
        if ($("#estc_codigo").val() == 2 || $("#estc_codigo").val() == 5) {
            $("#conjuge").show('low');
        } else {
            $("#conjuge").hide('low');
        }
    });

    if ($("#usu_deficiencia:checked").val() == "f") {
        desabilitaDeficiencias();
    }

    carregaUnidadesProfissional();
    carregaEspecialidade();
    checaSexoGestante();
    validaFieldsets();
    validacoeSecundarias();
});

function validaCamposObito() {
    if ($(".pep_obito:checked").val() == "t") {
        $("#data_obito").show();
        $("#doc_obito").show();
    } else {
        $("#data_obito").hide();
        $("#doc_obito").hide();
        $("#pep_data_obito").val("");
        $("#usu_numero_do").val("");
    }
}

function validaCamposGestante() {
    if ($(".usu_esta_gestante:checked").val() == "t") {
        $("#maternidade_referencia").show();
    } else {
        $("#maternidade_referencia").hide();
        $("#usu_maternidade_ref").val("");
    }
}

function carregaUnidadesProfissional() {
    var combo = "";
    var selected = "";
    var edit = $("#uni_codigo_edit").val();
    edit = (edit != undefined ? edit : '');
    $.ajax({
        url: baseUrl + '/default/unidade/get-unidades-por-profissional',
        async: false,
        data: {usr_codigo: $("#usr_codigo").val()},
        success: function (txt) {
            combo += "<option value=\"\">Selecione</option>";
            for (var i in txt) {
                if (edit.trim() != '') {
                    if (parseInt(edit) == parseInt(txt[i].uni_codigo)) {
                        selected = "selected=selected";
                    } else {
                        selected = "";
                    }
                }
                combo += "<option value=\"" + txt[i].uni_codigo + "\" " + selected + ">" + txt[i].uni_desc + "</option>";
            }
            combo += "</option>";
            $("#uni_codigo").html(combo);
        }
    });
    carregaEquipes();
}

function IsEmail(email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    if (re.test(String(email).toLowerCase())) {
        return true;
    } else {
        $("#pep_email").val("");
        return false;
    }
}

function carregaEspecialidade() {
    var combo = "";
    var selected = "";
    var edit = $("#esp_codigo_edit").val();
    edit = (edit != undefined ? edit : '');
    $.ajax({
        url: baseUrl + "/default/especialidade/lista-especialidade-por-profissional",
        type: "POST",
        async: false,
        data: {
            usrCodigo: $("#usr_codigo").val()
        },
        success: function (txt) {
            combo += "<option value=\"\">Selecione</option>";
            for (var i in txt) {
                if (edit.trim() != '') {
                    if (parseInt(edit) == parseInt(txt[i].esp_codigo)) {
                        selected = "selected=selected";
                    } else {
                        selected = "";
                    }
                }
                combo += "<option value=\"" + txt[i].esp_codigo + "\" " + selected + ">" + txt[i].esp_nome.toUpperCase() + "</option>";
            }
            combo += "</option>";
            $("#esp_codigo").html(combo);
        }
    }).done(function () {
        validaFieldsets();
    });
}

function carregaEquipes() {
    var combo = "";
    var selected = "";
    var edit = $("#equipe_codigo_edit").val();
    var uni_codigo = "";
    edit = (edit != undefined ? edit : '');
    if ($("#uni_codigo").val() != undefined) {
        uni_codigo = $("#uni_codigo").val();
    } else {
        uni_codigo = $("#uni_codigo_edit").val();
    }
    if (uni_codigo != undefined && uni_codigo != "") {
        $.ajax({
            url: baseUrl + "/default/especialidade/carrega-equipes",
            type: "POST",
            async: false,
            data: {
                usr_codigo: $("#usr_codigo").val(),
                uni_codigo: uni_codigo
            },
            success: function (txt) {
                for (var i in txt) {
                    if (edit.trim() != '') {
                        if (parseInt(edit) == parseInt(txt[i].co_seq_equipe)) {
                            selected = "selected=selected";
                        } else {
                            selected = "";
                        }
                    }
                    combo += "<option value=\"" + txt[i].co_seq_equipe + "\" " + selected + ">" + txt[i].nu_ine + " - " + txt[i].no_equipe + "</option>";
                }
                combo += "</option>";
                $("#equipe_codigo").html(combo);
            }
        });
    } else {
        $("#equipe_codigo").html("<option value=\"\">Selecione</option>");
    }
    carregaMicroarea();
}

function carregaMicroarea() {
    var combo = "";
    var selected = "";
    var edit = $("#ma_codigo_edit").val();
    var uni_codigo = $("#uni_codigo").val();
    var equipe_codigo = $("#equipe_codigo").val();
    edit = (edit != undefined ? edit : '');
    $.ajax({
        url: baseUrl + "/default/especialidade/carrega-microarea",
        type: "POST",
        async: false,
        data: {
            co_seq_equipe: equipe_codigo,
            uni_codigo: uni_codigo
        },
        success: function (txt) {
            combo += "<option value=\"\">Selecione</option>";
            for (var i in txt) {
                if (edit.trim() != '') {
                    if (parseInt(edit) == parseInt(txt[i].mic_codigo)) {
                        selected = "selected=selected";
                        $("#usu_microarea_fa").prop('checked', false);
                        $("#usu_microarea").attr('disabled', false);
                    } else {
                        selected = "";
                    }
                }
                combo += "<option value=\"" + txt[i].mic_codigo + "\" " + selected + ">" + txt[i].mic_descricao + ' - ' + txt[i].nu_ine + "</option>";
            }
            $("#usu_microarea").html(combo);
        }
    }).done(function () {
        validaFieldsets();
    });
    validaFieldsets();
}

function validaForaArea() {
    var checado = false;
    if ($("#usu_microarea_fa").attr("checked") == "checked") {
        checado = true;
    } else {
        checado = false;
    }
    if (checado) {
        $("#usu_microarea").prop('selectedIndex', 0);
        $("#usu_microarea").attr("disabled", true);
    } else {
        $("#usu_microarea").attr("disabled", false);
    }

}

function validaFieldsets() {
    var ma_codigo = "";
    if ($("#usu_microarea").val() !== undefined) {
        ma_codigo = $("#usu_microarea").val();
    } else {
        ma_codigo = $("#ma_codigo_edit").val();
    }
    if (($("#usu_microarea_fa").attr("checked") == "checked" || ma_codigo != "")) {
        $("#info_socio").attr("disabled", false);
        $("#cond_gerais").attr("disabled", false);
        $("#sit_rua").attr("disabled", false);
        validaRecusa();
        validacoeSecundarias();
    } else {
        $("#info_socio").attr("disabled", true);
        $("#cond_gerais").attr("disabled", true);
        $("#sit_rua").attr("disabled", true);
        validacoeSecundarias();
    }
}

function validaRecusa() {
    var usu_recusa = $("#usu_recusa:checked").val();

    if (usu_recusa == 't') {
        $("#info_socio").attr("disabled", true);
        $("#cond_gerais").attr("disabled", true);
        $("#sit_rua").attr("disabled", true);

        $("#info_socio input").each(function () {
            $(this).attr("checked", false);
            if (!$(this).is('[type=checkbox]') && !$(this).is('[type=radio]')) {
                $(this).val("");
            }
        })
        $("#info_socio select").each(function () {
            $(this).prop('selectedIndex', 0);
        })
        $("#cond_gerais input").each(function () {
            $(this).attr("checked", false);
            if (!$(this).is('[type=checkbox]') && !$(this).is('[type=radio]')) {
                $(this).val("");
            }
        })
        $("#cond_gerais select").each(function () {
            $(this).prop('selectedIndex', 0);
        })
        $("#sit_rua input").each(function () {
            $(this).attr("checked", false);
            if (!$(this).is('[type=checkbox]') && !$(this).is('[type=radio]')) {
                $(this).val("");
            }
        })
        $("#sit_rua select").each(function () {
            $(this).prop('selectedIndex', 0);
        })

    } else {
        $("#info_socio").attr("disabled", false);
        $("#cond_gerais").attr("disabled", false);
        $("#sit_rua").attr("disabled", false);
    }

}

function validacoeSecundarias() {
    validaCamposGestante();
    validaObito();
    validaMudancaTerritorio();
    validaMudancaTerritorio();
    validaForaArea();
    validaParentescoResposnavel();
    validaCrianca();
    validaComunidade();
    validaOrientacaoSexual();
    validaIdentidadeGenero();
    validaChecksDeficiencias();
    validaChecksCardiaca();
    validaChecksRenal();
    validaChecksPulmonar();
    validaInternacao();
    validaPlantas();
    validaInstituicao();
    validafrequencia();
    validaCamposRua();
}

function validaParentescoResposnavel() {
    if ($("#info_socio").is(':enabled')) {
        if ($("#proprio_responsavel:checked").val() == "S") {
            $("#uis_parentesco_resp").prop('selectedIndex', 0);
            $("#uis_parentesco_resp").attr("disabled", true);
        } else {
            $("#uis_parentesco_resp").attr("disabled", false);
        }
    }
}

function validaCrianca() {
    if (getIdade() < 12) {
        habilitaCriancas();
    } else {
        desabilitaCriancas();
    }
}

function validaChecksDeficiencias() {
    if ($("#usu_deficiencia:checked").val() == "t") {
        habilitaDeficiencias();
    } else {
        desabilitaDeficiencias();
    }
}

function validaChecksCardiaca() {
    if ($("#uis_doenca_cardiaca:checked").val() == "t") {
        habilitaCardiaca();
    } else {
        desabilitaCardiaca();
    }
}

function validaChecksRenal() {
    if ($("#uis_problema_rins:checked").val() == "t") {
        habilitaRenal();
    } else {
        desabilitaRenal();
    }
}

function validaChecksPulmonar() {
    if ($("#uis_doenca_respiratoria:checked").val() == "t") {
        habilitaPulmonar();
    } else {
        desabilitaPulmonar();
    }
}

function validaChecksHigiene() {
    if ($("#uis_acesso_higiene_pessoal:checked").val() == "t") {
        habilitaAcessosHigiene();
    } else {
        desabilitaAcessosHigiene();
    }
}

function validaComunidade() {
    if ($("#uis_povo_comunidade_trad:checked").val() == "t") {
        $("#povo_comunidade_trad_nome").show();
    } else {
        $("#povo_comunidade_trad_nome").hide();
        $("#uis_povo_comunidade_trad_nome").val("");
    }
}

function validaOrientacaoSexual() {
    if ($("#uis_orientacao_sexual:checked").val() == "t") {
        $("#orientacao_sexual_nome").show();
    } else {
        $("#orientacao_sexual_nome").hide();
        $("#uis_orientacao_sexual_nome").prop('selectedIndex', 0);
    }
}

function validaIdentidadeGenero() {
    if ($("#uis_identidade_genero:checked").val() == "t") {
        $("#identidade_genero_nome").show();
    } else {
        $("#identidade_genero_nome").hide();
        $("#uis_identidade_genero_nome").prop('selectedIndex', 0);
    }
}

function validaInternacao() {
    if ($("#uis_internacao_dose_meses:checked").val() == "t") {
        $("#internacao_dose_meses_causa").show();
    } else {
        $("#internacao_dose_meses_causa").hide();
        $("#uis_internacao_dose_meses_causa").val("");
    }
}

function validaPlantas() {
    if ($("#uis_plantas_medicinais:checked").val() == "t") {
        $("#plantas_medicinais_nome").show();
    } else {
        $("#plantas_medicinais_nome").hide();
        $("#uis_plantas_medicinais_nome").val("");
    }
}

function validaInstituicao() {
    if ($("#uis_acompanhado_intituicao:checked").val() == "t") {
        $("#acompanhado_intituicao_nome").show();
    } else {
        $("#acompanhado_intituicao_nome").hide();
        $("#uis_acompanhado_intituicao_nome").val("");
    }
}

function validafrequencia() {
    if ($("#uis_vista_familiar_frequencia:checked").val() == "t") {
        $("#vista_familiar_grau").show();
    } else {
        $("#vista_familiar_grau").hide();
        $("#uis_vista_familiar_grau").val("");
    }
}

function validaObito() {
    if ($(".usu_mudanca_territorio:checked").val() == "t") {
        $('#obito_false').attr('checked', 'checked');
    }
    validaCamposObito();
}

function validaMudancaTerritorio() {
    if ($(".pep_obito:checked").val() == "t") {
        $('#mudanca_false').attr('checked', 'checked');
    }
}

function validaCamposRua() {
    if ($("#usu_sit_rua:checked").val() == "t") {
        $("#uis_situacao_rua_tempo").attr("disabled", false);
        $('input[name=uis_recebe_beneficio]').attr("disabled", false);
        $('input[name=uis_referencia_familiar]').attr("disabled", false);
        $("#uis_vezes_alimenta_dia").attr("disabled", false);
        habilitaOrigemAlimentacao();
        $('input[name=uis_acompanhado_intituicao]').attr("disabled", false);
        $("#uis_acompanhado_intituicao_nome").attr("disabled", false);
        $('input[name=uis_vista_familiar_frequencia]').attr("disabled", false);
        $("#uis_vista_familiar_grau").attr("disabled", false);
        $('input[name=uis_acesso_higiene_pessoal]').attr("disabled", false);
        habilitaAcessosHigiene();
    } else {
        $("#uis_situacao_rua_tempo").attr("disabled", true);
        $("#uis_situacao_rua_tempo").val("");
        $("input[name=uis_recebe_beneficio]").attr("disabled", true);
        $("input[name=uis_recebe_beneficio]").attr("checked", false);
        $("input[name=uis_referencia_familiar]").attr("disabled", true);
        $("input[name=uis_referencia_familiar]").attr("checked", false);
        $("#uis_vezes_alimenta_dia").attr("disabled", true);
        $("#uis_vezes_alimenta_dia").val("");
        desabilitaOrigemAlimentacao();
        $("input[name=uis_acompanhado_intituicao]").attr("disabled", true);
        $("input[name=uis_acompanhado_intituicao]").attr("checked", false);
        $("#uis_acompanhado_intituicao_nome").attr("disabled", true);
        $("#uis_acompanhado_intituicao_nome").val("");
        $("input[name=uis_vista_familiar_frequencia]").attr("disabled", true);
        $("input[name=uis_vista_familiar_frequencia]").attr("checked", false);
        $("#uis_vista_familiar_grau").attr("disabled", true);
        $("#uis_vista_familiar_grau").val("");
        $("input[name=uis_acesso_higiene_pessoal]").attr("disabled", true);
        $("input[name=uis_acesso_higiene_pessoal]").attr("checked", false);
        desabilitaAcessosHigiene();
    }
    validaInstituicao();
    validafrequencia();
    validaChecksHigiene();
}

function buscarOcupacoes() {
    $("#no_ocupacao").buscar({
        url: baseUrl + '/default/paciente/buscar-ocupacao/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function getProntuarioDuplicado(val) {
    $.ajax({
        url: baseUrl + "/default/paciente/get-prontuario-duplicado/",
        type: "GET",
        data: {
            prontuario: val
        },
        success: function (json) {
            if (json >= 1) {
                $("#pep_prontuario_val").val(1);
            } else {
                $("#pep_prontuario_val").val(0);
            }
        }
    });
}

function validacoesCadastro() {

    validaAbas();

    $.validator.addMethod("validaNomeCidadao", function (validaNomeCidadao, element) {
        if (!validaNomeEsus(element.id)) {
            return false;
        } else {
            return true;
        }
    }, "Verifique a informação!");

    $.validator.addMethod("validaBairro", function (validaBairro, element) {
        if ($("#rua_nome").val() != "" && $("#rua_bairro").val() == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaMaternidade", function (validaMaternidade, element) {
        if ($(".usu_esta_gestante:checked").val() === "t" && $("#usu_maternidade_ref").val() == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaDataObito", function (validaDataObito, element) {
        if ($(".pep_obito:checked").val() === "t" && $("#pep_data_obito").val() == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaResponsavel", function (validaResponsavel, element) {
        if ($("#rua_nome").val() != "" && $("#proprio_responsavel:checked").val() != "S") {
            if ($("#usu_nome_responsavel").val() == "") {
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaResponsavelProprio", function (validaResponsavelProprio, element) {
        if ($("#rua_nome").val() != "" && $("#proprio_responsavel:checked").val() == undefined) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaNumDomicilio", function (validaNumDomicilio, element) {
        if ($("#rua_nome").val() != "" && $("#dom_numero").val() == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaCpf", function (validaCpf, element) {
        var cpf = $("#cnpj_cpf").val();
        cpf = cpf.replace(".", "").replace(".", "").replace("-", "");

        if (TestaCPF(cpf) || cpf == "") {
            return true;
        } else {
            return false;
        }
    }, "Cpf Inválido!");

    $.validator.addMethod("validaProntuario", function (validaProntuario, element) {
        if ($("#pep_prontuario_val").val() == "1") {
            return false;
        } else {
            return true;
        }
    }, "Prontuario já existe!");

    $.validator.addMethod("validaCep", function (validaCep, element) {
        if ($("#rua_nome").val() != "" && $("#rua_cep").val() == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaRua", function (validaRua, element) {
        if ($("#rua_nome").val() != "" && $("#dom_numero").val() != "" && $("#rua_codigo").val() == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $.validator.addMethod("validaOrgaoEmissor", function (validaOrgaoEmissor, element) {
        var orgaoemissor = $("#orgaoemissor").val().length;
        if (orgaoemissor > 6) {
            return false;
        } else {
            return true;
        }
    }, "Máximo de 6 digitos!");

    $.validator.addMethod("validaCidade", function (validaCidade, element) {
        var nacionalidade = $("#cd_nacionalidade option:selected").val();
        var cidade = $("#cid_codigo").val();
        if (nacionalidade == "B" && cidade == "") {
            return false;
        } else {
            return true;
        }
    }, "Selecione uma cidade");

    $.validator.addMethod("validaDeficiencia", function (validaDeficiencia, element) {
        var deficiencia = $("#usu_deficiencia:checked").val();
        validaDeficiencias();
        if (deficiencia == "t" && ($("#conf_def").val() == "" || $("#conf_def").val() == 0) && $("#info_socio").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Selecione a(s) deficiência(s)");

    $.validator.addMethod("validaCriancaNove", function (validaCriancaNove, element) {
        if (getIdade() <= 9 && ($("#conf_crianca").val() == "" || $("#conf_crianca").val() == 0) && $("#info_socio").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Selecione ao menos uma opção");

    $.validator.addMethod("validaCardiaca", function (validaCardiaca, element) {
        var cardiaca = $("#uis_doenca_cardiaca:checked").val();
        validaDoencaCardiaca();
        if (cardiaca == "t" && ($("#conf_cardiaca").val() == "" || $("#conf_cardiaca").val() == 0) && $("#cond_gerais").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Selecione a(s) doença(s)");

    $.validator.addMethod("validaRenal", function (validaRenal, element) {
        var renal = $("#uis_problema_rins:checked").val();
        validaDoencaRenal();
        if (renal == "t" && ($("#conf_renal").val() == "" || $("#conf_renal").val() == 0) && $("#cond_gerais").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Selecione o(s) probelma(s)");

    $.validator.addMethod("validaPulmonar", function (validaPulmonar, element) {
        var pulmonar = $("#uis_doenca_respiratoria:checked").val();
        validaDoencaPulmonar();
        if (pulmonar == "t" && ($("#conf_respiratoria").val() == "" || $("#conf_respiratoria").val() == 0) && $("#cond_gerais").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Selecione a(s) doença(s)");

    $.validator.addMethod("validaAcessos", function (validaAcessos, element) {
        var uis_acesso_higiene_pessoal = $("#uis_acesso_higiene_pessoal:checked").val();
        validaAcessosHigiene();
        if (uis_acesso_higiene_pessoal == "t" && ($("#conf_higiene").val() == "" || $("#conf_higiene").val() == 0) && $("#sit_rua").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Selecione o(s) acesso(s)");

    $.validator.addMethod("validaDataCadastro", function (validaDataCadastro, element) {
        var usu_microarea = $("#usu_microarea").val();
        var usu_microare_fa = $("#usu_microarea_fa").attr("checked");
        var usu_data_cad = $("#usu_data_cad").val();
        if ((usu_microarea != "" || usu_microare_fa == "checked") && usu_data_cad == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaFreqEscola", function (validaFreqEscola, element) {
        var usu_microarea = $("#usu_microarea").val();
        var usu_microare_fa = $("#usu_microarea_fa").attr("checked");
        var pep_frenquencia_escolar = $("#pep_frenquencia_escolar:checked").val();
        var usu_recusa = $("#usu_recusa:checked").val();
        if ((usu_microarea != "" || usu_microare_fa == "checked") &&
            (pep_frenquencia_escolar == "" || pep_frenquencia_escolar == undefined) && usu_recusa != "t") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaSitRua", function (validaSitRua, element) {
        var usu_microarea = $("#usu_microarea").val();
        var usu_microare_fa = $("#usu_microarea_fa").attr("checked");
        var usu_sit_rua = $("#usu_sit_rua:checked").val();
        var usu_recusa = $("#usu_recusa:checked").val();
        if ((usu_microarea != "" || usu_microare_fa == "checked") &&
            (usu_sit_rua == "" || usu_sit_rua == undefined) && usu_recusa != "t") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemDeficiencia", function (validaTemDeficiencia, element) {
        var usu_microarea = $("#usu_microarea").val();
        var usu_microare_fa = $("#usu_microarea_fa").attr("checked");
        var usu_deficiencia = $("#usu_deficiencia:checked").val();
        var usu_recusa = $("#usu_recusa:checked").val();
        if ((usu_microarea != "" || usu_microare_fa == "checked") &&
            (usu_deficiencia == "" || usu_deficiencia == undefined) && usu_recusa != "t") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemComunidade", function (validaTemComunidade, element) {
        var uis_povo_comunidade_trad = $("#uis_povo_comunidade_trad:checked").val();
        var uis_povo_comunidade_trad_nome = $("#uis_povo_comunidade_trad_nome").val();
        if (uis_povo_comunidade_trad == "t" && uis_povo_comunidade_trad_nome == "" && $("#info_socio").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemOrientacao", function (validaTemOrientacao, element) {
        var uis_orientacao_sexual = $("#uis_orientacao_sexual:checked").val();
        var uis_orientacao_sexual_nome = $("#uis_orientacao_sexual_nome").val();
        if (uis_orientacao_sexual == "t" && uis_orientacao_sexual_nome == "" && $("#info_socio").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemIdentidade", function (validaTemIdentidade, element) {
        var uis_identidade_genero = $("#uis_identidade_genero:checked").val();
        var uis_identidade_genero_nome = $("#uis_identidade_genero_nome").val();
        if (uis_identidade_genero == "t" && uis_identidade_genero_nome == "" && $("#info_socio").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemInternacao", function (validaTemInternacao, element) {
        var uis_internacao_dose_meses = $("#uis_internacao_dose_meses:checked").val();
        var uis_internacao_dose_meses_causa = $("#uis_internacao_dose_meses_causa").val();
        if (uis_internacao_dose_meses == "t" && uis_internacao_dose_meses_causa == "" && $("#cond_gerais").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemPlantas", function (validaTemPlantas, element) {
        var uis_plantas_medicinais = $("#uis_plantas_medicinais:checked").val();
        var uis_plantas_medicinais_nome = $("#uis_plantas_medicinais_nome").val();
        if (uis_plantas_medicinais == "t" && uis_plantas_medicinais_nome == "" && $("#cond_gerais").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemInstituicao", function (validaTemInstituicao, element) {
        var uis_acompanhado_intituicao = $("#uis_acompanhado_intituicao:checked").val();
        var uis_acompanhado_intituicao_nome = $("#uis_acompanhado_intituicao_nome").val();
        if (uis_acompanhado_intituicao == "t" && uis_acompanhado_intituicao_nome == "" && $("#sit_rua").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $.validator.addMethod("validaTemFamiliarFreq", function (validaTemFamiliarFreq, element) {
        var uis_vista_familiar_frequencia = $("#uis_vista_familiar_frequencia:checked").val();
        var uis_vista_familiar_grau = $("#uis_vista_familiar_grau").val();
        if (uis_vista_familiar_frequencia == "t" && uis_vista_familiar_grau == "" && $("#sit_rua").is(':enabled')) {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");

    $("#form").validate({
        rules: {
            nome: {required: true, validaNomeCidadao: true},
            datanascimento: {required: true},
            pep_mae: {required: true, validaNomeCidadao: true},
            pep_pai: {validaNomeCidadao: true},
            pep_sexo: {required: true},
            rua_bairro: {validaBairro: true},
            rua_cep: {validaCep: true},
            rua_codigo: {validaRua: true},
            dom_numero: {validaNumDomicilio: true},
            pep_prontuario: {validaProntuario: true},
            cnpj_cpf: {validaCpf: true},
            orgaoemissor: {validaOrgaoEmissor: true},
            cid_nome: {validaCidade: true},
            pep_data_obito: {validaDataObito: true},
            usu_maternidade_ref: {validaMaternidade: true},
            rac_codigo: {required: true},
            cd_nacionalidade: {required: true},
            pep_frenquencia_escolar: {validaFreqEscola: true},
            usu_sit_rua: {validaSitRua: true},
            usu_deficiencia: {validaTemDeficiencia: true},
            conf_def: {validaDeficiencia: true},
            conf_cardiaca: {validaCardiaca: true},
            conf_renal: {validaRenal: true},
            conf_respiratoria: {validaPulmonar: true},
            conf_crianca: {validaCriancaNove: true},
            conf_higiene: {validaAcessos: true},
            usu_nome_responsavel: {validaResponsavel: true},
            proprio_responsavel: {validaResponsavelProprio: true},
            // uni_codigo: {validaProfissional: true},
            // equipe_codigo: {validaEquipe: true},
            // esp_codigo: {validaEspecialidade: true},
            // usu_microarea: {validaMicroarea: true},
            usu_data_cad: {validaDataCadastro: true},
            uis_povo_comunidade_trad_nome: {validaTemComunidade: true},
            uis_orientacao_sexual_nome: {validaTemOrientacao: true},
            uis_identidade_genero_nome: {validaTemIdentidade: true},
            uis_internacao_dose_meses_causa: {validaTemInternacao: true},
            uis_plantas_medicinais_nome: {validaTemPlantas: true},
            uis_acompanhado_intituicao_nome: {validaTemInstituicao: true},
            uis_vista_familiar_grau: {validaTemFamiliarFreq: true},
        },
        messages: {
            nome: {required: "Campo Obrigatório"},
            datanascimento: {required: "Campo Obrigatório"},
            pep_mae: {required: "Campo Obrigatório", minlength: "Insira no mínimo 4 caracteres!"},
            pep_sexo: {required: "Campo Obrigatório"},
            uni_codigo: {required: "Campo Obrigatório"},
            rac_codigo: {required: "Campo Obrigatório"},
            cd_nacionalidade: {required: "Campo Obrigatório"},
            usu_sit_rua: {required: "Campo Obrigatório"},
            usu_deficiencia: {required: "Campo Obrigatório"},
        },
        submitHandler: function () {
            result = true;
            if ($("#rac_codigo option:selected").val() == 5) {
                if ($("#etn_codigo option:selected").val() === "") {
                    result = false;
                    mensagem("Atenção", "Obrigatório Etnia quando Indigena em raca/cor!", 300, 150);
                    $("#etn_codigo").focus();
                }
            }

            if ($("#cd_nacionalidade option:selected").val() == 'E') {
                if ($("#epa_codigo option:selected").val() === "") {
                    result = false;
                    mensagem("Atenção", "Obrigatório País quando nacionalidade Estrangeiro!", 300, 150);
                    $("#epa_codigo").focus();
                }
            }

            if ($("#cd_nacionalidade option:selected").val() == 'N') {
                if ($("#pep_portaria_naturalizacao").val() === "") {
                    result = false;
                    mensagem("Atenção", "Obrigatório Portaria Naturalização!", 300, 150);
                    $("#pep_portaria_naturalizacao").focus();
                }
                if ($("#pep_data_naturalizacao").val() === "") {
                    result = false;
                    mensagem("Atenção", "Obrigatório Data Naturalização!", 300, 150);
                    $("#pep_data_naturalizacao").focus();
                }
            }

            if ($("#proprio_responsavel:checked").val() == "N") {
                if ($("#info_socio").is(':enabled')) {
                    if ($("#uis_parentesco_resp").val() == "") {
                        result = false;
                        mensagem("Atenção", "Obrigatório informar o Parentesco com Responsável Familiar!", 300, 150);
                        //$("#uis_parentesco_resp").focus();
                    }
                }
            }

            if (!validaDataForm()) {
                result = false;
            }

            if (!checaSexoGestante()) {
                result = false;
            }

            if (!validaNomeEsus()) {
                result = false;
            }

            if ($('#pep_cartao_sus').val() != "") {
                if (!validaCns($('#pep_cartao_sus').val())) {
                    result = false;
                }
            }
            if ($("#usu_microarea").val() != "" || $("#usu_microarea_fa").attr("checked") == "checked") {
                if (!validaDataCad()) {
                    result = false;
                }
            }

            if (result) {
                salvarCadastro();
            }
        }
    });
}

function racCodigoChange() {
    if ($("#rac_codigo option:selected").val() == 5) {
        $("#etn_codigo").show();
        $(".etnia").show();
    } else {
        $("#etn_codigo").hide();
        $(".etnia").hide();
    }
}

function cdNacionalidadeChange() {
    if ($("#cd_nacionalidade option:selected").val() == 'E') {
        $("#epa_codigo").show();
        $("#epa_codigo_br").show();
        $("#epa_codigo_label").show();
        $("#pep_data_entrada_pais").show();
        $("#pep_data_entrada_pais_br").show();
        $("#pep_data_entrada_pais_label").show();
    } else {
        $("#epa_codigo").hide();
        $("#epa_codigo_label").hide();
        $("#epa_codigo_br").hide();
        $("#pep_data_entrada_pais").hide();
        $("#pep_data_entrada_pais_br").hide();
        $("#pep_data_entrada_pais_label").hide();
    }

    if ($("#cd_nacionalidade option:selected").val() == 'N') {
        $("#pep_portaria_naturalizacao").show();
        $("#pep_portaria_naturalizacao_br").show();
        $("#pep_portaria_naturalizacao_label").show();
        $("#pep_data_naturalizacao").show();
        $("#pep_data_naturalizacao_br").show();
        $("#pep_data_naturalizacao_label").show();
    } else {
        $("#pep_portaria_naturalizacao").hide();
        $("#pep_portaria_naturalizacao_label").hide();
        $("#pep_portaria_naturalizacao_br").hide();
        $("#pep_data_naturalizacao").hide();
        $("#pep_data_naturalizacao_br").hide();
        $("#pep_data_naturalizacao_label").hide();

    }
}

function betweenDate(dataEntrada, dataInicial, dataFinal) {
    var parts = dataEntrada.split('/');
    dataEntrada = new Date(parts[2], parts[1] - 1, parts[0]);
    parts = dataInicial.split('/');
    var dataInicial = new Date(parts[2], parts[1] - 1, parts[0]);
    parts = dataFinal.split('/');
    var dataFinal = new Date(parts[2], parts[1] - 1, parts[0]);
    if (dataEntrada >= dataInicial && dataEntrada <= dataFinal) {
        return true;
    } else {
        return false;
    }
}

function validaDataForm() {
    if ($("#cd_nacionalidade option:selected").val() == 'N') {
        if (betweenDate($("#pep_data_naturalizacao").val(), $("#datanascimento").val(), $("#dataatual").val())) {
            return true;
        } else {
            mensagem("Atenção", "Data de naturalização deve estar entre data nascimento e atual!", 300, 150);
            $("#pep_data_naturalizacao").focus();
            return false;
        }
    }
    if ($("#cd_nacionalidade option:selected").val() == 'E') {
        if (betweenDate($("#pep_data_entrada_pais").val(), $("#datanascimento").val(), $("#dataatual").val())) {
            return true;
        } else {
            mensagem("Atenção", "Data de entrada no país deve estar entre data nascimento e atual!", 300, 150);
            $("#pep_data_entrada_pais").focus();
            return false;
        }
    }
    return true;
}

function validaAbas() {
    if (($("#nome").val() == "" || $("#datanascimento").val() == "" || $("#pep_mae").val() == "")) {
        $(".abas").tabs({active: 0});
    }
    if (($("#nome").val() != "" && $("#datanascimento").val() != "" && $("#pep_mae").val() != "" && $("#rua_nome").val() != "") && ($("#rua_bairro").val() == "" || $("#rua_cep").val() == "" || $("#dom_numero").val() == "" || $("#co_tipo_logradouro").val() == "")) {
        $(".abas").tabs({active: 1});
    }
}

function habilitaCidade() {
    var nacionalidade = $("#cd_nacionalidade option:selected").val();
    if (nacionalidade == "B") {
        $("#div_cidade").show();
        $("#cidade").focus();
    } else {
        $("#div_cidade").hide();
    }
}

function desabilitaDeficiencias() {
    $("#deficiencias").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).prop('checked', false);
            $("#co_pergunta_detalhe" + $(this).val()).attr("disabled", true);
        });
    });
}

function habilitaDeficiencias() {
    $("#deficiencias").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).removeAttr("disabled");
        });
    });
}

function desabilitaCriancas() {
    $("#crianca").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).prop('checked', false);
            $("#co_pergunta_detalhe" + $(this).val()).attr("disabled", true);
        });
    });
}

function habilitaCriancas() {
    $("#crianca").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).removeAttr("disabled");
        });
    });
}

function desabilitaCardiaca() {
    $("#cardiaca").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).prop('checked', false);
            $("#co_pergunta_detalhe" + $(this).val()).attr("disabled", true);
        });
    });
}

function habilitaCardiaca() {
    $("#cardiaca").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).removeAttr("disabled");
        });
    });
}

function desabilitaRenal() {
    $("#renal").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).prop('checked', false);
            $("#co_pergunta_detalhe" + $(this).val()).attr("disabled", true);
        });
    });
}

function habilitaRenal() {
    $("#renal").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).removeAttr("disabled");
        });
    });
}

function desabilitaPulmonar() {
    $("#respiratoria").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).prop('checked', false);
            $("#co_pergunta_detalhe" + $(this).val()).attr("disabled", true);
        });
    });
}

function habilitaPulmonar() {
    $("#respiratoria").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).removeAttr("disabled");
        });
    });
}

function desabilitaOrigemAlimentacao() {
    $("#alimentacao").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).prop('checked', false);
            $("#co_pergunta_detalhe" + $(this).val()).attr("disabled", true);
        });
    });
}

function habilitaOrigemAlimentacao() {
    $("#alimentacao").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).removeAttr("disabled");
        });
    });
}

function desabilitaAcessosHigiene() {
    $("#higiene").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).prop('checked', false);
            $("#co_pergunta_detalhe" + $(this).val()).attr("disabled", true);
        });
    });
}

function habilitaAcessosHigiene() {
    $("#higiene").each(function (indice) {
        $(this).find('input[type="checkbox"]').each(function (indice) {
            $("#co_pergunta_detalhe" + $(this).val()).removeAttr("disabled");
        });
    });
}

function validaDeficiencias() {
    var cont = 0;
    $("#deficiencias").find("input[type=checkbox][name='deficiencias[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_def").val("");
    } else {
        $("#conf_def").val(cont);
    }
}

function validaCriancas() {
    var cont = 0;
    $("#crianca").find("input[type=checkbox][name='criancas[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_crianca").val("");
    } else {
        $("#conf_crianca").val(cont);
    }
}

function validaDoencaCardiaca() {
    var cont = 0;
    $("#cardiaca").find("input[type=checkbox][name='cardiaca[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_cardiaca").val("");
    } else {
        $("#conf_cardiaca").val(cont);
    }
}

function validaDoencaRenal() {
    var cont = 0;
    $("#renal").find("input[type=checkbox][name='renal[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_renal").val("");
    } else {
        $("#conf_renal").val(cont);
    }
}

function validaDoencaPulmonar() {
    var cont = 0;
    $("#respiratoria").find("input[type=checkbox][name='respiratoria[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_respiratoria").val("");
    } else {
        $("#conf_respiratoria").val(cont);
    }
}

function validaOrigem() {
    var cont = 0;
    $("#alimentacao").find("input[type=checkbox][name='alimentacao[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_alimentacao").val("");
    } else {
        $("#conf_alimentacao").val(cont);
    }
}

function validaAcessosHigiene() {
    var cont = 0;
    $("#higiene").find("input[type=checkbox][name='higiene[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_higiene").val("");
    } else {
        $("#conf_higiene").val(cont);
    }
}

function addRua() {
    window.open(baseUrl + "/rua/novo/popup/1", "_blank", "scrollbars=1,height=800,width=900", 'width=850,height=700');
}

function editarRua() {
    var rua_codigo = $("#rua_codigo").val();
    if (rua_codigo) {
        window.open(baseUrl + "/rua/editar/popup/1/id/" + rua_codigo, "_blank", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    } else {
        mensagem("Atenção", "Rua não selecionada para edição", 300, 150);
    }
}

function retornaRua(id, nome, cep, bai_codigo, bai_nome, cid, dist) {
    $("#rua_cep").val(cep);
    $("#rua_codigo").val(id);
    $("#rua_nome").val(nome);
    $("#bai_codigo").val(bai_codigo);
    $("#rua_bairro").val(bai_nome);
    $("#localidade").val(cid + " - Distrito: " + dist);
    $("#rua_cep").prop('readonly', true);
    getEnderecos();
}

function validaPaciente() {
    if ($("#novo").is(" :checked")) {
        $("#nome").autocomplete({disabled: true});
        $("#nome").val("");
        $("#nome").focus();
    } else {
        $("#nome").autocomplete({disabled: false});
        $("#nome").val("");
        $("#nome").focus();
        $("#nome").buscar({
            url: baseUrl + '/default/paciente/buscar-pessoa/',
            template: function (ul, item) {
                if (item.data.datanascimento == "" || item.data.datanascimento == "undefined") {
                    item.data.datanascimento = "Sem Informação";
                } else {
                    item.data.datanascimento = dataToBr(item.data.datanascimento);
                }

                if (item.data.cnpj_cpf == "" || item.data.cnpj_cpf == "undefined") {
                    item.data.cnpj_cpf = "Sem Informação";
                }

                return $("<li/>").data("item.autocomplete", item).append("<a><strong>" + item.label + "</strong>"
                    + "<br><strong>Data Nasc.:</strong> "
                    + item.data.datanascimento
                    + " <strong>CPF:</strong> " + item.data.cnpj_cpf
                    + "</a>&nbsp;").appendTo(ul);
            },
            callback: function (event, ui) {
                return true;
            }
        });
    }
}

function buscaCidade() {
    $("#cidade").buscar({
        url: baseUrl + '/default/cidade/buscar/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (event, ui) {
            getEnderecos();
        }
    });
}

function buscaCidades() {
    $("#cidade").buscar({
        url: baseUrl + '/cidade/buscar/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + " - " + item.data.uf_sigla + "</a>").appendTo(ul);
        },
        callback: function (ul, item) {
            return false;
        }
    });
}

function buscaEstado() {
    $("#uf").buscar({
        url: baseUrl + '/default/estado/buscar-por-nome/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (ul, item) {
            return false;
        }
    });
}

function clearCidade() {
    var string = $("#cidade").val();
    if (string.length == 0) {
        $("#cid_codigo").val("");
    }
}

function clearRua() {
    setTimeout(function () {
        if ($("#rua_nome").length == 0) {
            $("#editar_rua").hide();
            $("#rua_codigo").val("");
            $("#rua_cep").val("");
            $("#rua_nome").val("");
            $("#rua_nome").focus();
        }
    }, 500);
}


function clearBairro() {
    var string = $("#rua_bairro").val();
    if (string.length == 0) {
        $("#bai_codigo").val("");
    }
}

function buscarRua() {
    $("#rua_codigo").val("");
    $("#rua_nome").buscar({
        url: baseUrl + '/rua/buscar',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + ""
                + "<br/><strong>Bairro:</strong>" + item.data.bai_nome
                + "</a>&nbsp;").appendTo(ul);
        },
        callback: function (event, ui) {
            $("#rua_codigo").val(ui.item.id);
            $("#rua_cep").val(ui.item.data.rua_cep);
            $("#rua_bairro").val(ui.item.data.bai_nome);
            $("#rua_bairro").attr("disabled");
            $("#localidade").val(ui.item.data['cid_nome'] + " - Distrito: " + ui.item.data['dis_nome']);
            $("#editar_rua").show();
            getEnderecos();
            liberaCampos();
        }
    });
}

function getEnderecos() {
    $.ajax({
        url: baseUrl + "/default/paciente/buscar-numeros-de-domicilio-por-endereco/",
        type: "POST",
        data: {
            rua_codigo: $("#rua_codigo").val(),
            rua_cep: $("#rua_cep").val(),
            rua_bairro: $("#rua_bairro").val(),
            dom_numero: $("#dom_numero").val(),
            cid_codigo: $("#cid_codigo").val(),
            co_tipo_logradouro: $("#co_tipo_logradouro").val(),
            rua_nome: $("#rua_nome").val()
        },
        success: function (json) {
            var tr = "<tr class=\"notfirst\">" +
                "<th class=\"gridtable\">Logradouro </th>" +
                "<th class=\"gridtable\">Nº </th>" +
                "<th class=\"gridtable\">Compl. </th>" +
                "<th class=\"gridtable\">CEP </th>" +
                "<th class=\"gridtable\">Bairro </th>" +
                "<th class=\"gridtable\">Responsável </th>" +
                "<th class=\"gridtable\">Opções </th>" +
                "</tr>";
            for (var i in json) {
                if (json[i].usu_nome == "null" || json[i].usu_nome == "" || json[i].usu_nome == null) {
                    json[i].usu_nome = "Não Informado";
                }
                if (json[i].dom_numero == "null" || json[i].dom_numero == "" || json[i].dom_numero == null || json[i].dom_numero == 0) {
                    json[i].dom_numero = "S/N";
                }

                tr += "<tr class=\"regis notfirst hover_class\" >" +
                    "<td align='center' class=\"gridtable\">" + json[i].rua_nome + "</td>" +
                    "<td align='center' class=\"gridtable\">" + json[i].dom_numero + "</td>" +
                    "<td align='center' class=\"gridtable\">" + imprimeNull(json[i].dom_complemento) + "</td>" +
                    "<td align='center' class=\"gridtable\">" + imprimeNull(json[i].rua_cep) + "</td>" +
                    "<td class=\"gridtable\">" + imprimeNull(json[i].rua_bairro) + "</td>" +
                    "<td class=\"gridtable\">" + imprimeNull(json[i].usu_nome) + "</td>" +
                    "<td class=\"gridtable\" width=\"50\" align='center'>" +
                    "   <img title='Selecionar domicílio' " +
                    "        src=\"" + baseUrl + "/public/images/novo_select.png\" " +
                    "        style='width: 24px; height: 24px; cursor: pointer;'" +
                    "        onclick=\"selecionaEndereco('" + json[i].dom_numero + "','" + json[i].co_tipo_logradouro + "','" + json[i].ds_tipo_logradouro + "','" + json[i].rua_nome + "','" + json[i].rua_codigo + "','" + json[i].rua_cep + "','" + json[i].rua_bairro + "','" + json[i].dom_codigo + "','" + json[i].usu_codigo + "','" + json[i].usu_nome + "','" + json[i].cid_nome.replace("'", "") + "','" + json[i].cid_codigo + "','" + json[i].dom_complemento + "')\">" +
                    "</td>" +
                    "</tr>";
            }
            $("#results").html(tr);
        }
    });
}

function imprimeNull(campo) {
    return campo != null ? campo : "";
}

function changeSn() {
    alert($(this).val());
}

function selecionaEndereco(dom_numero, co_tipo_logradouro, ds_tipo_logradouro, rua_nome, rua_codigo, rua_cep, rua_bairro, dom_codigo, usu_codigo, usu_nome, cid_nome, cid_codigo, dom_complemento) {
    $("#rua_nome").val(rua_nome);
    $("#rua_cep").val(rua_cep);
    $("#rua_bairro").val(rua_bairro);
    $("#dom_numero").val(dom_numero);
    $("#dom_codigo").val(dom_codigo);
    $("#usu_nome_responsavel").val(usu_nome);
    $("#usu_codigo").val(usu_codigo);
    $("#rua_codigo").val(rua_codigo);
    $("#bai_codigo").val(bai_codigo);
    $("#dom_complemento").val(dom_complemento);

    $('select#co_tipo_logradoro').find('option').each(function () {
        if (co_tipo_logradouro == $(this).val()) {
            $(this).attr("selected", "selected");
        }
    });
    $("#dom_complemento").removeAttr("readonly");
    $("#busca-endereco").remove();
    $("#results").html("");
    $(".campos_dom").prop('readonly', true);
    $(".campos_dom_combo").attr("disabled");

    $("#acoes").show("slow");
    return false;
}


function inativaResponsavel() {
    if ($("#proprio_responsavel:checked").val() == "S") {
        $("#usu_nome_responsavel").prop('readonly', true);
        $("#usu_codigo").val("");
        $("#usu_nome_responsavel").val("");
    } else {
        $("#usu_nome_responsavel").removeAttr("readonly");
    }

}

function marca(e) {
    $(".selecionada").each(function () {
        $(this).removeClass("selecionada");
    });

    $(e).addClass("selecionada");
}

function liberaCampos() {
    $("#editar_rua").show();
    $("#acoes").hide("slow");
    $("#tabs1-2").find('select, textarea, input').each(function () {
        if (this.id !== 'rua_nome' && this.id !== 'rua_bairro'
            && this.id !== 'proprio_responsavel' && this.id !== 'rua_cep' && this.id !== 'localidade') {
            $(this).prop("readonly", false);
        }
    });
    $("#sn").prop("disabled", false);
}

function maskTelefone(idTelefone) {
    $("#" + idTelefone).mask("(99) 9999-9999?9");
    $("#" + idTelefone).blur(function (event) {
        if ($(this).val().length == 15) {
            $("#" + idTelefone).mask('(99) 99999-999?9');
        } else {
            $("#" + idTelefone).mask('(99) 9999-9999?9');
        }
    });
}

function informaSn(e) {
    var checado = false;
    if ($(e).attr("checked") == "checked") {
        checado = true;
    } else {
        checado = false;
    }

    if (checado) {
        $("#dom_numero").val("0");
        getEnderecos();
        $("#dom_numero").val("S/N");
        $("#dom_numero").attr("disabled");
    } else {
        $("#dom_numero").removeAttr("disabled");
        $("#dom_numero").val("");
    }

}

function removeDom() {
    $("#tabs1-2").find('select, textarea, input').each(function () {
        $(this).val("");
    });
    $("#proprio_responsavel").prop("checked", false);
    $("#acoes").hide("slow");
    $("#add_rua").show();
    $(".campos_dom").removeAttr("readonly");
    $(".campos_dom_combo").removeAttr("disabled");
}

function salvarCadastro() {
    var metodo = "salvar-usuario";

    mensagemSemOk("carregando-ate", "Aguarde", "Carregando...", 280, 80);
    var usu_nome = $("#nome").val();
    var valoresForm = $('#form').serialize();
    if (valoresForm.indexOf("usu_esta_gestante") == -1) {
        valoresForm = valoresForm + "&usu_esta_gestante=";
    }
    console.log("valoresform=" + valoresForm);
    $.ajax({
        url: baseUrl + "/default/paciente/lista-cadastros-duplicados/",
        type: "POST",
        data: {
            nome: $("#nome").val(),
            datanascimento: $("#datanascimento").val(),
            pep_mae: $("#pep_mae").val(),
            usu_cartao_sus: $('#pep_cartao_sus').val()
        },
        success: function (txt) {
            if (txt != "" && $("#pessoa-edita").val() == "") {
                $("body").append("<div id='conf-cadastro' title='Conferência de cadastro duplicado!' ></div>");
                var table = "<table width=\"100%\" class=\"gridtable hoverTable\">" +
                    "<tr class=\"notfirst\">" +
                    "<th class=\"gridtable\">Prontuário</th>" +
                    "<th class=\"gridtable\">Nome</th>" +
                    "<th class=\"gridtable\">Data Nascimento</th>" +
                    "<th class=\"gridtable\">Nome Mãe</th>" +
                    "<th class=\"gridtable\">Situação</th>" +
                    "</tr>";
                for (var i in txt) {
                    table += "<tr class=\"regis notfirst hover_class\" data-pessoa=\"" + i + "\" onclick=\"marca(this)\">" +
                        "<td class=\"gridtable\">" + txt[i].prontuario + "</td>" +
                        "<td class=\"gridtable\">" + txt[i].nome + "</td>" +
                        "<td class=\"gridtable\">" + txt[i].datanascimento + "</td>" +
                        "<td class=\"gridtable\">" + txt[i].pep_mae + "</td>" +
                        "<td class=\"gridtable\">" + txt[i].inativo + "</td>" +
                        "</tr>";
                }
                table += "</table>";

                $("#conf-cadastro").html(table);
                $("#conf-cadastro").dialog({
                    modal: true,
                    width: 800,
                    height: 500,
                    close: function () {

                    },
                    buttons: {
                        "Atualizar Cadastro": function () {
                            if ($("tr.selecionada").length <= 0) {
                                $("body").append("<div id=\"mensagem-dialog-usuarios\" title=\"Erro\">Não há itens selecionados</div>")
                                $("#mensagem-dialog-usuarios").dialog({
                                    modal: true,
                                    width: 250,
                                    height: 150,
                                    close: function () {
                                        $(this).remove();
                                    },
                                    buttons: {
                                        "Ok": function () {
                                            $(this).dialog('close');
                                        }
                                    }
                                });
                                return false;
                            } else {
                                var url = "";
                                url = baseUrl + "/default/paciente/form-paciente/pessoa/" + $("tr.selecionada").data("pessoa");
                                window.location = url;
                            }
                        },
                        "Efetuar Cadastro": function () {
                            $.ajax({
                                url: baseUrl + "/default/paciente/" + metodo + "/",
                                type: "POST",
                                data: valoresForm,
                                success: function (txt) {
                                    if (txt.id == "" || txt.id == null || txt.id == "undefined") {
                                        $("#conf-cadastro").dialog("destroy").remove();
                                        mensagem("Erro!", txt, 300, 150, function () {
                                            sucesso_salvar()
                                        });
                                    } else {
                                        $("#conf-cadastro").dialog("destroy").remove();
                                        mensagem("Confirmação de Cadastro", txt.msg, 300, 150, function () {
                                            sucesso_salvar(txt.id, usu_nome, poupup)
                                        });
                                        $(":text").each(function () {
                                            $(this).val("");
                                        });
                                    }
                                }
                            });
                        },
                        "Cancelar Cadastro": function () {
                            window.location = "../../../../WebSocialSaude/paciente.php";
                        }
                    }
                });
            } else {
                if ($("#pessoa-edita").val() == "") {
                    endUrl = baseUrl + "/default/paciente/" + metodo + "/";
                } else {
                    endUrl = baseUrl + "/default/paciente/" + metodo + "/pessoa/" + $("#pessoa-edita").val() + "/";
                }
                $.ajax({
                    url: endUrl,
                    type: "POST",
                    data: valoresForm,
                    success: function (txt) {
                        if (txt.id == "" || txt.id == null || txt.id == "undefined") {
                            $("#conf-cadastro").dialog("destroy").remove();
                            mensagem("Erro!", txt, 300, 150, function () {
                                fecharMensagemSemOk("carregando-ate");
                            });
                        } else {
                            $("#conf-cadastro").dialog("destroy").remove();
                            fecharMensagemSemOk("carregando-ate");

                            mensagem("Confirmação de Cadastro", txt.msg, 300, 150, function () {
                                sucesso_salvar(txt.id, usu_nome, $("#poupup").val());
                            });
                            if ($("#pessoa-edita").val() == "") {
                                $(":text").each(function () {
                                    $(this).val("");
                                });
                            }
                        }
                    }
                });
            }
        }
    });
}

function sucesso_salvar(id, usu_nome, poupup) {
    if (poupup == 1) {
        this.opener.retornaPac(id, usu_nome.toUpperCase());
        this.close();
    } else {
        if (valida == 0)
            window.location = baseUrl + "/../paciente.php";
        else
            window.location = baseUrl + "/programas-federais/cadastro-individual/inconsistencias";
    }
}


function buscarCep() {

    $("#rua_cep").buscar({
        url: baseUrl + '/default/paciente/buscar-cep/',

        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            $("#rua_cep").val("");
            $("#rua_cep").val($("#rua_cep_hidden").val());
            return true;
        }
    });
}

function buscaRua() {
    $("#rua_nome").buscar({
        url: baseUrl + '/default/paciente/buscar-rua/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

}

function buscaBairro() {
    $("#bai_codigo").val("");
    $("#rua_bairro").buscar({
        url: baseUrl + '/default/bairro/buscar/',
        //suffix: '_solicitante',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            getEnderecos();
            return true;
        }
    });

}

function buscarNumerosDeDomicilioPorEndereco() {
    $("#dom_numero").buscar({
        url: baseUrl + '/default/paciente/buscar-numeros-de-domicilio-por-endereco/rua_nome/' + $("#rua_nome").val() + '/rua_bairro/' + $("#rua_bairro").val() + '/rua_cep/' + $("#rua_cep").val() + '/dom_complemento' + $("#dom_complemento").val() + '/',
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                +"<a><strong>" + item.label + "</strong>"
                + "</a>&nbsp;").appendTo(ul);
        },
        callback: function (event, ui) {
            return true;
        }
    });
}

function verificaVinculo() {
    $.ajax({
        url: baseUrl + '/default/paciente/buscar-numeros-de-domicilio-por-endereco/rua_codigo/' + $("#rua_codigo").val() + '/rua_bairro/' + $("#rua_bairro").val() + '/rua_cep/' + $("#rua_cep").val() + '/dom_complemento/' + $("#dom_complemento").val() + '/' + '/dom_numero/' + $("#dom_numero").val() + '/',
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                +"<a><strong>" + item.label + "</strong>"
                + "</a>&nbsp;").appendTo(ul);
        },
        callback: function (event, ui) {
            return true;
        }
    });
}


function buscarResponsavelModal() {
    $("#usu_nome_responsavel").buscar({
        url: baseUrl + '/paciente/buscar',
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a><strong>" + item.label + "</strong>"
                + "<br><strong>Data Nasc.:</strong> "
                + item.data.usu_datanasc
                + " <strong>Mãe:</strong> " + item.data.usu_mae
                + "</a>&nbsp;").appendTo(ul);
        },
        suffix: '-2',
        callback: function (event, ui) {
            $("#usu_codigo").val(ui.item.id);
            verificaVinculosDomicilios(ui.item.id);
        }

    });
}


function verificaVinculosDomicilios(usu_codigo) {
    $.ajax({
        url: baseUrl + "/paciente/verifica-vinculos-domicilio",
        data: {usu_codigo: usu_codigo},
        success: function (txt) {
            var dom_codigo = "";
            if (txt.length > 0) {
                var msg = "O paciente selecionado possui vínculo nos domicilios!";
                msg += "<table width='100%' border=1>" +
                    "<tr>" +
                    "<th>Rua</th>" +
                    "<th>Número</th>" +
                    "<th>Bairro</th>" +
                    "<th>Situação</th>" +
                    "</tr>";
                for (var i in txt) {
                    if (dom_codigo !== txt[i].dom_codigo) {
                        dom_codigo = txt[i].dom_codigo;

                        msg += "<tr>" +
                            "<td>" + txt[i].ds_tipo_logradouro + " " + txt[i].rua_nome + "</td>" +
                            "<td>" + txt[i].dom_numero + "</td>" +
                            "<td>" + (txt[i].bai_nome == null ? "Sem bairro" : txt[i].bai_nome) + "</td>" +
                            "<td>" + (txt[i].usu_codigo_responsavel == null ? "Integrante" : "Responsável") + "</td>" +
                            "</tr>";
                    }
                }
                msg += "</table>";
                msg += "<br/> <font color='red'>AVISO: Ao selecionar este cidadão como responsável ele se tornará integrante e responsável do domicilio informado!</font>";
                mensagem("Aviso", msg, 600, 300);
            }
        }
    });
}

function busca() {
    var cep = $.trim($('#rua_cep_b').val());
    if (cep.length >= 8 && cep.indexOf("-") == -1) {
        $('#erro-cep').show();
    }
    if (cep.length >= 9) {
        mensagemSemOk("carregando-log", "Carregando...", "Carregando dados do logradouro", 250, 100);
        var url = 'http://clareslab.com.br/ws/cep/json/' + cep + '/';
        $.post(url, {
                cep: cep
            },
            function (rs) {
                rs = $.parseJSON(rs);
                if (rs != 0) {
                    address = rs.endereco + ', ' + rs.bairro + ', ' + rs.cidade + ', ' + ', ' + rs.uf;
                    $('#rua_nome_b').val(rs.endereco);
                    $('#rua_bairro_b').val(rs.bairro);
                    buscaCidadePeloNome(strReplaceChr(rs.cidade));
                    $('#erro-cep').hide();
                    last_cep = cep;
                    fecharMensagemSemOk("carregando-log");
                } else {
                    $('#erro-cep').show();
                    $('#cep').focus();
                    last_cep = 0;
                    fecharMensagemSemOk("carregando-log");
                }
            });
    }
}

function buscaCidadePeloNome(cidade) {
    $.ajax({
        url: baseUrl + "/default/cidade/busca-cidade-pelo-nome",
        type: "POST",
        data: {cidade: cidade},
        success: function (txt) {
            $("#cid_codigo").val(txt.cid_codigo);
            $("#cidade").val(txt.cid_nome);
            $("#cidade_b").val(txt.cid_nome);
        }
    });
}

function strReplaceChr(texto) {
    var chrEspeciais = new Array("á", "à", "â", "ã", "ä", "é", "è", "ê", "ë",
        "í", "ì", "î", "ï", "ó", "ò", "ô", "õ", "ö",
        "ú", "ù", "û", "ü", "ç",
        "Á", "À", "Â", "Ã", "Ä", "É", "È", "Ê", "Ë",
        "Í", "Ì", "Î", "Ï", "Ó", "Ò", "Ô", "Õ", "Ö",
        "Ú", "Ù", "Û", "Ü", "Ç");
    var chrNormais = new Array("a", "a", "a", "a", "a", "e", "e", "e", "e",
        "i", "i", "i", "i", "o", "o", "o", "o", "o",
        "u", "u", "u", "u", "c",
        "A", "A", "A", "A", "A", "E", "E", "E", "E",
        "I", "I", "I", "I", "O", "O", "O", "O", "O",
        "U", "U", "U", "U", "C");
    for (index in chrEspeciais) {
        texto = texto.replace(chrEspeciais[index], chrNormais[index]);
    }

    return texto.toUpperCase();
}

function SomenteNumero(e) {
    var tecla = (window.event) ? event.keyCode : e.which;
    if ((tecla > 47 && tecla < 58)) {
        setTimeout(function () {
            getEnderecos()
        }, 500);
        return true;
    } else {
        if (tecla == 8 || tecla == 0) {
            setTimeout(function () {
                getEnderecos()
            }, 500);
            return true;
        } else {
            return false;
        }
    }
}


function validaCns(vlr_cns) {
    var retorno = false;

    $.ajax({
        url: baseUrl + "/default/paciente/valida-cns-duplicado",
        type: "POST",
        async: false,
        data: {cns: vlr_cns},
        success: function (txt) {
            if (txt > 0 && $("#cartao_sus_referencia_validacao").val() != vlr_cns) {
                mensagem("Atenção", "Numero de CNS já existe", 300, 150);
                $("#pep_cartao_sus").val("");
            } else {
                retorno = validador_cns(vlr_cns);
            }
        }
    });

    return retorno;
}

function validador_cns(vlr_cns) {
    if ((vlr_cns.substring(0, 1) != "7") && (vlr_cns.substring(0, 1) != "8") && (vlr_cns.substring(0, 1) != "9")) {
        return validaCNS(vlr_cns);
    } else {
        return ValidaCNS_PROV(vlr_cns);
    }
}

function validaCNS(vlrCNS) {
    var soma = new Number;
    var resto = new Number;
    var dv = new Number;
    var pis = new String;
    var resultado = new String;
    var tamCNS = vlrCNS.length;

    if ((tamCNS) != 15) {
        mensagem("Atenção", "Numero de CNS invalido", 300, 150);
        $("#pep_cartao_sus").val("");
        return false;
    }
    pis = vlrCNS.substring(0, 11);
    soma = (((Number(pis.substring(0, 1))) * 15) +
        ((Number(pis.substring(1, 2))) * 14) +
        ((Number(pis.substring(2, 3))) * 13) +
        ((Number(pis.substring(3, 4))) * 12) +
        ((Number(pis.substring(4, 5))) * 11) +
        ((Number(pis.substring(5, 6))) * 10) +
        ((Number(pis.substring(6, 7))) * 9) +
        ((Number(pis.substring(7, 8))) * 8) +
        ((Number(pis.substring(8, 9))) * 7) +
        ((Number(pis.substring(9, 10))) * 6) +
        ((Number(pis.substring(10, 11))) * 5));
    resto = soma % 11;
    dv = 11 - resto;
    if (dv == 11) {
        dv = 0;
    }
    if (dv == 10) {
        soma = (((Number(pis.substring(0, 1))) * 15) +
            ((Number(pis.substring(1, 2))) * 14) +
            ((Number(pis.substring(2, 3))) * 13) +
            ((Number(pis.substring(3, 4))) * 12) +
            ((Number(pis.substring(4, 5))) * 11) +
            ((Number(pis.substring(5, 6))) * 10) +
            ((Number(pis.substring(6, 7))) * 9) +
            ((Number(pis.substring(7, 8))) * 8) +
            ((Number(pis.substring(8, 9))) * 7) +
            ((Number(pis.substring(9, 10))) * 6) +
            ((Number(pis.substring(10, 11))) * 5) + 2);
        resto = soma % 11;
        dv = 11 - resto;
        resultado = pis + "001" + String(dv);
    } else {
        resultado = pis + "000" + String(dv);
    }
    if (vlrCNS != resultado) {
        mensagem("Atenção", "Numero de CNS inválido!", 300, 150);
        $("#pep_cartao_sus").val("");
        return false;
    } else {
        return true;
    }
}

function ValidaCNS_PROV(Obj) {
    var pis;
    var resto;
    var dv;
    var soma;
    var resultado;
    var result;
    result = 0;

    var tamCNS = Obj.length;

    if ((tamCNS) != 15) {
        mensagem("Atenção", "Numero de CNS invalido", 300, 150);
        $("#pep_cartao_sus").val("");
        return false;
    }

    pis = Obj.substring(0, 15);

    if (pis == "") {
        return false;
    }

    if ((Obj.substring(0, 1) != "7") && (Obj.substring(0, 1) != "8") && (Obj.substring(0, 1) != "9")) {
        mensagem("Atenção", "Numero de CNS invalido", 300, 150);
        $("#pep_cartao_sus").val("");
        return false;
    }

    soma = ((parseInt(pis.substring(0, 1), 10)) * 15)
        + ((parseInt(pis.substring(1, 2), 10)) * 14)
        + ((parseInt(pis.substring(2, 3), 10)) * 13)
        + ((parseInt(pis.substring(3, 4), 10)) * 12)
        + ((parseInt(pis.substring(4, 5), 10)) * 11)
        + ((parseInt(pis.substring(5, 6), 10)) * 10)
        + ((parseInt(pis.substring(6, 7), 10)) * 9)
        + ((parseInt(pis.substring(7, 8), 10)) * 8)
        + ((parseInt(pis.substring(8, 9), 10)) * 7)
        + ((parseInt(pis.substring(9, 10), 10)) * 6)
        + ((parseInt(pis.substring(10, 11), 10)) * 5)
        + ((parseInt(pis.substring(11, 12), 10)) * 4)
        + ((parseInt(pis.substring(12, 13), 10)) * 3)
        + ((parseInt(pis.substring(13, 14), 10)) * 2)
        + ((parseInt(pis.substring(14, 15), 10)) * 1);

    resto = soma % 11;

    if (resto == 0) {
        return true;
    } else {
        mensagem("Atenção", "Numero de CNS inválido!", 300, 150);
        $("#pep_cartao_sus").val("");
        return false;
    }
}

function validaData() {
    var matchdata = new RegExp(/((0[1-9]|[12][0-9]|3[01])\/(0[13578]|1[02])\/[12][0-9]{3})|((0[1-9]|[12][0-9]|30)\/(0[469]|11)\/[12][0-9]{3})|((0[1-9]|1[0-9]|2[0-8])\/02\/[12][0-9]([02468][1235679]|[13579][01345789]))|((0[1-9]|[12][0-9])\/02\/[12][0-9]([02468][048]|[13579][26]))/gi);
    var data = $('#datanascimento').val();
    if(data){
        if ((data.match(matchdata)) != null) {
            validaDataAtual(data);
        } else {
            mensagem("Atenção", "Data inválida", 300, 150);
            $('#datanascimento').val("");
        }
    }
}

function validaDataCadastro() {
    var matchdata = new RegExp(/((0[1-9]|[12][0-9]|3[01])\/(0[13578]|1[02])\/[12][0-9]{3})|((0[1-9]|[12][0-9]|30)\/(0[469]|11)\/[12][0-9]{3})|((0[1-9]|1[0-9]|2[0-8])\/02\/[12][0-9]([02468][1235679]|[13579][01345789]))|((0[1-9]|[12][0-9])\/02\/[12][0-9]([02468][048]|[13579][26]))/gi);
    var data = $('#datacadastro').val();
    if (!data.match(matchdata) && data != "") {
        mensagem("Atenção", "Data inválida", 300, 150);
        $('#datacadastro').val("");
    } else {
        validaDataAtual(data);
    }
}

function validaDataAtual(data) {
    var dataAtual = $("#data_atual").val();
    var arrayDataDig = data.split('/');
    var dataDigInv = arrayDataDig[2] + arrayDataDig[1] + arrayDataDig[0];
    if (dataDigInv > dataAtual) {
        mensagem("Atenção", "Data de nascimento maior que a atual", 300, 150);
        $("#datanascimento").val("");
    }
}

function checaSexoGestante() {

    var tipoMedicoBloqueio = ["P", "A", "F", "B"];
    //console.log(tipoMedicoBloqueio.indexOf($('#usr_tipo_medico').val()));

    if ($('#pep_sexo:checked').val() == 'M' || (tipoMedicoBloqueio.indexOf($('#usr_tipo_medico').val()) != -1 && $('#usr_digitador').val() != 'S')) {
        $('#usu_esta_gestante1').attr('disabled', true);
        $('#usu_esta_gestante2').attr('disabled', true);
        return true;
    } else {
        if ($('#datanascimento').val() !== '' && $('#datanascimento').val() !== 'undefined') {
            if (getIdade() >= 9 && getIdade() <= 60) {
                $('#usu_esta_gestante1').removeAttr('disabled');
                $('#usu_esta_gestante2').removeAttr('disabled');
                return true;
            } else {
                $('#usu_esta_gestante1').attr('disabled', true);
                $('#usu_esta_gestante2').attr('disabled', true);
                if ($('#usu_esta_gestante1').is(":checked") && !$('#usu_esta_gestante1').is(":disabled")) {
                    mensagem("Atenção", "Idade do usuário incompatível com o status de Gestante! Deve estar entre 9 e 60 anos. ", 300, 150);
                    return false;
                }
                return true;
            }
        } else {
            $('#usu_esta_gestante1').attr('disabled', true);
            $('#usu_esta_gestante2').attr('disabled', true);
        }
        return true;
    }
}


function getIdade() {
    var parts = $('#datanascimento').val().split('/');
    var dataNascimento = new Date(parts[2], parts[1] - 1, parts[0]);

    var parts = $('#dataatual').val().split('/');
    var dataAtual = new Date(parts[2], parts[1] - 1, parts[0]);

    var idade = dataAtual.getFullYear() - dataNascimento.getFullYear();
    var m = dataAtual.getMonth() - dataNascimento.getMonth();
    if (m < 0 || (m = 0 && dataAtual.getDate() < dataNascimento.getDate())) {
        idade--;
    }
    return idade;
}


function exibeEstratificacaoRadio(idRadio, idDiv, idCampoRisco) {
    if ($("#" + idRadio + ":checked").val() == 't') {
        $("#" + idDiv).show();
    } else {
        $("#" + idDiv).hide();
        $("#" + idCampoRisco).val("");
    }
}

function exibeEstratificacaoIdade() {
    if (getIdade() >= 60) {
        $("#estrat_idoso").show();
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
    } else if (getIdade() < 12 && $('#usr_tipo_medico').val() !== 'P') {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").show();
    } else {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
    }
}

function validaDataCad() {
    var data = $("#usu_data_cad").val();
    var dataAtual = $("#data_atual").val();

    var arrayDataDig = data.split('/');
    var dataDigInv = arrayDataDig[2] + arrayDataDig[1] + arrayDataDig[0];
    if (dataDigInv > dataAtual) {
        mensagem("Atenção", "Data maior que a atual", 300, 150);
        $("#usu_data_cad").val("");
        return false;
    } else {
        return true;
    }
}
