$(function () {
  exibeVinculoSetor();
  checaCatmat();
  checaGrupoProduto();
  checaPsicotropico();

  $("#set_nome").buscar({
    url: baseUrl + "/setor/buscar",
    template: function (ul, item) {
      return jQuery("<li></li>").data("item.autocomplete", item).append(
        "<a>" + item.label + "</a>").appendTo(ul);
    }
  });
});


function editarProdutoForm(id) {
  window.location.replace(baseUrl + '/produto/form/id/' + id);
}

function salvarProdutoForm() {
  var form = $('#form').serialize();
  var id = $('#pro_codigo').val();

  $.ajax({
    url: baseUrl + "/produto/salvar",
    type: "POST",
    data: form,
    success: function (txt) {
      if (txt.success == true) {
        if (id) {
          mensagem("Atenção", "Dados cadastrados com sucesso!", 300, 150, function () {
            window.location.replace(baseUrl + '/produto/index');
          });
        } else {
          mensagem("Atenção", "Dados cadastrados com sucesso! Vincule o produto aos setores desejados!", 300, 150, function () {
            window.location.replace(baseUrl + '/produto/form/id/' + txt.novo);
          });
        }
      } else {
        mensagem("Atenção", txt.mensagem, 300, 150, function () {
          return false;
        });
      }

    }
  });
}

function adicionaVinculoProdutoSetor() {
  var setor = $('#set_codigo').val();
  var setor_nome = $('#set_nome').val();
  var produto = $('#pro_codigo').val();

  if (setor == null || setor == '') {
    mensagem("Alerta", "Selecione um setor!", 300, 150);
    return false;
  }

  $.ajax({
    url: baseUrl + "/produto/salvar-vinculo",
    type: "POST",
    data: {
      "setor": setor,
      "produto": produto,
    },
    success: function (txt) {
      if (txt.success == true) {
        $('#table_vinculo').append(
          "<tr id='vinc_cod_" + txt.prset_codigo + "'>" +
          "<td class='ui-state-default'>" + setor_nome + "</td>" +
          "<td class='ui-state-default c'><a onclick='excluirVinculoProdutoSetorConfirmacao(" + txt.prset_codigo + ")'><img src='" + baseUrl + "/public/images/icons/excluir.png' alt='Excluir'" +
          " title='Excluir'/></a></td>" +
          "</tr>");
        $("#set_codigo").val("");
        $("#set_nome").val("");
        $("#vinc_cod_0").remove();
        mensagem("Sucesso", "Vínculo criado com sucesso!", 300, 150);
        return true;
      } else {
        mensagem("Atenção", txt.mensagem, 300, 150, function () {
          $("#set_codigo").val("");
          $("#set_nome").val("");
          return false;
        });
      }

    }
  });


}

function excluirVinculoProdutoSetorConfirmacao(id) {
  confirme("Atenção", "Deseja realmente excluir este vínculo?", 350, 150, function () {
    excluirVinculoProdutoSetor(id)
  });
}

function excluirVinculoProdutoSetor(id) {
  $.ajax({
    url: baseUrl + "/produto/excluir-vinculo/id/" + id,
    type: "GET",
    success: function (txt) {
      if (txt.success == true) {
        mensagem("Sucesso", "Vínculo excluído com sucesso!", 300, 150);
        $("#vinc_cod_" + id).remove();
        return true;
      }
    }
  });
  return true;
}


function checaCatmat() {
  var selectBox = document.getElementById("pro_horus_tipo");
  var selectedValue = selectBox.options[selectBox.selectedIndex].value;
  var divBox = document.getElementById("cod_catmat");
  var input = document.getElementById("pro_horus");
  if (selectedValue == '') {
    divBox.style.display = "none";
    input.value = '';
  } else {
    divBox.style.display = "";
  }
}

function checaGrupoProduto() {
  var selectBox = document.getElementById("gru_codigo");
  var selectedValue = selectBox.options[selectBox.selectedIndex];
  console.log(selectedValue);
  var divBox = document.getElementById("vacina");
  var input = document.getElementById("pro_fracionado_n");
  if (selectedValue.className != 'vacina') {
    divBox.style.display = "none";
    input.checked = true;
  } else {
    divBox.style.display = "";
  }
}


function checaPsicotropico() {
  var selectBox = document.getElementById("psico_codigo");
  var selectedValue = selectBox.options[selectBox.selectedIndex].value;
  var divBox = document.getElementById("psicotropico");
  var input1 = document.getElementById("pro_codigo_dcb");
  var input2 = document.getElementById("pro_descricao_dcb");
  if (selectedValue == '') {
    divBox.style.display = "none";
    input1.value = '';
    input2.value = '';
  } else {
    divBox.style.display = "";
  }
}

function validaHorus() {
  var pro_horus = document.getElementById("pro_horus");
  pro_horus.value = pro_horus.value.toUpperCase();
  pro_horus.value = pro_horus.value.replace(/[^0-9A-Z?!]/ig, '');
  pro_horus.value = pro_horus.value.substring(0, 14);
}

function exibeVinculoSetor() {
  var id = $('#pro_codigo').val();

  if(id){
    $('#vinculo_setor').show();
  } else {
    $('#vinculo_setor').hide();
  }
}

function validaFormProduto() {
  pro_nome = document.getElementById("pro_nome").value;
  tipo_produto = document.getElementById("pro_tipo").value;
  grupo_produto = document.getElementById("gru_codigo").value;
  unidade_medida = document.getElementById("umed_codigo").value;

  tipo_horus = document.getElementById("pro_horus_tipo");
  valor_tipo_horus = tipo_horus.options[tipo_horus.selectedIndex].value;
  codigo_horus = document.getElementById("pro_horus").value;

  imuno = document.getElementById("tvi_codigo");
  valor_imuno = imuno.options[imuno.selectedIndex].value;


  if (pro_nome == '') {
    mensagem('Alerta!', 'Preencha o nome do produto', 300, 150);
    return false;
  }

  if (tipo_produto == '') {
    mensagem('Alerta!', 'Preencha o tipo do produto', 300, 150);
    return false;
  }

  if(valor_tipo_horus != '' && codigo_horus == ''){
    mensagem('Alerta!', 'Preencha o código CATMAT do produto', 300, 150);
    return false;
  }

  if (grupo_produto == '') {
    mensagem('Alerta!', 'Preencha o grupo do produto', 300, 150);
    return false;
  }

  if (unidade_medida == '') {
    mensagem('Alerta!', 'Preencha a unidade de medida do produto', 300, 150);
    return false;
  }

  if(grupo_produto == 100002 && valor_imuno == ''){
    mensagem('Alerta!', 'Preencha o imunobiológico da vacina', 300, 150);
    return false;
  }

  salvarProdutoForm();
}

