$(function () {

    if ($("#prof_resp_codigo").val() != "") {
        carregaCnes($("#prof_resp_codigo").val());
    }

    $.validator.addMethod("validaPosse", function (validaBairro, element) {
        if ($("#valid_66").val() == 1 && $('#tipo_imovel :checked').val() == 1) { // se tiver marcado como rural ele entra no validador
            if ($(".66").is(':checked') == true) { //se tem pelo menos uma opcao marcada
                return true;
            }
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório!");

    $("#form").validate({

        rules: {
            valid_57: {
                required: function () {
                    if (validaObrigatoriedade() == "C" && !recusado()) {
                        return true;
                    } else {
                        return false;
                    }
                }
            },
            valid_58: {
                required: function () {
                    if (validaObrigatoriedade() != "B" && !recusado()) {
                        return true;
                    } else {
                        return false;
                    }
                }
            },
            valid_66: {
                validaPosse: function () {
                    if (validaObrigatoriedade() == "C" && !recusado()) {
                        return true;
                    } else {
                        return false;
                    }
                }
            },
            prof_resp: {required: true},
            cod_cnes_uni: {required: true},
            co_data_atendimento: {required: true},
            tipo_imovel: {required: true},
            dom_microarea: {required: true}
        },
        messages: {
            valid_57: {required: "Campo Obrigatório!"},
            valid_58: {required: "Campo Obrigatório!"},
            prof_resp: {required: "Campo Obrigatório!"},
            co_data_atendimento: {required: "Campo Obrigatório!"},
            cod_cnes_uni: {required: "Campo Obrigatório!"},
            tipo_imovel: {required: "Campo Obrigatório!"},
            dom_microarea: {required: "Campo Obrigatório!"}
        }
    });

    $(".57").change(function () {
        $("#valid_57").val("1");
    });

    $(".58").change(function () {

        if ($(".58:checked").val() == 84) {
            $("#valid_66").val("1");
            $("#color_66").html("*");
        } else {
            $("#color_66").html("");
            $("#valid_66").val("0");
        }

        $("#valid_58").val("1");
    });

    if ($(".58:checked").val() == 83) {
        desabilitaAreaRural();
    } else {
        habilitaAreaRural();
    }

    if ($(".70:checked").val() == 0) {
        desabilitaAnimais();
    } else {
        habilitaAnimais();
    }

    validaRecusa();

    $(".70").change(function () {
        if ($(this).val() == 0) {
            desabilitaAnimais();
        } else {
            habilitaAnimais();
        }
    });

    $("#usu_recusa").change(function () {
        validaRecusa();
    });

    $('#tipo_imovel').change(function () {
        validaOpcoes();
    });

    $("#dom_microarea_fa").change(function () {
        validaMicroarea();
    });

    validaMicroarea();
});

function recusado() {
    if ($("#usu_recusa:checked").val() === 't') {
        return true;
    } else {
        return false;
    }
}

function validaObrigatoriedade() {
    var tipo_imovel = $('#tipo_imovel :checked').val();

    if (tipo_imovel === '10' || tipo_imovel === '11' ||
        tipo_imovel === '9' || tipo_imovel === '8' || tipo_imovel === '7') {
        return "A";
    } else if (tipo_imovel === '12' || tipo_imovel === '2' || tipo_imovel === '3' ||
        tipo_imovel === '4' || tipo_imovel === '5' || tipo_imovel === '6' || tipo_imovel === '99') {
        return "B";
    } else if (tipo_imovel === '1') {
        return "C";
    }
}

function validaRecusa() {
    if (recusado()) {
        $("#condicoes_moradia fieldset").prop("disabled", true);
        $("#condicoes_moradia fieldset input").each(function () {
            if (this.type == 'text' || this.type == 'textarea') {
                this.value = '';
            } else if (this.type == 'radio' || this.type == 'checkbox') {
                this.checked = false;
            } else if (this.type == 'select-one' || this.type == 'select-multiple') {
                this.value = 'All';
            }
        });
    } else {
        $("#condicoes_moradia fieldset").prop("disabled", false);
        $("#condicoes_moradia fieldset").prop("checked", true);
    }
    validaOpcoes();
}

function validaMicroarea() {
    if ($("#dom_microarea_fa:checked").val() == 't') {
        $("#dom_microarea").rules("remove", "required");
        $("#dom_microarea").html("<option value=\"\">Selecione</option>");
    } else {
        carregaMicroarea();
        $("#dom_microarea").rules("add", "required");
    }
}

function validaCns() {
    vlr_cns = $("#ipe_resp_cns").val();
    var retorno = false;
    $.ajax({
        url: baseUrl + "/default/paciente/valida-cns-duplicado",
        type: "POST",
        async: false,
        data: {cns: vlr_cns},
        success: function (txt) {
            if (txt > 0 && $("#cartao_sus_referencia_validacao").val() != vlr_cns) {
                mensagem("Atenção", "Numero de CNS já existe", 300, 150);
                $("#ipe_resp_cns").val("");
            } else {
                retorno = validador_cns(vlr_cns);
            }
        }
    });

    return retorno;
}

function validador_cns(vlr_cns) {
    if ((vlr_cns.substring(0, 1) != "7") && (vlr_cns.substring(0, 1) != "8") && (vlr_cns.substring(0, 1) != "9")) {
        return validaCNS(vlr_cns);
    } else {
        return ValidaCNS_PROV(vlr_cns);
    }
}

function validaCNS(vlrCNS) {
    var soma = new Number;
    var resto = new Number;
    var dv = new Number;
    var pis = new String;
    var resultado = new String;
    var tamCNS = vlrCNS.length;

    if ((tamCNS) != 15) {
        mensagem("Atenção", "Numero de CNS invalido", 300, 150);
        $("#ipe_resp_cns").val("");
        return false;
    }
    pis = vlrCNS.substring(0, 11);
    soma = (((Number(pis.substring(0, 1))) * 15) +
        ((Number(pis.substring(1, 2))) * 14) +
        ((Number(pis.substring(2, 3))) * 13) +
        ((Number(pis.substring(3, 4))) * 12) +
        ((Number(pis.substring(4, 5))) * 11) +
        ((Number(pis.substring(5, 6))) * 10) +
        ((Number(pis.substring(6, 7))) * 9) +
        ((Number(pis.substring(7, 8))) * 8) +
        ((Number(pis.substring(8, 9))) * 7) +
        ((Number(pis.substring(9, 10))) * 6) +
        ((Number(pis.substring(10, 11))) * 5));
    resto = soma % 11;
    dv = 11 - resto;
    if (dv == 11) {
        dv = 0;
    }
    if (dv == 10) {
        soma = (((Number(pis.substring(0, 1))) * 15) +
            ((Number(pis.substring(1, 2))) * 14) +
            ((Number(pis.substring(2, 3))) * 13) +
            ((Number(pis.substring(3, 4))) * 12) +
            ((Number(pis.substring(4, 5))) * 11) +
            ((Number(pis.substring(5, 6))) * 10) +
            ((Number(pis.substring(6, 7))) * 9) +
            ((Number(pis.substring(7, 8))) * 8) +
            ((Number(pis.substring(8, 9))) * 7) +
            ((Number(pis.substring(9, 10))) * 6) +
            ((Number(pis.substring(10, 11))) * 5) + 2);
        resto = soma % 11;
        dv = 11 - resto;
        resultado = pis + "001" + String(dv);
    } else {
        resultado = pis + "000" + String(dv);
    }
    if (vlrCNS != resultado) {
        mensagem("Atenção", "Numero de CNS inválido!", 300, 150);
        $("#ipe_resp_cns").val("");
        return false;
    } else {
        return true;
    }
}

function ValidaCNS_PROV(Obj) {
    var pis;
    var resto;
    var dv;
    var soma;
    var resultado;
    var result;
    result = 0;

    var tamCNS = Obj.length;

    if ((tamCNS) != 15) {
        mensagem("Atenção", "Numero de CNS invalido", 300, 150);
        $("#ipe_resp_cns").val("");
        return false;
    }

    pis = Obj.substring(0, 15);

    if (pis == "") {
        return false;
    }

    if ((Obj.substring(0, 1) != "7") && (Obj.substring(0, 1) != "8") && (Obj.substring(0, 1) != "9")) {
        mensagem("Atenção", "Numero de CNS invalido", 300, 150);
        $("#ipe_resp_cns").val("");
        return false;
    }

    soma = ((parseInt(pis.substring(0, 1), 10)) * 15)
        + ((parseInt(pis.substring(1, 2), 10)) * 14)
        + ((parseInt(pis.substring(2, 3), 10)) * 13)
        + ((parseInt(pis.substring(3, 4), 10)) * 12)
        + ((parseInt(pis.substring(4, 5), 10)) * 11)
        + ((parseInt(pis.substring(5, 6), 10)) * 10)
        + ((parseInt(pis.substring(6, 7), 10)) * 9)
        + ((parseInt(pis.substring(7, 8), 10)) * 8)
        + ((parseInt(pis.substring(8, 9), 10)) * 7)
        + ((parseInt(pis.substring(9, 10), 10)) * 6)
        + ((parseInt(pis.substring(10, 11), 10)) * 5)
        + ((parseInt(pis.substring(11, 12), 10)) * 4)
        + ((parseInt(pis.substring(12, 13), 10)) * 3)
        + ((parseInt(pis.substring(13, 14), 10)) * 2)
        + ((parseInt(pis.substring(14, 15), 10)) * 1);

    resto = soma % 11;

    if (resto == 0) {
        return true;
    } else {
        mensagem("Atenção", "Numero de CNS inválido!", 300, 150);
        $("#ipe_resp_cns").val("");
        return false;
    }
}

function maskTelefone(idTelefone) {
    $("#" + idTelefone).mask("(99) 9999-9999?9");
    $("#" + idTelefone).blur(function (event) {
        if ($(this).val().length == 15) {
            $("#" + idTelefone).mask('(99) 99999-999?9');
        } else {
            $("#" + idTelefone).mask('(99) 9999-9999?9');
        }
    });
}

function validaDataAtendimento() {
    var dataAtual = $('#co_data_atual').val();
    var dataAtualFormatada = dataAtual.split('/');
    var dataAtualFormatada = new Date(dataAtualFormatada[2], dataAtualFormatada[1] - 1, dataAtualFormatada[0]);

    var mesAtual = dataAtualFormatada.getMonth();
    var diaAtual = dataAtualFormatada.getDate();
    var anoAtual = dataAtualFormatada.getFullYear();

    var dataMinima = new Date(anoAtual, mesAtual - 12, diaAtual);

    var dataInformada = $("#co_data_atendimento").val();
    var dataInformadaFormatada = dataInformada.split('/');
    var dataInformadaFormatada = new Date(dataInformadaFormatada[2], dataInformadaFormatada[1] - 1, dataInformadaFormatada[0]);

    if (dataInformadaFormatada < dataMinima) {
        alert('A data do atendimento deve constar dentro do período de 1 ano!');
        $("#co_data_atendimento").val('');
    }
}

function validaOpcoes() {
    var tipo_imovel = $('#tipo_imovel :checked').val();
    console.log('tipo_imovel = ' + tipo_imovel);
    //UNIDADE DE MEDIDA SOCIO EDUCATIVA / DELEGACIA / UNIDADE PRISIONAL / INSTITUICAO LONGA PERMANENCIA IDOSOS / ABRIGO
    if (tipo_imovel === '10' || tipo_imovel === '11' ||
        tipo_imovel === '9' || tipo_imovel === '8' || tipo_imovel === '7') {
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").show(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").show(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").show(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").show(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").show(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").show(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").show(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
        $("#instituicao_permanencia").show(); //INSTITUIÇÃO DE PERMANÊNCIA
        $("#estratificacao_risco").hide(); //ESTRATIFICAÇÃO DE RISCO FAMILIAR
        $("#usu_recusa").show(); //RECUSA USUARIO
    }
    //ESTABELECIMENTO RELIGIOSO / COMERCIO / TERRENO BALDIO / PONTO ESTRATEGICO / ESCOLA / OUTROS
    else if (tipo_imovel === '12' || tipo_imovel === '2' || tipo_imovel === '3' ||
        tipo_imovel === '4' || tipo_imovel === '5' || tipo_imovel === '6' || tipo_imovel === '99') {
        $("#co_seq_pergunta_57").hide(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").hide(); //LOCALIZACAO
        $("#co_seq_pergunta_59").hide(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").hide(); //N DE MORADORES
        $("#co_seq_pergunta_61").hide(); //N DE COMODOS
        $("#co_seq_pergunta_62").hide(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").hide(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").hide(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").hide(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").hide(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").hide(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").hide(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").hide(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").hide(); //ANIMAIS NO DOMICILIO
        $("#instituicao_permanencia").hide(); //INSTITUIÇÃO DE PERMANÊNCIA
        $("#estratificacao_risco").hide(); //ESTRATIFICAÇÃO DE RISCO FAMILIAR
        $("#recusa").hide(); //RECUSA
    } else if (tipo_imovel === '1') { //DOMICILIO
        $("#co_seq_pergunta_57").show(); //SITUAÇÃO DE MORADIA POSSE DE TERRA
        $("#co_seq_pergunta_58").show(); //LOCALIZACAO
        $("#co_seq_pergunta_59").show(); //TIPO DE DOMICILIO
        $("#co_seq_pergunta_60").show(); //N DE MORADORES
        $("#co_seq_pergunta_61").show(); //N DE COMODOS
        $("#co_seq_pergunta_62").show(); //TIPO DE ACESSO DOMICILIO
        $("#co_seq_pergunta_63").show(); //DISPONIBILIDADE DE ENERGIA ELETRICA
        $("#co_seq_pergunta_64").show(); //DESTINO DO LIXO
        $("#co_seq_pergunta_65").show(); //TRATAMENTO DE AGUA NO DOMICILIO
        $("#co_seq_pergunta_66").show(); //EM CASO DE AREA DE PRODUCAO RURAL
        $("#co_seq_pergunta_67").show(); //MATERIAL PREDOMINANTE PAREDE EXTERNA DO DOMICILIO
        $("#co_seq_pergunta_68").show(); //ABASTECIMENTO DE AGUA
        $("#co_seq_pergunta_69").show(); //FORMA DE ESCOAMENTO BANHEIRO OU SANITARIO
        $("#co_seq_pergunta_70").show(); //ANIMAIS NO DOMICILIO
        $("#instituicao_permanencia").hide(); //INSTITUIÇÃO DE PERMANÊNCIA
        $("#estratificacao_risco").show(); //ESTRATIFICAÇÃO DE RISCO FAMILIAR
        $("#usu_recusa").show(); //RECUSA USUARIO
    }

    $("input:hidden").each(function () {
        if (this.type == 'text' || this.type == 'textarea') {
            this.value = '';
        } else if (this.type == 'radio' || this.type == 'checkbox') {
            this.checked = false;
        } else if (this.type == 'select-one' || this.type == 'select-multiple') {
            this.value = 'All';
        }
    });
    $("#cod_cnes_uni").change(function () {
        console.log("setou");
        carregaIne("", $("#prof_resp_codigo").val());
    });
}

function desabilitaAreaRural() {
    $(".66").prop("disabled", true);
    $(".66").prop("checked", false);
}

function habilitaAreaRural() {
    $(".66").prop("disabled", false);
}

function desabilitaAnimais() {
    $(".filhos").prop("disabled", true);
    $(".filhos").prop("checked", false);
    $(".filhos").val("");
}

function habilitaAnimais() {
    $(".filhos").prop("disabled", false);
}

function buscaProfResp() {
    $('#prof_resp').autocomplete({
        source: baseUrl + '/default/usuarios/buscar-profissionais-equipes',
        minLength: 3,
        delay: 300,
        open: function () {
            $(this).css("background", "none");
        },
        close: function () {
            $(this).css("background", "none");
        },
        select: function (event, ui) {
            $("#prof_resp").val(ui.item.label);
            $("#prof_resp_codigo").val(ui.item.id);
            carregaCnes(ui.item.id);
            //$("#cod_cnes_uni").val(validaCampoEmBranco(ui.item.data.cnes_numero));
            //$("#cod_equipe").val(validaCampoEmBranco(ui.item.data.nu_ine));
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function (ul, item) {
        return $("<li/>").data("item.autocomplete", item).append(
            "<a>" + item.label + "</a>").appendTo(ul);
    }
}

function carregaCnes(usrCodigo) {
    setTimeout(function () {
        $("#cod_cnes_uni option").remove();
        $("#cod_cnes_uni").show();
        $.ajax({
            url: baseUrl + "/default/unidade/carrega-cnes",
            type: "POST",
            data: {
                usr_codigo: usrCodigo
            },
            success: function (txt) {
                var codCnesEdit = $("#cod_cnes_edit").val();
                $.each(txt, function (key, value) {
                    // Valida Edição ao carregar a página
                    var selectedCnes = '';
                    if (codCnesEdit == value['uni_codigo']) {
                        selectedCnes = "selected='selected'";
                    }

                    $("#cod_cnes_uni").append("<option " + selectedCnes + " value=\"" + value['uni_codigo'] + "\" onclick='carregaIne(" + value['uni_codigo'] + "," + usrCodigo + ")'>" + value['uni_desc'] + "\</option>");
                })
                carregaIne($("#cod_cnes_uni option:selected").val(), usrCodigo);
            }
        });

    }, 150);
}

function validaCampoEmBranco(texto) {
    if (texto == "" || texto == null || texto == "null" || texto == "undefined") {
        return "";
    } else {
        return texto;
    }
}

function carregaIne(uniCodigo, usrCodigo) {
    console.log($("#cod_cnes_uni option:selected").val());
    setTimeout(function () {
        $("#cod_equipe option").remove();
        $("#cod_equipe").show();
        $.ajax({
            url: baseUrl + "/default/usuarios/carrega-equipes",
            type: "POST",
            data: {
                uni_codigo: $("#cod_cnes_uni option:selected").val(),
                usr_codigo: usrCodigo
            },
            success: function (txt) {
                var codIne = $("#cod_equipe_ine").val();
                $.each(txt, function (key, value) {
                    var selectedIne = '';
                    if (codIne == value['co_seq_equipe']) {
                        selectedIne = "selected='selected'";
                    }
                    $("#cod_equipe").append("<option " + selectedIne + " value=\"" + value['co_seq_equipe'] + "\" onclick='carregaMicroarea()'>" + value['nu_ine'] + "\</option>");
                })
                if ($("#dom_microarea_fa:checked").val() != 't') {
                    carregaMicroarea();
                }
            }
        });
    }, 150);
}

function carregaMicroarea() {
    setTimeout(function () {
        $("#dom_microarea option").remove();
        $("#dom_microarea").show();
        var uni_codigo = $("#cod_cnes_uni").val();
        $.ajax({
            url: baseUrl + "/default/especialidade/carrega-microarea",
            type: "POST",
            async: false,
            data: {
                co_seq_equipe: $("#cod_equipe option:selected").val(),
                uni_codigo: uni_codigo
            },
            success: function (txt) {
                $("#dom_microarea").append("<option value=\"\">Selecione</option>");
                var codMa = $("#dom_microarea_codigo").val();
                $.each(txt, function (key, value) {
                    var selectedMa = '';
                    if (codMa == value['mic_codigo']) {
                        selectedMa = "selected='selected'";
                    }
                    $("#dom_microarea").append("<option " + selectedMa + " value=\"" + value['mic_codigo'] + "\" onclick=''>" + value['mic_descricao'] + " - " + value['nu_ine'] + "\</option>");
                });
            }
        })
    }, 150);
}

function validaResponsavelInstituicao() {
    if ((validaObrigatoriedade() === "A" || validaObrigatoriedade() === "C") && !recusado()) {
        if (($('#ipe_nome').val() !== "" || $("#ipe_st_outros:checked").val() !== undefined ||
            $('#ipe_resp_cns').val() !== "" || $('#ipe_resp_cargo').val() !== "" || $('#ipe_resp_telefone').val() !== "")
            && $("#ipe_resp_nome").val() === "") {
            return false;
        } else {
            return true;
        }
    }
}

function validacoesCadastro() {
    $.validator.addMethod("validaNomeCidadao", function (validaNomeCidadao, element) {
        if (($('#ipe_nome').val() !== "" || $("#ipe_st_outros:checked").val() !== undefined ||
            $('#ipe_resp_cns').val() !== "" || $('#ipe_resp_cargo').val() !== "" ||
            $('#ipe_resp_telefone').val() !== "") && $("#ipe_resp_nome").val() === "") {
            return false;
        } else {
            if (!validaNomeEsus(element.id)) {
                return false;
            } else {
                return true;
            }
        }
    }, "Verifique a informação!");

    $("#form").validate({
        rules: {
            ipe_resp_nome: {required: true, validaNomeCidadao: true}
        }, messages: {
            ipe_resp_nome: {required: "Campo Obrigatório"}
        }
    });
}