$(document).ready(function () {
    $("tr:odd").addClass("odd");
});

var mindate;
var mindateDate = new Date();

function checaQuantidadeMinima(item) {
    if (item.pro_estoque_minimo >= parseInt(item.quantidade)) {
        alert(
            "Alerta!!\n\n\O produto desejado está abaixo do estoque mínimo\n\n\Quantidade em estoque: " + item.quantidade + "\n\Quantidade mínima: " + item.pro_estoque_minimo
        );
        $('#pro_nome').val(item.pro_nome);
        $('#pro_codigo').val(item.pro_codigo);
    }
}

function checaQuantidadeMinimaProNome(item) {
    if (item.item.data.pro_estoque_minimo >= parseInt(item.item.data.quantidade)) {
        alert(
            "Alerta!!\n\n\O produto desejado está abaixo do estoque mínimo\n\n\Quantidade em estoque: " + item.item.data.quantidade + "\n\Quantidade mínima: " + item.item.data.pro_estoque_minimo
        );
        $('#pro_nome').val(item.item.label);
        $('#pro_codigo').val(item.item.id);
    }
}

$(function () {

    $("#cod_receita").keyup(function(event){
        if ( event.keyCode == 13 ) {
            if ($("#cod_receita").val() != "") {
                $("#ite_cod_receita").val($("#cod_receita").val());
                $("#receita-controlada").dialog('destroy');
                $("#ite_quantidade").focus();
            } else {
                $("#cod_receita").focus();
            }
        }
    })

    $("#mov_data[name='mov_data']").change(function () {
        var parts = $('#mov_data').val().split("/");
        var dataF = new Date(parseInt(parts[2], 10),
            (parseInt(parts[1], 10) - 1),
            parseInt(parts[0], 10));

        if (mindateDate > dataF || dataF > new Date()) {
            $('#mov_data').val($.datepicker.formatDate("dd/mm/yy", new Date()));
        }
    });
    $("#mov_data[name='mov_data']").mask("99/99/9999");
    $("#mov_data[name='mov_data']").datepicker();
    $("#mov_data[name='mov_data']").datepicker('option', 'minDate', mindate);
    $("#mov_data[name='mov_data']").datepicker('option', 'maxDate', 0);

    $("#rec_codigo").change(function () {

        $("#usu_codigo").val("");
        $("#buscar1").val("");
        $("#usr_codigo").val("");
        $("#buscar5").val("");
        $("#interno").val("");
        $(".linha_produto").remove();

        $.ajax({
            url: baseUrl + "/farmacia/farmacia/get-receita",
            data: {rec_codigo: $("#rec_codigo").val()},
            success: function (txt) {
                if (txt.length != 0) {
                    $("#usu_codigo").val(txt.usu_codigo);
                    $("#buscar1").val(txt.usu_nome);
                    $("#buscar1").attr('readonly', true);
                    $("#usr_codigo").val(txt.usr_codigo);
                    $("#buscar5").val(txt.usr_nome);
                    $("#buscar5").attr('readonly', true);
                    $("#interno").val(1);
                    $("#pro_codigo").attr('readonly', true);
                    $("#ite_codbarras").attr('readonly', true);
                    $("#pro_nome").attr('readonly', true);
                    $("#ite_quantidade").attr('readonly', true);
                    $("#ite_duracao").attr('readonly', true);
                    var faltou = "";
                    var table = "";
                    for (var i in txt.itens) {
                        faltou += addLinhaCodBarrasAutomatico(
                            txt.itens[i].pro_codigo,
                            txt.itens[i].pro_nome,
                            txt.itens[i].irec_codigo,
                            txt.itens[i].irec_quantidade,
                            txt.itens[i].irec_qtde_pendente,
                            txt.itens[i].irec_quantidade_solicitada,
                            "",
                            null,
                            'S'
                        );
                    }

                    if (faltou != "") {
                        table = "<table>" +
                            "<tr>" +
                            "<th>Produto</th>" +
                            "<th>Qtde. Solicitada</th>" +
                            "<th>Qtde. Pendente</th>" +
                            "</tr>";

                        table += faltou;
                        table += "</table>";
                        mensagem("Alerta", "Não há estoque suficiente para os seguintes produtos:<br/><br/>" + table, 700, 300);
                    }

                } else {
                    mensagem("Alerta", "Receita inexistente ou finalizada.", 300, 150, function () {
                        setTimeout(function () {
                            $("#rec_codigo").val("");
                            $("#rec_codigo").focus();
                        }, 500);
                    });

                }
            }
        });
    });

    $("#buscar5").buscar({
        url: baseUrl + '/default/usuarios/buscar/externo/1',
        categoria: 'categoria',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            $("#buscar1").focus();
            return true;
        }
    });

    $("#mov_data").focusout(function () {
        if ($("#mov_data").val() == "") {
            mensagem("Erro", "Selecione a data de movimentação", 300, 150);
            return false;
        }
    });

    $("#pro_codigo").change(function () {
        if ($("#usu_codigo").val() == "") {
            mensagem("Erro", "Selecione o Paciente", 300, 150);
            $("#pro_codigo").val("");
            $("#pro_nome").val("");
            $("#ite_codbarras").val("");

            return false;
        }

        if ($("#pro_codigo").val() == "") {
            $("#pro_codigo").val("");
            $("#pro_horus").val("");
            $("#pro_horus_tipo").val("");
            $("#ite_codbarras").val("");
            $("#pro_nome").val("");
            $("#tbLoteVal")
                .html("<tr style=\"border: none;\">\n" +
                    "    <th width='33%' style=\"border: none;\">Lote</th>\n" +
                    "    <th width='34%' align='center' style=\"border: none;\">Validade</th>\n" +
                    "    <th width='33%' align='center' style=\"border: none;\">Saldo</th>\n" +
                    "</tr>");
            $("#div_lote")
                .html("<select id=\"ite_lote\" name=\"ite_lote\" class=\"ui-state-default\" style=\"width:350px;\" disabled=\"disabled\">" +
                    "  <option value=\"\">Lote - Validade - Saldo</option>" +
                    "</select>");
            $("#ite_quantidade").val("");
            $("#ite_duracao").val("");
            return false;
        }

        $.ajax({
            url: baseUrl + '/default/produto/verifica-se-dispensou-no-dia',
            data: {
                ite_codbarras: $("#ite_codbarras").val(),
                pro_codigo: $("#pro_codigo").val(),
                usu_codigo: $("#usu_codigo").val()
            },
            success: function (txt) {

                if (txt == 1) {
                    $("#pro_codigo").val("");
                    $("#pro_nome").val("");
                    $("#ite_codbarras").val("");
                    mensagem("Erro", "Este Paciente já pegou esse produto hoje!", 300, 150);
                    return false;
                } else {
                    mensagemSemOk("carregando-ate", "Aguarde", "Carregando...", 280, 80);

                    $.ajax({
                        url: baseUrl + '/default/produto/get-produto-com-estoque',
                        data: {
                            pro_codigo: $("#pro_codigo").val(),
                            set_codigo: $("#set_codigo").val(),
                            ite_codbarras: $("#ite_codbarras").val()
                        },
                        success: function (txt) {

                            if (txt) {
                                $("#pro_nome").val(txt.pro_nome);
                                $("#pro_horus").val(txt.pro_horus);
                                $("#pro_horus_tipo").val(txt.pro_horus_tipo);
                                $("#psico_codigo").val(txt.psico_codigo)
                                if ($("#lote_automatico").val() != 1) {
                                    getLotes(txt.pro_codigo);
                                }
                                $("#ite_codbarras").val(txt.ite_codbarras);
                                $("#carregando-ate").dialog("destroy").remove();
                                $("#ite_quantidade").focus();
                                $("#ite_quantidade").removeAttr("readonly");
                                if ($("#psico_codigo").val() != "" && txt.psico_exige_codigo != false) {
                                    getCodigoReceita();
                                }

                            } else {
                                $("#carregando-ate").dialog("destroy").remove();
                                $("#pro_codigo").val("");
                                $("#ite_codbarras").val("");
                                $("#ite_codbarras").focus();
                                $("#pro_nome").val("");
                                $("#ite_lote").html("<option value=\"\">Lote - Validade - Saldo</option>");
                                $("#ite_lote").prop('disabled', 'disabled');
                                $("#ite_lote").addClass("ui-state-disabled");
                            }
                            checaQuantidadeMinima(this.txt);
                        }

                    });
                }
            }
        });

    });


    $("#ite_codbarras").change(function () {
        if ($("#ite_codbarras").val() == "") {
            ;
            $("#ite_codbarras").val("");
            return false;
        }

        $.ajax({
            url: baseUrl + '/default/produto/verifica-se-dispensou-no-dia',
            data: {
                pro_codigo: $("#pro_codigo").val(),
                usu_codigo: $("#usu_codigo").val(),
                ite_codbarras: $("#ite_codbarras").val()
            },
            success: function (txt) {

                if (txt == 1) {
                    $("#pro_codigo").val("");
                    $("#pro_nome").val("");
                    $("#ite_codbarras").val("");
                    mensagem("Erro", "Este Paciente já pegou esse produto hoje!", 300, 150);
                    return false;
                } else {
                    mensagemSemOk("carregando-ate", "Aguarde", "Carregando...", 280, 80);

                    $.ajax({
                        url: baseUrl + '/default/produto/get-produto-com-estoque',
                        data: {
                            pro_codigo: $("#pro_codigo").val(),
                            set_codigo: $("#set_codigo").val(),
                            ite_codbarras: $("#ite_codbarras").val()
                        },
                        success: function (txt) {

                            if (txt) {
                                $("#pro_codigo").val(txt.pro_codigo);
                                $("#pro_nome").val(txt.pro_nome);
                                $("#psico_codigo").val(txt.psico_codigo);

                                if ($("#lote_automatico").val() != 1) {
                                    getLotes(txt.pro_codigo);
                                }
                                $("#ite_codbarras").val(txt.ite_codbarras);
                                $("#carregando-ate").dialog("destroy").remove();
                                $("#ite_quantidade").focus();
                                $("#ite_quantidade").removeAttr("readonly");
                                if ($("#psico_codigo").val() != "" && txt.psico_exige_codigo != false) {
                                    getCodigoReceita();
                                }

                            } else {
                                $("#carregando-ate").dialog("destroy").remove();
                                $("#ite_codbarras").val("");
                                $("#ite_codbarras").focus();
                                $("#pro_codigo").val("");
                                $("#pro_nome").val("");
                                $("#tbLoteVal")
                                    .html("<tr style=\"border: none;\">\n" +
                                        "    <th width='33%' style=\"border: none;\">Lote</th>\n" +
                                        "    <th width='34%' align='center' style=\"border: none;\">Validade</th>\n" +
                                        "    <th width='33%' align='center' style=\"border: none;\">Saldo</th>\n" +
                                        "</tr>");
                                $("#ite_lote").html("<option value=\"\">Lote - Validade - Saldo</option>");
                                $("#ite_lote").prop('disabled', 'disabled');
                                $("#ite_lote").addClass("ui-state-disabled");
                            }
                            checaQuantidadeMinima(txt);
                        }
                    });
                    //mensagemSemOk("carregando-ate", "Aguarde", "Carregando...", 280, 80);

                    $.ajax({
                        url: baseUrl + '/default/produto/get-produto-com-estoque',
                        data: {
                            pro_codigo: $("#pro_codigo").val(),
                            set_codigo: $("#set_codigo").val(),
                            ite_codbarras: $("#ite_codbarras").val()
                        },
                        success: function (txt) {

                            if (txt) {
                                $("#pro_nome").val(txt.pro_nome);
                                $("#pro_horus").val(txt.pro_horus);
                                $("#pro_horus_tipo").val(txt.pro_horus_tipo);

                                if ($("#lote_automatico").val() != 1) {
                                    getLotes(txt.pro_codigo);
                                }
                                $("#ite_codbarras").val(txt.ite_codbarras);
                                $("#carregando-ate").dialog("destroy").remove();
                                $("#ite_quantidade").focus();
                                $("#ite_quantidade").removeAttr("readonly");

                            } else {
                                $("#carregando-ate").dialog("destroy").remove();
                                $("#pro_codigo").val("");
                                $("#ite_codbarras").val("");
                                $("#ite_codbarras").focus();
                                $("#pro_nome").val("");
                                $("#ite_lote").html("<option value=\"\">Lote - Validade - Saldo</option>");
                                $("#ite_lote").prop('disabled', 'disabled');
                                $("#ite_lote").addClass("ui-state-disabled");
                            }
                            checaQuantidadeMinima(txt);

                        }
                    });
                }
            }
        });

    });


    $("#pro_nome").buscar({
        delay: 10,
        minLength: 3,
        url: baseUrl + "/produto/buscar-produtos-com-estoque/setor/" + $("#set_codigo").val() + "/setor_movimento/" + 1, //Passando true como parametro de setor da nota Ps: Nome da variavel errado
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (ul, item) {
            if ($("#usu_codigo").val() == "") {
                mensagem("Erro", "Selecione o Paciente", 300, 150);
                $("#pro_codigo").val("");
                $("#pro_horus").val("");
                $("#pro_horus_tipo").val("");
                $("#ite_codbarras").val("");
                $("#pro_nome").val("");
                return false;
            }

            if ($("#psico_codigo").val() != "" && $("#psico_exige_codigo").val() != "false") {
                getCodigoReceita();
            }

            $.ajax({
                url: baseUrl + '/default/produto/verifica-se-dispensou-no-dia',
                data: {
                    pro_codigo: $("#pro_codigo").val(),
                    ite_codbarras: $("#ite_codbarras").val(),
                    usu_codigo: $("#usu_codigo").val()
                },
                success: function (txt) {
                    if (txt == 1) {
                        $("#pro_codigo").val("");
                        $("#pro_horus").val("");
                        $("#pro_horus_tipo").val("");
                        $("#pro_nome").val("");
                        $("#ite_codbarras").val("");
                        mensagem("Erro", "Este Paciente já pegou esse produto hoje!", 300, 150);
                        return false;
                    } else {

                        if ($("#lote_automatico").val() != 1) {
                            getLotes();
                        }
                        $("#ite_quantidade").focus();
                        $("#ite_quantidade").removeAttr("readonly");
                    }
                }
            });
            checaQuantidadeMinimaProNome(item);
        }
    });

    $(".nova_linha").click(function () {
        addLinhaProd();
    });


    $("#new").click(function () {
        if ($("#lote_automatico").val() != 1) {
            addLinhaProd();
        } else {
            addLinhaLoteAutomatico();
        }
    });

    $("#salvar_dispensacao").click(function () {
        salvarDispensa();
    });

    $("#ite_lote").change(function () {
        $("#ite_quantidade").focus();
    });

    $(".historico").click(function () {

        var usu_codigo = $("#usu_codigo").val();
        if (usu_codigo == "" || usu_codigo == null) {
            setTimeout(function () {
                mensagem("Erro", "Selecione um paciente", 300, 150)
            }, 500);
            return false;
        }

        $("body").append("<div id=\"historico-dialog\" title=\"Histórico\"></div>");
        $.ajax({
            url: baseUrl + '/farmacia/farmacia/get-historico-paciente',
            data: {usu_codigo: usu_codigo},
            success: function (txt) {
                var table = "<table class=\"lista\">" +
                    "<tr>" +
                    "<th>Produto</th>" +
                    "<th>Data</th>" +
                    "<th>Lote</th>" +
                    "<th>Qtde.</th>" +
                    ($("#validade_medicamentos").val() == 1 ? "<th>Próxima Dispensação</th>" : "") +
                    "<th>Usuário</th>" +
                    "<th>Setor</th>" +
                    "</tr>";
                for (var i in txt) {
                    table += "<tr>" +
                        "<td>" + txt[i].pro_nome + "</td>" +
                        "<td>" + dataToBr(txt[i].mov_data) + "</td>" +
                        "<td>" + txt[i].ite_lote + "</td>" +
                        "<td>" + Math.round(txt[i].ite_quantidade) + "</td>" +
                        ($("#validade_medicamentos").val() == 1 ? "<td>" + txt[i].duracao + "</td>" : "") +
                        "<td>" + txt[i].usr_nome + "</td>" +
                        "<td>" + txt[i].set_nome + "</td>" +
                        "</tr>";
                }
                table += "</table>";
                $("#historico-dialog").html(table);
            }
        });
        $("#historico-dialog").dialog({
            modal: true,
            width: 960,
            height: 600,
            close: function () {
                $("#pro_codigo").focus();

                $(this).dialog('close');
            },
            buttons: {
                Ok: function () {
                    $("#pro_codigo").focus();
                    $(this).dialog('close');
                }
            }
        });
    });

    $(".paciente").click(function () {
        var usu_codigo = $("#usu_codigo").val();
        var cadastro_aise = $("#cadastro_aise").val();
        var link = "";


        // if(cadastro_aise == 1){
        link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
        //}else{
        // link = "../../../../WebSocialSaude/paciente.php?acao=form&poupup=1&usu_codigo="+usu_codigo;
        //}
        window.open(link, "_blank", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });

});

function getCodigoReceita() {

    $("#receita-controlada").dialog({
        modal: true,
        width: 300,
        height: 200,
        buttons: {
            Ok: function () {
                $("#ite_quantidade").focus();
                if ($("#cod_receita").val() != "") {
                    $("#ite_cod_receita").val($("#cod_receita").val());
                    $(this).dialog('destroy');
                } else {
                    $("#cod_receita").focus();
                }
            }
        },
        open: function () {
            $('.ui-dialog-titlebar-close').remove();
        }
    });
}

function buscaPaciente() {
    var tipo_busca = $("#tipo_busca").val();
    $("#buscar1").buscar({
        delay: 10,
        minLength: 3,
        url: baseUrl + '/paciente/buscar/tipo_busca/' + tipo_busca,
        callback: function () {
            getUltimosDispensados();
            getObservacao();
            $("#ite_codbarras").focus();
        }
    });
}

function getObservacao() {
    var usu_codigo = $("#usu_codigo").val();
    $("#mov_observacao").text("");
    $.ajax({
        url: baseUrl + '/farmacia/farmacia/get-observacao',
        data: {usu_codigo: usu_codigo},
        async: false,
        success: function (txt) {
            if (txt != "" || txt != null) {
                $("#mov_observacao").text(txt[0].mov_observacao);
            }
        }
    });
}


function getUltimosDispensados() {
    var usu_codigo = $("#usu_codigo").val();
    $("body").append("<div id=\"ultimos-dialog\" style=\"display:none;\" title=\"O paciente pegou medicamento nos ultimos dias\"></div>");
    var quantidade = 0;
    $.ajax({
        url: baseUrl + '/farmacia/farmacia/get-ultimos-dispensados',
        data: {usu_codigo: usu_codigo},
        async: false,
        success: function (txt) {
            if (txt != "" || txt != null) {
                var table = "<table class=\"lista\">" +
                    "<tr>" +
                    "<th>Produto</th>" +
                    "<th>Data</th>" +
                    "<th>Lote</th>" +
                    "<th>Qtde.</th>" +
                    ($("#validade_medicamentos").val() == 1 ? "<th>Próxima Dispensação</th>" : "") +
                    "<th>Usuário</th>" +
                    "<th>Setor</th>" +
                    "</tr>";
                quantidade = txt.length;
                for (var i in txt) {

                    table += "<tr>" +
                        "<td>" + txt[i].pro_nome + "</td>" +
                        "<td>" + dataToBr(txt[i].mov_data) + "</td>" +
                        "<td>" + txt[i].ite_lote + "</td>" +
                        "<td>" + Math.round(txt[i].ite_quantidade) + "</td>" +
                        ($("#validade_medicamentos").val() == 1 ? "<td>" + txt[i].duracao + "</td>" : "") +
                        "<td>" + txt[i].usr_nome + "</td>" +
                        "<td>" + txt[i].set_nome + "</td>" +
                        "</tr>";
                }
                table += "</table>";
                $("#ultimos-dialog").html(table);
            }
        }
    });
    if (quantidade > 0) {
        $("#ultimos-dialog").show();
        $("#ultimos-dialog").dialog({
            modal: true,
            width: 960,
            height: 400,
            close: function () {
                foco();
                $(this).dialog('close');

            },
            buttons: {
                Ok: function () {
                    foco();
                    $(this).dialog('close');
                }
            },
            open: function () {
                $(this).parent().find('button:nth-child(1)').focus();
            }
        });

    }
}

function foco() {
    $("#pro_codigo").focus();
}

function addLinhaProd() {
    var cont = $(".linha_produto").length + 1;
    var arr_lote = $("#ite_lote").val().split("|");

    if (parseInt(arr_lote[1]) < parseInt($("#ite_quantidade").val())) {
        setTimeout(function () {
            mensagem("Erro", "A quantidade digitada é maior que a quantidade do respectivo lote!", 300, 150)
        }, 500);
        $("#ite_quantidade").focus();
        return false;
    }


    if ($("#pro_codigo").val() != "" && $("#ite_quantidade").val() != "") {
        var linha = "<tr class=\"linha_produto line_" + cont + " lote_" + replaceSpecialChars(arr_lote[0]) + " " + $("#pro_codigo").val() + replaceSpecialChars(arr_lote[0]) + "\" data-pro=\"" + $("#pro_codigo").val() + "\" data-horus='" + $('#pro_horus').val() + "' data-horus-tipo='" + $('#pro_horus_tipo').val() + "' data-barras=\"" + $("#ite_codbarras").val() + "\" data-lote=\"'" + arr_lote[0] + "'\" data-validade=\"" + arr_lote[2] + "\" data-saldo=\"" + arr_lote[1] + "\" data-qtde=\"" + $("#ite_quantidade").val() + "\" data-duracao=\"" + $("#ite_duracao").val() + "\" data-item-editado='N' data-codrec=\"" + $("#ite_cod_receita").val() + "\">" +
            "<td>" + $("#ite_codbarras").val() + "</td>" +
            "<td align='center'>" + $("#pro_codigo").val() + "</td>" +
            "<td hidden>" + $("#pro_codigo").val() + "</td>" +
            "<td>" + $("#pro_nome").val() + "</td>" +
            "<td align='center'><b>Lote</b>:" + arr_lote[0] + " <b>Validade</b>: " + (arr_lote[2] != "" ? dataToBr(arr_lote[2]) : "SEM_VALIDADE") + " <b>Saldo</b>: " + arr_lote[1] + "</td>" +
            "<td align='center'>" + $("#ite_quantidade").val() + "</td>" +

            ($("#validade_medicamentos").val() == 1 ? "<td align='center'>" + $("#ite_duracao").val() + "</td>" : "") +
            "<td align='center'><a href=\"#\" class=\"ui-button add new ui-corner-bl ui-corner-tr\" style=\"margin-left: 5px;\" onclick=\"excluir('" + $("#pro_codigo").val() + replaceSpecialChars(arr_lote[0]) + "')\"> <div><img src=\"/WebSocialSaude/zf/public/images/icons/excluir2.png\"></div>Excluir</a></td>" +
            "</tr>";
        $("#itens_content").append(linha);
        $(".campos").val("");
        $("#tbLoteVal")
            .html("<tr style='border: none;'>\n" +
                "    <th width='33%' style='border: none;'>Lote</th>\n" +
                "    <th width='34%' align='center' style='border: none;'>Validade</th>\n" +
                "    <th width='33%' align='center' style='border: none;'>Saldo</th>\n" +
                "</tr>");
        $("#div_lote").html("<select id=\"ite_lote\" name=\"ite_lote\" class=\"ui-state-default\" style=\"width:350px;\" disabled=\"disabled\">" +
            "<option value=\"\">Lote &nbsp;-&nbsp; Validade &nbsp;-&nbsp; Saldo</option>" +
            "</select>");


        $("#pro_codigo").focus();
    } else {
        setTimeout(function () {
            mensagem("Erro", "Tem informações a serem preenchidas!", 300, 150)
        }, 500);
    }
}

function addLinhaLoteAutomatico() {

    var cont = $(".linha_produto").length + 1;
    if ($("#pro_codigo").val() != "" && $("#ite_quantidade").val() != "") {
        var qtde = $("#ite_quantidade").val();
        $.ajax({
            url: baseUrl + "/produto/get-lote-automatico/",
            data: {
                pro_codigo: $("#pro_codigo").val(),
                quantidade: qtde,
                set_codigo: $("#set_codigo").val(),
                ite_codbarras: $("#ite_codbarras").val()
            },
            success: function (txt) {
                var arr_txt = "";
                var validador = 0;
                var produtos_faltou = "";
                var produtos = "";

                for (var i in txt) {
                    if (validador != 1) {
                        var pro_codigo = $("#pro_codigo").val();
                        var duracao = $("#ite_duracao").val();
                        var nome = $("#pro_nome").val();
                        var barras = $("#ite_codbarras").val();
                        validador = 1;
                    }
                    if (i != "faltam") {
                        arr_txt = txt[i].split("|");
                        var linha = "<tr class=\"linha_produto line_" + cont + " lote_" + replaceSpecialChars(i) + " " + pro_codigo + replaceSpecialChars(i) + "\" data-pro=\"" + pro_codigo + "\" data-horus='" + $("#pro_horus").val() + "' data-horus-tipo='" + $("#pro_horus_tipo").val() + "'  data-barras=\"" + barras + "\" data-lote=\"'" + i + "'\" data-validade=\"" + arr_txt[1] + "\" data-saldo=\"" + arr_txt[0] + "\" data-qtde=\"" + arr_txt[0] + "\" data-duracao=\"" + duracao + "\" data-item-editado='N' data-codrec=\"" + $("#ite_cod_receita").val() + "\">" +
                            "<td>" + $("#ite_codbarras").val() + "</td><td align='center'>" + $("#pro_codigo").val() + "</td>" +
                            "<td>" + $("#pro_nome").val() + "</td>" +
                            "<td><b>Lote</b>:" + i + " <b>Validade</b>:" + dataToBr(arr_txt[1]) + "  <b>Quantidade</b>: " + arr_txt[0] + "</td>" +
                            "<td style='text-align: center'>" + $("#ite_quantidade").val() + "</td>" +
                            ($("#validade_medicamentos").val() == 1 ? "<td >" + $("#ite_duracao").val() + "</td>" : "") +
                            "<td style='text-align: center'>" + ($("#rec_codigo").val() == "" ? "<a href=\"#\" class=\"ui-button add new ui-corner-bl ui-corner-tr\" style=\"margin-left: 5px;\" onclick=\"excluirOculto('" + pro_codigo + replaceSpecialChars(i) + "', '" + irec_codigo + "')\"><div><img src=\"/WebSocialSaude/zf/public/images/icons/excluir2.png\"></div>Excluir</a>" : "") + "</td>" +
                            "<input name=\"irec_excluido\" id=\"irec_excluido_" + irec_codigo + "\"  value='0' type='hidden'>" +
                            "</tr>";

                        $("#itens_content").append(linha);
                        $(".campos").val("");
                    } else {
                        var table = "<table>" +
                            "<tr>" +
                            "<th>Produto</th>" +
                            "<th>Qtde. Solicitada</th>" +
                            "<th>Qtde. Pendente</th>" +
                            "</tr>" +
                            "<tr>" +
                            "<td>" + nome + "</td>" +
                            "<td>" + $("#ite_quantidade").val() + "</td>" +
                            "<td>" + txt[i] + "</td>" +
                            "</tr>" +
                            "</table>";
                        mensagem("Alerta", "Não há estoque suficiente para os seguintes produtos:<br/><br/>" + table, 700, 300);
                    }
                }

                $("#pro_codigo").focus();
            }
        });
    } else {
        setTimeout(function () {
            mensagem("Erro", "Tem informações a serem preenchidas!", 300, 150)
        }, 500);
    }

}

function excluirEditados(ite_codigo, pro_codigo_lote) {
    confirme("Confirme", "Remover este item alterará o movimento. Deseja continuar?", 300, 150, function () {
        mensagemSemOk("carregando-del-item", "Aguarde", "Carregando...", 280, 80);
        $.ajax({
            url: baseUrl + "/farmacia/farmacia/remover-item/ite_codigo/" + ite_codigo,
            success: function (ret) {
                fecharMensagemSemOk("carregando-del-item");
                if (!ret.horus && !ret.protocolos) {
                    $("." + pro_codigo_lote).remove();
                    mensagem("Sucesso", ret.msg, 300, 150, function () {
                        //Remove dispensações sem itens por confirmação
                        if ($(".linha_produto").length == 0) {
                            var mov_codigo = $("#mov_codigo").val();
                            confirme("Confirme", "Esta dispensação não contém mais itens. Deseja exclui-la?", 300, 150, function () {
                                excluirMovimentoSemItens(mov_codigo);
                            });
                        }
                    });
                } else if (ret.protocolos) {
                    $("." + pro_codigo_lote).remove();
                    mensagem("Sucesso", ret.msg + "<br/>" + ret.protocolos, 400, "auto", function () {
                        //Remove dispensações sem itens por confirmação
                        if ($(".linha_produto").length == 0) {
                            var mov_codigo = $("#mov_codigo").val();
                            confirme("Confirme", "Esta dispensação não contém mais itens. Deseja exclui-la?", 300, 150, function () {
                                excluirMovimentoSemItens(mov_codigo);
                            });
                        }
                    });
                } else if (ret.horus) {
                    mensagem("Erro", ret.msg + "<br/>" + ret.horus, 300, 180);
                }
            }
        });
    });
}

function excluirMovimentoSemItens(mov_codigo) {
    mensagemSemOk("carregando-del-mov", "Aguarde", "Carregando...", 280, 80);
    $.ajax({
        url: baseUrl + "/farmacia/farmacia/remover-movimento/mov_codigo/" + mov_codigo,
        success: function (ret) {
            fecharMensagemSemOk("carregando-del-mov");
            if (ret.sucesso) {
                mensagem("Sucesso", "Dispensação removida com sucesso", 300, 150, function () {
                    window.location = baseUrl + "/farmacia/farmacia/administracao";
                });
            } else {
                mensagem("Erro", "Não foi possível remover esta dispensação. <br/> " + ret.erro, 300, 150);
            }
        }
    });
}

function excluirMovimento(mov_codigo) {
    confirme("Confirme", "Remover este item alterará o movimento. Deseja continuar?", 300, 150, function () {

    });
}

function excluir(pro_codigo_lote) {
    $("." + replaceSpecialChars(pro_codigo_lote)).remove();
}

function excluirOculto(pro_codigo_lote, irec_codigo) {
  $("." + replaceSpecialChars(irec_codigo)).hide();
  $("#irec_excluido_" + replaceSpecialChars(irec_codigo)).val('1');
  $("#irec_quantidade_" + replaceSpecialChars(irec_codigo)).val('0');
}

function getLotes(pro_codigo) {

    if (pro_codigo == "" || pro_codigo == null) {
        pro_codigo = $("#pro_codigo").val();
    }

    var setor = $("#set_codigo").val();
    var cod_barras = null;
    if ($("#ite_codbarras").val() != "" || $("#ite_codbarras").val() != null) {
        cod_barras = $("#ite_codbarras").val();
    }

    $.ajax({
        url: baseUrl + "/produto/get-lotes/",
        type: "POST",
        data: {
            pro_codigo: pro_codigo,
            set_codigo: setor,
            ite_codbarras: cod_barras,
            enviados: 1
        },
        success: function (txt) {
            if (txt.length > 0) {
                var select = "<select id=\"ite_lote\" name=\"ite_lote\" class=\"ui-state-default\" style=\"width:350px; padding: 10px; border: none;\">";
                for (var i in txt) {
                    var quantidade = txt[i].sal_qtde;
                    if ($("." + pro_codigo + replaceSpecialChars(txt[i].sal_lote)).data("qtde")) {
                        quantidade = (txt[i].sal_qtde - parseInt($("." + pro_codigo + replaceSpecialChars(txt[i].sal_lote)).data("qtde")));
                    }
                    var checked = "";

                    if ($("." + txt[i].pro_codigo + replaceSpecialChars(txt[i].sal_lote)).length < 1) {
                        $("#tbLoteVal")
                            .html("<tr style='border: none;'>\n" +
                                "    <th width='33%' style='border: none;'>Lote</th>\n" +
                                "    <th width='34%' align='center' style='border: none;'>Validade</th>\n" +
                                "    <th width='33%' align='center' style='border: none;'>Saldo</th>\n" +
                                "</tr>");
                        select += "<option value=\"" + txt[i].sal_lote + "|" + quantidade + "|" + txt[i].sal_validade + "\"" + checked + ">Lote: " + txt[i].sal_lote + " - Val.: " + dataToBr(txt[i].sal_validade) + " - Saldo: " + quantidade + "</option>";
                    }
                }

                select += "</select>";
                $("#div_lote").html(select);
            } else {
                mensagem("Erro", "O produto selecionado não possui saldo!", 300, 150, function () {
                    foco();
                });
                $("#pro_codigo").val("");
                $("#pro_nome").val("");
                $("#ite_codbarras").val("");
                $("#ite_quantidade").val("");
                $("#div_lote").html("<select id=\"ite_lote\" name=\"ite_lote\" class=\"ui-state-default\" style=\"width:350px;\" disabled=\"disabled\">" +
                    "<option value=\"\">Lote &nbsp;-&nbsp; Validade &nbsp;-&nbsp; Saldo</option>" +
                    "</select>");
                $("#pro_codigo").focus();

            }
        }
    });
}

function Item(ite_codbarras, ite_cod_receita, cod_receita, pro_codigo, horus, horus_tipo, protocolo_horus, ite_lote, ite_validade, ite_quantidade, ite_qtde_pendente, ite_quantidade_solicitada, ite_duracao, item_editado) {
    var qtde_pendente = (parseInt(ite_qtde_pendente) - parseInt(ite_quantidade_solicitada));
    this.ite_codbarras = ite_codbarras;
    this.ite_cod_receita = ite_cod_receita;
    this.cod_receita = cod_receita;
    this.pro_codigo = pro_codigo;
    this.horus = horus;
    this.horus_tipo = horus_tipo;
    this.protocolo_horus = protocolo_horus;
    this.ite_lote = ite_lote;
    this.ite_validade = ite_validade;
    this.ite_quantidade = ite_quantidade;
    this.ite_qtde_pendente = (qtde_pendente < 0 ? 0 : qtde_pendente);
    this.ite_quantidade_solicitada = ite_quantidade_solicitada;
    this.ite_duracao = ite_duracao;
    this.item_editado = item_editado;
}

function salvarDispensa() {
    var mov_codigo = $("#mov_codigo").val();
    var edicao = (mov_codigo ? true : false);
    var usu_codigo = $("#usu_codigo").val();
    var usr_codigo = $("#usr_codigo").val();
    var interno = $("#interno").val();
    var set_codigo = $("#set_codigo").val();
    var rec_codigo = $("#rec_codigo").val();
    var mov_data = $("#mov_data").val();
    var mov_observacao = $('#mov_observacao').val();
    var tipo_receita = $('#tipo_receita:checked').val();

    if ($("#pro_codigo").val() != "") {
        setTimeout(function () {
            mensagem("Erro", "Há um item a ser salvo", 300, 150)
        }, 500);
        return false;
    }

    if (usu_codigo == "" || usu_codigo == null) {
        setTimeout(function () {
            mensagem("Erro", "Informe um paciente", 300, 150)
        }, 500);
        return false;
    }

    if (usr_codigo == "" || usr_codigo == null) {
        setTimeout(function () {
            mensagem("Erro", "Informe um profissional", 300, 150)
        }, 500);
        return false;
    }

    confirme("Confirme:", "Deseja realmente gerar movimentação?", 300, 150, function () {
        mensagemSemOk("carregando-ate1", "Aguarde", "Carregando...", 280, 80);

        var itens = new Array();
        var irec_codigo = "";
        if ($(".linha_produto").length == 0) {
            fecharMensagemSemOk("carregando-ate1");
            setTimeout(function () {
                mensagem("Erro", "Não há produtos selecionados", 300, 150)
            }, 500);
            return false;
        } else {
            var duracao = "";
            $(".linha_produto").each(function () {
                irec_codigo = $(this).data("irec");
                if (irec_codigo == "" || irec_codigo == null || irec_codigo == "undefined") {
                    duracao = $(this).data("duracao");
                } else {
                    duracao = $("#irec_duracao_" + irec_codigo).val();
                }

                itens.push(
                    new Item(
                        $(this).data("barras"),
                        irec_codigo,
                        $(this).data("codrec"),
                        $(this).data("pro"),
                        $(this).data("horus"),
                        $(this).data("horus-tipo"),
                        $(this).data("protocolo-horus"),
                        $(this).data("lote"),
                        $(this).data("validade"),
                        ($("#irec_excluido_" + irec_codigo).val() == 1 ? 0 : $(this).data("qtde")),
                        $(this).data("pendente"),
                        ($("#irec_excluido_" + irec_codigo).val() == 1 ? 0 : $(this).data("solicitada")),
                        duracao,
                        $(this).data("item-editado")
                    )
                );
            });
        }

        $.ajax({
            url: baseUrl + "/farmacia/farmacia/salvar",
            data: {
                mov_codigo: mov_codigo,
                usu_codigo: usu_codigo,
                set_codigo: set_codigo,
                usr_codigo: usr_codigo,
                interno: interno,
                itens: itens,
                rec_codigo: rec_codigo,
                mov_data: mov_data,
                mov_observacao: mov_observacao,
                tipo_receita: tipo_receita

            },
            success: function (txt) {
                fecharMensagemSemOk("carregando-ate1");
                if (txt !== "undefined" && txt !== undefined && txt !== null && txt !== "") {
                    if (txt.id == "" || txt.id == null || typeof txt.id == "undefined") {
                        if (txt.horus != null || txt.horus != "undefined" || txt.horus.length > 0) {
                            for (i = 0; i < txt.horus.length; i++) {
                                txt.msg += txt.horus[i];
                            }
                        }
                        mensagem("Erro", txt.msg, 300, 150);
                    } else {
                        var msg = "Dispensação realizada com sucesso.<br/>";
                        if (typeof txt.protocolos != "undefined" || txt.protocolos.length > 0) {
                            for (i = 0; i < txt.protocolos.length; i++) {
                                msg += txt.protocolos[i];
                            }
                        }
                        msg += "<br/>";
                        if (typeof txt.horus != "undefined" || txt.horus.length > 0) {
                            for (i = 0; i < txt.horus.length; i++) {
                                msg += txt.horus[i];
                            }
                        }
                        mensagem("Sucesso", msg, 400, "auto", sucesso_salvar(txt.id, edicao));
                    }
                } else {
                    mensagem("Erro", "Ocorreu um erro ao processar sua solicitação. Entre em contato com o suporte técnico. Cód.404 - Hórus", 350, "auto");
                }
            }
        });
    });
}

function sucesso_salvar(mov_codigo, edicao) {
    if ($("#via_medicamentos").val() == 1) {
        $("body").append("<div id=\"confirma-disp\" title=\"Confirmação:\"><br />Dados cadastrado com sucesso! <br />Deseja imprimir o comprovante de dispensação?</div>");
        $("#confirma-disp").dialog({
            modal: true,
            width: 290,
            height: 180,
            close: function () {
                window.location = baseUrl + "/farmacia/farmacia";
                $(this).remove();
            },
            buttons: {
                Sim: function () {
                    window.open(baseUrl + "/farmacia/farmacia/imprimir-via/mov_codigo/" + mov_codigo, '', 'width=750,height=700');
                    $(this).dialog('close');
                },
                'Não': function () {
                    $(this).dialog('close');
                    if (edicao)
                        window.location = baseUrl + "/farmacia/farmacia/administracao";
                    else
                        window.location = baseUrl + "/farmacia/farmacia";
                }
            }
        });
    } else {
        if (edicao)
            window.location = baseUrl + "/farmacia/farmacia/administracao";
        else
            window.location = baseUrl + "/farmacia/farmacia";
    }
}

function retornaPac(usu_codigo, usu_nome) {

    $("#usu_codigo").val(usu_codigo);
    $("#buscar1").val(usu_nome);
    $("#pro_codigo").focus();
}

function addLinhaCodBarrasAutomatico(pro_codigo, pro_nome, irec_codigo, irec_quantidade, irec_qtde_pendente, irec_qtde_solicitada, ite_duracao, digitada, item_editado) {
    mensagemSemOk("carregando-ate2", "Aguarde", "Carregando...", 280, 80);
    var cont = $(".linha_produto").length + 1;

    var qtde = (digitada ? digitada : irec_qtde_pendente);

    if (pro_codigo != "" && parseInt(irec_qtde_pendente) > 0) {
        var produtos = "";
        $.ajax({
            url: baseUrl + "/produto/get-lote-automatico/",
            data: {
                pro_codigo: pro_codigo,
                quantidade: qtde,
                set_codigo: $("#set_codigo").val()
            },
            async: false,
            success: function (txt) {
                $("#carregando-ate2").dialog("destroy").remove();
                var arr_txt = "";
                var validador = 0;
                var codigo = "";
                var nome = "";
                var quantidade = "";
                var campo_duracao = "";
                var duracao = "";

                for (var i in txt) {
                    if (validador != 1) {
                        codigo = pro_codigo;
                        nome = pro_nome;
                        quantidade = qtde;
                        validador = 1;
                        duracao = ite_duracao
                        campo_duracao = "<input name=\"irec_duracao\" id=\"irec_duracao_" + irec_codigo + "\"  value=\"" + duracao + "\" class=\"campos ui-state-default\" style=\"width: 60px;\" onkeypress=\"return SomenteNumero(event)\" type=\"text\">";
                    } else {
                        codigo = "";
                        nome = "";
                        quantidade = "";
                        duracao = "";
                        campo_duracao = "";
                    }

                    if (i != "faltam") { //entra só a primeira vez no for
                        arr_txt = txt[i].split("|");
                        var linha = "<tr class=\"" + irec_codigo + " linha_produto line_" + cont + " lote_" + replaceSpecialChars(i) + " " + pro_codigo + replaceSpecialChars(i) + "\" data-horus='" + $('#pro_horus').val() + "' data-horus-tipo='" + $('#pro_horus_tipo').val() + "' data-pro=\"" + pro_codigo + "\" data-horus='" + $("#pro_horus").val() + "' data-horus-tipo='" + $("#pro_horus_tipo").val() + "' data-lote=\"'" + i + "'\" data-validade=\"" + arr_txt[1] + "\" data-qtde=\"" + irec_quantidade + "\" data-pendente=\"" + irec_qtde_pendente + "\" data-solicitada=\"" + qtde + "\" data-irec=\"" + irec_codigo + "\" data-item-editado='N' data-codrec=\"" + $("#rec_codigo").val() + "\">" +
                            "<td align='center'>" + arr_txt[2] + "</td>" +
                            "<td align='center'>" + codigo + "</td>" +
                            "<td>" + nome + "</td>" +
                            "<td> " +
                            "   <table style='border: none;'> " +
                            "       <tr style='border: none;'> " +
                            "           <td width='20%' style='border: none;'>" + i + "</td> " +
                            "           <td width='10%' align='center' style='border: none;'>" + dataToBr(arr_txt[1]) + " </td> " +
                            "           <td width='35%' align='center' style='border: none;'>" + irec_quantidade + "</td>" +
                            "           <td width='35%' align='center' style='border: none;'>" + irec_qtde_pendente + "</td> " +
                            "       </tr> " +
                            "   </table> " +
                            "</td>" +
                            "<td>" + (quantidade != "" ? "<input name=\"irec_quantidade\" id=\"irec_quantidade_" + irec_codigo + "\"  value=\"" + quantidade + "\" class=\"campos ui-state-default\" style=\"width: 60px; text-align: center;\" onkeypress=\"return SomenteNumero(event)\" onChange=\"alteraLinha('" + pro_codigo + "','" + pro_nome + "','" + irec_codigo + "','" + irec_quantidade + "','" + irec_qtde_pendente + "','" + item_editado + "')\" type=\"text\">" : "") + "</td>" +
                            "<td align='center'>" + ($("#validade_medicamentos").val() == 1 ? campo_duracao : "") + "<input type=\"hidden\" value=\"" + $("#rec_codigo").val() + "\" id=\"ite_cod_receita\"></td>" +
                            "<td align='center'><a href=\"#\" class=\"ui-button add new ui-corner-bl ui-corner-tr\" style=\"margin-left: 5px;\" onclick=\"excluirOculto('" + pro_codigo + replaceSpecialChars(i) + "', '" + irec_codigo + "')\"><div><img src=\"/WebSocialSaude/zf/public/images/icons/excluir2.png\"></div>Excluir</a></td>" +
                            "<input name=\"irec_excluido\" id=\"irec_excluido_" + irec_codigo + "\"  value='0' type='hidden'>" +
                            "</tr>";

                        $("#table_itens").append(linha);
                    } else {
                        validador = 1;
                        produtos += "<tr>" +
                            "<td>" + nome + "</td>" +
                            "<td>" + irec_quantidade + "</td>" +
                            "<td>" + txt[i] + "</td>" +
                            "</tr>";
                    }

                }

                $("#pro_codigo").focus();
            }
        });
        return produtos;
    } else {
        setTimeout(function () {
            mensagem("Erro", "Tem informações a serem preenchidas!", 300, 150)
        }, 500);
    }
}

function alteraLinha(pro_codigo, pro_nome, irec_codigo, irec_quantidade, irec_qtde_pendente, item_editado) {
    var quantidade = $("#irec_quantidade_" + irec_codigo).val() != null ? $("#irec_quantidade_" + irec_codigo).val() : 0;
    var duracao = $("#irec_duracao_" + irec_codigo).val();
    $("." + irec_codigo).remove();
    addLinhaCodBarrasAutomatico(pro_codigo, pro_nome, irec_codigo, irec_quantidade, irec_qtde_pendente, quantidade, duracao, quantidade, item_editado)
}
