$(function () {
    checaRegulacao();
    $(".paciente").click(function () {
        var usu_codigo = $("#usu_codigo").val();
        if (usu_codigo != "") {
            var link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
        } else {
            link = baseUrl + "/default/paciente/form-paciente/poupup/1";
        }

        window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });

});
function retornaPac(usu_codigo, usu_nome) {
    $("#usu_codigo").val(usu_codigo);
    $("#usu_nome").val(usu_nome);
}
function buscaUnidade() {
    $("#uni_desc").buscar({
        url: baseUrl + "/default/unidade/buscar",
        minLength: 3,
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function buscaProfissional() {

    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar/externo/1/conveniado/1',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function buscaEspecialidadeFila() {
    $("#esp_nome").buscar({
        url: baseUrl + '/especialidade/buscar/',
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });
}

function buscaProcedimentoFila() {
    $("#proc_nome").buscar({
        url: baseUrl + "/procedimento/buscar/esp/" + $("#esp_codigo").val(),
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            adicionaProcedimento();
            limparCampos();

        }
    });
}

function buscaProfissionalFila() {
    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar/externo/1',
        categoria: 'categoria',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

}

function checaRegulacao() {

    var fila_codigo = $('#fila_codigo').val();
    var botao = baseUrl + "/public/images/icons/";

    $.ajax({
        url: baseUrl + "/filaespera/filas-usuario/checa-regulacao",
        type: "POST",
        data: {fila_codigo: fila_codigo},
        success: function (txt) {
            if (txt.regulador == true) {
                document.getElementById("salvar_autorizar").style.visibility = "visible";
                return true;
            } else {
                $("#fiusu_status").val("AR");
                document.getElementById("salvar_autorizar").style.visibility = "hidden";
                return true;
            }
        }
    });

}

function validaForm(evt, tipo_salvar) {
    var uni_codigo = $('#uni_codigo').val();
    var fila_codigo = $('#fila_codigo').val();
    var esp_codigo = $('#esp_codigo').val();
    var usr_codigo = $('#usr_codigo').val();
    var fiusu_data_pedido = $('#fiusu_data_pedido').val();
    var fiti_codigo = $('#fiti_codigo').val();
    var fipr_codigo = $('#fipr_codigo').val();
    var usu_codigo = $('#usu_codigo').val();
    var cont = parseInt($("#proc_qtd_total").val());
    var tipo_fila = "";

    if (tipo_salvar == 1) {
        $("#fiusu_status").val("ES");
        if($("#fiusu_status").val() == ""){
            $("#fiusu_status").val("AR");
        }
    }
    var valoresForm = $('#form').serialize();
    if (uni_codigo == "") {
        alert('Unidade Solicitante é obrigatório!');
        document.getElementById('uni_desc').focus();
        evt.preventDefault();
        return false;
    }

    if (fila_codigo == "") {
        alert('Selecione uma Fila de Espera!');
        evt.preventDefault();
        return false;
    }

    if (esp_codigo == "") {
        alert('Selecione a Especialidade!');
        evt.preventDefault();
        return false;
    }

    if (cont == "") {
        alert('Selecione um Procedimento!');
        evt.preventDefault();
        return false;
    }

    if (usr_codigo == "") {
        alert('Selecione o Profissional Solicitante!');
        evt.preventDefault();
        return false;
    }

    if (fiusu_data_pedido == "") {
        alert('Selecione a Data do Pedido!');
        evt.preventDefault();
        return false;
    }

    if (fiti_codigo == "") {
        alert('Selecione o Tipo de Atendimento!');
        evt.preventDefault();
        return false;
    }

    if (fipr_codigo == "") {
        alert('Selecione a Prioridade!');
        evt.preventDefault();
        return false;
    }

    if (usu_codigo == "") {
        alert('Selecione o Paciente!');
        evt.preventDefault();
        return false;
    }
    if (cont > 1) {
        tipo_fila = verificaTipoFila(fila_codigo);
        switch (tipo_fila) {
            case 'U':
                break;
            case 'P':
                break;
            default:
                mensagem("Erro", "Este tipo de fila não permite mais de 1 procedimento!", 250, 150);
                return;
        }
    }
    mensagemSemOk("carregando-fila-espera", "Aguarde", "Carregando...", 280, 80);
    $.ajax({
        url: baseUrl + "/filaespera/filas-usuario/salvar",
        type: "POST",
        data: valoresForm,
        success: function (txt) {
            if (txt.success) {
                afterSubmit(txt);
                return true;
            } else{
                mensagem(txt.titulo, txt.mensagem, 300, 200);
                fecharMensagemSemOk("carregando-fila-espera");
                return;
            }
        }
    });

}

function afterSubmit(json) {
    fecharMensagemSemOk("carregando-fila-espera");

    $("<div id='dialog-1'> <span>Solicitação cadastrada com sucesso!</span> <br> <span>Deseja imprimir o comprovante?</span>   </div>").dialog({
        autoOpen: true,
        modal: true,
        resizable: false,
        closeOnEscape: true,
        position: ['top', 'center'],
        width: 400,
        height: 140,
        title: "Aviso:",
        close: function () {
            window.location.href = baseUrl + "/filaespera/filas-usuario/buscar/fila/" + json.fila_codigo;
            $(this).remove();
        },
        buttons: {
            "Imprimir em 1 via": function () {
                // imprimir
                var url = baseUrl + "/filaespera/filas-usuario/imprimir/copias/1/fiusu_codigo/" + json.fiusu_codigo;
                window.open(url);
                $(this).dialog('close');
            },
            "Imprimir em 2 vias": function () {
                // imprimir
                var url = baseUrl + "/filaespera/filas-usuario/imprimir/copias/2/fiusu_codigo/" + json.fiusu_codigo;
                window.open(url);
                $(this).dialog('close');
            },
            "Não": function () {
                // não imprimir
                $(this).dialog('close');
            }
        }
    });
}

function limparCampos() {
    $("#proc_nome").val("");
}

function adicionaProcedimento() {
    var cont = parseInt($("#proc_qtd_total").val()) + 1;
    var proc_nome = $("#proc_nome").val().trim();
    var proc_codigo = $("#proc_codigo").val();
    var proc_codigo_sus = $("#proc_codigo_sus").val();
    var sem_codigo = "";
    var fila_codigo = $('#fila_codigo').val();
    var tipo_fila = "";

    if (proc_codigo_sus == "") {
        sem_codigo = "SEM CÓDIGO"
    }
    if (cont > 1) {
        tipo_fila = verificaTipoFila(fila_codigo);
        switch (tipo_fila) {
            case 'U':
                break;
            case 'P':
                break;
            default:
                mensagem("Erro", "Este tipo de fila não permite mais de 1 procedimento!", 250, 150);
                return;
        }
    }
    if (validaProcedimento(proc_codigo) == 0) {
        $("#proc_qtd_total").val(cont);
        $("#procedimentos").append(
            '<tr id="proc_qtd' + cont + '">' +
            "<td>" + sem_codigo + proc_codigo_sus + " - " + proc_nome +
            "<input type='hidden' name='proc[" + cont + "][proc_codigo]' value=\"" + proc_codigo + "\" />" +
            "<input type='hidden' name='proc[" + cont + "][fiproc_codigo]' value=\"\"/>" +
            "</td>" +
            "<td>" +
            "<a href='#' class='excluir'>" +
            '<img src="' + baseUrl + '/public/images/icons/excluir.png" alt="Excluir" title="Excluir" onclick="excluirConfirmacao(' + cont + ')" />' +
            "</a>" +
            "</td>" +
            "</tr>");
        $("#proc_nome").val("");
    } else {
        mensagem("Erro", "Procedimento já cadastrado", 250, 150);
    }
    $('html, body').animate({scrollTop: $('#proc_qtd' + cont).offset().top}, 'slow');
    document.getElementById('proc_nome').focus();


}

function validaProcedimento(term) {
    var cont = new Number($("#proc_qtd_total").val()) + 1;
    var table = $('#procedimentos');
    var retorno = "";
    if (cont > 1) {
        table.find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (term == $(this).val()) {
                    retorno = 1;
                }
            });
        });
    }
    return retorno;
}

function excluirConfirmacao(id, fiproc_codigo) {

    $('html, body').animate({scrollTop: $('#proc_qtd' + id).offset().top}, 'slow');
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        $("#proc_qtd" + id).remove();
        var cont = parseInt($("#proc_qtd_total").val()) - 1;
        $("#proc_qtd_total").val(cont);

        if (fiproc_codigo) {
            $.ajax({
                url: baseUrl + "/filaespera/filas-usuario/excluir-procedimento/fiproc_codigo/" + fiproc_codigo,
                type: "POST",
                data: fiproc_codigo,
                success: function (txt) {
                    if (txt.success == true) {
                        mensagem("Atenção", "Procedimento excluído com Sucesso!", 300, 150, function () {
                            return true;
                        });
                    } else {
                        mensagem(txt.titulo + "," + txt.mensagem, 300, 150, function () {
                            return false;
                        });
                    }

                }
            });
        }

    });
}

function verificaTipoFila(fila_codigo) {
    var retorno = "";
    $.ajax({
        url: baseUrl + "/filaespera/fila/get-lista/fila_codigo/" + fila_codigo,
        type: "POST",
        async: false,
        data: fila_codigo,
        success: function (txt) {
            if (txt.success) {
                retorno = txt.mensagem;
            }
        }
    });
    return retorno;
}
