$(function() {
  $("#busca input").autocomplete( {
    source : baseUrl + "/produto/medicamento/limite/15",
    select : function(event, ui) {
      $('#pro_nome').val(ui.item.label);
      $('#pro_codigo').val(ui.item.id);
      return false;
    }
  });
});

function adicionarModelo() {
  if ($('#adm_codigo :selected').val() == '-Selecione-') {
    mensagem("Atenção", "Informe o modo de administração!", 300, 150);
    $('#adm_codigo').focus();
    return;
  }
  else if (!$('#lgm_quantidade').val()) {
    mensagem("Atenção", "Informe a quantidade!", 300, 150);
    $('#lgm_quantidade').focus();
    return;
  }
  else if (!$('#pro_codigo').val()) {
    mensagem("Atenção", "Informe o medicamento!", 300, 150);
    $('#pro_codigo').focus();
    return;
  }

  $.ajax({
    url: baseUrl + '/leito/categoria/salvar-modelo',
    type: 'POST',
    data: {
      lgm_codigo: $('#lgm_codigo').val(),
      lgc_codigo: $('#lgc_codigo').val(),
      adm_codigo: $('#adm_codigo').val(),
      lgm_quantidade: $('#lgm_quantidade').val(),
      pro_codigo: $('#pro_codigo').val()
    },
    success: function () {
      $('#adm_codigo').val('');
      $('#lgm_quantidade').val('');
      $('#pro_codigo').val('');
      $('#pro_nome').val('');
      location.reload();
    }
  });
}

function editarModelo(id) {
  $('#lgm_codigo').val(id);
  $('#adm_codigo').val($('#administracao-' + id).val());
  $('#lgm_quantidade').val($('#quantidade-' + id).val());
  $('#pro_codigo').val($('#medicamento-' + id).val());
  $('#pro_nome').val($('#medicamentonome-' + id).val());
}

function excluirModelo(id) {
  $.ajax({
    url: baseUrl + '/leito/categoria/excluir-modelo',
    type: 'POST',
    data: {
      id: id
    },
    success: function () {
      location.reload();
    }
  });
}

function validarAdministracao(adm_codigo, adm_nome) {
  if (adm_codigo == 0) {
    $("#administracao_controle").val('');
    $("#administracao_nome").val('');
  } else {
    $("#administracao_controle").val(adm_codigo);
    $("#administracao_nome").val(adm_nome);
  }
}
