$(function () {
  $("#busca input").autocomplete({
    source: baseUrl + "/produto/medicamento/limite/15",
    select: function (event, ui) {
      $('#medicamento').val(ui.item.label);
      $('#medicamento-id').val(ui.item.id);

      return true;
    }
  })

  $("button").click(function () {
    $("#busca input").autocomplete("search");
  });
});

function carregarModelos() {
  if ($('#modelos :selected').val() != 'Selecione...') {
    $.ajax({
      url: baseUrl + '/leito/medicamentos/listagem-modelos/',
      type: 'POST',
      data: {
        id: $('#modelos :selected').val()
      },
      success: function (resp) {
        if (resp != '') {
          var modelosLength = $('#tab-modelos tr').length;
          if (modelosLength == 0) {
            var html = '<tr class="ui-widget-header">'
              + '  <th width="40%">Medicamento</th>'
              + '  <th width="15%">Administração</th>'
              + '  <th width="5%">Quantidade</th>'
              + '  <th width="1%">Ações</th>'
              + '</tr>';
          }
          $.each(resp, function (i, element) {
            html += carregaTabelaItens(i, element);
          });

          if (modelosLength == 0) {
            $('#tab-modelos').html(html);
          } else {
            $('#tab-modelos tr:nth-child(' + modelosLength + ')').after(html);
          }
          $('#tab-modelos').show();
          $('#finaliza-grade').css('visibility', 'visible');
        }
        else {
          $('#tab-modelos').hide();
        }
      }
    });
  }
  else {
    $('#tab-modelos').hide();
  }
}

function carregaTabelaItens(i, element) {
  return '<tr name="tr-grade" id="tr-modelos-' + i + '">'
    + '  <td style="display: none">'
    + '    <input name="grade[' + i + '][pro_codigo]" type="hidden" id="produto-codigo-' + i + '" value="' + element.pro_codigo + '">'
    + '    <input name="grade[' + i + '][adm_codigo]" type="hidden" id="administracao-codigo-' + i + '" value="' + element.adm_codigo + '">'
    + '    <input name="grade[' + i + '][lig_quantidade]" type="hidden" id="modelo-quantidade-' + i + '" value="' + element.lgm_quantidade + '">'
    + '  </td>'
    + '  <td class="ui-state-default medicamento">' + element.pro_nome + '</td>'
    + '  <td class="ui-state-default administracao c">' + element.adm_nome + (element.adm_sigla != '' ? ' (' + element.adm_sigla + ')' : '') + '</td>'
    + '  <td class="ui-state-default quantidade c">' + element.lgm_quantidade + '</td>'
    + '  <td class="ui-state-default acoes c">'
    + '    <a onclick="excluirModelo(' + i + ')">'
    + '      <img src="' + baseUrl + '/public/images/icons/excluir.png" alt="Excluir" title="Excluir"/>'
    + '    </a>'
    + '  </td>'
    + '</tr>';
}

function excluirModelo(id) {
  $('#tr-modelos-' + id).remove();
}

function adicionarMedicamento() {
  if ($('#administracao :selected').val() == 'Selecione...') {
    mensagem("Atenção", "Informe o modo de administração!", 300, 150);
    $('#administracao').focus();
    return;
  }
  else if (!$('#lgra_repeticoes').val()) {
    mensagem("Atenção", "Informe as repetições!", 300, 150);
    $('#lgra_repeticoes').focus();
    return;
  }
  else if (!$('#lgra_quantidade').val()) {
    mensagem("Atenção", "Informe a quantidade!", 300, 150);
    $('#lgra_quantidade').focus();
    return;
  }
  else if (!$('#medicamento').val()) {
    mensagem("Atenção", "Informe o medicamento!", 300, 150);
    $('#medicamento').focus();
    return;
  }

  var i = $('#tab-modelos tr').length;
  var element = {
    pro_nome: $('#medicamento').val(),
    pro_codigo: $('#medicamento-id').val(),
    adm_nome: $('#administracao :selected').text(),
    adm_codigo: $('#administracao :selected').val(),
    adm_sigla: '',
    lgm_quantidade: $('#lgra_quantidade').val(),
  };

  if ($('#tab-modelos tr').length == 0) {
    var html = '<tr class="ui-widget-header">'
      + '  <th width="40%">Medicamento</th>'
      + '  <th width="15%">Administração</th>'
      + '  <th width="5%">Quantidade</th>'
      + '  <th width="1%">Ações</th>'
      + '</tr>'
      + carregaTabelaItens(i, element);

    $('#tab-modelos').html(html);

  }
  else {
    $('#tab-modelos tr:nth-child(' + i + ')').after(carregaTabelaItens(i, element));
  }
  $('#tab-modelos').show();
  $('#medicamento').val('');
  $('#medicamento-id').val('');
  $('#administracao').val('');
  $('#finaliza-grade').css('visibility', 'visible');
}


function salvarGrade() {
  mensagemSemOk("carregando-grade", "Aguarde", "Carregando...", 280, 80);
  $.ajax({
    url: baseUrl + "/leito/medicamentos/salvar",
    type: "POST",
    data: $("#grade").serialize(),
    success: function(ret){
      fecharMensagemSemOk("carregando-grade");
      window.opener.location.href = window.opener.location.href;
      window.close();
    }
  })

}
