/**
 * Começa a piscar $ minutos antes do horário da próxima dispensação
 * vide zf/configuracao
 */
var _alertaEm;
var _timerRefresh;

$(function () {

    atualizarDiferencas();
    setInterval('atualizarDiferencas()', 1000);
    setInterval('alertas()', 1000);
    setTimeout('verificaERecarrega()', 360000); // 5 min

    $(".leito").click(function () {

        //session.initialize();
        var id = $(this).data("id");
        writeCookie('idGrade', id, 3);
        atribuiId(id);
    });

    $('.data-hora-mask').live('focus', function () {
        $(".data-hora-mask").mask('99/99/9999 99:99');
    });


});

function writeCookie(name, value, days) {
    var date, expires;
    if (days) {
        date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = "; expires=" + date.toGMTString();
    } else {
        expires = "";
    }
    document.cookie = name + "=" + value + expires + "; path=/";
}

function readCookie(name) {
    var i, c, ca, nameEQ = name + "=";
    ca = document.cookie.split(';');
    for (i = 0; i < ca.length; i++) {
        c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1, c.length);
        }
        if (c.indexOf(nameEQ) == 0) {
            return c.substring(nameEQ.length, c.length);
        }
    }
    return '';
}

function atribuiId(id2) {
    var idGrade = readCookie('idGrade');

    jQuery('#valida-dialog').dialog('close');

    var url = baseUrl + '/leito/medicamentos/listar-produtos/lgra/' + idGrade;

    $("body").append("<div id=\"leito-dialog\" title=\"Produtos a serem ministrados\" />");

    $("#leito-dialog")
        .html(imgCarregando())
        .load(url, onLoadMedicamentos)
        .dialog({
            modal: true,
            width: 542,
            height: 450,
            close: function () {
                $(this).remove();
            },
            buttons: [
                {
                    id: "btn_acao",
                    text: "carregando",
                    click: function () {
                        verificaLogin();
                    }
                },
                {
                    id: "btn_historico",
                    text: "Histórico",
                    click: function () {
                        mostrarHistorico(idGrade);

                    }
                },
                {
                    id: "btn_devolver",
                    text: "Devolver",
                    click: function () {
                        confirme("Confirme", "Deseja realmente devolver estes itens para o estoque?", 330, 150, function () {
                            devolver(idGrade);
                        });
                    }
                },
                {
                    id: "btn_cancelar",
                    text: "Cancelar",
                    click: function () {
                        $(this).dialog('close');
                    }
                }
            ]
        });
    //return false;
    $("#btn_acao,#btn_devolver")
        .attr("disabled", "disabled")
        .addClass("ui-state-disabled");
    // especial button!
    $("#btn_historico").prependTo(".ui-dialog-buttonpane");
    writeCookie('idGrade', '', 3);
}
function mostrarHistorico(lgra_codigo) {
    carregandoAba(1);
    $("body").append("<div id=\"historico-dialog\" title=\"Histórico de Dispensação\" />");
    $("#historico-dialog")
        .load(baseUrl + '/leito/medicamentos/historico/lgra/' + lgra_codigo + "/usu/1", function () {
            carregandoAba(0);
            bindHistorico();
        })
        .dialog({
            modal: true,
            width: 600,
            height: 330,
            close: function () {
                $(this).remove();
            },
            buttons: {
                Ok: function () {
                    $(this).dialog('close');
                }
            }
        });
}

function bindHistorico() {
    $("#historico .mais").click(function () {
        $(this).parents("tr").next("tr").show();
    });
}

function onLoadMedicamentos() {
    //return false
    habilitarBotoes();
    if ($("#status").val() != 1) { // pare por aqui: a grade não está mais ativa
        mensagem("Atenção!", "Esta grade não está mais ativa!<br /><br />Clique em OK para recarregar a tela.", 330, 170, reload)
    }

    var tipo = $("#tipo").val();
    //alert(tipo);
    var url = baseUrl + "/" + (tipo == 1 ? "leito/medicamentos/dispensar-da-reserva" : "produto/reservar");

    var lgra = $("#lgra_codigo").val();

    $("#num").val($("#lgra_" + lgra).data("vezes"));


}

function afterSubmit(json) {
    carregandoAba(1);
    if (json.error) {
        mensagem("Erro!", json.mensagem, 300, 150, function () {
            reload(json);
        });
    } else{
        if( $("#tipo").val() == 1){
            mensagem("Atenção!", "Itens dispensados com sucesso.", 300, 150, function () {
                reload(json);
            });
        }else {
            mensagem("Atenção!", "Itens reservados com sucesso.", 300, 150, function () {
                reload(json);
            });
        }

    }
}

function reload(json) {
    window.location.replace(baseUrl + "/leito/medicamentos/index/");
}

function verificaERecarrega() {
    var modaisAbertos = $(".ui-dialog").size();
    if (modaisAbertos > 0) {
        if (typeof(_timerRefresh) == "undefined")
            _timerRefresh = setInterval('verificaERecarrega()', 1000);

    } else {
        if (typeof(_timerRefresh) != "undefined")
            clearInterval(_timerRefresh);

        reload();
    }


}

function habilitarBotoes() {
    var tipo = $("#tipo").val();
    $("#btn_acao").removeAttr("disabled").removeClass("ui-state-disabled").find("span").html(tipo == 1 ? "Dispensar" : "Reservar");
    if (tipo == 1) { // botão devolver
        $("#btn_devolver").removeAttr("disabled").removeClass("ui-state-disabled");
    } else {
        $("#btn_devolver").remove();
    }
}

function devolver(id) {
    carregandoAba(1);
    $.ajax({
        url: baseUrl + '/produto/retirar-reserva/',
        type: 'post',
        data: {
            tipo: "lgra_codigo",
            codigo: id
        },
        success: function (txt) {
            carregandoAba(0);
            mensagem("Sucesso", "Itens devolvidos com sucesso", 330, 150);
            $(this).dialog('close');
            afterSubmit(txt);
        }
    });
}

function atualizarDiferencas() {
    //alert("localization");
    _alertaEm = $("#alertaEm").val();

    $(".leito").each(function () {

        var horario = $(this).data("proximo");

        if (horario == "") {
            $(this)
                .find("span:last")
                .html("Nenhuma dispensação realizada ainda")
        } else {
            var atraso = compararDataHora(horario) == 2;
            var dif = diferencaEntreHoras(horario);
            var lgra = $(this).attr("id");

            $(this)
                .find("span:last")
                .html(segundosToHora(dif))
                .end()
                .find("span:first")
                .html((atraso ? "Atraso" : "Faltam") + ":");

            if (atraso) {
                $(this).addClass("ui-state-error").addClass("high");
                $(this).effect("highlight", {}, 1000);

            } else if (dif < _alertaEm * 60) {
                $(this).addClass("high").effect("highlight", {}, 1000);
            }

        }

    });
}

function alertas() {
    $(".high").effect("highlight", {}, 1000);
}

function verificaLogin(){
    $("body").append("<div id=\"login-dialog\" title=\"Autenticação\" />");
    $("#login-dialog")
        .load(baseUrl + '/leito/medicamentos/login')
        .dialog({
            modal: true,
            width: 350,
            height:460,
            resizable: false,
            close: function () {
                $(this).remove();
            },
            buttons: {
                "Cancelar": function () {
                    $(this).dialog('close');
                },
                "Autenticar": function () {
                    validaUsuarioDispensacao();

                }

            }
        });
}

function validaUsuarioDispensacao(){
var login = $('#login').val();
var senha = $('#senha').val();


$.ajax({
   url: baseUrl + "/usuarios/usuarios/verifica-login/login/"+login+"/senha/"+senha,
   success: function (txt) {
    if(txt.success){
        $('#usr_codigo').val(login);
        salvarDispensacao();
        $(this).dialog('close');
    }else{
        mensagem("Erro", "Login ou Senha incorretos!", 300,150);
    }

   }


});

}

function salvarDispensacao() {

   var tipo = $("#tipo").val();
   var form = $('#form-grade').serializeArray();


   if(tipo == 1){
       $("body").append("<div id=\"data-dialog\" title=\"Dados Dispensação\">"
           +
           "<label class='ui-state-default'>Data e hora da Dispensação: <span class='obrigatorio'>*</span></label>"
           +
           "<input type='text' class='data-hora-mask ui-state-default' id='hora' name='hora' style='width: 100px'>"
           + "<br/><br/>"
           + "<span class='obrigatorio' style='font-size: 10px'> * em branco para data e hora atuais.</span>"

           +"</div>");
       $("#data-dialog")
           .dialog({
               modal: true,
               width: 250,
               height:180,
               resizable: false,
               close: function () {
                   $(this).remove();
               },
               buttons: {
                   "Cancelar": function () {
                       $(this).dialog('close');
                   },
                   "Dispensar": function () {
                    $('#data_hora').val($('#hora').val());
                       form = $('#form-grade').serializeArray();
                        $.ajax({
                            url: baseUrl + "/leito/medicamentos/dispensar-da-reserva",
                            type:"POST",
                            data: form,
                            success: function (txt) {
                              afterSubmit(txt);
                            }
                        });

                   }

               }
           });
   }else{
        $.ajax({
            url: baseUrl + "/produto/reservar",
            type:"POST",
            data: form,
            success: function (txt) {
                   afterSubmit(txt);
                    $(this).dialog('close');
            }
       });
   }

}