var urlLogin = "../WebSocialComum/login/Login.php";
$(function () {
    $.get("./VERSAO", function(data){
        $("#versao").text("Versão: " + data);
    });
    // Executando o Flyway
    $.ajax({
        url: "../WebSocialComum/WebSocialUpdate/flyway/Flyway.php",
        async: true,
        dataType: 'json',
        success: function(ret){
            if(ret != null){
                if(!ret.status){
                    $("#versao_flyway").text(ret.message).css("color", "red");
                    if(ret.error != null && ret.error !=""){
                        console.error(ret.error);
                    } else {
                        console.error("Verifique o log de erros em WebSocialComum/WebSocialUpdate/flyway/logs");
                    }
                }
            } else {
                $("#versao_flyway").text("Erro na atualização do banco de dados.").css("color", "red");
                console.error("Verifique o log de erros em WebSocialComum/WebSocialUpdate/flyway/logs");
            }
        }
    });
    $(document).bind('keypress', function(e){
        if(e.keyCode ==13){
            login();
        }
    });
    $.ajax({
        url: 'cnes_server.php', //url para acessar o arquivo
        dataType: 'json', //TIPO DO RETORNO JSON/TEXTO
        success: function (data) {//DATA É O VALOR RETORNADO
            if(data.mensagem != ""){
                mensagem("CNES", data.mensagem, 350, 'auto');
            }
        }
    });


});

function login() {
    if(validaForm()){
        $.ajax({
            url: urlLogin,
            type: 'POST',
            data:{
                "usuario": $("#user").val(),
                "senha": $("#pass").val(),
                "acao": "logar",
                "sistema": "SAUDE"
            },
            dataType: 'json',
            success: function(ret){
                if(ret.status){
                    if(ret.dados.trocasenha == "S"){
                        abrirModalTrocaSenha(ret.dados.usr_codigo);
                    }else{
                        abreDialogDados(ret.dados);
                    }
                }else{
                    if(ret.statusUsuario)
                        valida("div-user", ret.mensagem);
                    if(ret.statusSenha)
                        valida("div-pass", ret.mensagem);
                }
            }
        });
    }
}

function visualizarSenha(id) {
    $("#" + id).prop("type", "text");
    $("#btn-" + id).find('svg').attr('data-icon', "eye");
    setTimeout(function () {
        $("#" + id).prop("type", "password");
        $("#btn-" + id).find('svg').attr('data-icon', "eye-slash");
    }, 2000);
}

function abrirModalTrocaSenha(usr_codigo) {
    $("<div id='dlg-troca-senha' title='Alterar Senha'></div>").dialog({
        autoOpen: true,
        width: 350,
        height: 'auto',
        resizable: false,
        buttons: [
            {
                text: "Cancelar",
                "class": "btn",
                click: function(){
                    $(this).dialog('destroy');
                }
            },
            {
                text: "Salvar",
                "class": "btn btn btn-acessar",
                click: function(){
                    var confirmPass = $("#confirmpass").val();
                    var newPass = $("#newpass").val();
                    var copyPass = $("#copypass").val();
                    $.ajax({
                        url: urlLogin,
                        type: 'POST',
                        data:{"usuario": usr_codigo,"senha": confirmPass,"acao": "confirma"},
                        dataType: 'json',
                        async: true,
                        success: function(ret){
                            if(ret.status){
                                if(validaSenha(newPass, copyPass)){
                                    atualizaSenha({"usuario": usr_codigo,"senha": newPass,"acao": "atualiza"});
                                }
                            }else{
                                valida('div-confirmpass', '* Senha não confere');
                            }
                        }
                    });
                }
            }
        ]
    }).load("./zf/public/js/login/redefinir.html");
}

function abreDialogDados(dados) {
    var indexUrl = window.location.href + "/../index.php";
    $("#dlg-dados").remove();
    $("<div id='dlg-dados' title='Informe os Dados Iniciais'></div>")
        .dialog({
            width: 400,
            height: 'auto',
            resizable: false,
            buttons: [
                {
                    text: 'Cancelar',
                    'class': 'btn',
                    click: function(){
                        $("#dlg-dados").dialog('destroy');
                    }
                },
                {
                    id: "btn-acessar",
                    text: 'Acessar',
                    'class': 'btn btn-acessar',
                    click: function(){
                        var uni_codigo = $("#unidade option:selected").val();
                        var esp_codigo = $("#especialidade option:selected").val();
                        var set_codigo = $("#setor option:selected").val();
                        if(validaCombos(uni_codigo, esp_codigo, set_codigo))
                            $.ajax({
                                url: urlLogin,
                                type: 'POST',
                                data: {
                                    usr_codigo: dados.usr_codigo,
                                    uni_codigo: (uni_codigo > -1 ? uni_codigo : "") ,
                                    esp_codigo: (esp_codigo > -1 ? esp_codigo : ""),
                                    set_codigo: (set_codigo > -1 ? set_codigo : ""),
                                    acao: 'logon'
                                },
                                success: function(ret){
                                    $("#dlg-dados").dialog('destroy');
                                    window.location.href = indexUrl + "?id_login=" + dados.usr_codigo+"&link=";
                                }
                            });
                    }
                }
            ],
        }).load("./zf/public/js/login/dados-iniciais.html", carregaDados);
    function carregaDados(){
        $("#usr_codigo").val(dados.usr_codigo);
        $("#btn-acessar").focus();
        if(dados.unidades.length > 0){
            $("#unidade").attr("disabled", false);
            $.each(dados.unidades, function(index, item){
                var select = "";
                if(dados.logon){
                    select = (dados.logon.uni_codigo == item.uni_codigo ? "selected" : "");
                }
                $("#unidade").append("<option value='" + item.uni_codigo + "' " + select + ">" + item.uni_desc.toUpperCase() + "</option>");
            });
        }else{
            $("#unidade").attr("disabled", true);
        }

        if(dados.especialidades.length > 0){
            $("#especialidade").attr("disabled", false);
            $.each(dados.especialidades, function(index, item){
                var select = "";
                if(dados.logon){
                    select = (dados.logon.esp_codigo == item.esp_codigo ? "selected" : "");
                }
                $("#especialidade").append("<option value='" + item.esp_codigo + "' " + select + ">" + item.esp_nome.toUpperCase() + "</option>");
            });
        }else{
            $("#especialidade").attr("disabled", true);
        }

        if(dados.setores.length > 0){
            $("#setor").attr("disabled", false);
            $.each(dados.setores, function(index, item){
                var select = "";
                if(dados.logon){
                    select = (dados.logon.cod_setor == item.set_codigo ? "selected" : "");
                }
                $("#setor").append("<option value='" + item.set_codigo + "' " + select + ">" + item.set_nome.toUpperCase() + "</option>");
            });
        }else{
            $("#setor").attr("disabled", true);
        }
        $("#dlg-dados").dialog('open');
    }
}

function atualizaSenha(data){
    $.ajax({
        url: urlLogin,
        type: 'POST',
        data: data,
        dataType: 'json',
        success: function(ret){
            if(ret.status){
                mensagem("Confirmação", "Senha alterada com sucesso", 350, 150, function(){
                    $("#dlg-troca-senha").dialog('destroy');
                });
            }
        }
    });
}

function validaSenha(ns, cs){
    if(!ns && !cs){
        valida("div-newpass");
        valida("div-copypass");
        return false;
    }

    if(!ns){
        valida("div-newpass");
        return false;
    }

    if(!cs){
        valida("div-copypass");
        return false;
    }

    if(ns.length < 8){
        valida("div-newpass", "* Nova senha deve conter no mínimo 8 digitos");
        return false;
    }

    if(ns !== cs){
        valida("div-newpass", "* Senha não confere");
        valida("div-copypass", "* Senha não confere");
        return false;
    }

    return true;
}

function validaCombos(uni_codigo, esp_codigo, set_codigo) {
    var ret = true;
    if(uni_codigo == -1){
        valida("div-unidade");
        ret = false;
    }
    if(esp_codigo == -1 && !$("#especialidade").is(":disabled")){
        valida("div-especialidade");
        ret = false;
    }
    if(set_codigo == -1 && !$("#setor").is(":disabled")){
        valida("div-setor");
        ret = false;
    }
    return ret;
}

function carregaCombosEspecialidadeSetor(){
    var uni_codigo = $("#unidade option:selected").val();
    var usr_codigo = $("#usr_codigo").val();
    if(uni_codigo && usr_codigo){
        $.ajax({
            url: urlLogin,
            type: "POST",
            dataType: "json",
            data: {
                uni_codigo: uni_codigo,
                usr_codigo: usr_codigo,
                acao: "carregarCombos"
            },
            success: function(ret){
                $("#especialidade").empty().html("<option value='-1'>Selecione a Especialidade</option>");
                $("#setor").empty().html("<option value='-1'>Selecione o Setor / Centro de Estoque</option>");

                if(ret.dados.especialidades.length > 0){
                    $("#especialidade").attr("disabled", false);
                    $.each(ret.dados.especialidades, function(index, item){
                        $("#especialidade").append("<option value='" + item.esp_codigo + "'>" + item.esp_nome.toUpperCase() + "</option>");
                    });
                }else{
                    $("#especialidade").attr("disabled", true);
                }


                if(ret.dados.setores.length > 0){
                    $("#setor").attr("disabled", false);
                    $.each(ret.dados.setores, function(index, item){
                        $("#setor").append("<option value='" + item.set_codigo + "'>" + item.set_nome.toUpperCase() + "</option>");
                    });
                }else{
                    $("#setor").attr("disabled", true);
                }
            }
        });
    }
}

function validaForm(){
    var ret = true;
    var usuario = $("#user").val();
    var senha = $("#pass").val();
    if(!usuario){
        ret = false;
        valida("div-user");
    }

    if(!senha){
        ret =  false;
        valida("div-pass");
    }
    return ret;
}

function valida(id, msg){
    var campo = $("#" + id);
    var msg = (msg ? msg : "* Campo obrigatório");
    campo.addClass("has-error");
    $("#msg").remove();
    campo.after("<small id='msg' class='text-danger'>" + msg + "</small>");
    setTimeout(function () {
        campo.removeClass("has-error");
        $("#msg").remove();
    }, 2500);
}


