function voltarMateriais(codigoUsuario) {
  window.location = "/WebSocialSaude/index.php?link=materiais.php&id_login=" + codigoUsuario;
}

function carregarInventario(codigoUsuario, codigoInventario = '', carregarPelaTable = false) {
  if (carregarPelaTable) {
      montaLocalStorage(
        codigoInventario,
        $('#data-abertura-' + codigoInventario).val(),
        $('#grupo-' + codigoInventario).val(),
        $('#setor-' + codigoInventario).val(),
        $('#responsavel-' + codigoInventario).val(),
        $('#equipe-' + codigoInventario).val(),
        codigoUsuario
      );

      return;
    }

  if (validaForm()) {
    $.ajax({
    url: baseUrl + "/materiais/inventario/check-inventario/",
    type: "POST",
    data: {
      data: $('#data').val(),
      grupo: $('#grupo :selected').val(),
      setor: $('#setor :selected').val()
    },
    success: function(resp) {
      if(resp.codigoInventario !== null) {
        Swal({
          title: 'Já existe um inventário aberto com estes dados!',
          text: 'Deseja edita-lo?',
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Sim',
          cancelButtonText: 'Não'
        }).then((result) => {
          if (result.value) {
            montaLocalStorage(
              resp.codigoInventario,
              $('#data').val(),
              $('#grupo :selected').val(),
              $('#setor :selected').val(),
              $('#responsavel').val(),
              $('#equipe').val(),
              codigoUsuario
            );
          }
        });
      }
      else {
        montaLocalStorage(
          resp.codigoInventario,
          $('#data').val(),
          $('#grupo :selected').val(),
          $('#setor :selected').val(),
          $('#responsavel').val(),
          $('#equipe').val(),
          codigoUsuario
        );
      }
    }
  });
  }
}

function validaForm() {
  if ($('#data').val() == '') {
    Swal({
      width: '400px',
      heightAuto: true,
      title: 'Por favor, informe a data!',
      type: 'info'
    }).then((result) => {
      $('#data').focus();
    });
    return false;
  }
  else if ($('#data').val() < moment().format('DD/MM/YYYY')) {
    Swal({
      width: '450px',
      heightAuto: true,
      title: 'A data não pode ser menor que a data atual!',
      type: 'info'
    }).then((result) => {
      $('#data').focus();
    });
    return false;
  }
  else if ($('#data').val() > moment().format('DD/MM/YYYY')) {
    Swal({
      width: '450px',
      heightAuto: true,
      title: 'A data não pode ser maior que a data atual!',
      type: 'info'
    }).then((result) => {
      $('#data').focus();
    });
    return false;
  }
  else if ($('#responsavel').val() == '') {
    Swal({
      width: '350px',
      heightAuto: true,
      title: 'Por favor, informe o responsável!',
      type: 'info'
    }).then((result) => {
      $('#responsavel').focus();
    });
    return false;
  }
  else if (!$('#responsavel').val().match(/^[a-zA-ZéúíóáÉÚÍÓÁèùìòàçÇÈÙÌÒÀõãñÕÃÑêûîôâÊÛÎÔÂëÿüïöäËYÜÏÖÄ\-\ \s]+$/)) {
    Swal({
      width: '370px',
      heightAuto: true,
      title: 'Existem caracteres inválidos no responsável!',
      type: 'info'
    }).then((result) => {
      $('#responsavel').focus();
    });
    return false;
  }
  else if (!$('#responsavel').val().match(/[a-z]\s[a-z]/gim)) {
    Swal({
      width: '350px',
      heightAuto: true,
      title: 'Informe o nome e sobrenome do responsável!',
      type: 'info'
    }).then((result) => {
      $('#responsavel').focus();
    });
    return false;
  }

  return true;
}

function montaLocalStorage(codigoInventario, data, grupo, setor, responsavel, equipe, codigoUsuario) {
  localStorage.setItem('inventario', JSON.stringify({
    'invCodigo': codigoInventario,
    'data': data,
    'grupo': grupo,
    'setor': setor,
    'responsavel': responsavel,
    'equipe': equipe,
    'codigoUsuario': codigoUsuario
  }));
  window.location = baseUrl + "/materiais/inventario/inventario-dados";
}

function cancelarInventario(codigoInventario) {
  Swal({
    title: 'Deseja cancelar o inventário?',
    type: 'question',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Sim',
    cancelButtonText: 'Não'
  }).then((result) => {
    if (result.value) {
      $.ajax({
        url: '/WebSocialSaude/rest/saude/movimento/inventario/cancelar/' + codigoInventario,
        type: 'DELETE',
        success: function (resp) {
          if (resp.response.mensagem != 'OK') {
            Swal({
              title: resp.response.mensagem,
              type: 'error'
            });
          }
          else {
            Swal({
              title: resp.response.dados,
              type: 'success',
              confirmButtonColor: '#a5dc86'
            }).then((result) => {
              window.location.reload();
            });
          }
        }
      });
    }
  });
}

function imprimirInventario(codigoInventario){
    callGenerateReport(
        baseUrl + "/materiais/inventario/imprimir-inventario",
        {
            "codigoInventario": codigoInventario,
        }
    );
}

function voltarInventario(){
    window.location.replace(baseUrl+"/materiais/inventario")
}

