var baseUrl = '/WebSocialSaude/zf';

$(document).on("input", ".numeric", function() {
  this.value = this.value.replace(/\D/g,'');
});

$(function() {
  ligaLoading();

  inventario = JSON.parse(localStorage.getItem('inventario'));
  if (inventario.invCodigo == null) {
    // Cria um novo inventário caso não existe nenhum
    $.ajax({
      url: "/WebSocialSaude/rest/saude/movimento/inventario/abrir",
      type: "POST",
      data: {
        data: moment(inventario.data, "DD/MM/YYYY").format("YYYY-MM-DD"),
        set_codigo: inventario.setor,
        gru_codigo: inventario.grupo,
        responsavel: inventario.responsavel,
        equipe: inventario.equipe,
        usr_codigo: inventario.codigoUsuario,
      },
      success: function (resp) {
        localStorage.setItem('inventario', JSON.stringify({
          'invCodigo': resp.response.dados.id
        }));
        carregarInventario(resp.response.dados);
      }
    });
  }
  else {
    // Carrega o inventário caso ele exista
    $.ajax({
      url: "/WebSocialSaude/rest/saude/movimento/inventario/" + inventario.invCodigo,
      type: "GET",
      success: function (resp) {
        carregarInventario(resp.response.dados);
      }
    });
  }
});

function carregarInventario(data) {
  $('#cod_inventario').val(data.id);
  $('#cod_usuario').val(data.usuario.id);
  $('#lblCodInv').append("<b>Cód. Inventário: </b>" + data.id);
  $('#lblGrupo').append("<b>Grupo de Produto: </b>" + data.grupo.gruNome);
  $('#lblSetor').append("<b>Setor: </b>" + data.setor.setNome);
  $('#lblData').append("<b>Data: </b>" + moment(data.data, "YYYY-MM-DD").format("DD/MM/YYYY"));
  carregaProdutos(data);
}

function carregaProdutos(informacoes) {
  var arrayProdutos = [];
  var arrayProdutosLotes = [];

  $.ajax({
    url: "/WebSocialSaude/rest/saude/movimento/inventario/carrega-produtos/" + informacoes.id + "/" + informacoes.usuario.id,
    type: "GET",
    async: false,
    success: function (resp) {
      $.each(resp.response.dados, function(key, item) {
        arrayProdutos.push(
          {
            'id': item.id,
            'quantidade': item.quantidade,
            'lote': item.lote,
            'validade': item.validade,
            'produto': {
              'id': item.produto.id,
              'proNome': item.produto.proNome,
            },
            'usuario': {
              'id': item.usuario.id,
            },
          }
        );

        $.ajax({
          url: "/WebSocialSaude/rest/saude/movimento/inventario/lote/" + item.id,
          type: "GET",
          async: false,
          success: function (respLote) {
            if (respLote.response.dados) {
              $.each(respLote.response.dados, function(key, lote) {
                arrayProdutosLotes.push(
                  {
                    'id': lote.id,
                    'quantidadeSaldo': lote.quantidadeSaldo,
                    'lote': lote.lote,
                    'validade': lote.validade,
                    'produto': {
                      'id': lote.inventarioProduto.id,
                    },
                  }
                );
              });
            }
          }
        });
      });

      $("#tbProdutos").html(
          "<thead>"
        + "  <th width='300px'>Produto</th>"
        + "  <th style='text-align: center;'>Saldo Inicial</th>"
        + "  <th width='180px' style='text-align: center;'>Saldo Atual</th>"
        + "  <th style='text-align: center;'>Fração</th>"
        + "  <th style='text-align: center;'>Lote</th>"
        + "  <th style='text-align: center;'>Validade</th>"
        + "  <th width='80px' style='text-align: center;'></th>"
        + "</thead>"
        + "</tbody>"
        +   carregaHtmlProdutos(arrayProdutos, arrayProdutosLotes)
        + "</tbody>");
      inputNumber();
    }
  });

  ligaLoading(false);
}

function carregaHtmlProdutos(arrayProdutos, arrayProdutosLotes) {
  var html = "";

  $.each(arrayProdutos, function(key, item) {
    html += "<tr id='tr_lote_" + key + "' class='tb-produto-itens'>"
         +  "  <td style='display: none'>"
         +  "    <input type='hidden' id='pro_codigo_" + key + "' value='" + item.produto.id + "'>"
         +  "  </td>"
         +  "  <td style='display: none'>"
         +  "    <input type='hidden' id='pro_temp_codigo_" + key + "' value='" + item.id + "'>"
         +  "  </td>"
         +  "  <td style='display: none'>"
         +  "    <input type='hidden' id='usu_codigo_" + key + "' value='" + item.usuario.id + "'>"
         +  "  </td>"
         +  "  <td class='nome'>" + item.produto.proNome + "</td>"
         +  "  <td class='saldo center'>" + item.quantidade + "</td>"
         +  "  <td class='saldo-atual center'>"
         +  "    <input id='saldo_" + key + "' onchange='salvarInventario(" + key + ");' class='number-style numeric' type='number' name='saldo[" + key + "]' step='1' min='0' max='99999'>"
         +  "  </td>"
         +  "  <td class='fracao center'></td>"
         +  "  <td class='lote center'>" + item.lote + "</td>"
         +  "  <td class='validade center'>" + moment(item.validade, "YYYY-MM-DD").format("DD/MM/YYYY") + "</td>"
         +  "  <td class='adiciona-lote center'>"
         +  "    <div class='number-style'>"
         +  "      <span class='number-plus' title='Adicionar Lote' onclick='addLote(" + key + ")'></span>"
         +  "    </div>"
         +  "  </td>"
         +  "</tr>";

    if (arrayProdutosLotes) {
      $.each(arrayProdutosLotes, function(key, lote) {
        if (item.id == lote.produto.id) {
          html += "<tr id='sub_tr_" + lote.id + "' class='sub_tr'>"
               +  "  <td colspan='2'></td>"
               +  "  <td style='text-align: center; width: 15%'>"
               +  "    <input id='sub_saldo_" + lote.id + "' class='number-style numeric saldo-lote' value='" + (lote.quantidadeSaldo != null ? lote.quantidadeSaldo : '') + "' onchange='salvarLote(" + lote.id + ");' type='number' step='1' min='0' max='99999'>"
               +  "  </td>"
               +  "  <td class='cell'>"
               +  "   <input id='sub_fracao_" + lote.id + "' class='input-cell numeric input-lote' onchange='salvarLote(" + lote.id + ");'>"
               +  "  </td>"
               +  "  <td class='cell'>"
               +  "    <input id='sub_lote_" + lote.id + "' class='input-cell input-lote' value='" + (lote.lote != null ? lote.lote : '') + "' maxlength='10' onchange='salvarLote(" + lote.id + ");'>"
               +  "  </td>"
               +  "  <td class='cell'>"
               +  "    <input id='sub_validade_" + lote.id + "' class='input-cell date input-lote' value='" + (lote.validade != null ? moment(lote.validade, "YYYY-MM-DD").format("YYYY-MM-DD") : '') + "' type='date' onchange='salvarLote(" + lote.id + ");'>"
               +  "  </td>"
               +  "  <td style='text-align: center; width=10%'>"
               +  "    <div class='number-style'>"
               +  "      <span class='number-minus' title='Remover Lote' onclick='removeLote(" + lote.id + ")'></span>"
               +  "    </div>"
               +  "  </td>"
               +  "</tr>";
        }
      });
    }
  });

  return html;
}

function addLote(key) {
  if (verificaCamposVazios(key)) {
    $.ajax({
      url: "/WebSocialSaude/rest/saude/movimento/inventario/lote/abrir",
      type: "POST",
      data: {
        inventario_produto: $('#pro_temp_codigo_' + key).val()
      },
      success: function (resp) {
        if (resp.response.mensagem != 'OK') {
          alert(resp.response.mensagem);
        } else {
          var id = resp.response.dados;
          $("<tr id='sub_tr_" + id + "' class='sub_tr'>"
            + "  <td colspan='2'></td>"
            + "  <td style='text-align: center; width: 15%'>"
            + "    <input id='sub_saldo_" + id + "' class='number-style numeric saldo-lote' onchange='salvarLote(" + id + ");' type='number' step='1' min='0' max='99999'>"
            + "  </td>"
            + "  <td class='cell'>"
            + "   <input id='sub_fracao_" + id + "' class='input-cell numeric input-lote' onchange='salvarLote(" + id + ");'>"
            + "  </td>"
            + "  <td class='cell'>"
            + "    <input id='sub_lote_" + id + "' class='input-cell input-lote' maxlength='10' onchange='salvarLote(" + id + ");'>"
            + "  </td>"
            + "  <td class='cell'>"
            + "    <input id='sub_validade_" + id + "' class='input-cell date input-lote' type='date' onchange='salvarLote(" + id + ");'>"
            + "  </td>"
            + "  <td style='text-align: center; width: 10%'>"
            + "    <div class='number-style'>"
            + "      <span class='number-minus' title='Remover Lote' onclick='removeLote(" + id + ")'></span>"
            + "    </div>"
            + "  </td>"
            + "</tr>")
          .insertAfter("#tr_lote_" + key);
          $('#sub_saldo_' + id).number();
        }
      }
    });
  }
  else{
    mensagem("Atenção", "É necessário preencher os campos para adicionar um novo lote!");
  }
}

function removeLote(id) {
  $.ajax({
    url: "/WebSocialSaude/rest/saude/movimento/inventario/lote/remover/" + id,
    type: "DELETE",
    success: function (resp) {
      if (resp.response.mensagem != 'OK') {
        alert(resp.response.mensagem);
      } else {
        $("#sub_tr_"+ id).remove();
      }
    }
  });
}

function salvarInventario(key) {
  $.ajax({
    url: "/WebSocialSaude/rest/saude/movimento/inventario/alterar",
    type: "POST",
    data: {
      id: $('#pro_temp_codigo_' + key).val(),
      usuario: $('#usu_codigo_' + key).val(),
      quantidade: $('#saldo_' + key).val()
    },
    success: function (resp) {
      if (resp.response.mensagem != 'OK') {
        alert(resp.response.mensagem);
      }
    }
  });
}

function salvarLote(id) {
  $.ajax({
    url: "/WebSocialSaude/rest/saude/movimento/inventario/lote/alterar",
    type: "POST",
    data: {
      id: id,
      lote: ($('#sub_lote_' + id).val() != '' ? $('#sub_lote_' + id).val() : null),
      validade: ($('#sub_validade_' + id).val() != '' ? $('#sub_validade_' + id).val() : null),
      quantidade: ($('#sub_saldo_' + id).val() != '' ? $('#sub_saldo_' + id).val() : 0),
      quantidade_saldo: ($('#sub_saldo_' + id).val() != '' ? $('#sub_saldo_' + id).val() : 0),
      dose_lote: ($('#sub_fracao_' + id).val() != '' ? $('#sub_fracao_' + id).val() : 0),
      dose_atual: ($('#sub_fracao_' + id).val() != '' ? $('#sub_fracao_' + id).val() : 0),
      tipo: 'temporario'
    },
    success: function (resp) {
      if (resp.response.mensagem != 'OK') {
        alert(resp.response.mensagem);
      }
    }
  });
}

function finalizarInventario() {
  Swal({
    width: '400px',
    heightAuto: false,
    title: 'Deseja finalizar o inventário?',
    type: 'question',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Sim',
    cancelButtonText: 'Não'
  }).then((result) => {
    if (result.value) {
      ligaLoading();

      $.ajax({
        url: "/WebSocialSaude/rest/saude/movimento/inventario/processar/" + $('#cod_inventario').val(),
        type: "POST",
        success: function (resp) {
          ligaLoading(false);

          if (resp.response.mensagem != 'OK') {
            Swal({
              title: resp.response.mensagem,
              type: 'error'
            });
          } else {
            Swal({
              title: resp.response.dados.inventario_msg,
              type: 'success',
              confirmButtonColor: '#a5dc86'
            }).then((result) => {
              window.location = baseUrl + '/materiais/inventario/index';
            });
          }
        }
      });
    }
  });
}

function cancelarInventario() {
  Swal({
    width: '400px',
    heightAuto: false,
    title: 'Deseja cancelar o inventário?',
    type: 'question',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Sim',
    cancelButtonText: 'Não'
  }).then((result) => {
    if (result.value) {
      ligaLoading();

      $.ajax({
        url: '/WebSocialSaude/rest/saude/movimento/inventario/cancelar/' + $('#cod_inventario').val(),
        type: 'DELETE',
        success: function (resp) {
          ligaLoading(false);

          if (resp.response.mensagem != 'OK') {
            Swal({
              title: resp.response.mensagem,
              type: 'error'
            });
          } else {
            Swal({
              title: resp.response.dados,
              type: 'success',
              confirmButtonColor: '#a5dc86'
            }).then((result) => {
              window.location = baseUrl + '/materiais/inventario/index';
            });
          }
        }
      });
    }
  });
}

function verificaCamposVazios(key) {
  var existeVazio = true;
  var next = $("#tr_lote_" + key).next().attr('id');
  if (next !== undefined && next.indexOf("sub_tr_") !== -1) {
    $("#" + next + " input").each(function() {
      if ($(this).val() == "") {
        existeVazio = false;
        return;
      }
    });
  }

  return existeVazio;
}

function inputNumber() {
  $('input[type=number]').each(function () {
    $(this).number();
  });
}

function ligaLoading(ligado = true) {
  if (ligado) {
    $("#load").before('<img id="loader" class="loading" src="' + baseUrl + '/public/images/loading-eclipse.gif"/>');
    $("#tbHeader").addClass('invisible');
    $("#tbProdutos").addClass('invisible');
    $("#botoes-acesso").addClass('invisible');
    return
  }

  $("#tbHeader").addClass('invisible');
  $("#tbHeader").addClass('visible');
  $("#tbProdutos").addClass('invisible');
  $("#tbProdutos").addClass('visible');
  $("#botoes-acesso").addClass('invisible');
  $("#botoes-acesso").addClass('visible');

  $("#loader").remove();
  return;
}

function voltarInventario(){
    Swal({
        width: '400px',
        heightAuto: false,
        title: 'Deseja retornar a tela inicial de inventários?',
        type: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sim',
        cancelButtonText: 'Não'
    }).then((result) => {
        if (result.value) {
   window.location.replace(baseUrl+"/materiais/inventario")
        }


});
}
