$(function(){
    var msg_obrigatorio = "Campo obrigatório";

    $("#form").validate({
        rules: {
            med_nome:{ required: true },
            med_crm:{ required: true },
            uf_codigo_crm:{ required: true },
            med_con_codigo:{ required: true },
            med_email: { email: true }
        },
        messages: {
            med_nome:{ required: msg_obrigatorio, },
            med_crm:{ required: msg_obrigatorio, },
            uf_codigo_crm:{ required: msg_obrigatorio, },
            med_con_codigo:{ required: msg_obrigatorio, },
            med_email:{ required: msg_obrigatorio, email: "Digite um email válido!"}
        }
    });

    $("#sn").change(function(){
        var checked = $(this).is(":checked");
        $("#med_end_numero").val((checked ? "S/N" : ""));
        $("#med_end_numero").attr("disabled", checked);
    });

    $("#med_endereco").buscar({
        url: baseUrl + '/rua/buscar',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + ""
                + "<br/><strong>Bairro:</strong>" + item.data.bai_nome
                + "</a>&nbsp;").appendTo(ul);
        },
        callback: function (event, ui) {
            $("#med_end_cep").val(ui.item.data.rua_cep);
            $("#med_end_bairro").val(ui.item.data.bai_nome);
            $("#med_end_cidade").val(ui.item.data['cid_nome']);
            $("#med_end_uf").val(ui.item.data.uf_sigla);
        }
    });

    $("#med_end_cidade").buscar({
        url: baseUrl + '/cidade/buscar',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>&nbsp;").appendTo(ul);
        },
        callback: function (event, ui) {
            $("#med_end_cidade").val(ui.item.data['cid_nome']);
            $("#med_end_uf").val(ui.item.data.uf_sigla);
        }
    });
});

function salvarMedico(){

    if($("#form").valid()){
        mensagemSemOk("carregando-medico", "Aguarde", "Carregando...", 280, 80);
        $.ajax({
            url: baseUrl + "/medicos/cadastro-medicos/salvar",
            type: "POST",
            data: $("#form").serialize(),
            success: function(ret){
                fecharMensagemSemOk("carregando-medico");
                if(ret.success){
                    mensagem("Confirmação de Cadastro","Médico salvo com sucesso!",300,120, function () {
                        var retorno = {
                            "med_codigo": ret.med_codigo,
                            "med_nome": $("#med_nome").val()
                        };
                        window.opener.postMessage(retorno, "*");
                        window.close();
                    });
                }else{
                    mensagem(ret.titulo, ret.mensagem, 400, 250);
                }
            },
            error: function(error){
                mensagem(error.titulo, error.mensagem, 400, 250);
            }
        })
    }
}