$(function(){
    var msg_obrigatorio = "Campo obrigatório";

    $("#form").validate({
        rules: {
            med_nome:{ required: true },
            med_crm:{ required: true },
            uf_codigo_crm:{ required: true },
            med_con_codigo:{ required: true },
            prestador_servico:{ required: {
                    depends: function(){
                        return ($("#med_tipo_pessoa").val() == "F");
                    }
                } },
            med_espec_f:{
                required: {
                    depends: function(){
                        return ($("#med_tipo_pessoa").val() == "F");
                    }
                }
            },
            med_email: { email: true },
            med_cns: {required: {
                    depends: function () {
                        return ($("#med_tipo_pessoa").val() == "F")
                    }
                }}
        },
        messages: {
            med_nome:{ required: msg_obrigatorio, },
            med_crm:{ required: msg_obrigatorio, },
            uf_codigo_crm:{ required: msg_obrigatorio, },
            med_con_codigo:{ required: msg_obrigatorio, },
            prestador_servico:{ required: msg_obrigatorio, },
            med_espec_f:{ required: msg_obrigatorio, },
            med_email:{ required: msg_obrigatorio, email: "Digite um email válido!"},
            med_cns:{required: msg_obrigatorio, }
        }
    });

    $("#med_tipo_pessoa").change(function(){
        var p_fisica = (this.value === "F");
        $('#div-fisica').attr("hidden", !p_fisica);
        $('#div-juridica').attr("hidden", p_fisica);
        $('#div-prestador').attr("hidden", !p_fisica);
        $("#med_cpf").val("");
        $("#med_cnpj").val("");

    });

    $("#sn").change(function(){
        var checked = $(this).is(":checked");
        $("#med_end_numero").val((checked ? "S/N" : ""));
        $("#med_end_numero").attr("disabled", checked);
    });

    $("#med_endereco").buscar({
        url: baseUrl + '/rua/buscar',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + ""
                + "<br/><strong>Bairro:</strong>" + item.data.bai_nome
                + "</a>&nbsp;").appendTo(ul);
        },
        callback: function (event, ui) {
            $("#med_end_cep").val(ui.item.data.rua_cep);
            $("#med_end_bairro").val(ui.item.data.bai_nome);
            $("#med_end_cidade").val(ui.item.data['cid_nome']);
            $("#med_end_uf").val(ui.item.data.uf_sigla);
        }
    });

    $("#med_end_cidade").buscar({
        url: baseUrl + '/cidade/buscar',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>&nbsp;").appendTo(ul);
        },
        callback: function (event, ui) {
            $("#med_end_cidade").val(ui.item.data['cid_nome']);
            $("#med_end_uf").val(ui.item.data.uf_sigla);
        }
    });

    $("#med_tipo_pessoa").change(function(){
      toggleCnsCnes();
    });

    $("#med_cns").blur(function(){
        let cnsSemMascara = $("#med_cns").val().replace(/\s/g, '');
        if(validaCNS(cnsSemMascara) == "false"){
            mensagem("Atenção", "Numero de CNS inválido", 300, 150);
            $("#med_cns").val("");
        };
    });

    toggleCnsCnes();
});

function salvarMedico(){

  if($("#form").valid()){
      mensagemSemOk("carregando-medico", "Aguarde", "Carregando...", 280, 80);
      $.ajax({
          url: baseUrl + "/medicos/cadastro-medicos/salvar",
          type: "POST",
          data: $("#form").serialize(),
          success: function(ret){
              fecharMensagemSemOk("carregando-medico");
              if(ret.success){
                  mensagem("Confirmação de Cadastro","Médico salvo com sucesso!",300,120, function () {
                      if($("#med_poupup").val() != 1){
                          window.location = baseUrl + "/medicos/cadastro-medicos/lista";
                      }else{
                          var retorno = {
                              "med_codigo": ret.med_codigo,
                              "med_nome": $("#med_nome").val()
                          };
                          window.opener.postMessage(retorno, "*");
                          window.close();
                      }
                  });
              }else{
                  mensagem(ret.titulo, ret.mensagem, 400, 250);
              }
          },
          error: function(error){
              mensagem(error.titulo, error.mensagem, 400, 250);
          }
      })
  }
}

function toggleCnsCnes(){
  if($("#med_tipo_pessoa").val() == "F"){
    $("#div_cns").show();
    $("#div_cnes").hide();
    $("#div_cnes").val("");
  }else{
    $("#div_cns").val("");
    $("#div_cns").hide();
    $("#div_cnes").show();
  }
}
