$(function () {
    $("#uni_desc").buscar({
        url: baseUrl + "/unidade/buscar",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
});


function excluirProcedimento(id) {

    confirme("Atenção.", "Deseja realmente excluir esse procedimento?", 350, 150, function () {
        $.ajax({
            url: baseUrl + "/procedimento-classificacao/procedimento/excluir/id/" + id,
            type: "GET",
            success: function (txt) {
                if (txt.success == true) {
                    alert("Atenção, Procedimento excluído com sucesso! ");
                    window.location.replace( baseUrl + "/procedimento-classificacao/procedimento/index");
                } else {
                    alert("Atenção, " + txt.mensagem);
                    return false;
                }
            }
        });
    });

}


function editarProcedimento(id) {
    window.location.replace(baseUrl + '/procedimento-classificacao/procedimento/form/id/' + id);
}

function salvarProcedimento() {
    var form = $('#form').serialize();
    $.ajax({
        url: baseUrl + "/procedimento-classificacao/procedimento/salvar",
        type: "POST",
        data: form,
        success: function (txt) {
            if (txt.success == true) {
                mensagem("Atenção", "Dados cadastrados com sucesso!", 300, 150, function () {
                    window.location.replace(baseUrl + '/procedimento-classificacao/procedimento/index');
                });
            } else {
                mensagem("Atenção", txt.mensagem, 300, 150, function () {
                    return false;
                });
            }

        }
    });
}

function adicionaVinculo() {
    var unidade = $('#uni_codigo').val();
    var unidade_nome = $('#uni_desc').val();
    var servico = $('#co_servico').val();
    var classificacao = $('#co_classificacao').val();
    var procedimento = $('#proc_codigo').val();

    if (unidade == null || unidade == '') {
        alert("Selecione uma unidade!");
        return false;
    }

    if (servico == null || servico == '') {
        alert("Selecione um serviço!");
        return false;
    }
    if (classificacao == null || classificacao == '') {
        alert("Selecione uma classificação!");
        return false;
    }
    $.ajax({
        url: baseUrl + "/procedimento-classificacao/procedimento/salvar-vinculo",
        type: "POST",
        data: {
            "unidade": unidade,
            "servico": servico,
            "classificacao": classificacao,
            "procedimento": procedimento,
        },
        success: function (txt) {
            if (txt.success == true) {
                $('#table_parametrizacao').append(
                    "<tr id='pcs_cod_" + txt.pcs_codigo + "'>" +
                    "<td class='ui-state-default'>" + unidade_nome + "</td>" +
                    "<td class='ui-state-default c'>" + servico + "</td>" +
                    "<td class='ui-state-default c'>" + classificacao + "</td>" +
                    "<td class='ui-state-default c'><a onclick='excluirVinculo(" + txt.pcs_codigo + ")'><img src='" + baseUrl + "/public/images/icons/excluir.png' alt='Excluir'" +
                    " title='Excluir'/></a></td>" +
                    "</tr>");
                $("#uni_codigo").val("");
                $("#uni_desc").val("");
                $("#pcs_cod_0").remove();
                alert("Parametrização criada com sucesso!");
                return true;
            } else {
                mensagem("Atenção", txt.mensagem, 300, 150, function () {
                    $("#uni_codigo").val("");
                    $("#uni_desc").val("");
                    return false;
                });
            }

        }
    });


}

function excluirVinculo(id) {
    confirme("Atenção", "Deseja realmente excluir esta parametrização?", 350, 150, function () {
        excluir(id)
    });
}

function excluir(id) {
    $.ajax({
        url: baseUrl + "/procedimento-classificacao/procedimento/excluir-vinculo/id/" + id,
        type: "GET",
        success: function (txt) {
            if (txt.success == true) {
                alert("Parametrização excluída com sucesso!");
                $("#pcs_cod_" + id).remove();
                return true;
            }
        }
    });
    return true;
}