$(document).ready(function () {
    checaTipo();

    validaTemasParaReuniao();
    validaPublicoAlvo();
    validaPraticasEmSaude();
    validaTemasParaSaude();

    $('#praticas30').click(function () {
        if ($('#praticas30').prop('checked')) {
            $('#outro_procedimento_coletivo').removeAttr('disabled');
        } else {
            $('#outro_procedimento_coletivo').attr('disabled', true);
            $('#outro_procedimento_coletivo').val('');
        }
    });

    setTimeout(function () {
        //Força a limpa o contador dos profissionais e usuario responsaveis
        if ($("#codFicha").val() == "") {
            $("#profs_part_qtd").val("");
            $("#usus_part_qtd").val("0");
        }

        // Desativa PCNT, pois só pode habilitar quando a opção estiver checkada em Práticas/Temas
        $("#part_fuma").attr("disabled", true);
        $("#part_grupo").attr("disabled", true);
        // Carrega CNES para edição
        var usrCodigo = $("#prof_resp_codigo").val();
        if (usrCodigo) {
            carregaCnes(usrCodigo)
        }
    }, 150);

    $("#form-busca").validate({
        rules: {
            tipo_busca: {required: true},
            busca: {required: true}
        },
        messages: {
            tipo_busca: {required: "(*)Obrigatório"},
            busca: {required: "(*)Obrigatório"}
        }
    });


    $("#ativ-coletiva").validate({
        rules: {
            uni_codigo: {required: true},
            dt_atividade: {required: true},
            hr_inicio: {required: true},
            hr_fim: {required: true},
            prof_resp_codigo: {required: true},
            conf_ativ: {
                required: function () {
                    return !getAtividadeTipo();
                }
            },
            conf_prof: {required: true},
            num_particip: {required: true},
            conf_temas: {
                required: function () {
                    return getAtividadeTipo() < 4;
                }
            },
            conf_temasaude: {
                required: function () {
                    return (getAtividadeTipo() > 3 && getAtividadeTipo() < 6) || (getAtividadeTipo() > 6);
                }
            },
            conf_pub: {
                required: function () {
                    return getAtividadeTipo() > 3;
                }
            },
            conf_prat: {
                required: function () {
                    return getAtividadeTipo() === 6;
                }
            },
            cod_cnes_uni: {required: true},
            data_valida: {required: true},
            num_inep: {required: true}
        },
        messages: {
            uni_codigo: {required: "(*)Obrigatório"},
            dt_atividade: {required: "(*)Obrigatório"},
            hr_inicio: {required: "(*)Obrigatório"},
            hr_fim: {required: "(*)Obrigatório"},
            prof_resp_codigo: {required: "(*)Obrigatório"},
            conf_ativ: {required: "(*)Obrigatório"},
            conf_prof: {required: "(*)Obrigatório"},
            conf_temas: {required: "(*)Obrigatório"},
            conf_temasaude: {required: "(*)Obrigatório"},
            num_particip: {required: "(*)Obrigatório"},
            conf_pub: {required: "(*)Obrigatório"},
            conf_prat: {required: "(*)Obrigatório"},
            cod_cnes_uni: {required: "(*)Obrigatório"},
            data_valida: {required: "Data inválida."},
            num_inep: {required: "(*)Obrigatório"}

        }
    });

});

function verificaProgramaEscola(){
    var educacao = $("#saude-escola-educacao").is(':checked');
    var saude = $("#saude-escola-saude").is(':checked');

    $("#uni_codigo").val("");
    $("#num_inep").val("");
    $("#ds_local").val("");

    if ($("#temasaude18").is(':checked') && !saude) {
      $("#saude-escola-educacao").attr('checked', true);
    }

    if(educacao || saude){
        $("#uni_codigo").attr("disabled", "disabled");
        $("#ds_local").attr("disabled", "disabled");
        $("#num_inep").removeAttr("disabled");

        if (educacao && !saude) {
          $("#atividade1").attr("disabled", "disabled");
          $("#atividade2").attr("disabled", "disabled");
          $("#atividade3").attr("disabled", "disabled");
          $("#atividade5").attr("disabled", "disabled");
          $("#temas1").attr("disabled", "disabled");
          $("#temas2").attr("disabled", "disabled");
          $("#temas3").attr("disabled", "disabled");
          $("#temas4").attr("disabled", "disabled");
          $("#temas5").attr("disabled", "disabled");
          $("#temas6").attr("disabled", "disabled");
          $("#temas7").attr("disabled", "disabled");
          $("#praticas2").attr("disabled", "disabled");
          $("#praticas9").attr("disabled", "disabled");
          $("#praticas25").attr("disabled", "disabled");
          $("#praticas26").attr("disabled", "disabled");
          $("#praticas27").attr("disabled", "disabled");
          $("#praticas28").attr("disabled", "disabled");
          $("#praticas24").attr("disabled", "disabled");
          $("#outro_procedimento_coletivo").attr("disabled", "disabled");

        } else {
          $("#atividade1").removeAttr("disabled");
          $("#atividade2").removeAttr("disabled");
          $("#atividade3").removeAttr("disabled");
          $("#atividade5").removeAttr("disabled");
          $("#temas1").removeAttr("disabled");
          $("#temas2").removeAttr("disabled");
          $("#temas3").removeAttr("disabled");
          $("#temas4").removeAttr("disabled");
          $("#temas5").removeAttr("disabled");
          $("#temas6").removeAttr("disabled");
          $("#temas7").removeAttr("disabled");
          $("#praticas2").removeAttr("disabled");
          $("#praticas9").removeAttr("disabled");
          $("#praticas25").removeAttr("disabled");
          $("#praticas26").removeAttr("disabled");
          $("#praticas27").removeAttr("disabled");
          $("#praticas28").removeAttr("disabled");
          $("#praticas24").removeAttr("disabled");
          $("#outro_procedimento_coletivo").removeAttr("disabled");
        }
    }
    else{
        $("#uni_codigo").removeAttr("disabled");
        $("#num_inep").attr("required", false);
        $("#num_inep").removeAttr("disabled");
        $("#ds_local").removeAttr("disabled");
        $("#atividade1").removeAttr("disabled");
        $("#atividade2").removeAttr("disabled");
        $("#atividade3").removeAttr("disabled");
        $("#atividade5").removeAttr("disabled");
        $("#temas1").removeAttr("disabled");
        $("#temas2").removeAttr("disabled");
        $("#temas3").removeAttr("disabled");
        $("#temas4").removeAttr("disabled");
        $("#temas5").removeAttr("disabled");
        $("#temas6").removeAttr("disabled");
        $("#temas7").removeAttr("disabled");
        $("#praticas2").removeAttr("disabled");
        $("#praticas9").removeAttr("disabled");
        $("#praticas25").removeAttr("disabled");
        $("#praticas26").removeAttr("disabled");
        $("#praticas27").removeAttr("disabled");
        $("#praticas28").removeAttr("disabled");
        $("#praticas24").removeAttr("disabled");
        $("#outro_procedimento_coletivo").removeAttr("disabled");
    }

}

function getAtividadeTipo() {
    var tp_value = $('input[name=atividade]:checked', '#ativ-coletiva').val();
    if (tp_value != null) {
        return parseInt(tp_value);
    }
    return false;
}

function validaHoraInicial() {
    var hora = $('#hr_inicio').val();
    var validaHora = new RegExp(/^([0-1][0-9]|2[0-3]):[0-5][0-9]$/gi);
    if (!hora.match(validaHora)) {
        mensagem("Erro", "Horário inicial inválido", 250, 150);
        $('#hr_inicio').val("");
    }
}

function validaHoraFinal() {
    var hora = $('#hr_fim').val();
    var hora_ini = $('#hr_inicio').val();
    if (hora_ini.replace(":", "") > hora.replace(":", "")) {
        mensagem("Erro", "Horário final inválido", 250, 150, function () {
            $('#hr_fim').focus();
        });
        $('#hr_fim').val("");

    }

    var validaHora = new RegExp(/^([0-1][0-9]|2[0-3]):[0-5][0-9]$/gi);
    if (!hora.match(validaHora)) {
        mensagem("Erro", "Horário final inválido", 250, 150);
        $('#hr_fim').val("");
    }

}

function valida(tab_id, input_name, conf_id) {
    var cont = 0;
    $("#" + tab_id).find("input[type=checkbox][name='" + input_name + "[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont === 0) {
        $("#" + conf_id).val("");
    } else {
        $("#" + conf_id).val(cont);
    }
}

function validaTemasParaReuniao() {
    valida('tab-temas', 'temas', 'conf_temas');
}

function validaPublicoAlvo() {
    valida('tab-pub-alvo', 'pubAlvo', 'conf_pub');
}

function validaPraticasEmSaude() {
    valida('tab-prat', 'praticas', 'conf_prat');
}

function validaTemasParaSaude() {
  valida('tab-temasaude', 'temasaude', 'conf_temasaude');

  if ($("#temasaude18").is(':checked') && !$("#saude-escola-saude").is(':checked')) {
    $("#saude-escola-educacao").attr('checked', true);
  }
}

function buscaProfissionais() {
    $("#profs_part_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar-profissionais-equipes',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (event, ui) {
            carregaEspecialidade(ui.item.id);
            return true;
        }
    });

}

function carregaEspecialidade(usrCodigo) {
    $("#profs_part_esp option").remove();
    $("#td_profs_part_esp").show();
    $("#td_profs_part_conf").show();
    $.ajax({
        url: baseUrl + "/default/especialidade/lista-especialidade-por-profissional",
        type: "POST",
        data: {
            usrCodigo: usrCodigo
        },
        success: function (txt) {
            $.each(txt, function (key, value) {
                $("#profs_part_esp").append("<option title=\"" + value['esp_nome'] + "\" value=\"" + value['cod_cbo'] + "\">" + value['esp_nome'] + "</option>");
            })
        }
    });
}

function confirmarProfsPart() {
    var cont = parseInt($("#conf_prof").val()) + 1;
    var usrCodigo = $("#usr_codigo").val();
    var usrNome = $("#profs_part_nome").val();
    var codCbo = $("#profs_part_esp").val();
    var nameCbo = $("#profs_part_esp :selected").text();
    $("#conf_prof").val(cont);
    if (codCbo != undefined && codCbo != '') {
        if (validaConfirmacaoResp(usrCodigo) == 0) {
            $("#profs_part").show();
            // Cria um contador pro array de campos, através de um hidden
            $("#profs_part_qtd").val(cont);
            $("#profs_part_qtd0").remove();
            $("#profs_part").append(
                '<tr id="profs_part_qtd' + cont + '">' +
                "<td>" + usrNome +
                "<input type='hidden' name='profs_part[" + cont + "][usr_codigo]' value=\"" + usrCodigo + "\" />" +
                "</td>" +
                "<td>" + codCbo + " - " + nameCbo +
                "<input type='hidden' name='profs_part[" + cont + "][cbo]' value=\"" + codCbo + "\" />" +
                "</td>" +
                "<td align='center'>" +
                "<a href='#' class='excluir'>" +
                '<img src="' + baseUrl + '/public/images/icons/excluir.png" alt="Excluir" title="Excluir" onclick="excluirConfirmacaoResp(' + cont + ')" />' +
                "</a>" +
                "</td>" +
                "</tr>");

            $("#prof_resp_codigo").append("<option value=\"" + usrCodigo + "\">" + usrNome + "</option>")
            habilitaNovaConfirmacao();
        } else {
            mensagem("Erro", "Responsável já cadastrado", 250, 150);
        }
    } else {
        mensagem("Alerta", "Especialidade não pode ser vazia", 250, 150);
    }
}

function habilitaNovaConfirmacao() {
    setTimeout(function () {
        $("#profs_part_esp option").remove();
        $("#td_profs_part_esp").hide();
        $("#td_profs_part_conf").hide();
        $("#profs_part_nome").val("");
        $("#profs_part_nome").focus();
    }, 150);
}

function validaConfirmacaoResp(term) {
    var cont = parseInt($("#profs_part_qtd").val()) + 1;
    var table = $('#profs_part');
    var retorno = "";
    if (cont > 1) {
        table.find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (term == $(this).val()) {
                    retorno = 1;
                }
            });
        });
    }
    return retorno;
}

function excluirConfirmacaoResp(id) {
    var cont = parseInt($("#conf_prof").val()) - 1;
    var idProfissional = document.getElementsByName("profs_part["+ id + "][usr_codigo]")[0].value;

    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        $("#profs_part_qtd" + id).remove();
        if (cont == 0) {
            cont = "";
        }
        $("#conf_prof").val(cont);
        $("#profs_part_qtd").val(cont);

        if($("#prof_resp_codigo option[value='" + idProfissional + "']").is(':selected')){
            $("#prof_resp_codigo option[value='" + idProfissional + "']").remove();
            $("#cod_cnes_uni").html("<option value=''>Selecione Profissional Responsável</option>");
            $("#cod_equipe").html("<option value=''>Selecione Cód. CNES Unidade</option>");
        } else {
            $("#prof_resp_codigo option[value='" + idProfissional + "']").remove();
        }
    });

}

function validaQtdParticipantes() {
    var qtdParticipantes = $(".participantes").length;
    if (qtdParticipantes < 1) {
        // Validação Atividade, se for as 3 primeiras retirar obrigatoriedade de Participantes
        var atividadeTipo = getAtividadeTipo();
        if (atividadeTipo === 5 || atividadeTipo === 6) {
            $("#conf_part").val("");
        } else {
            $("#conf_part").val("1");
        }
    } else {
        $("#conf_part").val(qtdParticipantes);
    }
}

function validaQtdParticipantesSalvar() {
    var qtdParticipantes = $(".participantes").length;
    var atividadeTipo = getAtividadeTipo();
    if ((atividadeTipo === 5 || atividadeTipo === 6) && (qtdParticipantes < 1)) {
        alert('É necessário adicionar ao menos um participante!');
        $("#part_nome").focus();
        return false;
    } else if ($("#num_particip").val() < 1 || $("#num_particip").val() == "") {
        alert('O número de participantes deve ser informado!');
        return false;
    }
    return true;
}

function confirmaParticipante() {
    var cont = parseInt($("#usus_part_qtd").val()) + 1;
    var usuNome = $("#part_nome").val();
    var usuCodigo = $("#part_codigo").val();
    var peso = $("#part_peso").val();
    var dtNasc = $("#part_dtnasc").val();
    var altura = $("#part_altura").val();
    var aval = $("#part_aval:checked").val();
    var fuma = $("#part_fuma:checked").val();
    var grupo = $("#part_grupo:checked").val();

    if (!usuCodigo) {
        return false;
    }
    var avalEsc;
    var class_aval;
    if (aval == 1) {
        avalEsc = "SIM";
        class_aval = "aval";
    } else {
        avalEsc = "NÃO";
        aval = "0";
    }

    aval = (aval == 1) ? 1 : 0;
    fuma = (fuma == 1) ? 1 : 0;
    grupo = (grupo == 1) ? 1 : 0;
    var fumaEsc = (fuma === 1) ? "SIM" : "NÃO";
    var grupoEsc = (grupo === 1) ? "SIM" : "NÂO";

    var msgValida = validaInformacoes(peso, altura);

    if (msgValida !== "") {
        mensagem("Erro", msgValida, 280, 160);
    } else {
        if (validaConfirmacaoPart(usuCodigo) == 0) {
            $("#usus_part").show();
            $("#usus_part_qtd0").remove();
            $("#usus_part").append(
                '<tr id="usu_part_qtd' + cont + '" class=\"participantes ' + class_aval + '\" >' +
                "   <td>" + usuNome +
                "       <input type='hidden' name='usus_part[" + cont + "][usu_codigo]' value=\"" + usuCodigo + "\" />" +
                "   </td>" +
                "   <td align='center'>" + dtNasc +
                "       <input type='hidden' name='usus_part[" + cont + "][dt_nascimento]' value=\"" + dtNasc + "\" />" +
                "   </td>" +
                "   <td align='center'>" + avalEsc +
                "       <input type='hidden' name='usus_part[" + cont + "][st_avaliacao_alterada]' value=\"" + aval + "\" />" +
                "   </td>" +
                "   <td align='center'>" + peso +
                "       <input type='hidden' name='usus_part[" + cont + "][nu_peso]' value=\"" + peso + "\" />" +
                "   </td>" +
                "   <td align='center'>" + altura +
                "       <input type='hidden' name='usus_part[" + cont + "][nu_altura]' value=\"" + altura + "\" />" +
                "   </td>" +
                "   <td align='center'>" + fumaEsc +
                "       <input type='hidden' name='usus_part[" + cont + "][st_cessou_habito_fumar]' value=\"" + fuma + "\" />" +
                "   </td>" +
                "   <td align='center'>" + grupoEsc +
                "       <input type='hidden' name='usus_part[" + cont + "][st_abandonou_grupo]' value=\"" + grupo + "\" />" +
                "   </td>" +
                "   <td align='center'>" +
                "       <a href='#' class='excluir'>" +
                '           <img src="' + baseUrl + '/public/images/icons/excluir.png" alt="Excluir" title="Excluir" onclick="excluirConfirmacaoPart(' + cont + ')" />' +
                "       </a>" +
                "   </td>" +
                "</tr>");
            validaQtdParticipantes();
            $("#usus_part_qtd").val(cont);
        } else {
            mensagem("Erro", "Participante já cadastrado", 250, 150);
        }
        $('html, body').animate({scrollTop: $('#usu_part_qtd' + cont).offset().top}, 'slow');

        $("#confirm_paciente").hide();
        $("#num_particip").val((parseInt($("#num_particip").val()) + parseInt(1)));
        $("#num_aval").val($(".aval").size());

        habilitaNovaConfirmacaoPart();
    }
}

function validaInformacoes(peso, altura) {
    var msg = "";
    //Peso
    if (peso != "") {
        peso = parseFloat(peso.replace(',', '.'));
        if (parseFloat(peso) < 0.5 || parseFloat(peso) > 500) {
            msg = msg + " O Peso deve estar entre 0,5kg e 500kg <br/><br/>";
        }
    }
    //Altura
    if (altura != "") {
        altura = parseFloat(altura.replace(',', '.'));
        if (parseFloat(altura) < 20 || parseFloat(altura) > 250) {
            msg = msg + " A Altura deve estar entre 20cm e 250cm";
        }
    }
    return msg;
}

function validaConfirmacaoPart(term) {
    var cont = parseInt($("#usus_part_qtd").val()) + 1;
    var table = $('#usus_part');
    var retorno = "";
    if (cont > 1) {
        table.find('tr').each(function (indice) {
            $(this).find('td input[type="hidden"]').each(function (indice) {
                if (term == $(this).val()) {
                    retorno = 1;
                }
            });
        });
    }
    return retorno;
}

function excluirConfirmacaoPart(id) {
    $('html, body').animate({scrollTop: $('#usu_part_qtd' + id).offset().top}, 'slow');
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        $("#usu_part_qtd" + id).remove();

        $("#num_particip").val($("#num_particip").val() - 1);
        $("#num_aval").val($(".aval").size());
        validaQtdParticipantes();
    });
}


function habilitaNovaConfirmacaoPart() {
    setTimeout(function () {
        $("#part_codigo").val("");
        $("#part_nome").val("");
        $("#part_dtnasc").val("");
        $("#part_peso").val("");
        $("#part_altura").val("");
        $("#part_aval").attr("checked", false);
        $("#part_fuma").attr("checked", false);
        $("#part_grupo").attr("checked", false);
        $("#part_nome").focus();
    }, 150);
}


function carregaCnes(usrCodigo) {
    if(!usrCodigo){
        usrCodigo = $("#prof_resp_codigo option:selected").val();
    }
    setTimeout(function () {
        $("#cod_cnes_uni option").remove();
        $("#cod_cnes_uni").removeAttr("disabled");

        $.ajax({
            url: baseUrl + "/default/unidade/carrega-cnes",
            type: "POST",
            data: {
                usr_codigo: usrCodigo
            },
            success: function (txt) {

                if (txt.length > 1) {
                    $("#cod_cnes_uni").append("<option value=''>Selecione</option>");
                    carregaIne()
                }
                var checked = "";

                $.each(txt, function (key, value) {
                    checked = "";
                    if ($("#cod_cnes_edit").val() == value['uni_cnes'] || txt.length == 1) {
                        checked = "selected=selected";
                        carregaIne(value['uni_codigo'], usrCodigo);
                    }
                    $("#cod_cnes_uni").append("<option " + checked + " value=\"" + validaCampoEmBranco(value['uni_cnes']) + "\" onclick='carregaIne(" + value['uni_codigo'] + "," + usrCodigo + ")'>" + value['uni_desc'] + "\</option>");
                })
            }
        });
    }, 150);
}

function carregaIne(uniCodigo, usrCodigo) {
    setTimeout(function () {
        $("#cod_equipe option").remove();
        $("#cod_equipe").removeAttr("disabled");
        $.ajax({
            url: baseUrl + "/default/usuarios/carrega-equipes",
            type: "POST",
            data: {
                uni_codigo: uniCodigo,
                usr_codigo: usrCodigo
            },
            success: function (txt) {
                var codIne = $("#cod_equipe_ine").val();

                $("#cod_equipe").append("<option value=''>Selecione</option>");

                $.each(txt, function (key, value) {
                    var selectedIne = '';
                    if (codIne == validaCampoEmBranco(value['nu_ine'])) {
                        selectedIne = "selected='selected'";
                    }
                    $("#cod_equipe").append("<option " + selectedIne + " value=\"" + value['nu_ine'] + "\">\n"
                        + value['nu_ine'] + "</option>");
                })
            }
        });
    }, 150);
}


function validaCampoEmBranco(texto) {
    if (texto == "" || texto == null || texto == "null" || texto == "undefined") {
        return "";
    } else {
        return texto;
    }
}

function SomenteNumero(e) {
    var tecla = (window.event) ? event.keyCode : e.which;
    if ((tecla > 47 && tecla < 58))
        return true;
    else {
        return (tecla == 8 || tecla == 0);
    }
}

function validaIne() {
    if ($("#cod_equipe").val().length != 10) {
        mensagem("Erro", "INE inválido!", 250, 150);
        $("#cod_equipe option[value='']").attr("selected", "selected");
    }
}

function validaAltura() {
    if ($("#part_altura").val() <= 20) {
        mensagem("Erro", "Altura mínima 20 cm", 250, 150);
        $("#part_altura").val("");
        $("#part_altura").focus();
    }
}

function validaPeso() {
    if ($("#part_peso").val() != "") {
        var peso = parseFloat($("#part_peso").val().replace(",", "."));
        if (peso < 0.5 && peso > 500) {
            mensagem("Erro", "Peso deve estar entre 0,5kg e 500kg", 250, 150);
            $("#part_peso").val("");
            $("#part_peso").focus();
        }
    }
}

function formataPeso() {
    $('#part_peso').priceFormat({
        prefix: '',
        centsSeparator: ',',
        centsLimit: 3,
        thousandsSeparator: ''
    });
}

function desabilitaPnct() {
    var pcnt25 = $("#praticas25").is(":checked");
    var pcnt26 = $("#praticas26").is(":checked");
    var pcnt27 = $("#praticas27").is(":checked");
    var pcnt28 = $("#praticas28").is(":checked");

    if (pcnt25 == true || pcnt26 == true || pcnt27 == true || pcnt28 == true) {
        $("#part_fuma").removeAttr("disabled");
        $("#part_grupo").removeAttr("disabled");
    } else {
        $("#part_fuma").attr("disabled", true);
        $("#part_grupo").attr("disabled", true);
    }

    var contPratica = "";
    $("#tab-prat").each(function (indice) {
        $(this).find('td input[type="checkbox"]').each(function (indice) {
            if ($("#praticas" + $(this).val() + ":checked").val() > 0) {
                contPratica++;
            }
            $("#praticas" + $(this).val()).removeAttr("disabled");
        });
    });
    $("#conf_prat").val(contPratica);

    var contSaude = "";
    $("#tab-temasaude").each(function (indice) {
        $(this).find('td input[type="checkbox"]').each(function (indice) {
            if ($("#temasaude" + $(this).val() + ":checked").val() > 0) {
                contSaude++;
            }
            $("#temasaude" + $(this).val()).removeAttr("disabled");
        });
    });
    $("#conf_temasaude").val(contSaude);

}

function checaTipo() {
    var atividadeTipo = getAtividadeTipo();
    validaQtdParticipantes();
    switch (atividadeTipo) {
        case 1:
        case 2:
        case 3:
            habilitaTemasParaReuniao();
            desabilitaPublicoAlvo();
            desabilitaTemasParaSaude();
            desabilitaPraticaEmSaude();
            break;
        case 4:
        case 7:
            habilitaPublicoAlvo();
            habilitaTemasParaSaude();
            desabilitaTemasParaReuniao();
            desabilitaPraticaEmSaude();
            break;
        case 5:
        case 6:
            habilitaPublicoAlvo();
            habilitaTemasParaSaude();
            habilitaPraticasEmSaude();
            desabilitaTemasParaReuniao();
            break;
        default:
            break;
    }
}

function desabilita(tab_id, input_id, conf_id) {
    $("#" + conf_id).val("1");
    $("#" + tab_id).each(function () {
        $(this).find('td input[type="checkbox"]').each(function () {
            $("#" + input_id + $(this).val()).attr("disabled", true);
            $("#" + input_id + $(this).val()).attr("checked", false);
        });
    });
}

function desabilitaPraticaEmSaude() {
    desabilita("tab-prat", "praticas", "conf_prat");
}

function desabilitaPublicoAlvo() {
    desabilita("tab-pub-alvo", "pubAlvo", "conf_pub");
}

function desabilitaTemasParaReuniao() {
    desabilita("tab-temas", "temas", "conf_temas");
}

function desabilitaTemasParaSaude() {
    desabilita("tab-temasaude", "temasaude", "conf_temasaude");
}

function habilita(tab_id, input_id, conf_id) {
    var cont = 0;
    $("#" + tab_id).each(function () {
        cont = $(this).find('td input[type="checkbox"]:checked ').length;
        $(this).find('td input[type="checkbox"]').each(function () {
            $("#" + input_id + $(this).val()).removeAttr("disabled");
        });
    });
    cont = (cont === 0) ? "" : cont;
    $("#" + conf_id).val(cont);

}

function habilitaTemasParaReuniao() {
    habilita("tab-temas", "temas", "conf_temas");
}

function habilitaPublicoAlvo() {
    habilita("tab-pub-alvo", "pubAlvo", "conf_pub");
}

function habilitaPraticasEmSaude() {
    habilita("tab-prat", "praticas", "conf_prat");
    var atividadeTipo = getAtividadeTipo();
    if (atividadeTipo === 6) {
        $("#praticas2").attr("disabled", false);
        $("#praticas9").attr("disabled", false);
    } else if (atividadeTipo === 5) {
        $("#conf_prat").val("1");
        $("#praticas2").attr("checked", false);
        $("#praticas9").attr("checked", false);
        $("#praticas2").attr("disabled", true);
        $("#praticas9").attr("disabled", true);
    }
}

function habilitaTemasParaSaude() {
    habilita("tab-temasaude", "temasaude", "conf_temasaude");
}

function desabilitaTemas() {
    validaQtdParticipantes()
    $("#conf_temas").val("1");
    $("#conf_ativ").val("1");
    $("#tab-temas").each(function () {
        $(this).find('td input[type="checkbox"]').each(function () {
            $("#temas" + $(this).val()).attr("disabled", true);
            $("#temas" + $(this).val()).attr("checked", false);
        });
    });
}

function validaData(e) {
    if ($(e).val().length > 0) {
        if (VerificaData(e)) {
            return true;
        } else {
            $("#dt_atividade").val("");
            setTimeout(function () {
                $('#dt_atividade').focus()
            }, 500);
            $("#dt_atividade").focus();
        }
    }
}

function validaDataValidate(event) {
    event.preventDefault();
    var data = $("#dt_atividade").val();
    var dataFormatada = data.split('/');
    dataFormatada = new Date(dataFormatada[2], dataFormatada[1] - 1, dataFormatada[0]);
    var dataHoje = new Date();

    if (dataFormatada <= dataHoje) {
        $("#data_valida").val(true);
    } else {
        $("#data_valida").val('');
    }
    $("#ativ-coletiva").validate();
    if (validaQtdParticipantesSalvar() && $("#ativ-coletiva").valid()) {
        mensagemSemOk("carregando-ativcol", "Aguarde", "Carregando...", 280, 80);
        $.ajax({
            url: baseUrl + "/programas-federais/atividade-coletiva/salvar",
            data: $("#ativ-coletiva").serialize(),
            type: 'POST',
            success: function (ret) {
                mensagem("OK", "Atividade Coletiva salva com sucesso!");
                console.log(ret);
                setTimeout(function (ret) {
                    if(ret){
                        parent.location.reload(true);
                    }else{
                        location.href = baseUrl + "/programas-federais/atividade-coletiva/inconsistencias";
                    }
                    fecharMensagemSemOk("carregando-ativcol");
                }, 1000, ret);
            }
        })
    }else{
        mensagem("Atenção", "Existem campos obrigatórios não preenchidos");
    }
}

function enableDisableLocalAtividades(field){
    if(field === "unidade"){
        var unidade = $("#uni_codigo").val();
        if(unidade !== ""){
            $("#num_inep").attr("disabled", "disabled");
            $("#ds_local").attr("disabled", "disabled");
        }else{
            $("#num_inep").removeAttr("disabled");
            $("#ds_local").removeAttr("disabled");
        }
    }

    if(field === "inep"){
        var inep = $("#num_inep").val();
        if(inep !== ""){
            $("#uni_codigo").attr("disabled", "disabled");
            $("#ds_local").attr("disabled", "disabled");
        }else{
            $("#uni_codigo").removeAttr("disabled");
            $("#ds_local").removeAttr("disabled");
        }
    }

    if(field === "localidade"){
        var localidade = $("#ds_local").val();
        if(localidade !== ""){
            $("#uni_codigo").attr("disabled", "disabled");
            $("#num_inep").attr("disabled", "disabled");
        }else{
            $("#uni_codigo").removeAttr("disabled");
            $("#num_inep").removeAttr("disabled");
        }
    }


}

function validaDataAtendimento() {
    var dataAtual = $('#data_atual').val();
    var dataAtualFormatada = dataAtual.split('/');
    dataAtualFormatada = new Date(dataAtualFormatada[2], dataAtualFormatada[1] - 1, dataAtualFormatada[0]);

    var mesAtual = dataAtualFormatada.getMonth();
    var diaAtual = dataAtualFormatada.getDate();
    var anoAtual = dataAtualFormatada.getFullYear();

    var dataMinima = new Date(anoAtual, mesAtual - 12, diaAtual);

    var dataInformada = $("#dt_atividade").val();
    var dataInformadaFormatada = dataInformada.split('/');
    dataInformadaFormatada = new Date(dataInformadaFormatada[2], dataInformadaFormatada[1] - 1, dataInformadaFormatada[0]);

    if (dataInformadaFormatada < dataMinima) {
        alert('A data do atendimento deve constar dentro do período de 1 ano!');
        $("#dt_atividade").val('');
        $("#dt_atividade").focus();
    }
}


function verificaTamanho(tamanho) {

    var valorCampo = $("#ds_local").val();

    if (valorCampo.length >= tamanho) {
        alert("O campo suporta no máximo " + tamanho + " caracteres!");
        var retorno = valorCampo.substr(0, tamanho - 1);
        $("#ds_local").val(retorno);
        $("#ds_local").focus();
        return false;
    }
}

function verificaTecla(e) {
    var tecla;
    if (e.keyCode) {
        tecla = e.keyCode;
    } else if (e.which) {
        tecla = e.which;
    }

    if (tecla != 8) { // 8 = backspace
        verificaTamanho(250);
    }

}

function abrirCadastroGrupos() {
    location.href = baseUrl + "/programas-federais/grupo-atividade-coletiva";
}

function abrirGrupos() {
    var tpl =
        "<table class='grid ui-widget ui-widget-content ui-corner-all' width='100%'>" +
        "    <tr class='ui-widget-header'>" +
        "        <th width='55%'>Nome</th>" +
        "        <th width='15%'>Qtde. Part.</th>" +
        "        <th width='15%'>Status</th>" +
        "        <th width='15%'>Opções</th>" +
        "    </tr>";
    $.ajax({
        url: baseUrl + "/programas-federais/grupo-atividade-coletiva/listar-grupos-ativos",
        type: "GET",
        success: function (ret) {
            if (ret.length > 0) {
                ret.forEach(function (dados) {
                    tpl += "<tr onclick='fechaModal(" + dados.gac_codigo + ")'>" +
                        "   <td class='ui-state-default'>" + dados.gac_descricao + "</td>" +
                        "   <td class='ui-state-default' align='center'>" + dados.qtd_part + "</td>" +
                        "   <td class='ui-state-default' align='center'>" + (dados.gac_status ? "Ativo" : "Inativo") + "</td>" +
                        "   <td class='ui-state-default c' width='80'>" +
                        "       <a style='cursor: pointer;' class='editar'>" +
                        "           <img src=" + baseUrl + '/public/images/icons/selecionar.png' + " alt='Selecionar Grupo' title='Selecionar Grupo' />" +
                        "       </a>" +
                        "   </td>" +
                        "</tr>";
                });
            } else {
                tpl += "<td colspan='6'>Nenhum item encontrado</td>";
            }
            tpl += "</table>";

            $("body").append("<div id='gac_modal' title='Seleção de grupo' ></div>");
            $("#gac_modal")
                .html(tpl)
                .dialog({
                    modal: true,
                    height: 500,
                    width: "75%",
                    title: "Grupos de Atividade Coletiva",
                    resizable: false,
                    close: function () {
                        selecionaGrupoAtividadeColetiva($(this).data('gac_codigo'));
                    }
                });
        }
    });
}

function fechaModal(gac_codigo) {
    $("#gac_modal").data('gac_codigo', gac_codigo);
    $("#gac_modal").dialog('close');
}

function selecionaGrupoAtividadeColetiva(gac_codigo) {
    $.ajax({
        url: baseUrl + "/programas-federais/grupo-atividade-coletiva/listar-participantes-por-grupo?gac_codigo=" + gac_codigo,
        type: "GET",
        success: function (ret) {
            if (ret.length > 0) {
                var cont = parseInt($("#usus_part_qtd").val());
                $("#conf_part").val(cont);
                var part_duplicado = 0;

                ret.forEach(function (dados) {
                    cont++;
                    var fumaEsc = (dados.gap_cessou_habito_fumar == 1) ? "SIM" : "NÃO";
                    var avalEsc = (dados.gap_avaliacao_alterada == 1) ? "SIM" : "NÃO";
                    var class_aval;
                    if (dados.gap_avaliacao_alterada == 1) {
                        class_aval = "aval";
                    }
                    var grupoEsc = (dados.gap_abandonou_grupo == 1) ? "SIM" : "NÃO";

                    if (validaConfirmacaoPart(dados.usu_codigo) != 1) {
                        $("#usus_part").show();
                        $("#usus_part_qtd0").remove();
                        $("#usus_part").append(
                            '<tr id="usu_part_qtd' + cont + '" class=\"participantes ' + class_aval + '\" >' +
                            "   <td>" + dados.usu_nome +
                            "       <input type='hidden' name='usus_part[" + cont + "][usu_codigo]' value=\"" + dados.usu_codigo + "\" />" +
                            "   </td>" +
                            "   <td align='center'>" + formataData(dados.gap_dt_nascimento) +
                            "       <input type='hidden' name='usus_part[" + cont + "][dt_nascimento]' value=\"" + dados.gap_dt_nascimento + "\" />" +
                            "   </td>" +
                            "   <td align='center'>" + avalEsc +
                            "       <input type='hidden' name='usus_part[" + cont + "][st_avaliacao_alterada]' value=\"" + parseInt(dados.gap_avaliacao_alterada) + "\" />" +
                            "   </td>" +
                            "   <td align='center'>" + number_format(dados.gap_peso, 3, ",", ".") +
                            "       <input type='hidden' name='usus_part[" + cont + "][nu_peso]' value=\"" + parseInt(dados.gap_peso) + "\" />" +
                            "   </td>" +
                            "   <td align='center'>" + dados.gap_altura +
                            "       <input type='hidden' name='usus_part[" + cont + "][nu_altura]' value=\"" + dados.gap_altura + "\" />" +
                            "   </td>" +
                            "   <td align='center'>" + fumaEsc +
                            "       <input type='hidden' name='usus_part[" + cont + "][st_cessou_habito_fumar]' value=\"" + parseInt(dados.gap_cessou_habito_fumar) + "\" />" +
                            "   </td>" +
                            "   <td align='center'>" + grupoEsc +
                            "       <input type='hidden' name='usus_part[" + cont + "][st_abandonou_grupo]' value=\"" + parseInt(dados.gap_abandonou_grupo) + "\" />" +
                            "   </td>" +
                            "   <td align='center'>" +
                            "       <a class='excluir'>" +
                            '           <img src="' + baseUrl + '/public/images/icons/excluir.png" alt="Excluir" title="Excluir" onclick="excluirConfirmacaoPart(' + cont + ')" />' +
                            "       </a>" +
                            "   </td>" +
                            "</tr>");
                        validaQtdParticipantes();
                        $("#usus_part_qtd").val(cont);
                        var num_part = $("#num_particip").val();
                        $("#num_particip").val((parseInt(num_part) + 1));
                    } else {
                        part_duplicado++;
                    }

                    $("#confirm_paciente").hide();
                    $("#num_aval").val($(".aval").size());

                    habilitaNovaConfirmacaoPart();
                });
                if (part_duplicado > 0) {
                    mensagem("Atenção", "Não foram adicionados os participantes do grupo que já estão incluídos!")
                }
            }
        }
    });
}
