$(function () {

    exibeInfoPaciente();
    exibeEstratificacaoRadio('diabetico', 'estrat_diabetes', 'risco_diabetes');
    exibeEstratificacaoRadio('gestante', 'estrat_gestante', 'risco_gestacao');
    exibeEstratificacaoRadio('hipertensao', 'estrat_hipertensao', 'risco_hipertensao');
    exibeEstratificacaoIdade();
    carregarDadosEspeciaisPaciente($('#usu_codigo').val());
    checaSexoGestante();

    $("#tipoBusca").change(function () {
        if ($(this).val() == '2') {
            $('#busca').hide();
            $('#busca2').show();
        } else {
            $('#busca2').hide();
            $('#busca').show();
        }
    });

    carregaEspecialidade()

    $("tr:odd").addClass("odd");

    $("#form-busca").validate({
        rules: {
            tipo_busca: {required: true},
        },
        messages: {
            tipo_busca: {required: "(*)Obrigatório"}
        }
    });

    $("#usu_codigo").live('input', function () {
        if(usu_codigo === undefined){
        }else{
            console.log("usu_codigo = "+usu_codigo);
            $.ajax({
                url: baseUrl + '/default/usuarios/getSexo/usu_codigo/' + usu_codigo,
                success: function (result) {
                    $("#usu_sexo").val(result);
                }
            });
        }
    });




    $("#ate-simplificado").validate({
        rules: {
            data_atendimento: {required: true},
            usu_codigo: {required: true},
            usr_codigo: {required: true},
            esp_codigo: {required: true},
            proc_codigo: {required: true},
            conf_ta: {required: true},
            conf_tc: {required: true},
            conf_cond: {required: true},
            conf_vig: {required: true},
            uni_codigo: {required: true},
            data_valida: {required: true},
        },
        messages: {
            data_atendimento: {required: "Campo obrigatório."},
            usu_codigo: {required: "Selecione um Paciente."},
            usr_codigo: {required: "Selecione um Profissional."},
            esp_codigo: {requires: "Selecione uma Especialidade."},
            proc_codigo: {required: "Selecione um Procedimento."},
            conf_ta: {required: "Campo obrigatório."},
            conf_tc: {required: "Campo obrigatório."},
            conf_cond: {required: "Campo obrigatório."},
            conf_vig: {required: "Campo obrigatório."},
            uni_codigo: {required: "Campo obrigatório."},
            data_valida: {required: "Data inválida."}
        }
    });

    $(".ate_tipo_atendimento").change(function () {
        if ($(this).val() == "V") {
            carregaModalVisita();
        } else {

        }
    });


    $(".paciente").click(function () {
        var usu_codigo = $("#usu_codigo").val();
        if (usu_codigo > 1) {
            var link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
        } else {
            link = baseUrl + "/default/paciente/form-paciente/poupup/1";
        }
        window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });


    if ($("#usr_nome").val() != "") {
        carregaIne();
    };

});


setInterval(function () {
    var usu_codigo = $("#usu_codigo").val();
    if(usu_codigo !== undefined)
    $.ajax({
        url: baseUrl + '/default/usuarios/get-sexo/usu_codigo/' + usu_codigo,
        success: function (result) {
            if (result == 'M') {
                $("#gestante").attr("disabled", true);
                $("#gestante").attr("checked", false);
            } else {
                $("#gestante").removeAttr("disabled");
            }
            $("#usu_sexo").val(result);
        }
    });
}, 3000);

function buscaProcedimentos() {
    $("#proc_nome").buscar({
        url: baseUrl + "/procedimento/buscar3/esp/" + $("#esp_codigo").val() + "/selecionados/" + $("#procedimentos").val(),
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            adicionaProcedimentos();
            limparCampos();
        }
    });
}


function buscaPaciente() {
    var tipo_busca = $("#tipo_busca").val();
    $("#usu_nome").buscar({
        url: baseUrl + '/paciente/buscar/tipo_busca/' + tipo_busca,
        callback: function () {
            return true;
        }
    });
}

// Pega o procedimento e o código selecionado e coloca o valor em um campo 
// oculto para realizar a inserção
function adicionaProcedimentos() {

    $("#dadosProcAtendSimp").append("\
        <div class='procAtendSimp' style='width:60%; display: inline-block;' id='procAtendSimp" + $("#proc_codigo").val() + "-" + $(".procAtendSimp").length + "'>\n\
            <span class='titProcAtendSimp'>\n\
                " + $("#proc_codigo_sus").val() + " - " + $("#proc_nome").val().substr(0, 32) + " ...\n\
            </span>\n\
            <div class='excProcAtendSimp'>\n\
                <img src='" + baseUrl + "/public/images/icons/excluir.png' onclick=\"excluiProcedimento('" + $("#proc_codigo").val() + "-" + $(".procAtendSimp").length + "')\" title='Excluir Procedimento' style='cursor: pointer' />\n\
                <input type='hidden' name='procedimento[]' value='" + $("#proc_codigo").val() + "' />\
            </div>\
        </div>\
        <div  id='divprocAtendSimp" + $("#proc_codigo").val() + "-" + $(".procAtendSimp").length + "' style='width:20%;display: inline-block; vertical-align: middle;'>\
            <select id='qtdeComboProcedimento" + $("#proc_codigo").val() + "' name='qtdeProc[]' style=' height:24px;' class='ui-state-default'>\
            </select>\
        </div>");
    var id = $("#proc_codigo").val();
    preencherProcedimentos(id, false);
    incrementaComboQuantidadeProcedimento(id);
}

function incrementaComboQuantidadeProcedimento(id) {
    var retorno = "";

    for (var i = 1; i <= 32; i++) {
        retorno = retorno + "<option value='" + i + "'>" + i + "</option>\n";
    }
    return $("#qtdeComboProcedimento" + id).append(retorno);
}

function excluiProcedimento(procCodigo) {
    confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
        $("#procAtendSimp" + procCodigo).remove();
        $("#imgprocAtendSimp" + procCodigo).remove();
        $("#divprocAtendSimp" + procCodigo).remove();
        console.log("#procAtendSimp" + procCodigo);
        preencherProcedimentos(procCodigo.toString().substr(0, procCodigo.length - 2), true);
    });
}

function limparCampos() {
    $("#proc_nome").val("");
}

function preencherProcedimentos(valor, removendo) {
    var atual = $("#procedimentos").val();
    var concatenado;

    if (!removendo) {
        if ($("#procedimentos").val()) {
            concatenado = atual + ',' + valor;
        } else {
            concatenado = valor;
        }
        $("#procedimentos").val(concatenado);
    } else {
        if (atual.indexOf(valor) != -1) {
            var pedacos = atual.toString().split(",");
            var devolutiva = "";

            for (var x = 0; x < pedacos.length; x++) {
                if (pedacos[x] == valor) {
                    pedacos.slice(x, 1);
                } else {
                    devolutiva = devolutiva + pedacos[x] + ',';
                }
            }
            while (devolutiva.indexOf(",,") != -1) {
                devolutiva.replace(",,", ",");
            }
            if (devolutiva.charAt(devolutiva.length - 1) == ",") {
                devolutiva = devolutiva.substr(0, devolutiva.length - 1);
            }

            $("#procedimentos").val(devolutiva);
        }
    }

}

function carregaEspecialidade() {
    if ($("#usr_codigo").val() && $("#uni_codigo").val()) {
        $("#especialidade").show();
        $.ajax({
            url: baseUrl + "/default/especialidade/lista-especialidade-por-profissional",
            type: "POST",
            data: {
                usrCodigo: $("#usr_codigo").val(),
                uni_codigo: $("#uni_codigo").val()
            },
            success: function (txt) {
                $("#esp_codigo").html("");
                $.each(txt, function (key, value) {
                    if (value['esp_codigo'] == $("#esp_codigo_editar").val()) {
                        $("#esp_codigo").append("<option selected = '" + "selected" + "' title=\"" + value['esp_nome'] + "\" value=\"" + value['esp_codigo'] + "\">" + value['esp_nome'] + "</option>");
                    } else {
                        $("#esp_codigo").append("<option title=\"" + value['esp_nome'] + "\" value=\"" + value['esp_codigo'] + "\">" + value['esp_nome'] + "</option>");
                    }
                });
            }
        });
    }
}

function buscaUnidade() {
    $("#uni_desc").buscar({
        url: baseUrl + "/unidade/buscar",
        minLength: 3,
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function buscaProfissional() {
    var tipo_atend = $("#tipo_atendimento").val();
    var uni_codigo = $("#uni_codigo").val();
    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar/tipo/' + tipo_atend + '/unidade/' + uni_codigo + '/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            carregaEspecialidade();
            carregaIne();
        }
    });

}

function validaTipoConduta() {
    var cont = 0;
    $("#conduta").find("input[type=checkbox][name='conduta[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_cond").val("");
    } else {
        $("#conf_cond").val(cont);
    }
}



function validaTipoVigilancia() {
    var cont = 0;
    $("#vigilancia").find("input[type=checkbox][name='vigilancia[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_vig").val("");
    } else {
        $("#conf_vig").val(cont);
    }
}

function validaTipoAtendimento() {
    $("#conf_ta").val("1");
    //CONSULTA AGENDADA
    var cont = "";
    if ($("#tipo_atend:checked").val() == 2) {
        $("#tipo_consulta").each(function (indice) {
            $(this).find('input[type="radio"]').each(function (indice) {
                $("#tipo_cons" + $(this).val()).removeAttr("disabled");
                if ($("#tipo_cons" + $(this).val() + ":checked").val() > 0) {
                    cont++;
                }
            });
        });
        $("#conf_tc").val(cont);
    }
    //ESCUTA INICIAL / ORIENTAÇÃO
    if ($("#tipo_atend:checked").val() == 4) {
        $("#conf_tc").val("1");
        $("#tipo_consulta").each(function (indice) {
            $(this).find('input[type="radio"]').each(function (indice) {
                $("#tipo_cons" + $(this).val()).attr("disabled", true);
                $("#tipo_cons" + $(this).val()).attr("checked", false);
            });
        });
    }
    //CONSULTA NO DIA
    if ($("#tipo_atend:checked").val() == 5) {
        $("#conf_tc").val("1");
        $("#tipo_consulta").each(function (indice) {
            $(this).find('input[type="radio"]').each(function (indice) {
                $("#tipo_cons" + $(this).val()).removeAttr("disabled");
            });
        });
    }
    //ATENDIMENTO DE URGÊNCIA
    if ($("#tipo_atend:checked").val() == 6) {
        $("#conf_tc").val("1");
        $("#tipo_consulta").each(function (indice) {
            $(this).find('input[type="radio"]').each(function (indice) {
                if ($(this).val() == 2) {
                    $("#tipo_cons" + $(this).val()).attr("disabled", true);
                    $("#tipo_cons" + $(this).val()).attr("checked", false);
                } else {
                    $("#tipo_cons" + $(this).val()).removeAttr("disabled");
                }
            });
        });
    }
}

function validaTipoConsulta() {
    $("#conf_tc").val("1");
}

function validaData(e) {
    if ($(e).val().length > 0) {
        if (VerificaData(e)) {
            return true;
        } else {
            $("#data_atendimento").val("");
            setTimeout(function () {
                $('#data_atendimento').focus()
            }, 500);
            $("#data_atendimento").focus();
        }
    }
}

function retornaPac(usu_codigo, usu_nome) {
    $("#usu_codigo").val(usu_codigo);
    $("#usu_nome").val(usu_nome);
}

function validaData() {

    var data = $("#data_atendimento").val();
    var dataFormatada = data.split('/');
    var dataFormatada = new Date(dataFormatada[2], dataFormatada[1] - 1, dataFormatada[0]);
    var dataHoje = new Date();

    if (dataFormatada <= dataHoje) {
        $("#data_valida").val(true);
    } else {
        $("#data_valida").val('');
    }

}

function validaDataAtendimento() {
    var dataAtual = $('#data_atual').val();
    var dataAtualFormatada = dataAtual.split('/');
    var dataAtualFormatada = new Date(dataAtualFormatada[2], dataAtualFormatada[1] - 1, dataAtualFormatada[0]);
    
    var mesAtual = dataAtualFormatada.getMonth();
    var diaAtual = dataAtualFormatada.getDate();
    var anoAtual = dataAtualFormatada.getFullYear();
    
    var dataMinima = new Date(anoAtual, mesAtual - 12, diaAtual);
    
    var dataInformada = $("#data_atendimento").val();
    var dataInformadaFormatada = dataInformada.split('/');
    var dataInformadaFormatada = new Date(dataInformadaFormatada[2], dataInformadaFormatada[1] - 1, dataInformadaFormatada[0]);

    if (dataInformadaFormatada < dataMinima) {
        alert('A data do atendimento deve constar dentro do período de 1 ano!');
        $("#data_atendimento").val('');
    } 
}


function ValidaTipoConsultaConduta() {
    if ($("#tipo_cons4:checked").length > 0) {
        $("#conduta15").attr("disabled", true);
        $("#conduta15").removeAttr("checked");
        $("#conduta17").removeAttr("disabled");
    } else {
        $("#conduta15").removeAttr("disabled");
        $("#conduta17").attr("disabled", true);
        $("#conduta17").removeAttr("checked");
    }
}

function carregaIne() {
    console.log($("#cod_cnes_uni option:selected").val());
    setTimeout(function () {
        $("#cod_equipe option").remove();
        $("#cod_equipe").show();
        $.ajax({
            url: baseUrl + "/default/usuarios/carrega-equipes",
            type: "POST",
            data: {
                uni_codigo: $("#uni_codigo").val(),
                usr_codigo: $("#usr_codigo").val()
            },
            success: function (txt) {
                if (txt.length > 0) {
                    $("#equipe").show();
                    $("#cod_equipe").rules("add", "required");
                    var codIne = $("#cod_equipe_ine").val();
                    $.each(txt, function (key, value) {
                        var selectedIne = '';
                        if (codIne == value['co_seq_equipe']) {
                            selectedIne = "selected='selected'";
                        }
                        $("#cod_equipe").append("<option " + selectedIne + " value=\"" + value['co_seq_equipe'] + "\">" + value['nu_ine'] + " - " + value['no_equipe'] + "\</option>");
                    })
                } else {
                    $("#cod_equipe").rules("remove", "required");
                    $("#equipe").hide();

                }
            }
        });
    }, 150);
}

function getIdade() {
    var parts = $('#datanascimento').val().split('/');
    var dataNascimento = new Date(parts[2], parts[1] - 1, parts[0]);

    var parts = $('#dataatual').val().split('/');
    var dataAtual = new Date(parts[2], parts[1] - 1, parts[0]);

    var idade = dataAtual.getFullYear() - dataNascimento.getFullYear();
    var m = dataAtual.getMonth() - dataNascimento.getMonth();
    if (m < 0 || (m = 0 && dataAtual.getDate() < dataNascimento.getDate())) {
        idade--;
    }
    return idade;
}


function exibeEstratificacaoCheckbox(idCheckbox, idDiv, idCampoRisco) {
    if ($("#" + idCheckbox).is(':checked')) {
        $("#" + idDiv).show();
    } else {
        $("#" + idDiv).hide();
        $("#" + idCampoRisco).val("");
    }
}

function exibeEstratificacaoIdade() {
    if (getIdade() >= 60) {
        $("#estrat_idoso").show();
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
    } else if (getIdade() < 12 && $('#usr_tipo_medico').val() !== 'P') {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").show();
    } else {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
    }
}

function exibeInfoPaciente() {
    if ($('#usu_codigo').val() == '') {
        $('#dados_paciente').hide();
    } else {
        $('#dados_paciente').show();
    }
}
