$(function () {
    exibeInfoPaciente();
    exibeEstratificacaoRadio('diabetico', 'estrat_diabetes', 'risco_diabetes');
    exibeEstratificacaoRadio('gestante', 'estrat_gestante', 'risco_gestacao');
    exibeEstratificacaoRadio('hipertensao', 'estrat_hipertensao', 'risco_hipertensao');
    exibeEstratificacaoIdade();
    carregarDadosEspeciaisPaciente($('#usu_codigo').val());
    checaSexoGestante();
    $('#hanseniase').hide();

    $("#tipoBusca").change(function () {
        if ($(this).val() == '2') {
            $('#busca').hide();
            $('#busca2').show();
        } else {
            $('#busca2').hide();
            $('#busca').show();
        }
    });
    $("#tvi_codigo").change(function () {
        var tvi_codigo = $(this).val();
        buscaEstrategia(tvi_codigo);
        if (tvi_codigo == '15') {
            $('#hanseniase').show();
        } else {
            $('#hanseniase').hide();
        }
    });

    $("#tve_codigo").change(function () {
        var tve_codigo = $(this).val();
        var tvi_codigo = $("#tvi_codigo").val();
        buscaDose(tve_codigo, tvi_codigo);
    });

    carregaEspecialidade();

    $("tr:odd").addClass("odd");

    $("#form-busca").validate({
        rules: {
            tipo_busca: {required: true},
        },
        messages: {
            tipo_busca: {required: "(*)Obrigatório"}
        }
    });

    $("#usu_codigo").live('input', function () {
        if(usu_codigo === undefined){
        }else{
            $.ajax({
                url: baseUrl + '/default/usuarios/getSexo/usu_codigo/' + usu_codigo,
                success: function (result) {
                    $("#usu_sexo").val(result);
                }
            });
        }
    });

    $('#efv_gestante').click(
        function () {
            if($('#usu_sexo').val() == 'M'){
                alert("Atenção. Paciente do sexo masculino!");
                $(this).removeAttr('checked');
            }
            $('#efv_puerpera').removeAttr('checked');
        }
    );
    $('#efv_puerpera').click(
        function () {
            if($('#usu_sexo').val() == 'M'){
                alert("Atenção. Paciente do sexo masculino!");
                $(this).removeAttr('checked');
            }
            $('#efv_gestante').removeAttr('checked');
        }
    );

    $("#form_vacinacao").validate({
        rules: {

            usu_codigo: {required: true},
            usr_codigo: {required: true},
            esp_codigo: {required: true},
            uni_codigo: {required: true},
              efc_data: {required: true}

        },
        messages: {

            usu_codigo: {required: "Selecione um Paciente."},
            usr_codigo: {required: "Selecione um Profissional."},
            esp_codigo: {requires: "Selecione uma Especialidade."},
            uni_codigo: {required: "Campo obrigatório."},
              efc_data: {required: "Data é obrigatória"}

        }
    });

    $(".paciente").click(function () {
        var usu_codigo = $("#usu_codigo").val();
        if (usu_codigo > 1) {
            var link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
        } else {
            link = baseUrl + "/default/paciente/form-paciente/poupup/1";
        }
        window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });


    if ($("#usr_nome").val() != "") {
        carregaIne();
    }

});

function buscaPaciente() {
    var tipo_busca = $("#tipo_busca").val();
    $("#usu_nome").buscar({
        url: baseUrl + '/paciente/buscar/tipo_busca/' + tipo_busca,
        callback: function () {
            return true;
        }
    });
}

function carregaEspecialidade() {
    if ($("#usr_codigo").val() && $("#uni_codigo").val()) {
        $("#especialidade").show();
        $.ajax({
            url: baseUrl + "/default/especialidade/lista-especialidade-por-profissional",
            type: "POST",
            data: {
                usrCodigo: $("#usr_codigo").val(),
                uni_codigo: $("#uni_codigo").val()
            },
            success: function (txt) {
                $("#esp_codigo").html("");
                $.each(txt, function (key, value) {
                    if (value['esp_codigo'] == $("#esp_codigo_editar").val()) {
                        $("#esp_codigo").append("<option selected = '" + "selected" + "' title=\"" + value['esp_nome'] + "\" value=\"" + value['esp_codigo'] + "\">" + value['esp_nome'] + "</option>");
                    } else {
                        $("#esp_codigo").append("<option title=\"" + value['esp_nome'] + "\" value=\"" + value['esp_codigo'] + "\">" + value['esp_nome'] + "</option>");
                    }
                });
            }
        });
    }
}

function buscaUnidade() {
    $("#uni_desc").buscar({
        url: baseUrl + "/unidade/buscar",
        minLength: 3,
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function buscaProfissional() {

    var uni_codigo = $("#uni_codigo").val();
    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar/unidade/' + uni_codigo + '/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            carregaEspecialidade();
            carregaIne();
        }
    });

}

function validaTipoConsulta() {
    $("#conf_tc").val("1");
}

function retornaPac(usu_codigo, usu_nome) {
    $("#usu_codigo").val(usu_codigo);
    $("#usu_nome").val(usu_nome);
}

function carregaIne() {
    setTimeout(function () {
        $("#cod_equipe option").remove();
        $("#cod_equipe").show();
        $.ajax({
            url: baseUrl + "/default/usuarios/carrega-equipes",
            type: "POST",
            data: {
                uni_codigo: $("#uni_codigo").val(),
                usr_codigo: $("#usr_codigo").val()
            },
            success: function (txt) {
                if (txt.length > 0) {
                    $("#equipe").show();

                    var codIne = $("#cod_equipe_ine").val();
                    $.each(txt, function (key, value) {
                        var selectedIne = '';
                        if (codIne == value['co_seq_equipe']) {
                            selectedIne = "selected='selected'";
                        }
                        $("#cod_equipe").append("<option " + selectedIne + " value=\"" + value['co_seq_equipe'] + "\">" + value['nu_ine'] + " - " + value['no_equipe'] + "\</option>");
                    })
                } else {

                    $("#equipe").hide();

                }
            }
        });
    }, 150);
}

function getIdade() {
    var parts = $('#datanascimento').val().split('/');
    var dataNascimento = new Date(parts[2], parts[1] - 1, parts[0]);

    var parts = $('#dataatual').val().split('/');
    var dataAtual = new Date(parts[2], parts[1] - 1, parts[0]);

    var idade = dataAtual.getFullYear() - dataNascimento.getFullYear();
    var m = dataAtual.getMonth() - dataNascimento.getMonth();
    if (m < 0 || (m = 0 && dataAtual.getDate() < dataNascimento.getDate())) {
        idade--;
    }
    return idade;
}

function exibeEstratificacaoCheckbox(idCheckbox, idDiv, idCampoRisco) {
    if ($("#" + idCheckbox).is(':checked')) {
        $("#" + idDiv).show();
    } else {
        $("#" + idDiv).hide();
        $("#" + idCampoRisco).val("");
    }
}

function exibeEstratificacaoIdade() {
    if($('#datanascimento').val()!= undefined && $('#datanascimento').val()!="") {
        if (getIdade() >= 60) {
            $("#estrat_idoso").show();
            $("#estrat_crianca").hide();
            $("#risco_crianca").val("");
        } else if (getIdade() < 12 && $('#usr_tipo_medico').val() !== 'P') {
            $("#estrat_idoso").hide();
            $("#risco_idoso").val("");
            $("#estrat_crianca").show();
        } else {
            $("#estrat_idoso").hide();
            $("#risco_idoso").val("");
            $("#estrat_crianca").hide();
            $("#risco_crianca").val("");
        }
    }
}

function exibeInfoPaciente() {
    if ($('#usu_codigo').val() == '') {
        $('#dados_paciente').hide();
    } else {
        $('#dados_paciente').show();
    }
}

function adicionaVacina(){
    var imunobiologico = $('#tvi_codigo option:selected').text();
    var tvi_codigo = $("#tvi_codigo").val();
    var hanseniase = ($("#tvi_codigo").val() == '15' ? $('#efv_hanseniase').val() : 'FALSE');
    var estrategia = $('#tve_codigo option:selected').text();
    var tve_codigo = $('#tve_codigo').val();
    var dose = $('#tvd_codigo option:selected').text();
    var tvd_codigo = $('#tvd_codigo').val();
    var lote = $('#tvd_lote').val();
    var fabricante = $('#tvd_fabricante').val();
    var quantidade = $('#quantidade').val();
    var proximo = parseInt(quantidade) + 1;

        $('#table_vacinas').append('' +
            '<tr id="fvv_codigo_'+proximo+'">' +
            '   <td class="ui-state-default">'+ imunobiologico  +
            '       <input type="hidden" name="fvv['+proximo+'][tvi_codigo]" value="'+tvi_codigo+'"/></td>'  +
            '       <input type="hidden" name="fvv['+proximo+'][efv_hanseniase]" value="'+hanseniase+'"/></td>'  +
            '   <td class="ui-state-default c">'+ estrategia+'</td>'  +
            '       <input type="hidden" name="fvv['+proximo+'][tve_codigo]" value="'+tve_codigo+'"/></td>'  +
            '   <td class="ui-state-default c">'+dose+'</td>'  +
            '       <input type="hidden" name="fvv['+proximo+'][tvd_codigo]" value="'+tvd_codigo+'"/></td>'  +
            '   <td class="ui-state-default c">' + lote +'</td>'       +
            '       <input type="hidden" name="fvv['+proximo+'][tvd_lote]" value="'+lote+'"/></td>'  +
            '   <td class="ui-state-default c">' + fabricante + '</td>' +
            '       <input type="hidden" name="fvv['+proximo+'][tvd_fabricante]" value="'+fabricante+'"/></td>'  +
            '   <td class="ui-state-default c">'+
            '       <a onclick="excluirVacinacao('+proximo+')">' +
            '       <img src="'+baseUrl+'/public/images/icons/excluir.png" alt="Excluir"' +
            '       title="Excluir"/>' +
            '       </a>' +
            '   </td>' +
            '</tr>');
        $('#fvv_codigo_0').remove();
        $('#quantidade').val(proximo);
        $('#tvd_lote').val("");
        $('#tvd_fabricante').val("");
}

function salvarVacinacao() {
    if($("#form_vacinacao").valid()) {
        var form = $('#form_vacinacao').serialize();
        $.ajax({
            url: baseUrl + "/programas-federais/ficha-vacinacao/salvar",
            type: "POST",
            data: form,
            success: function (txt) {
                if (txt.success) {
                    mensagem("Sucesso", "Dados salvos com sucesso!", 300, 150, function () {
                        if (txt.inconsistencia) {
                            window.location.replace(baseUrl + '/programas-federais/ficha-vacinacao/inconsistencias');
                        } else {
                            window.location.replace(baseUrl + '/programas-federais/ficha-vacinacao/index');
                        }
                    });
                } else {
                    mensagem("Erro", txt.mensagem, 300, 150);
                }
            }
        });
        return false;
    }
}

function excluirVacinacao(id,fvv_codigo){
    confirme("Atenção", "Deseja excluir esta vacinação?", 350, 150, function () {
        if(fvv_codigo){
            $.ajax({
                url: baseUrl + "/programas-federais/ficha-vacinacao/excluir-vacinacao/id/" + fvv_codigo,
                type: "GET",
                success: function(txt){
                    if(txt.success){
                        mensagem("Sucesso", "Vacinação excluída com sucesso!", 300, 150);
                        $('#fvv_codigo_'+id).remove();
                    } else{
                        mensagem("Erro",txt.mensagem, 300, 150);
                    }
                }
            });
        } else{
            mensagem("Sucesso", "Vacinação excluída com sucesso!", 300, 150);
            $('#fvv_codigo_'+id).remove();
        }
    });


}

function buscaEstrategia(tvi_codigo){
    $.ajax({
        url: baseUrl + "/programas-federais/ficha-vacinacao/buscar-estrategia-por-imunobiologico",
        type: "POST",
        data: {tvi_codigo:tvi_codigo},
        async:false,
        success: function(txt){
            $('#tve_codigo').removeProp("disabled");
            $('#tve_codigo option').remove();
            txt.forEach(function (element, index, array) {
                $('#tve_codigo').append(" <option value='"+element.tve_codigo+"'>"+element.tve_descricao+"</option>");
            })
        }
    });
    buscaDose($('#tve_codigo').val(), tvi_codigo);
}
function buscaDose(tve_codigo, tvi_codigo){
    $.ajax({
        url: baseUrl + "/programas-federais/ficha-vacinacao/buscar-dose-por-imunobiologico-estrategia",
        type: "POST",
        data: {tvi_codigo:tvi_codigo,
               tve_codigo:tve_codigo},
        success: function(txt){
            $('#tvd_codigo').removeProp("disabled");
            $('#tvd_codigo option').remove();
            txt.forEach(function (element, index, array) {
                $('#tvd_codigo').append(" <option value='"+element.tvd_codigo+"'>"+element.tvd_descricao+"</option>");
            })
        }
    });
}



