$(function (){
    $('#paramBusca').change(function(){
      (this.value == "competencia") ? $('#divCompetencia').css('display', 'block') : $('#divCompetencia').css('display', 'none');
      (this.value == "data") ? $('#divDatas').css('display', 'block') : $('#divDatas').css('display', 'none');
      (this.value == "protocolo") ? $('#divBuscaGenerica').css('display', 'block') : $('#divBuscaGenerica').css('display', 'none');
      (this.value == "tipoRegistro") ? $('#divTipoRegistro').css('display', 'block') : $('#divTipoRegistro').css('display', 'none');
    });
});

function enviarCompetencia(){
  var competencia = $('#competencia').val();

  if(!validaCompetencia(competencia)){
    return false;
  }

  $.ajax({
    url:baseUrl+"/programas-federais/horus/verificar-competencia-enviada",
    type: "POST",
    data:{
      competencia:competencia
    },
    success:function(msg) {
      if(msg == "true"){
        confirme("Atenção", "Já existem lotes dessa competência enviados, deseja enviar novamente?", 350, 170, function(){
          enviarPosicaoEstoqueEmLote(competencia);
        });
      }else{
        enviarPosicaoEstoqueEmLote(competencia);
      }
    }
  });
}

function validaCompetencia(competencia){
  if(competencia == "" || competencia == 'undefined'){
    mensagem("Atenção","Competência não informada!",300,150,function(){
      return false;
    });
    return false;
  }

  var arr = competencia.split("/");
  arr[0] = arr[0] - 1;
  var dataCompetencia = new Date(arr[1], arr[0]);
  var hoje = new Date(Date.now());

  if(dataCompetencia > hoje){
    mensagem("Atenção","Não é possível enviar um competência futura",300,150,function(){
      return false;
    });
    return false;
  }

  return true;
}

function enviarPosicaoEstoqueEmLote(competencia){
  mensagemSemOk("mensagem-envio-posicao-estoque", "Aguarde", "Enviando Produtos...", 280, 80);
  $.ajax({
    url:baseUrl+"/programas-federais/horus/enviar-posicao-estoque-em-lote",
    type: "POST",
    data:{
      competencia:competencia
    },
    success:function(msg) {
      fecharMensagemSemOk("mensagem-envio-posicao-estoque");
      mensagem("Atenção","Competência enviada! Consulte o log para mais informações",'auto', 'auto', function(){
        return false;
      });
    }
  });
}
