$(function () {

  // Pede para imprimir o atendimento
  $("#finalizar").click(function (e) {
    e.preventDefault();
    var url = $(this).attr("href");
    var ate = $(this).data("ate");
    var imprimir = $(this).data("imprimir");
    var ate_encaminhamento = $("#ate_encaminhamento").val();
    var ate_codigo = $("#ate_codigo").val();
    var ate_codigo_reavaliacao = $("#ate_codigo.ate-original").val();
    var usr_tipo_medico = $("#usr_tipo_medico").val();
    var pc = $("#pc").val();
    var age_atendido = $("#age_atendido").val();
    var age_codigo = $("#age_codigo").val();
    var condutas = [];
    var encaminhamentos = [];
    var condEncSelecionados = [];

    if (ate_codigo != '') {
      var somenteProcedimento = false;
      $.ajax({
        url: baseUrl + "/prontuario/atendimento/checa-somente-procedimento",
        data: {
          ate_codigo: ate_codigo
        },
        success: function (ret) {
          somenteProcedimento = (ret != true ? false : ret);
        }
      })
      $.ajax({
        url: baseUrl + "/prontuario/atendimento/get-condutas-encaminhamentos",
        data: {
          age_codigo: age_codigo
        },
        async: false,
        type: "GET",
        success: function (data) {
          var indexC = 0;
          var indexE = 0;

          data.forEach(function (value) {
            if (usr_tipo_medico != 'D') {
              if (value.co_cds_tipo_conduta == 1 ||
                value.co_cds_tipo_conduta == 2 ||
                value.co_cds_tipo_conduta == 3 ||
                value.co_cds_tipo_conduta == 9 ||
                value.co_cds_tipo_conduta == 12) {
                condutas[indexC++] = value;
              }
              else {
                encaminhamentos[indexE++] = value;
              }
            }
            else {
              if (value.co_cds_tipo_encam_odonto == 12 ||
                value.co_cds_tipo_encam_odonto == 13 ||
                value.co_cds_tipo_encam_odonto == 14 ||
                value.co_cds_tipo_encam_odonto == 15 ||
                value.co_cds_tipo_encam_odonto == 16 ||
                value.co_cds_tipo_encam_odonto == 17) {
                condutas[indexC++] = value;
              }
              else {
                encaminhamentos[indexE++] = value;
              }
            }
          });
        }
      });

      $.ajax({
        url: baseUrl + "/prontuario/atendimento/get-condutas-atendimento",
        data: {
          ate_codigo: ate_codigo
        },
        async: false,
        type: "GET",
        success: function (data) {
          condEncSelecionados = data;
        }
      });
    }

    $.ajax({
      url: baseUrl + "/prontuario/agenda-do-dia/verifica-status",
      data: {
        age_codigo: age_codigo
      },
      type: "GET",
      success: function (data) {
        if (data !== '') {
          mensagem("Atenção", data, 280, 150, function () {
            window.location.reload(true);
          });
        }
        else {
          if (ate_codigo == '') {
            criaModalFinalizarAtendimento(true, somenteProcedimento, condutas, encaminhamentos, condEncSelecionados, usr_tipo_medico);
          } else {
            criaModalFinalizarAtendimento(false, somenteProcedimento, condutas, encaminhamentos, condEncSelecionados, usr_tipo_medico);
          }

          $("#finalizar-dialog")
            .dialog({
              modal: true,
              width: 590,
              height: 225,
              close: function () {
                $(this).remove();
              },
              buttons:
                [{
                  id: "button-finalizar",
                  text: "Finalizar",
                  click: function () {
                    if (ate_codigo == '') {
                      finalizarAtendimento(age_codigo, usr_tipo_medico, ate_codigo, ate, imprimir, baseUrl);

                    }
                    else {
                      if ($("#conf_cond_ate").val() > 0 || somenteProcedimento) {
                        $("#label-conduta-obrigatoria").text('');
                        finalizarAtendimento(age_codigo, usr_tipo_medico, ate_codigo, ate, imprimir, baseUrl);

                      } else {
                        $("#label-conduta-obrigatoria").text('Campo Obrigatório.');
                      }
                    }
                  }
                },
                {
                  id: "button-retorno",
                  text: "Reavaliar",
                  click: function () {
                    if ($("#conf_cond_ate").val() > 0) {
                      $("#label-conduta-obrigatoria").text('');
                      $.removeCookie("ate_reclamacao");
                      $.removeCookie("ate_exame_fisico");
                      $.removeCookie("ate_diagnostico");
                      $.removeCookie("ate_tratamento");
                      $.removeCookie("ate_reclamacao");

                      $.ajax({
                        url: baseUrl + "/prontuario/agenda-do-dia/retorno",
                        data: {
                          age: age_codigo,
                          retorno: "S",
                          ate_codigo: ate_codigo,
                          tipoMedico: usr_tipo_medico,
                          condutas: $("#form-conduta").serializeArray()

                        },
                        type: "GET",
                        success: function () {
                          location.href = baseUrl + "/prontuario/agenda-do-dia";
                        }
                      });
                      $(this).dialog("close");
                    } else {
                      $("#label-conduta-obrigatoria").text('Campo Obrigatório.');
                    }
                  }
                },
                {
                  id: "button-cancelar",
                  text: "Cancelar",
                  click: function () {
                    $(this).dialog("close");
                  }
                }]
            });

          if (pc == "S" && ate_encaminhamento == "") {
            $("#button-retorno").hide();
          }
        }
      }
    })
  });

  $("#cancelar").click(function (e) {
    e.preventDefault();
    var age_codigo = $("#age_codigo").val();
    var ate = $(this).data("ate");

    $("body").append("<div id='cancelar-dialog' title='Cancelar'>"
      + "  Deseja realmente cancelar este atendimento?"
      + "  <br>");

    $("#cancelar-dialog").dialog({
      modal: true,
      width: 330,
      height: 225,
      close: function () {
        $(this).remove();
      },
      buttons: [
        {
          id: "button-cancelar",
          text: "Cancelar Atendimento",
          click: function () {
            $.ajax({
              url: baseUrl + "/prontuario/index/cancelar",
              data: {
                age: age_codigo
              },
              type: "GET",
              success: function () {
                if (typeof ate != "undefined") {
                  $.cookie("ate_reclamacao", "");
                  $.cookie("ate_exame_fisico", "");
                  $.cookie("ate_diagnostico", "");
                  $.cookie("ate_tratamento", "");
                  $.cookie("ate_curativo", "");

                  $.removeCookie("ate_reclamacao");
                  $.removeCookie("ate_exame_fisico");
                  $.removeCookie("ate_diagnostico");
                  $.removeCookie("ate_tratamento");
                  $.removeCookie("ate_reclamacao");
                }
                $(this).dialog('close');
                window.location.href = baseUrl + "/prontuario/agenda-do-dia";
              }
            });
          }
        },
        {
          id: "button-voltar",
          text: "Voltar",
          click: function () {
            $(this).dialog("close");
          }
        }
      ]
    });
  });
});

function buscaEspecialidadeEncaminhamento() {
  var usr_codigo = $('#usr_codigo_enc option:selected').val();
  $('#esp_codigo_enc').html("");
  $.ajax({
    url: baseUrl + '/default/usuarios/get-especialidade-encaminhamento/usr/' + usr_codigo,
    success: function (txt) {
      txt.forEach(function (data) {
        $('#esp_codigo_enc').append(
          '<option value="' + data.esp_codigo + '">' + data.esp_nome + '</option>'
        )
      });
      buscaProcedimentoEncaminhamento()
    }
  });
}

function buscaProcedimentoEncaminhamento() {
  var esp_codigo = $('#esp_codigo_enc option:selected').val();
  $('#proc_codigo_enc').html("");
  $.ajax({
    url: baseUrl + '/default/usuarios/get-procedimento-encaminhamento/esp/' + esp_codigo,
    success: function (txt) {
      txt.forEach(function (data) {
        $('#proc_codigo_enc').append(
          '<option value="' + data.proc_codigo + '">' + data.proc_nome + '</option>'
        )
      });

    }
  });
}

function finalizarAtendimento(age_codigo, usr_tipo_medico, ate_codigo, ate, imprimir, baseUrl) {

  var enc_interno = $('#enc_interno').val();

  if (enc_interno != undefined && enc_interno != '') {
    let usr_enc = $('#usr_codigo_enc option:selected').val();
    let esp_enc = $('#esp_codigo_enc option:selected').val();
    let proc_enc = $('#proc_codigo_enc option:selected').val();

    if (usr_enc == '' || esp_enc == '' || proc_enc == '') {
      mensagem("Atenção", "Profissional, Especialidade e Procedimento são obrigatórios!", 300, 150, function () {
        return false;
      });
      return false;
    }
  }

  $.ajax({
    url: baseUrl + "/prontuario/agenda-do-dia/finalizar",
    data: {
      age: age_codigo,
      tipoMedico: usr_tipo_medico,
      ateCodigo: ate_codigo,
      condutas: $("#form-conduta").serializeArray(),
      encaminhamento: $('#form-encaminhamento').serializeArray()
    },
    type: "POST",
    success: function () {
      if (typeof ate != "undefined") {
        $.cookie("ate_reclamacao", "");
        $.cookie("ate_exame_fisico", "");
        $.cookie("ate_diagnostico", "");
        $.cookie("ate_tratamento", "");
        $.cookie("ate_curativo", "");

        $.removeCookie("ate_reclamacao");
        $.removeCookie("ate_exame_fisico");
        $.removeCookie("ate_diagnostico");
        $.removeCookie("ate_tratamento");
        $.removeCookie("ate_reclamacao");
      }
      // Exibindo nome do dente
      if (imprimir) {
        $("body").append("<div id=\"imprimi-dialog\" title=\"Impressão de Prontuário\"></div>");
        $("#imprimi-dialog")
          .html("Deseja realmente finalizar e imprimir este atendimento?")
          .dialog({
            modal: true,
            width: 400,
            height: 160,
            buttons: {
              Sim: function () {
                popup(baseUrl + "/prontuario/ficha/atendimento/ate/" + ate, "imprimir-atendimento", 835, 500);
                location.href = baseUrl + "/prontuario/agenda-do-dia";
              },
              Não: function () {
                location.href = baseUrl + "/prontuario/agenda-do-dia";
              }
            }
          });
      }
      else {
        window.location.href = baseUrl + "/prontuario/agenda-do-dia";
      }
    }
  });
}

function criaModalFinalizarAtendimento(preConsulta, somenteProcedimento, condutas, encaminhamentos, condEncSelecionados, usr_tipo_medico) {

  var age_codigo = $('#age_codigo').val();
  var tipo_consulta = '';

  //Checa o tipo de agendamento, para bloquear determinadas opções de conduta.
  $.ajax({
    url: baseUrl + "/prontuario/atendimento/checa-tipo-agendamento-odonto/age_codigo/" + age_codigo,
    async: false,
    success: function (tipo) {
      tipo_consulta = tipo;
    }
  });

  if (preConsulta || somenteProcedimento) {
    $("body").append("<div id='finalizar-dialog' title='Finalizar'>"
      + "  Deseja realmente finalizar este atendimento?"
      + "  <br>");
  }
  else {
    $("body").append("<div id='finalizar-dialog' title='Finalizar'>"
      + "  Deseja realmente finalizar este atendimento?"
      + "  <br>"
      + "  <div style='margin-left: -5px;' class='f'>"
      + "    <fieldset style='width: 540px; float: left; margin-left: 6px;' id='fieldset-conduta'>"
      + "      <legend id='legend-conduta'>Conduta"
      + "        <input type='hidden' name='conf_cond_ate' id='conf_cond_ate' value='" + condEncSelecionados.length + "'/>"
      + "        <label class='error' id='label-conduta-obrigatoria'></label>"
      + "      </legend>"
      + "      <form id='form-conduta' method='post'>"
      + "        <div id='conduta_ate'>"
      + montaHtmlCondutaEncaminhamento(condutas, usr_tipo_medico, condEncSelecionados, tipo_consulta)
      + "          <fieldset>"
      + "            <legend>Encaminhamento</legend>"
      + montaHtmlCondutaEncaminhamento(encaminhamentos, usr_tipo_medico, condEncSelecionados, tipo_consulta)
      + "          </fieldset>"
      + "        </div>"
      + "      </form>"
      + "    </fieldset>"
      + "  </div>");
  }
}

function montaHtmlCondutaEncaminhamento(obj, tipoMedico, condEncSelecionados, tipoConsulta) {
  var html = '';

  obj.forEach(function (value, index) {
    var checked = false;
    var disabled = false;

    condEncSelecionados.forEach(function (data) {

      if (tipoMedico != 'D') {
        if (data.tp_cds_conduta == value.co_cds_tipo_conduta) {
          checked = true;
          return true;
        }
      } else {
        if (data.tp_cds_encam_odonto == value.co_cds_tipo_encam_odonto) {
          checked = true;
          return true;
        }
      }
    });

    /* A opção 15 - Tratamento concluído só pode ser selecionada se no campo tiposConsultaOdonto for selecionada uma
     das opções 1 - Primeira consulta odontológica programática ou 2 - Consulta de retorno em odontologia. */
    if (tipoMedico == 'D' && (tipoConsulta != 1 && tipoConsulta != 2) && value.co_cds_tipo_encam_odonto == 15) {
      disabled = true;
    }

    /* A opção 17 - Alta do episódio não pode ser selecionada se no campo tiposConsultaOdonto for selecionada uma
    das opções 1 - Primeira consulta odontológica programática ou 2 - Consulta de retorno em odontologia. */
    if (tipoMedico == 'D' && (tipoConsulta == 1 || tipoConsulta == 2) && value.co_cds_tipo_encam_odonto == 17) {
      disabled = true;
    }

    html += "<input type='checkbox' name='conduta_ind[]' value='" + (tipoMedico != 'D' ? value.co_cds_tipo_conduta : value.co_cds_tipo_encam_odonto) + "' "
      + " onclick='validaTipoCondutaAte()'" + (checked ? "checked='checked'" : "") + (disabled ? "disabled='disabled'" : "") + "/>"
      + "<label class='not'>" + (tipoMedico != 'D' ? value.no_cds_tipo_conduta : value.no_cds_tipo_encam_odonto) + "</label>"
      + "<br>";
  });

  return html;
}

function validaTipoCondutaAte() {
  var cont = 0;
  var enc = 0;
  const DENTISTA = "D";

  if($("#usr_tipo_medico").val() == DENTISTA)
    return;

  $("#conduta_ate").find("input[type=checkbox][name='conduta_ind[]']:checked").each(function () {
    if ($(this).val()) {
      cont++;
    }
    if ($(this).val() == 11) {
      enc++;
    }
  });
  if (enc > 0) {
    var profissionais = null;
    $.ajax({
      url: baseUrl + '/default/usuarios/get-profissional-encaminhamento',
      async: false,
      success: function (txt) {
        profissionais = txt;
      }
    });
    $("#button-retorno").hide();
    var append = "";
    append += '   <fieldset id="encaminhamento-interno">'
      + '       <legend> Encaminhamento Interno</legend>'
      + '       <form id="form-encaminhamento">'
      + '       <div style="padding-bottom: 3px">'
      + '          <input type="hidden" id="enc_interno" name="enc_interno" value="1">'
      + '       <label style="width: 20%">Profissional:<span class="obrigatorio">*</span></label>'
      + '       <select name="usr_codigo_enc" id="usr_codigo_enc" onchange="buscaEspecialidadeEncaminhamento()" style="width: 75%">'
      + '          <option value="">Selecione um Profissional.</option>';
    profissionais.forEach(function (data) {
      append += '<option value="' + data.usr_codigo + '">' + data.usr_nome + '</option>';
    });
    append += '    </select></div><div style="padding-bottom: 3px">'
      + '    <label style="width: 20%">Especialidade:<span class="obrigatorio">*</span> </label>'
      + '    <select name="esp_codigo_enc" id="esp_codigo_enc" onchange="buscaProcedimentoEncaminhamento()" style="width: 75%">'
      + '       <option value="">Selecione um Profissional.</option>'
      + '    </select></div><div style="padding-bottom: 3px">'
      + '   <label style="width: 20%">Procedimento:<span class="obrigatorio">*</span></label>'
      + '   <select name="proc_codigo_enc" id="proc_codigo_enc" style="width: 75%">'
      + '       <option value=""> Selecione uma Especialidade.</option>'
      + '   </select></div>'
      + '</form></fieldset>';


    $('#fieldset-conduta').append(append);

  } else {
    $("#button-retorno").show();
    $('#encaminhamento-interno').remove();
  }

  if (cont == 0) {
    $("#conf_cond_ate").val("");
  } else {
    $("#conf_cond_ate").val(cont);
  }
}

function trim(str) {
  if (str != null) {
    return str.replace(/^\s+|\s+$/g, "");
  }
}

function chamar(age_codigo) {
  $.ajax({
    url: baseUrl + "/guiche/chamar/",
    data: {
      age_codigo: age_codigo
    },
    type: "GET",
    success: function (txt) {
    }
  });
}

function faltou(age_codigo) {
  $.ajax({
    url: baseUrl + "/guiche/faltou/",
    data: {
      age_codigo: age_codigo
    },
    type: "GET",
    success: function (txt) {
      console.log(txt);
    },
    error: function (txt) {
      console.log(txt);
    }
  });
}

function limparCookies() {
  $.cookie("ate_reclamacao", ' ', -1);
  $.cookie("ate_exame_fisico", ' ', -1);
  $.cookie("ate_diagnostico", ' ', -1);
  $.cookie("ate_tratamento", ' ', -1);
  $.cookie("ate_curativo", ' ', -1);
}


