$(function () {
    setInterval(function () {
        if ($('#atualiza_pagina').val() == 'true') {
            window.location = baseUrl + "/prontuario/agenda-do-dia";
        }
    }, 60000);

    $("#ate_data").mask("99/99/9999");
    $("#buscar_paciente").buscar({
        url: baseUrl + '/paciente/buscar/',
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (event, ui) {
            return true;
        }
    });
    $("#buscar_medico").buscar({
        url: baseUrl + '/default/usuarios/buscar/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });
});

function buscaProfissional(tipo_atend, uni_codigo) {
    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar/tipo/' + tipo_atend + '/unidade/' + uni_codigo + '/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function iniciarAge(cod) {
    window.location = baseUrl + "/prontuario/index/iniciar/cod/" + cod;
}

function verAte(cod) {
    window.location = baseUrl + "/prontuario/atendimento/ver/age/" + cod;
}

function verificaStatusAtendimento(cod, ate_codigo, espec, id_login){
    $.cookie("ate_reclamacao", ' ', -1);
    $.cookie("ate_exame_fisico", " ");
    $.cookie("ate_diagnostico", " ");
    $.cookie("ate_tratamento", " ");
    $.cookie("ate_curativo", " ");
    if(espec !== 'null'){
        $('#atualiza_pagina').val('false');
        mensagemSemOk("carregando-ate", "Aguarde", "Carregando prontuário...", 280, 80);
        $.ajax({
            url: baseUrl + '/prontuario/atendimento/verifica-status-atendimento',
            type: "POST",
            data: {
                age_codigo: cod,
                ate_codigo: ate_codigo
            },
            success: function (txt) {
                if(txt !== null){
                    fecharMensagemSemOk("carregando-ate");
                    mensagem("Atenção", "Atendimento já está sendo realizado pelo profissional " + txt);
                } else {
                    verificaSeEstaEmAtendimento(cod, ate_codigo, id_login);
                }
            },
            error: function (pq) {
                alert(JSON.stringify(txt));
            }
        });
    }else{
        confirme("Atenção",
            "É necessário informar a <b>ESPECIALIDADE</b> no login para acessar este módulo.\n" +
            "Deseja efetuar o login novamente?", 300, 150, function () {
                window.open(baseUrl + '/login/logout?id_login='+id_login, '_self');
            }
        );
    }
}

function verificaSeEstaEmAtendimento(cod, ate_codigo) {
    $.ajax({
        url: baseUrl + '/prontuario/atendimento/verificaseestaematendimento',
        type: "POST",
        data: {
            age_codigo: cod,
            ate_codigo: ate_codigo
        },
        success: function (txt) {
            if (txt == 2) {
                window.location = baseUrl + "/prontuario/agenda-do-dia/index/pacem/s";
            } else {
                window.location = baseUrl + "/prontuario/index/iniciar/cod/" + cod;
            }
        },
        error: function (pq) {
            $('#atualiza_pagina').val('true');
            alert(pq)
        }
    });
}

function recuperaAtendimento(event, cod, ate_codigo, usu_atend, id_login) {
    if(event.target.id == ''){
        if(usu_atend === id_login){
            $.ajax({
                url: baseUrl + '/prontuario/atendimento/recuperaatendimento',
                type: "POST",
                data: {
                    age_codigo: cod,
                    ate_codigo: ate_codigo,
                    id_login: id_login
                },
                success: function (txt) {
                    if (txt == 2) {
                        window.location = baseUrl + "/prontuario/agenda-do-dia/index/pacem/s";
                    } else {
                        window.location = baseUrl + "/prontuario/index/iniciar/cod/" + cod;
                    }
                },
                error: function (pq) {
                    $('#atualiza_pagina').val('true');
                    alert(pq)
                }
            });
        } else {
            mensagem("Atenção", "Transfira ou Extorne o atendimento!");
        }
    }
}

/******* Em Atendimento *******/
function tranferirProfissional(age_codigo, medico_origem_id, medico_origem_desc, age_item, age_status){
    $('#atualiza_pagina').val('false');
    var dlg = $( "#dialog-tranferencia" )
        .dialog({
        modal: true,
        autoOpen: false,
        height: 'auto',
        width: 500,
        resizable: false,
        buttons: {
            Cancel: {
                text: "Não Transferir",
                click: function() {
                    $( this ).dialog('close');
                    $('#atualiza_pagina').val('true');
                    reiniciaRefresh();
                }
            },
            Ok: {
                text: "Tranferir",
                click: transfererirAgendamento
            }
        },
        close: function() {
            $( this ).dialog('close');
            $('#atualiza_pagina').val('true');
            reiniciaRefresh();
        }
    });
    if(age_item !== 'AL' || age_status === 'EM' || age_status === 'A'){
        mensagem("Atenção", "Este atendimento não pode ser transferido!");
        $('#atualiza_pagina').val('true');
    }else{
        dlg.dialog( "open" );

        $("#trans_age_codigo").val(age_codigo);
        $("#trans_pro_origem_desc").val(medico_origem_desc);
        $("#trans_pro_origem_id").val(medico_origem_id);
        $("#age_status").val(age_status);
    }
}

function transfererirAgendamento() {
    var age_codigo = $("#trans_age_codigo").val();
    var id_pro_origem = $("#trans_pro_origem_id").val();
    var id_pro_destino = $("#usr_codigo").val();
    var motivo_transferencia = $("#trans_motivo").val();
    var age_status = $("#age_status").val();

    if(id_pro_origem !== id_pro_destino){
        mensagemSemOk("carregando-trans", "Aguarde", "Transferindo profissional...", 280, 80);
        $.ajax({
            url: baseUrl + '/prontuario/atendimento/transferir-profissional',
            type: "POST",
            data: {
                age_codigo: age_codigo,
                age_status: age_status,
                pro_origem: id_pro_origem,
                pro_destino: id_pro_destino,
                motivo: motivo_transferencia,
                tipo: "T"
            },
            success: function (txt) {
                fecharMensagemSemOk("carregando-trans");
                $( "#dialog-tranferencia" ).remove();
                window.location.reload(true);
                $('#atualiza_pagina').val('true');
                reiniciaRefresh();
            },
            error: function (pq) {
                $('#atualiza_pagina').val('true');
                reiniciaRefresh();
                alert(pq)
            }
        });
    }else{
        mensagem("Erro", "O Profissional de Destino não pode ser o mesmo que o Profissional de Origem!");
    }
}

function liberarPaciente(age_codigo){
    mensagemSemOk("carregando-trans", "Aguarde", "Liberando Atendimento...", 280, 80);
    $.ajax({
        url: baseUrl + '/prontuario/index/liberar/age/' + age_codigo,
        type: "POST",
        data: {
            age_codigo: age_codigo
        },
        success: function (txt) {
            fecharMensagemSemOk("carregando-trans");
            parent.location.reload();
        },
        error: function (pq) {
            // $('#atualiza_pagina').val('true');
            alert(pq)
        }
    });
}

function reiniciaRefresh() {
    setInterval(function () {
        if ($('#atualiza_pagina').val() == 'true') {
            window.location.reload();
        }
    }, 60000);
}