var atend = 0;
$(function () {
    var codPaciente = $('#usu_codigo').val();

    setTimeout(function(){
        carregarDadosEstratificacao(codPaciente);
    }, 500);

    $("#erro_cid_ciap").hide();

    //alert(codPaciente);


    if ($("#ate_somente_procedimento").val() == "t") {
        somenteProcedimento();
    }

    if ($("#uni_tipo").val() == "H") {
        somenteProcedimento();
    }
    // Validação se for dentista, preenche os campos CIAP e conduta qie não usado pelo dentista
    if ($("#usr_tipo_medico").val() == "D") {
        $("#conf_ciap").val("1");
        $("#conf_cond_ate").val("1");
        // Validação se não for dentista, já seta os campos dele como preenchido
    } else {
        // Preenchendo conduta e vigilância de saúde bucal
        $("#conf_vig").val("1");
        $("#conf_cond").val("1");
    }

    $.validator.addMethod("ate_reclamacao", function (ate_reclamacao, element) {
        if ($("#ate_reclamacao").val() == "") {
            return false;
        } else {
            return true;
        }
    }, "Campo Obrigatório");


    $("#form-atendimento").validate({
        rules: {
            ate_reclamacao: {ate_reclamacao: true},
            conf_cond: {required: true},
            conf_vig: {required: true},
            conf_ciap: {
                required: function () {
                    selecionarTodosOsCiapSelecionados();
                    if ($("#ciap-selecionados option:first").val() != '0' && $("#ciap-selecionados option:first").val() != undefined) {
                        $("#erro_cid_ciap").html('');
                        $("#erro_cid_ciap").hide();
                        return false;
                    } else {
                        if (atend > 0) {
                            $("#erro_cid_ciap").html('');
                            $("#erro_cid_ciap").hide();
                            return false;
                        } else {
                            $("#erro_cid_ciap").html('Selecione um CID atendimento ou CIAP.');
                            $("#erro_cid_ciap").show();
                        }
                    }
                    return true;
                }
            },
            conf_cond_ate: {required: true},
        },
        messages: {
            ate_reclamacao: {required: "Campo Obrigatório."},
            conf_cond: {required: "Campo Obrigatório."},
            conf_vig: {required: "Campo Obrigatório."},
            conf_ciap: {required: "Campo Obrigatório."},
            conf_cond_ate: {required: "Campo Obrigatório."}
        }
    });

    $("#ds_ciap").buscar({

        url: baseUrl + '/prontuario/atendimento/buscar-ciap/',
        suffix: '_2',
        search: function () {
            $("#ciap").empty();
        },
        template: function (ul, item) {
            ul.hide();
            $("<option />").val(item.id).html(item.label).appendTo("#ciap");
            return false;
        },
        callback: function (event, ui) {
            $("#ciap").focus();
        }

    });

    if ($("#ate_codigo").val() != "") {
        carregaCid($("#ate_codigo").val());
    }

    $("#ciap")
        .bind('dblclick', selecionarCiap)
        .bind('keydown', selecionarCiap);

    $("#ciap-selecionados")
        .bind('dblclick', deselecionarCiap)
        .bind('keydown', deselecionarCiap);

    $("#form-unico").validate({
        rules: {
            cd10_codigo: {
                required: true
            }
        },
        messages: {
            cd10_codigo: {
                required: "Campo Obrigatório"
            }
        }
    });

    $('textarea.tinymce_atendimento').tinymce({
        script_url: '/WebSocialSaude/zf/public/js/tiny_mce.js',
        theme: "advanced",
        setup: function (ed) {
            ed.onKeyUp.add(function (ed, l) {
                $.cookie("ate_reclamacao", $("#ate_reclamacao").val(), {expires: 10});
                $.cookie("ate_exame_fisico", $("#ate_exame_fisico").val(), {expires: 10});
                $.cookie("ate_diagnostico", $("#ate_diagnostico").val(), {expires: 10});
                $.cookie("ate_tratamento", $("#ate_tratamento").val(), {expires: 10});
                $.cookie("ate_curativo", $("#ate_curativo").val(), {expires: 10});
            });
        },
        skin: "o2k7",
        //plugins : "pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template",

        // Theme options
        theme_advanced_buttons1: "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,fontselect,fontsizeselect",
        theme_advanced_buttons2: "",
        theme_advanced_buttons3: "",
        theme_advanced_buttons4: "",
        theme_advanced_toolbar_location: "top",
        theme_advanced_toolbar_align: "left",
        theme_advanced_statusbar_location: "bottom",
        theme_advanced_resizing: true
    });

    $("#ver-mais-pre-consultas").click(verMaisPreConsultas);

    $(".pre-consulta").click(function () {
        var pc_codigo = $(this).data("pc");
        $("body").append("<div id=\"pre-consulta-dialog\" title=\"Pré-Consulta\" />");
        $("#pre-consulta-dialog")
            .html(imgCarregando())
            .load(baseUrl + "/prontuario/pre-consulta/ver/id/" + pc_codigo + "/sem-layout/1", function () {
                megaBind("#pre-consulta-dialog");
            })
            .dialog({
                modal: true,
                width: 610,
                height: 500,
                close: function () {
                    $(this).remove();
                },
                buttons: {
                    Ok: function () {
                        $(this).dialog('close');
                    }
                }
            });
    });

    $(".enfermagem").click(function() {
      var pe_codigo = $(this).data("pc");

      $("body").append('<div id="posto-enfermagem-dialog" title="Posto de Enfermagem"/>');
      $('#posto-enfermagem-dialog')
        .html(imgCarregando())
        .load(baseUrl + "/prontuario/enfermagem/ver-posto/cod/" + pe_codigo + "/sem-layout/1", function () {
          megaBind("#posto-enfermagem-dialog");
        })
        .dialog({
          modal: true,
          width: 560,
          height: 500,
          close: function () {
            $(this).remove();
          },
          buttons: {
            Ok: function () {
              $(this).dialog('close');
            }
          }
        });
    });

    //scrollpane parts
    var scrollPane = $(".scroll-pane"),
        scrollContent = $(".scroll-content");

    //build slider
    var scrollbar = $(".scroll-bar").slider({
        slide: function (event, ui) {
            if (scrollContent.width() > scrollPane.width()) {
                scrollContent.css("margin-left", Math.round(
                    ui.value / 100 * (scrollPane.width() - scrollContent.width())
                ) + "px");
            } else {
                scrollContent.css("margin-left", 0);
            }
        }
    });

    //append icon to handle
    var handleHelper = scrollbar.find(".ui-slider-handle")
        .mousedown(function () {
            scrollbar.width(handleHelper.width());
        })
        .mouseup(function () {
            scrollbar.width("100%");
        })
        .append("<span class='ui-icon ui-icon-grip-dotted-vertical'></span>")
        .wrap("<div class='ui-handle-helper-parent'></div>").parent();

    //change overflow to hidden now that slider handles the scrolling
    scrollPane.css("overflow", "hidden");

    //size scrollbar and handle proportionally to scroll distance
    function sizeScrollbar() {
        var remainder = scrollContent.width() - scrollPane.width();
        var proportion = remainder / scrollContent.width();
        var handleSize = scrollPane.width() - (proportion * scrollPane.width());
        scrollbar.find(".ui-slider-handle").css({
            width: handleSize,
            "margin-left": -handleSize / 2
        });
        handleHelper.width("").width(scrollbar.width() - handleSize);
    }

    //reset slider value based on scroll content position
    function resetValue() {
        var remainder = scrollPane.width() - scrollContent.width();
        var leftVal = scrollContent.css("margin-left") === "auto" ? 0 :
            parseInt(scrollContent.css("margin-left"));
        var percentage = Math.round(leftVal / remainder * 100);
        scrollbar.slider("value", percentage);
    }

    function selecionarCiap(e) {
        $("#conf_ciap").val("1");
        // só pode ser a tecla 39 (seta para direita)
        if (e.keyCode && e.keyCode != 39 || e.charCode)
            return;

        if (!$("#ciap option:selected").size())
            return;

        // se o primeiro for 0, limpar select
        if ($("#ciap-selecionados option:first").val() == "0") {
            $("#ciap-selecionados").empty();
        }

        // add
        $("#ciap-selecionados").append(
            $("#ciap option:selected")
        );

    }

    function deselecionarCiap(e) {

        // só pode ser a tecla 39 (seta para esquerda)

        if (e.keyCode && e.keyCode != 37 || e.charCode)
            return;

        // remover
        $("#ciap-selecionados option:selected").remove();

        // se não houver mais opções, add "Nenhum"
        if ($("#ciap-selecionados option").size() == 0) {
            $("#ciap-selecionados").empty().append('<option value="0" disabled="disabled">Nenhum ciap selecionado</option>');
            $("#conf_ciap").val("");
        }

    }

    //if the slider is 100% and window gets larger, reveal content
    function reflowContent() {
        var showing = scrollContent.width() + parseInt(scrollContent.css("margin-left"), 10);
        var gap = scrollPane.width() - showing;
        if (gap > 0) {
            scrollContent.css("margin-left", parseInt(scrollContent.css("margin-left"), 10) + gap);
        }
    }

    //change handle position on window resize
    $(window).resize(function () {
        resetValue();
        sizeScrollbar();
        reflowContent();
    });
    //init scrollbar size
    setTimeout(sizeScrollbar, 10);//safari wants a timeout

});

function trim(str) {
    if (str != null) {
        return str.replace(/^\s+|\s+$/g, "");
    }
}

function selecionarTodosOsCiapSelecionados() {
    var optionlist = document.getElementById('ciap-selecionados').options;
    var ciap = 0;
    for (var option = 0; option < optionlist.length; option++) {
        optionlist[option].selected = true;
        ciap++;
    }
}

var codsCid = "";

function carregaCid(codAtend) {
    $.ajax({
        url: baseUrl + "/atendimento/atendimento-simplificado/lista-cids-atendimento",
        type: "POST",
        data: {
            codAtend: codAtend
        },
        success: function (txt) {
            $(".tb_cids").show();
            if (txt["cd10_codigo"] != null) {
                $(".tb_cids").append("<tr class='tb_cids_" + txt["cd10_codigo"] + "'>\n\
                                         <td>\n\
                                             " + (txt["cd10_codigo_desc"].indexOf(txt["cd10_codigo_cid"]) == "-1" ? txt["cd10_codigo_cid"] : "") + " " + txt["cd10_codigo_desc"] + "\n\
                                             <input type='hidden' name='cid_codigo[]' value='" + txt["cd10_codigo"] + "' /> \n\
                                         </td>\n\
                                         <td>\n\
                                             <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCidBanco(" + txt["cd10_codigo"] + ")\" \>\n\
                                         </td>\n\
                                     </tr>");
            }
            if (txt["cd10_codigos"] != null) {
                $(".tb_cids").append("<tr class='tb_cids_" + txt["cd10_codigos"] + "'>\n\
                                         <td>\n\
                                             " + (txt["cd10_codigos_desc"].indexOf(txt["cd10_codigos_cid"]) == "-1" ? txt["cd10_codigos_cid"] : "") + " " + txt["cd10_codigos_desc"] + "\n\
                                             <input type='hidden' name='cid_codigo[]' value='" + txt["cd10_codigos"] + "' /> \n\
                                         </td>\n\
                                         <td>\n\
                                             <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCidBanco(" + txt["cd10_codigos"] + ")\" \>\n\
                                         </td>\n\
                                     </tr>");
            }
            if (txt["cd10_codigot"] != null) {
                $(".tb_cids").append("<tr class='tb_cids_" + txt["cd10_codigot"] + "'>\n\
                                         <td>\n\
                                             " + (txt["cd10_codigot_desc"].indexOf(txt["cd10_codigot_cid"]) == "-1" ? txt["cd10_codigot_cid"] : "") + " " + txt["cd10_codigot_desc"] + "\n\
                                             <input type='hidden' name='cid_codigo[]' value='" + txt["cd10_codigot"] + "' /> \n\
                                         </td>\n\
                                         <td>\n\
                                             <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCidBanco(" + txt["cd10_codigot"] + ")\" \>\n\
                                         </td>\n\
                                     </tr>");
            }

        }
    });
}

var metodo = "";

function buscaCid() {
    if ($("#ate_codigo").val() != "") {
        metodo = adicionaCidBanco;
    } else {
        metodo = adicionaCid;
    }

    $("#buscar").buscar({
        url: baseUrl + '/prontuario/cid/buscar/',
        delay: 10,
        minLength: 3,
        template: function (ul, item) {
            return $("<li></li>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: metodo
    });
}

//var num_registros = 0;
function adicionaCidBanco() {
    var nomeCid = $("#buscar").val();
    var codCid = $("#cd10_codigo").val();
    if ($(".tb_cids_" + $("#cd10_codigo").val()).length == 0) {
        if ($('.tb_cids tr').length < 3) {
            $.ajax({
                url: baseUrl + "/atendimento/atendimento-simplificado/atualizar-cids/",
                type: "POST",
                data: {
                    ate_codigo: $("#ate_codigo").val(),
                    cd10_codigo: $("#cd10_codigo").val()
                },
                success: function (txt) {
                    var template = "<tr class='tb_cids_" + $("#cd10_codigo").val() + "'>"
                                +   "<td>"
                                +     (nomeCid.indexOf(codCid) == "-1" ? codCid : "") + " " + nomeCid
                                +   " <input type='hidden' name='cid_codigo[]' value='" + $("#cd10_codigo").val() + "'/>"
                                +   "</td>"
                                +   "<td>"
                                +   "   <img style='cursor:pointer;' src='" + baseUrl + "/public/images/icons/excluir2.png'"
                                +   "        onClick='excluiCid(" + $("#cd10_codigo").val() + ")'\>"
                                +   "</td>"
                                + "</tr>";
                    $(".tb_cids").show();
                    $(".tb_cids").css('border', '1px solid #CDDEF2');
                    $(".tb_cids").append(template);
                    atend++;
                }
            });
        } else {
            $(".ui-state-error").remove();
            $("#erro").prepend("<span class='ui-state-error'>Máximo de 3 CID(s) por atendimento!</span>");
        }
    }
    $("#buscar").val("");
}

function excluiCidBanco(cidCodigo) {
    $.ajax({
        url: baseUrl + "/atendimento/atendimento-simplificado/excluir-cids/",
        type: "POST",
        data: {
            ate_codigo: $("#ate_codigo").val(),
            cd10_codigo: cidCodigo
        },
        success: function (txt) {
            $(".ui-state-error").remove();
            $(".tb_cids_" + cidCodigo).remove();
            if ($('.tb_cids tr').length == 0) {
                $(".tb_cids").hide();
            }
            atend--;
        }
    });

}


//var num_registros = 0;
function adicionaCid() {
    var nomeCid = $("#buscar").val();
    var codCid = $("#cd10_codigo").val();
    if ($(".tb_cids_" + $("#cd10_codigo").val()).length == 0) {
        if ($('.tb_cids tr').length < 3) {
            $(".tb_cids").show();
            $(".tb_cids").css('border', '1px solid #CDDEF2');
            $(".tb_cids").append("<tr class='tb_cids_" + $("#cd10_codigo").val() + "'>\n\
                                    <td>\n\
                                        " + (nomeCid.indexOf(codCid) == "-1" ? codCid : "") + " " + nomeCid + "\n\
                                        <input type='hidden' name='cid_codigo[]' value='" + $("#cd10_codigo").val() + "' /> \n\
                                    </td>\n\
                                    <td>\n\
                                        <img style=\"cursor:pointer;\" src='" + baseUrl + "/public/images/icons/excluir2.png' onClick=\"excluiCid(" + $("#cd10_codigo").val() + ")\" \>\n\
                                    </td>\n\
                                </tr>");
            atend++;
        } else {
            $(".ui-state-error").remove();
            $("#erro").prepend("<span class='ui-state-error'>Máximo de 3 CID(s) por atendimento!</span>");
        }
    }
    $("#buscar").val("");
}

function excluiCid(cidCodigo) {
    $(".ui-state-error").remove();
    $(".tb_cids_" + cidCodigo).remove();
    if ($('.tb_cids tr').length == 0) {
        $(".tb_cids").css('border', '');
        $(".tb_cids").hide();
    }
    atend--;
}

function verMaisPreConsultas() {
    $("#ver-mais-pre-consultas").html("Menos")
        .unbind("click")
        .click(verMenosPreConsltas);

    $("#historico-pre-consulta").show("normal");
}

function verMenosPreConsltas() {
    $("#ver-mais-pre-consultas").html("Ver mais")
        .unbind("click")
        .click(verMaisPreConsultas);

    $("#historico-pre-consulta").hide("fast");
}

function selecionarTodos() {


    $("#ciap-selecionados option").each(function () {
        $(this).attr('selected', 'selected')
    })
}

function validaTipoVigilancia() {
    var cont = 0;
    $("#vigilancia").find("input[type=checkbox][name='vigilancia[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_vig").val("");
    } else {
        $("#conf_vig").val(cont);
    }
}

function validaTipoConduta() {
    var cont = 0;
    $("#conduta").find("input[type=radio][name='conduta[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    $("#conduta").find("input[type=checkbox][name='conduta[]']:checked").each(function () {
        if ($(this).val()) {
            cont++;
        }
    });
    if (cont == 0) {
        $("#conf_cond").val("");
    } else {
        $("#conf_cond").val(cont);
    }
}

function validaTipoCondutaAte() {
  var cont = 0;
  var enc = 0;

  $("#conduta_ate").find("input[type=checkbox][name='conduta_ind[]']:checked").each(function () {
    if ($(this).val()) {
      cont++;
    }
    if ($(this).val() == 11) {
      enc++;
    }
  });
  if(enc>0){
    var profissionais = null;
    $.ajax({
      url: baseUrl + '/default/usuarios/get-profissional-encaminhamento',
      async: false,
      success: function (txt) {
        profissionais = txt;
      }
    });
    $("#button-retorno").hide();
    var append = "";
    append+='   <fieldset id="encaminhamento-interno">'
      +'       <legend> Encaminhamento Interno</legend>'
      +'       <form id="form-encaminhamento">'
      +'       <div style="padding-bottom: 3px">'
      +'       <label style="width: 20%">Profissional:</label>'
      +'       <select name="usr_codigo_enc" id="usr_codigo_enc" onchange="buscaEspecialidadeEncaminhamento()" style="width: 75%">'
      +'          <option value="">Selecione um Profissional.</option>';
    profissionais.forEach(function (data) {
      append+= '<option value="'+data.usr_codigo+'">'+data.usr_nome+'</option>';
    });
    append+='    </select></div><div style="padding-bottom: 3px">'
      +'    <label style="width: 20%">Especialidade:</label>'
      +'    <select name="esp_codigo_enc" id="esp_codigo_enc" onchange="buscaProcedimentoEncaminhamento()" style="width: 75%">'
      +'       <option value="">Selecione um Profissional.</option>'
      +'    </select></div><div style="padding-bottom: 3px">'
      +'   <label style="width: 20%">Procedimento:</label>'
      +'   <select name="proc_codigo_enc" id="proc_codigo_enc" style="width: 75%">'
      +'       <option value=""> Selecione uma Especialidade.</option>'
      +'   </select></div>'
      +'</form></fieldset>';


    $('#fieldset-conduta').append(append);

  } else {
    $("#button-retorno").show();
    $('#encaminhamento-interno').remove();
  }


  if (cont == 0) {
    $("#conf_cond_ate").val("");
  } else {
    $("#conf_cond_ate").val(cont);
  }
}


function buscaEspecialidadeEncaminhamento(){
  var usr_codigo = $('#usr_codigo_enc option:selected').val();
  $('#esp_codigo_enc').html("");
  $.ajax({
    url: baseUrl +'/default/usuarios/get-especialidade-encaminhamento/usr/'+usr_codigo,
    success: function (txt) {
      txt.forEach(function (data) {
        $('#esp_codigo_enc').append(
          '<option value="'+data.esp_codigo+'">'+data.esp_nome+'</option>'
        )
      });
      buscaProcedimentoEncaminhamento()
    }
  });
}

function buscaProcedimentoEncaminhamento(){
  var esp_codigo = $('#esp_codigo_enc option:selected').val();
  $('#proc_codigo_enc').html("");
  $.ajax({
    url: baseUrl +'/default/usuarios/get-procedimento-encaminhamento/esp/'+esp_codigo,
    success: function (txt) {
      txt.forEach(function (data) {
        $('#proc_codigo_enc').append(
          '<option value="'+data.proc_codigo+'">'+data.proc_nome+'</option>'
        )
      });

    }
  });
}



function somenteProcedimento() {
    $("#info-sus").hide();
    if ($("#uni_tipo").val() != "H") {
        $("#ate_reclamacao").val("Procedimento");
        $("#ate_individual").show();
    }
    $("#conf_cond").val("1");
    $("#conf_vig").val("1");
    $("#conf_cond_ate").val("1");
    $("#conf_ciap").val("1");
    $("#somente").hide();
    $("#local_esus").hide();

    $("#ate_somente_procedimento").val("t");
}

function validaUnico() {
    if ($("#ate_somente_procedimento").val() != "t") {
        validaTipoCondutaAte();
        selecionarTodos();
        selecionarTodosOsCiapSelecionados();
    }

}

function atendimentoIndividual() {
    $("#info-sus").show();

    $("#ate_reclamacao").val("");

    $("#conf_cond").val("");
    $("#conf_vig").val("");

    $("#conf_cond_ate").val("");
    validaTipoCondutaAte();

    $("#conf_ciap").val("");
    $("#ate_individual").hide();
    $("#somente").show();
    $("#ate_somente_procedimento").val("f");
}


function buscarCiap() {
    selecionarTodos();
    $("#ciap_busca").buscar({
        url: baseUrl + '/prontuario/atendimento/novo-buscar-ciap/selecionados/' + $("#ciap-selecionados").val() + '/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a><strong>" + item.codigoCiap + " - " + item.label + "</strong><br>\n\
                        <font size=\"1\"> Inlc: " + item.ds_inclusao + " \n\
                        <br>\n\
                        Excl: " + item.ds_exclusao + "  \n\
                        <br>\n\
                        </font></a>").appendTo(ul);
        },
        callback: function (event, ui) {
            if (ui.item.id != 0) {
                if ($("#ciap-selecionados option:first").val() == "0") {
                    $("#ciap-selecionados").empty();
                    $("#conf_ciap").val("1");
                }
                $('#ciap-selecionados').append("<option select=\"selected\" value=" + ui.item.id + ">" + ui.item.label + "</option>");
            }
            $('#ciap_busca').val("");
            selecionarTodos();
        }
    });
}


function verificaStatusAtendimento(cod, ate_codigo, espec, id_login){
    $.cookie("ate_reclamacao", ' ', -1);
    $.cookie("ate_exame_fisico", " ");
    $.cookie("ate_diagnostico", " ");
    $.cookie("ate_tratamento", " ");
    $.cookie("ate_curativo", " ");
    if(espec !== 'null'){
        $('#atualiza_pagina').val('false');
        mensagemSemOk("carregando-ate", "Aguarde", "Carregando prontuário...", 280, 80);
        $.ajax({
            url: baseUrl + '/prontuario/atendimento/verifica-status-atendimento',
            type: "POST",
            data: {
                age_codigo: cod,
                ate_codigo: ate_codigo
            },
            success: function (txt) {
                if(txt !== null){
                    fecharMensagemSemOk("carregando-ate");
                    mensagem("Atenção", "Atendimento já está sendo realizado pelo profissional " + txt);
                } else {
                    verificaSeEstaEmAtendimento(cod, ate_codigo, id_login);
                }
            },
            error: function (pq) {
                alert(JSON.stringify(txt));
            }
        });
    }else{
        confirme("Atenção",
            "É necessário informar a <b>ESPECIALIDADE</b> no login para acessar este módulo.\n" +
            "Deseja efetuar o login novamente?", 300, 150, function () {
                window.open(baseUrl + '/login/logout?id_login='+id_login, '_self');
            }
        );
    }
}

function verificaSeEstaEmAtendimento(cod, ate_codigo) {
    $.ajax({
        url: baseUrl + '/prontuario/atendimento/verificaseestaematendimento',
        type: "POST",
        data: {
            age_codigo: cod,
            ate_codigo: ate_codigo
        },
        success: function (txt) {
            if (txt == 2) {
                window.location = baseUrl + "/prontuario/agenda-do-dia/index/pacem/s";
            } else {
                window.location = baseUrl + "/prontuario/index/iniciar/cod/" + cod;
            }
        },
        error: function (pq) {
            $('#atualiza_pagina').val('true');
            alert(pq)
        }
    });
}


function getIdade() {
    var parts = $('#datanascimento').val().split('/');
    var dataNascimento = new Date(parts[2], parts[1] - 1, parts[0]);

    var parts = $('#dataatual').val().split('/');
    var dataAtual = new Date(parts[2], parts[1] - 1, parts[0]);

    var idade = dataAtual.getFullYear() - dataNascimento.getFullYear();
    var m = dataAtual.getMonth() - dataNascimento.getMonth();
    if (m < 0 || (m = 0 && dataAtual.getDate() < dataNascimento.getDate())) {
        idade--;
    }
    //console.log(idade);
    return idade;
}


function exibeEstratificacaoIdade() {
    if (getIdade() >= 60) {
        $("#estrat_idoso").show();
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
        $("#gestante").attr("disabled", true);
    } else if (getIdade() < 12 && $('#usr_tipo_medico').val() !== 'P') {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").show();
        $("#gestante").attr("disabled", true);
    } else {
        $("#estrat_idoso").hide();
        $("#risco_idoso").val("");
        $("#estrat_crianca").hide();
        $("#risco_crianca").val("");
        //$("#gestante").attr("disabled", false);
    }
}


function exibeEstratificacaoCheckbox(idCheckbox, idDiv, idCampoRisco) {
    if ($("#" + idCheckbox).is(':checked')) {
        $("#" + idDiv).show();
    } else {
        $("#" + idDiv).hide();
        $("#" + idCampoRisco).val("");
    }
}
