$(function () {
  $("#exames-solicitado").buscar({
    url: baseUrl + "/procedimento/buscar/",
    template: function (ul, item) {
      return $("<li></li>").data("item.autocomplete", item).append(
               "<a>" + item.label + "</a>"
              ).appendTo(ul);
    },
    callback: function (ul, item) {
      $("#proc_codigo-solicitado").val(item.item.data.proc_codigo)
    }
  });

  $("#exame_nome_historico-solicitado").buscar({
    url: baseUrl + "/procedimento/buscar/",
    template: function (ul, item) {
      return $("<li></li>").data("item.autocomplete", item).append(
               "<a>" + item.label + "</a>"
              ).appendTo(ul);
    },
    callback: function (ul, item) {
      $("#exame_codigo_historico-solicitado").val(item.item.data.proc_codigo);
      var rel = $("#exame_nome_historico-solicitado").attr("rel");
      var tipo = rel.split('-');

      $.ajax({
        url: baseUrl + "/prontuario/exame/itens-historico-form/",
        type: 'POST',
        data: {
          usuCodigo: $("#usu_codigo").val(),
          tipo: tipo[1],
          id: item.item.data.proc_codigo
        },
        success: function (data) {
          $("#itens_tabela-" + tipo[1]).html(data);
        }
      });
    }
  });

  $("#exames-avaliado").buscar({
    url: baseUrl + "/procedimento/buscar/",
    template: function (ul, item) {
      return $("<li></li>").data("item.autocomplete", item).append(
               "<a>" + item.label + "</a>"
              ).appendTo(ul);
    },
    callback: function (ul, item) {
      $("#proc_codigo-avaliado").val(item.item.data.proc_codigo)
    }
  });

  $("#exame_nome_historico-avaliado").buscar({
    url: baseUrl + "/procedimento/buscar/",
    template: function (ul, item) {
      return $("<li></li>").data("item.autocomplete", item).append(
               "<a>" + item.label + "</a>"
              ).appendTo(ul);
    },
    callback: function (ul, item) {
      $("#exame_codigo_historico-avaliado").val(item.item.data.proc_codigo);
      var rel = $("#exame_nome_historico-avaliado").attr("rel");
      var tipo = rel.split('-');

      $.ajax({
        url: baseUrl + "/prontuario/exame/itens-historico-form/",
        type: 'POST',
        data: {
          usuCodigo: $("#usu_codigo").val(),
          tipo: tipo[1],
          id: item.item.data.proc_codigo
        },
        success: function (data) {
          $("#itens_tabela-" + tipo[1]).html(data);
        }
      });
    }
  });

  var print = $("#imprimir").val();
  if (typeof print != "undefined" && print != 0 && print != "") {
    popup(baseUrl + '/prontuario/exame/imprimir/selecionados/' + print, 'exame', 630, 540);
  }

  $("form:first").validate({
    rules: {
      proc_nome: {
        required: true
      }
    },
    messages: {
      proc_nome: {
        required: "Infome um procedimento"
      }
    }
  });
});

function validaSolicitado() {
  if ($("#exames-solicitado").val() == '') {
    alert('É necessário informar qual é o exame solicitado!');
    $("#exames-solicitado").focus();
    return;
  }
  else if ($("#data-solicitacao-solicitado").val() == '') {
    alert('É necessário informar qual é a data de solicitação do exame!');
    $("#data-solicitacao-solicitado").focus();
    return;
  }

  salvarExame($("#tipo1").val());
}

function validaAvaliado() {
  if ($("#exames-avaliado").val() == '') {
    alert('É necessário informar qual é o exame avaliado!');
    $("#exames-avaliado").focus();
    return;
  }
  else if ($("#data-realizacao-avaliado").val() == '') {
    alert('É necessário informar qual é a data de realização do exame!');
    $("#data-realizacao-avaliado").focus();
    return;
  }
  else if ($("#data-resultado-avaliado").val() == '') {
    alert('É necessário informar qual é a data do resultado do exame!');
    $("#data-resultado-avaliado").focus();
    return;
  }

  salvarExame($("#tipo2").val());
}

function salvarExame(tipo) {
  $("#tipo").val(tipo);
  var obs = ($("#obs").val() ? true : false);

  $.ajax({
    type:"POST",
    url: baseUrl + "/prontuario/exame/salvar/",
    data: {
      tipo: tipo,
      ate_codigo: $("#ate_codigo").val(),
      usu_codigo: $("#usu_codigo").val(),
      req_codigo: $("#req_codigo-" + tipo).val(),
      proc_codigo: $("#proc_codigo-" + tipo).val(),
      observacao: $("#observacao-" + tipo).val(),
      data_solicitacao: $("#data-solicitacao-" + tipo).val(),
      data_realizacao: $("#data-realizacao-" + tipo).val(),
      data_resultado: $("#data-resultado-" + tipo).val(),
    },
    success: function(txt){
      var tabsTipos = {
        "solicitado": "#tabs2-1",
        "avaliado": "#tabs2-2",
      };

      $("#req_codigo-" + tipo).val('');
      $("#proc_codigo-" + tipo).val('');
      $("#observacao-" + tipo).val('');
      $("#data-solicitacao-" + tipo).val('');
      $("#data-realizacao-" + tipo).val('');
      $("#data-resultado-" + tipo).val('');
      $("#exames-" + tipo).val('');
      location.reload();
      if (!obs) {
        window.location.replace(baseUrl + "/prontuario/exame/" + tabsTipos[tipo]);
      }
    }
  });
}

function imprimirSelecionados(url){
  var print = [];
  $(".itensSelecionados ").each(function () {
    if(this.checked)
      print.push(this.value);
  });

  if (print.length > 0) {
    popup(url + "/selecionados/" + print, 800, 600);
  } else {
    alert('Selecione ao menos um exame!');
  }
}

function editarExame(id, tipo) {
  var dataArray = '';
  var data = '';

  $('#exames-' + tipo).val($('#exame-' + id).val().trim());
  $('#proc_codigo-' + tipo).val($('#exame-cod-' + id).val().trim());

  if (tipo == 'solicitado') {
    dataArray = $('#data-solicitacao-' + id).val().split('-');
    data = dataArray[2] + '/' + dataArray[1] + '/' + dataArray[0];
    $('#data-solicitacao-' + tipo).val(data);
  }
  else {
    dataArray = $('#data-realizacao-' + id).val().split('-');
    data = dataArray[2] + '/' + dataArray[1] + '/' + dataArray[0];
    $('#data-realizacao-' + tipo).val(data);

    dataArray = $('#data-resultado-' + id).val().split('-');
    data = dataArray[2] + '/' + dataArray[1] + '/' + dataArray[0];
    $('#data-resultado-' + tipo).val(data);
  }

  $('#observacao-' + tipo).html($('#observacao-' + id).val());
  $('#req_codigo-' + tipo).val(id);
}

function replicarExame(id, tipo) {
  var dataArray = $('#data-solicitacao-' + id).val().split('-');
  var data = dataArray[2] + '/' + dataArray[1] + '/' + dataArray[0];

  $('#exames-' + tipo).val($('#exame-' + id).val().trim());
  $('#proc_codigo-' + tipo).val($('#exame-cod-' + id).val().trim());
  $('#data-solicitacao-' + tipo).val(data);
  $('#observacao-' + tipo).html($('#observacao-' + id).val());
}
