var color_dente     = "#337ab7";
var color_boca      = "#d9534f";
var color_sextante  = "#5cb85c";
var color_branco    = "#fff";
var color_extraido  = "#6600ff";
// globais
var DENTES_ADULTO = new Array('', 'Incisivo Central', 'Incisivo Lateral', 'Canino', '1º Premolar', '2º Premolar', '1º Molar', '2º Molar', '3º Molar');
var DENTES_CRIANCA = new Array('', 'Incisivo Central', 'Incisivo Lateral', 'Canino', '1º Molar', '2º Molar');

$(function(){
    var odo_trat_codigo =  $("#odo_trat_codigo").val();
    if(odo_trat_codigo){
        mensagemSemOk("load_odonto", "Aguarde", "Carregando Dados ...", 250, 150);
        $.ajax({
            dataType: "json",
            url: baseUrl + "/prontuario/odontograma/carrega-tratamentos-odonto/odo_trat_codigo/" + odo_trat_codigo,
            success: function (json) {
                fecharMensagemSemOk("load_odonto");
                pintarDentes(json);
            }
        });
    }
});

function marcarFace(dente, face, consulta){
    consulta = (consulta != undefined ? consulta : "");
    $("#dente_" + consulta + dente).find("#" + face).css("fill", color_dente);
}

function desmarcarFace(dente, face, consulta){
    consulta = (consulta != undefined ? consulta : "");
    $("#dente_" + consulta + dente).find("#" + face).removeAttr("style");
}

function marcarSextante(id, consulta){
    consulta = (consulta != undefined ? consulta : "");
    $("#" + consulta + id).css("fill", color_sextante);
}

function marcarDenteCompleto(id, consulta){
    consulta = (consulta != undefined ? consulta : "");
    $("#dente_" + consulta + id).find("path, rect, polygon").css("fill", color_dente);
}

function marcarBoca(id, consulta){
    consulta = (consulta != undefined ? consulta : "");
    $("#" + consulta + id).css("fill", color_boca);
}

function desmarcar(id){
    $("#" + id).removeAttr("style");
}

function selecionaDente(face) {
    var face_selec;
    switch (face.id){
        case "O": face_selec = "OCLUSAL"; break;
        case "M": face_selec = "MESIAL"; break;
        case "V": face_selec = "VESTIBULAR"; break;
        case "L": face_selec = "LINGUAL"; break;
        case "D": face_selec = "DISTAL"; break;
    }
    var selecionado = $(face).attr("style");
    if (selecionado == undefined){
        $(face).css("fill", color_dente);
        $("#selecionado_" + face.id).remove();
        var td = "<tr id='selecionado_" + face.id + "'><td class='ui-state-default' align='center'>" + face_selec + "</td></tr>";
        $("#t_faces").append(td);
    }else{
        console.log("desmarca");
        $(face).removeAttr("style");
        $("#selecionado_" + face.id).remove();
    }
}

function selecionaDenteEdit(face) {
    var face_selec;
    switch (face){
        case "O": face_selec = "OCLUSAL"; break;
        case "M": face_selec = "MESIAL"; break;
        case "V": face_selec = "VESTIBULAR"; break;
        case "L": face_selec = "LINGUAL"; break;
        case "D": face_selec = "DISTAL"; break;
    }
    $("#dente_amostra").find("#" + face).css("fill", color_dente);
    var td = "<tr id='selecionado_" + face + "'><td class='ui-state-default' align='center'>" + face_selec + "</td></tr>";
    $("#t_faces").append(td);
}

function selecionaDenteCompleto() {
    $("#dente_amostra").find("path, rect, polygon").css("fill", color_dente);
}

function checkDenteExtraido(){
    if($("#check_dente_faltante").is(":checked")){
        marcaDenteExtraido("dente_amostra");
        $("#odo_proc_statusT").attr("checked", true);
        $('input:radio[name="odo_proc_status"]').attr("disabled", true);
        esconde_dt_programada();
    }else{
        desmarcaDenteExtraido("dente_amostra");
        $('input:radio[name="odo_proc_status"]').attr("disabled", false);
        if($("#odo_tipo_trat:checked").val() == "D"){
            selecionaDenteCompleto();
        }
    }
}

function marcaSextanteExodontia(sextante){
    $("#" + sextante).css("fill", color_branco)
        .css("stroke", color_boca)
        .css("pointer-events", "none");
    $("#t_faces").empty();
}

function marcaDenteExodontia(dente){
    $("#" + dente).find("path, rect, polygon")
        .css("fill", color_branco)
        .css("stroke", color_boca);
    $("#t_faces").empty();
}

function desmarcaDenteExodontia(dente, consulta){
    $("#" + dente).find("path, rect, polygon").removeAttr("style");
    $("#t_faces").empty();
}

function marcaDenteExtraido(dente){
    $("#" + dente).find("path, rect, polygon")
        .css("fill", color_branco)
        .css("stroke", color_extraido)
        .css("pointer-events", "none");
    $("#fieldset-proc").attr("disabled", true);
    $("#proc_codigo").val("");
    $("#t_faces").empty();
}

function desmarcaDenteExtraido(dente){
    $("#" + dente).find("path, rect, polygon").removeAttr("style");
    $("#fieldset-proc").removeAttr("disabled");
}

function abrirProcedimento(denteNum){
    $('#odo_proc_dtprogramada').live('focus', function () {
        $(this).datepicker({changeMonth: true, changeYear: true})
    });
    // Exibindo nome do dente
    $("#dente-dialog").remove();
    $("body").append("<div id='dente-dialog' title='" + getTitulo(denteNum) + "'></div>");
    $("body").css("overflow", "hidden");
    $("#dente-dialog")
        .html("<img src=\"" + baseUrl + "/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando Cadastro de Procedimento...\" />")
        .dialog({
            modal: true,
            width: 800,
            height: 520,
            close: function(){
                $("body").removeAttr("style");
            },
            buttons: {
                Cancelar: function () {
                    $("body").removeAttr("style");
                    $("#dente-dialog").dialog("destroy").remove();
                },
                Salvar: function () {
                    var dados = validaDados();
                    if(dados){
                        salvarDados(dados);
                    };
                }
            }
        })
        .load(baseUrl + "/prontuario/odontograma/cadastra-procedimento/dente/" + denteNum + "/tipo/" + verificaProcedimento(denteNum), function(){
            var title = "";
            if(denteNum > 10){
                title = "Histórico do Dente";
            }else{
                if(denteNum == "A" || denteNum == "I"){
                    title = "Histórico da Boca";
                }else{
                    title = "Histórico do Sextante";
                }
            }
            $("#title-hist").text(title);
            selecionaDenteCompleto();
            $("#odo_tipo_trat[type=radio]").change(function(){
                if(this.value == "D"){
                    $("#fieldset-faces-sel").css("display", "none");
                    $("#check_dente_faltante").css("display", "");
                    $("#lbl_dente_faltante").css("display", "");
                    $("#div-faces").css("grid-template-columns", "595px 150px");
                    $("#fieldset-faces svg").css("pointer-events", "none");
                    selecionaDenteCompleto();
                }else{
                    $("#fieldset-faces-sel").css("display", "block");
                    $("#check_dente_faltante").css("display", "none");
                    $("#lbl_dente_faltante").css("display", "none");
                    $("#div-faces").css("grid-template-columns", "auto 150px auto");
                    $("#fieldset-faces svg").css("pointer-events", "all");
                    desmarcaDenteExtraido("fieldset-faces");
                }
                $("#tipo").val(this.value);
                buscaProcedimentosPorTipo(this.value);
                $("#check_dente_faltante").attr("checked", false);
            });
        });
}

// Função que edita o procedimento realizado
function editaProcedimentoRealizado(odo_preal_codigo) {
    $('#odo_proc_dtprogramada').live('focus', function () {
        $(this).datepicker({changeMonth: true, changeYear: true})
    });
    // Exibindo nome do dente
    $("#dente-dialog").remove();
    $("body").append("<div id='dente-dialog' title='Edição de procedimentos realizado'></div>");
    $("body").css("overflow", "hidden");
    $("#dente-dialog")
        .html("<img src='" + baseUrl + "/public/images/load.gif' alt='Carregando...' title='Carregando Edição de Procedimento...' />")
        .dialog({
            modal: true,
            width: 800,
            height: 520,
            close: function(){
                $("body").removeAttr("style");
            },
            buttons: {
                Cancelar: function () {
                    $("body").removeAttr("style");
                    $("#dente-dialog").dialog("destroy").remove();
                },
                Salvar: function () {
                    var dados = validaDados();
                    if(dados){
                        salvarDados(dados);
                    };
                }
            }
        })
        .load(baseUrl + "/prontuario/odontograma/cadastra-procedimento/procRealCodigo/" + odo_preal_codigo, function(){
            $("#odo_tipo_trat[type=radio]").change(function(){
                if(this.value == "D"){
                    $("#fieldset-faces-sel").css("display", "none");
                    $("#check_dente_faltante").css("display", "");
                    $("#lbl_dente_faltante").css("display", "");
                    $("#div-faces").css("grid-template-columns", "595px 150px");
                    $("#fieldset-faces svg").css("pointer-events", "none");
                    selecionaDenteCompleto();
                }else{
                    $("#fieldset-faces-sel").css("display", "block");
                    $("#check_dente_faltante").css("display", "none");
                    $("#lbl_dente_faltante").css("display", "none");
                    $("#div-faces").css("grid-template-columns", "auto 150px auto");
                    $("#fieldset-faces svg").css("pointer-events", "all");
                    desmarcaDenteExtraido("fieldset-faces");
                }
                $("#tipo").val(this.value);
                buscaProcedimentosPorTipo(this.value);
                $("#check_dente_faltante").attr("checked", false);
            });
            if($("#tipoDente").val()){
                selecionaDenteCompleto();
            }else{
                var faces = $("#faces").val();
                for(i=0;i < faces.length;i++){
                    console.log("Marca face: " + faces.charAt(i));
                    selecionaDenteEdit(faces.charAt(i));
                    // marcarFace("amostra", faces.charAt(i));
                }
            }
        });
}

function buscaProcedimentosPorTipo(tipo){
    mensagemSemOk("load_proc", "Aguarde", "Carregando Procedimentos ...", 250, 150);
    $.ajax({
        url: baseUrl + "/prontuario/odontograma/buscar-procedimento-odontologico/tipo/" + tipo,
        success: function(ret){
            if(ret != null && ret.length > 0){
                fecharMensagemSemOk("load_proc");
                $("#proc_codigo").empty();
                $.each(ret, function(index, value){
                    $("#proc_codigo").append("<option class='"+ value.proc_codigo_sus +"' value='" + value.proc_codigo+ "' onclick='selecionaProcedimento(this)'>" + value.proc_nome + "</option>");
                });
            }
        }
    });
}

function validaDados(){
    var tipo = $("#tipo").val();
    var ret = {
        "odo_proc_dentenum" : $("#odo_proc_dentenum").val(),
        "odo_proc_denteanot" : $("#odo_proc_denteanot").val(),
        "odo_preal_marcacao" : false,
        "odo_proc_denteface" : "",
        "odo_proc_exodontia" : false,
    };
    if($("#odo_preal_codigo").val() != ""){
        ret['odo_preal_codigo'] = $("#odo_preal_codigo").val();
    }
    var x = 350;
    var y = 150;
    switch (tipo){
        case "D":
            ret["odo_preal_marcacao"] = $("#check_dente_faltante").is(":checked");
            break;
        case "F":
            ret["odo_proc_denteface"] = retornaFaces();
            if(ret["odo_proc_denteface"] == ""){
                mensagem("Erro", " * Face do procedimento não selecionada!<br />", x,y);
                return false;
            }
            break;
        case "S":
            ret["odo_proc_sextante"] = getSextanteBoca();
            break;
        case "B":
            ret["odo_proc_boca"] = getSextanteBoca();
            break;
    }
    if(!$("#check_dente_faltante").is(":checked")){
        if($("#proc_codigo").val() != null || $("#proc_codigo option:selected").val() != null){
            ret["proc_codigo"] = ($("#proc_codigo").val() ? $("#proc_codigo").val() : $("#proc_codigo option:selected").val());
        }else{
            mensagem("Erro", " * Selecione um procedimento!<br />", x,y);
            return false;
        }
    }
    var v_checked = $('input:radio[name="odo_proc_status"]:checked').val();
    ret["odo_proc_status"] = retornaStatus();
    var msg_erro = "";
    if (v_checked == "F") {
        var data_atual = $("#dt_atual").val();
        var data_programada = $("#odo_proc_dtprogramada").val().split("/");
        var dt_programada = data_programada[2] + "-" + data_programada[1] + "-" + data_programada[0];

        if (!$("#odo_proc_dtprogramada").val()) {
            msg_erro += " * Informe uma data para o procedimento!<br />";
        }

        if (data_atual > dt_programada) {
            msg_erro += " * A data a ser realizada é maior que a atual!<br />";
        }
    }
    if(msg_erro != ""){
        mensagem("Erro", msg_erro , x,y);
        return false;
    }else{
        ret["odo_proc_dtprogramada"] = $("#odo_proc_dtprogramada").val();
    }

    //Verifica se é exodontia dente
    if($("#proc_codigo option:selected").hasClass("0414020120") || $("#proc_codigo option:selected").hasClass("0414020138") || $("#proc_codigo option:selected").hasClass("0414020146")){
        ret["odo_proc_exodontia"] = true;
    }

    return ret;
}

function selecionaProcedimento(e){
    var exodontia = ['0414020120', '0414020138', '0414020146'];
    if(exodontia.indexOf(e.className) > -1){
        marcaDenteExodontia("dente_amostra");
    }else{
        if($("#odo_tipo_trat:checked").val() != "D"){
            desmarcaDenteExodontia("dente_amostra");
        }else{
            selecionaDenteCompleto();
        }
    }
}

function getSextanteBoca() {
    var denteNum = $("#odo_proc_dentenum").val();
    switch (denteNum){
        case "1": return "SASE";
        case "2": return "SASC";
        case "3": return "SASD";
        case "4": return "SISE";
        case "5": return "SISC";
        case "6": return "SISD";
        case "7": return "SIIE";
        case "8": return "SIIC";
        case "9": return "SIID";
        case "X": return "SAIE";
        case "Y": return "SAIC";
        case "Z": return "SAID";
        case "A": return "BA";
        case "I": return "BI";
    }
}

function salvarDados(dados){
    mensagemSemOk("salvar_procedimento", "Confirmação", "Salvando dados ...", 250, 150);
    $.ajax({
        url: baseUrl + "/prontuario/odontograma/salvar-procedimento",
        type: "POST",
        data: dados,
        success: function (txt) {

            $("#dente-dialog").dialog("destroy").remove();
            incluiProcedimentoRealizado(txt);
            fecharMensagemSemOk("salvar_procedimento");
            mensagem("Confirmação de Cadastro", "Procedimento cadastrado com sucesso!", 350, 120, function(){
                var odo_trat_codigo =  $("#odo_trat_codigo").val();
                limparDentes();
                if(odo_trat_codigo){
                    mensagemSemOk("load_odonto", "Aguarde", "Carregando Dados ...", 250, 150);
                    $.ajax({
                        dataType: "json",
                        url: baseUrl + "/prontuario/odontograma/carrega-tratamentos-odonto/odo_trat_codigo/" + odo_trat_codigo,
                        success: function (json) {
                            fecharMensagemSemOk("load_odonto");
                            $("body").removeAttr("style");
                            pintarDentes(json);
                        }
                    });
                }
            });

        }
    });
}

function verificaProcedimento(n){
    if(n.toString().length == 2){
        return "D";
    }
    if(n.toString() != "A" && n.toString() != "I"){
        return "S";
    }
    return "B";
}

function buscarProcedimentoOdontologico() {
    $.ajax({
        url: baseUrl + "/prontuario/odontograma/buscar-procedimento-odontologico/term/" + $("#proc_nome_buscar").val() + "/tipo/" + $("#tipo").val(),
        success: function(ret){
            if(ret != null && ret.length > 0){
                $("#proc_codigo").empty();
                $.each(ret, function(index, value){
                    $("#proc_codigo").append("<option class='"+ value.proc_codigo_sus +"' value='" + value.proc_codigo+ "' onclick='selecionaProcedimento(this)'>" + value.proc_nome + "</option>");
                });
            }
        }
    });
}

function mostra_dt_programada() {
    $(".data-programada").show();
}

function esconde_dt_programada() {
    $(".data-programada").hide();
    $("#dt_atual").val();
}

function retornaFaces() {
    if ($("#proc_codigo option:selected").hasClass("0414020120") || $("#proc_codigo option:selected").hasClass("0414020138") || $("#proc_codigo option:selected").hasClass("0414020146") || $("#proc_codigo option:selected").hasClass("0307030016") || $("#proc_codigo option:selected").hasClass("0307030024") || $("#proc_codigo option:selected").hasClass("0307030032")) {
        if(!$("#check_dente_faltante").is(":checked")){
            $("#dente_amostra").find("path, polygon").css("fill", color_dente);
        }
    }

    var face = "";
    $("#dente_amostra").find("path, polygon").each(function(){
        var attr = $(this).attr("style");
        if(attr != undefined){
            face += this.id;
        }
    });

    var tipo_proc = verificaProcedimento($("#odo_proc_dentenum").val());
    if(tipo_proc != "D"){
        face = $("#odo_proc_dentenum").val();
    }

    return face;
}

function retornaStatus() {
    if ($("#odo_proc_statusT").is(':checked')) {
        return true;
    } else {
        return false;
    }
}

function bindFaces() {

    $("area").click(function () {
        var area = $(this).data("area");
        var ckeckbox = $("#face" + area);
        ckeckbox.attr('checked', !ckeckbox.is(':checked'));
    }).hover(function () {
        var area = $(this).data("area");
        var area_img = $(this).data("img");
        $("#img_face" + area_img).css({'visibility': 'visible'});
        $("#face" + area).next().css("font-weight", "bold");
    }, function () {
        var area = $(this).data("area");
        var area_img = $(this).data("img");
        $("#img_face" + area_img).css({'visibility': 'hidden'});
        $("#face" + area).next().css("font-weight", "normal");
    });
}

function getTitulo(n) {
    if(verificaProcedimento(n) == "D"){
        var d = n.toString().substr(1,2);
        var qs = "Quadrante ", qp;
        //Define quadrante
        if(n > 50){
            qs += (n > 50 && n < 66 ? 'superior' : 'inferior');
            qp = (n > 60 && n < 76 ? 'esquerdo' : 'direito');
            return "Dente Infantil: " + DENTES_CRIANCA[d] + ' ' + qs + ' ' + qp;
        }else{
            qs += (n > 10 && n < 29 ? 'superior' : 'inferior');
            qp = (n > 20 && n < 39 ?  'esquerdo' : 'direito');
            return "Dente Adulto: " + DENTES_ADULTO[d] + ' ' + qs + ' ' + qp;
        }
    }else{
        var titulo;
        switch (n){
            case "1": titulo = "Sextante Adulto Superior Esquerdo"; break;
            case "2": titulo = "Sextante Adulto Superior Central"; break;
            case "3": titulo = "Sextante Adulto Superior Direito"; break;
            case "4": titulo = "Sextante Infantil Superior Esquerdo"; break;
            case "5": titulo = "Sextante Infantil Superior Central"; break;
            case "6": titulo = "Sextante Infantil Superior Direito"; break;
            case "7": titulo = "Sextante Infantil Inferior Esquerdo"; break;
            case "8": titulo = "Sextante Infantil Inferior Central"; break;
            case "9": titulo = "Sextante Infantil Inferior Direito"; break;
            case "X": titulo = "Sextante Adulto Inferior Esquerdo"; break;
            case "Y": titulo = "Sextante Adulto Inferior Central"; break;
            case "Z": titulo = "Sextante Adulto Inferior Direito"; break;
            case "A": titulo = "Procedimentos Boca Adulto"; break;
            case "I": titulo = "Procedimentos Boca Infantil"; break;
        }
        return titulo;
    }
}

function imprimirProcedimentos() {
    var odo_trat_codigo = $("#odo_trat_codigo").val();
    $("body").append("<div id='imprimir-procedimentos' title='Impressão de procedimentos realizados e a realizar' ></div>");
    $("body").css("overflow", "hidden");
    $("#imprimir-procedimentos")
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' title='Carregando impressão ...' />")
        .dialog({
            modal: true,
            autoOpen: false,
            width: 800,
            height: 520,
            close: function(){
                $("body").removeAttr("style");
            },
            buttons: {
                Imprimir: function () {
                    //$('.camada_para_impressao').printElement();
                    $("#print").printElement();
                }
            }
        })
        .load(baseUrl + "/prontuario/odontograma/imprimir-procedimentos", function(){
            var svg = $("#svg-odonto").clone(true);
            svg.attr("id", "svg-copy");
            svg.css("pointer-events", "none");
            svg.css("height", "300px");
            svg.appendTo("#imgOdonto");
            carregaHistDeProcReal(odo_trat_codigo);
            $(this).dialog('open');
        });
        // .on( "dialogcreate", function( event, ui ) {} );;
}

function imprimirOdontograma() {
    var odo_trat_codigo = $("#odo_trat_codigo").val();
    $("body").append("<div id='imprimir-odontograma' title='Impressão de odontograma e procedimentos realizados' ></div>");
    $("body").css("overflow", "hidden");
    $("#imprimir-odontograma")
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' title='Carregando impressão ...' />")
        .dialog({
            modal: true,
            width: 800,
            height: 520,
            autoOpen: false,
            close: function(){
                $("body").removeAttr("style");
            },
            buttons: {
                Imprimir: function () {
                    //$('.camada_para_impressao').printElement();
                    $("#print").printElement();
                }
            }
        })
        .load(baseUrl + "/prontuario/odontograma/imprimir-odontograma", function () {
            var svg = $("#svg-odonto").clone(true);
            svg.attr("id", "svg-copy-odonto");
            svg.css("pointer-events", "none");
            svg.css("height", "300px");
            svg.appendTo("#imgOdontograma");
            carregaHistDeProcReal(odo_trat_codigo);
            $(this).dialog('open');
        });
}

// Função responsavel por salvar o inicio do tratamento e a carregar o odontograma
function iniciarTratamento() {
    mensagemSemOk("carregando-ate", "Aguarde", "Iniciando tratamento...", 280, 80);
    $.ajax({
        url: baseUrl + '/prontuario/odontograma/salvar-tratamento',
        type: "POST",
        success: function (txt) {
            window.location = baseUrl + "/prontuario/odontograma";
        },
        error: function (pq) {
            alert(pq)
        }
    });
}

// Função responsavel por carregar o modal de lista de tratamentos realizados
function listaTratamentosRealizados() {
    $("body").append("<div id='tratamentos-realizados' title='Consulta de listagem de tratamentos realizados' ></div>");
    $("body").css("overflow", "hidden");
    $("#tratamentos-realizados")
        .html("<img src=" + baseUrl + "/public/images/load.gif alt='Carregando' title='Carregando listagem de tratamentos' />")
        .dialog({
            modal: true,
            width: 640,
            height: 380,
            close: function(){
                $("body").removeAttr("style");
            }
        })
        .load(baseUrl + "/prontuario/odontograma/lista-tratamentos-realizados");
}

// Função que carrega o tratamento
function consultaTratamento(odo_trat_codigo) {
    // Exibindo nome do dente
    $("body").append("<div id=\"consulta-tratamento\" title=\"Consulta de Tratamento\"></div>");
    $("body").css("overflow", "hidden");
    $("#consulta-tratamento")
        .html("<img src=\"" + baseUrl + "/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando consulta...\" />")
        .dialog({
            modal: true,
            width: 800,
            height: 520,
            autoOpen: false,
            close: function(){
                $("body").removeAttr("style");
            },
            buttons: {
                Imprimir: function () {
                    //$('.camada_para_impressao').printElement();
                    $("#print").printElement();
                }
            }
        })
        .load(baseUrl + "/prontuario/odontograma/consulta-tratamento/tratCodigo/" + odo_trat_codigo, function () {
            carregaConsultaHistDeProcReal(odo_trat_codigo);
            $(this).dialog('open');
        });
}

// Função responsável por executar a finalização do tratamento
function finalizarTratamento() {
    $.ajax({
        url: baseUrl + "/prontuario/odontograma/finalizar-tratamento",
        type: "POST",
        success: function (txt) {
            if (txt == "ok") {
                mensagemSemOk("carregando-ate", "Aguarde", "Finalizando Tratamento", 280, 80);
                window.location = baseUrl + "/prontuario/odontograma/"
            } else {
                mensagem("Erro", "Ainda existe procedimentos a serem realizado!", 350, 120);
            }
        }
    });
}
// Função responsável por chamar os procedimentos a realizar
function procedimentosaRealizar() {
    // Exibindo nome do dente
    $("body").append("<div id=\"procedimentos-realizar\" title=\"Lista de procedimentos a realizar\"></div>");
    $("body").css("overflow", "hidden");
    $("#procedimentos-realizar")
        .html("<img src=\"" + baseUrl + "/public/images/load.gif\" alt=\"Carregando...\" title=\"Carregando Cadastro de Procedimento...\" />")
        .dialog({
            modal: true,
            width: 800,
            height: 520,
            close: function(){
                // window.location.reload(true);
                $(this).dialog('destroy');
                $("body").removeAttr("style");
            },
            buttons: {
                Fechar: function () {
                    // window.location.reload(true);
                    $(this).dialog('destroy');
                    $("body").removeAttr("style");
                }
            }
        })
        .load(baseUrl + "/prontuario/odontograma/lista-procedimentos/");
}

// Função que seta o procedimento como realizado exclui dos pensentes e insere nos realizados
function salvarProcedimentoRealizado(odo_proc_codigo) {
    $("#proc-codigo" + odo_proc_codigo)
        .attr("src", baseUrl + "/public/images/loading.gif")
        .attr("title", "Carregando");
    $.ajax({
        url: baseUrl + '/prontuario/odontograma/salvar-procedimento-realizado',
        type: "POST",
        data: {
            odo_proc_codigo: odo_proc_codigo
        },
        success: function (txt) {
            $("#proc-codigo" + odo_proc_codigo)
                .attr("src", baseUrl + "/public/images/icons/accept.png")
                .attr("title", "Realizado");
            incluiProcedimentoRealizado(txt);
        }
    });
}

// Função que inclui linha nos procedimentos realizados
function incluiProcedimentoRealizado(odo_preal_codigo) {
    var listaProcedimentos = "";
    $.ajax({
        url: baseUrl + "/prontuario/odontograma/get-procedimento-realizado",
        type: "POST",
        data: {odo_preal_codigo: odo_preal_codigo},
        success: function (txt) {
            // Validaçoes
            var dentenum = (txt.odo_preal_dentenum.trim().length > 1 ? txt.odo_preal_dentenum : "---");
            var denteanot = ((txt.odo_preal_denteanot == "" || txt.odo_preal_denteanot == null) ? "---" : txt.odo_preal_denteanot );
            var denteface = (txt.odo_preal_denteface == "" ? "---" : txt.odo_preal_denteface );
            var sextante = (txt.odo_preal_sextante != null ? txt.odo_preal_sextante : "---" );
            var boca = (txt.odo_preal_boca != null ? txt.odo_preal_boca : "---");
            $("#proc-num" + txt.odo_preal_codigo).remove();
            if(txt.proc_codigo > -1){
                // Criando lista de procedimentos
                listaProcedimentos += "<tr id='proc-num" + txt.odo_preal_codigo + "'>" +
                    "<td class='ui-state-default'>" + txt.proc_nome + "</td>" +
                    "<td class='ui-state-default' align='center'>" + dentenum + "</td>" +
                    "<td class='ui-state-default' align='center'>" + denteface + "</td>" +
                    "<td class='ui-state-default' align='center'>" + sextante + "</td>" +
                    "<td class='ui-state-default' align='center'>" + boca + "</td>" +
                    "<td class='ui-state-default'>" + denteanot + "</td>" +
                    "<td class='ui-state-default' align='center'>" +
                    "<a style='cursor: pointer'>" +
                    "<img title='Excluir' alt='Excluir' src='/WebSocialSaude/zf/public/images/icons/excluir.png' onclick='excluiProcedimentoRealizado(" + txt.odo_preal_codigo + ");'></img>" +
                    "</a>" +
                    "</td>" +
                    "<td class='ui-state-default' align='center'>" +
                    "<a style='cursor: pointer'>" +
                    "<img title='Editar' alt='Editar' src='/WebSocialSaude/zf/public/images/icons/editar.png' onclick='editaProcedimentoRealizado(" + txt.odo_preal_codigo + ");' />" +
                    "</a>" +
                    "</td>" +
                    "</tr>";
                $("#nenhum-result").remove();
                $("#result")
                    .attr("src", baseUrl + "/public/images/load.gif")
                    .attr("title", "Carregando");
                // Inserindo procedimento realizado na lista
                $("#result").prepend(listaProcedimentos);
            }else{
                // Criando lista de procedimentos
                listaProcedimentos += "<tr id='proc-num" + txt.odo_preal_codigo + "'>" +
                    "<td class='ui-state-default' align='center'>" + dentenum + "</td>" +
                    "<td class='ui-state-default'>" + denteanot + "</td>" +
                    "<td class='ui-state-default' align='center'>" +
                    "<a style='cursor: pointer'>" +
                    "<img title='Excluir' alt='Excluir' src='/WebSocialSaude/zf/public/images/icons/excluir.png' onclick='excluiProcedimentoRealizado(" + txt.odo_preal_codigo + ");'/>" +
                    "</a></td></tr>";
                $("#nenhum-result").remove();
                $("#result_faltante")
                    .attr("src", baseUrl + "/public/images/load.gif")
                    .attr("title", "Carregando");
                // Inserindo procedimento realizado na lista
                $("#result_faltante").prepend(listaProcedimentos);
            }
            // Pinta o dente do procedimento realizado
            carregaProcReal(odo_preal_codigo);
        }
    });
}

// Função que exclui o procedimento realizado
function excluiProcedimentoRealizado(odo_preal_codigo) {
    $.ajax({
        url: baseUrl + "/prontuario/odontograma/confere-procedimento-realizado-atendimento",
        type: "POST",
        data: {
            odo_preal_codigo: odo_preal_codigo
        },
        success: function (txt) {
            if (txt == "true") {
                confirme("Confirme:", "Deseja realmente excluir este item?", 300, 150, function () {
                    $("#proc-num" + odo_preal_codigo + "")
                        .attr("src", baseUrl + "/public/images/loading.gif")
                        .attr("title", "Carregando");
                    $.ajax({
                        url: baseUrl + "/prontuario/odontograma/excluir-procedimento-realizado",
                        type: "POST",
                        data: {
                            odo_preal_codigo: odo_preal_codigo
                        },
                        success: function (txt) {
                            $("#proc-num" + odo_preal_codigo).remove();
                            carregaHistDeProcReal();
                        }
                    });
                });
            } else {
                mensagem("Erro:", "Procedimento não está vinculado com o atendimento atual! Não pode ser apagado!", 320, 180);
            }
        }
    });
}

// Carrega o histórico de procedimentos realizados
function carregaHistDeProcReal(odo_trat_codigo) {
    //carregandoAba(1);
    limparDentes();
    $.ajax({
        dataType: "json",
        url: baseUrl + "/prontuario/odontograma/lista-procedimentos-realizado",
        type: "POST",
        data: {
            odo_trat_codigo: odo_trat_codigo
        },
        success: function (json) {
            pintarDentes(json);
            carregandoAba(0);
        }
    });
}

// Carrega o histórico de procedimentos realizados
function carregaConsultaHistDeProcReal(odo_trat_codigo) {
    $.ajax({
        dataType: "json",
        url: baseUrl + "/prontuario/odontograma/lista-procedimentos-realizado-consulta",
        type: "POST",
        data: {
            odo_trat_codigo: odo_trat_codigo
        },
        //url: baseUrl+"/prontuario/odontograma/procedimentos",
        success: function (json) {
            pintarDentesConsulta(json);
            carregandoAba(0);
        }
    });
}

// Carrega somente o procedimento realizado especificado
function carregaProcReal(odo_preal_codigo) {
    $.ajax({
        url: baseUrl + "/prontuario/odontograma/lista-procedimentos-realizado",
        type: "POST",
        data: {
            odo_preal_codigo: odo_preal_codigo
        },
        success: function (json) {
            pintarDentes(json);
        }
    });
}

function limparDentes() {
    $("#odontograma").find("path, rect, polygon").removeAttr("style");
}

function limparDentesEspecifico(dente) {
    $("#odontograma #dente_" + dente).find("path, rect, polygon").removeAttr("style");
}

function pintarDentes(json) {
    var faces = ["M", "L", "O", "D", "V"];
    $.each(json, function(i, v){
        //procedimento boca
        if(v.odo_preal_exodontia){
            if(v.odo_preal_sextante != null){
                marcaSextanteExodontia(v.odo_preal_dentenum.trim());
            }else{
                marcaDenteExodontia("dente_" + v.odo_preal_dentenum.trim());
            }
        }else{
            if(v.odo_preal_boca != null){
                marcarBoca(v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_sextante != null){
                marcarSextante(v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_marcacao){
                marcaDenteExtraido("dente_" + v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_denteface == "" && !v.odo_preal_marcacao){
                marcarDenteCompleto(v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_denteface != "" && !v.odo_preal_marcacao){
                for(c=0;c < v.odo_preal_denteface.length; c++){
                    var char = v.odo_preal_denteface.trim().charAt(c);
                    if(faces.indexOf(char) != -1){
                        marcarFace(v.odo_preal_dentenum, char);
                    }
                }
            }
        }
    });
}

function pintarDentesConsulta(json) {
    var faces = ["M", "L", "O", "D", "V"];
    // $("#svg-odonto").find("path, polygon, rect").removeAttr("style");
    $.each(json, function(i, v){
        //procedimento boca
        if(v.odo_preal_exodontia){
            if(v.odo_preal_sextante != null){
                marcaSextanteExodontia("c_" + v.odo_preal_dentenum.trim());
            }else{
                marcaDenteExodontia("dente_c_" + v.odo_preal_dentenum.trim());
            }
        }else{
            if(v.odo_preal_boca != null){
                marcarBoca("c_" + v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_sextante != null){
                marcarSextante("c_" + v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_marcacao){
                marcaDenteExtraido("dente_c_" + v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_denteface == "" && !v.odo_preal_marcacao){
                marcarDenteCompleto("c_" + v.odo_preal_dentenum.trim());
            }
            if(v.odo_preal_denteface != "" && !v.odo_preal_marcacao){
                for(c=0;c < v.odo_preal_denteface.length; c++){
                    var char = v.odo_preal_denteface.trim().charAt(c);
                    if(faces.indexOf(char) != -1){
                        marcarFace("c_" + v.odo_preal_dentenum, char);
                    }
                }
            }
        }
    });
}
