$(function(){
    
	$("#historico").click(function(){
		$("#historico-dialog").dialog({
			modal: true	
		});
	});

	if($("#pc_codigo").val() !== ''){
        $('form').find('input, textarea, select').attr('disabled','disabled');
	}

	$("#btn-editar").click(function () {
        $('form').find('input, textarea, select').removeAttr('disabled');
        $("#imc").attr('disabled','disabled');
        $("#btn-salvar").css("display", 'inline-block');
        $("#btn-editar").css("display", 'none');
    });

	setRules();

	$("form").validate({
		rules: {
            temperatura: { ruleTemperatura: {"min": 30,"max": 45} },
			peso: { rulePeso: {"min": 0.5,"max": 500} },
			altura: { ruleAltura: {"min": 0.2,"max": 2.5} },
            p_cefalico: { ruleCefalico: {"min": 10.0,"max": 200.0} },
            pressao_sistolica: { range: [0, 300] },
            pressao_diastolica: { range: [0, 300] }
		}
	});
    
});

function setRules(){
    jQuery.validator.addMethod("ruleTemperatura", function(value, element, params) {
        return this.optional(element) || methodValid(value, element, params);
    }, "Verifique a temperatura");

    jQuery.validator.addMethod("rulePeso", function(value, element, params) {
        return this.optional(element) || methodValid(value, element, params);
    }, "Valores devem ser entre 0,5 e 500");

    jQuery.validator.addMethod("ruleAltura", function(value, element, params) {
        return this.optional(element) || methodValid(value, element, params);
    }, "Verifique a altura");
    jQuery.validator.addMethod("ruleCefalico", function(value, element, params) {
        return this.optional(element) || methodValid(value, element, params);
    }, "Valores devem ser entre 10,00 e 200,00 ");
}

function methodValid(value, element, params){
    return (stringToFloat(value) >= params.min && stringToFloat(value) <= params.max);
}

function stringToFloat(value){
    if(value.indexOf(",") != -1){
        return parseFloat(value.toString().replace(".", "").replace(",", "."));
    }
    return parseFloat(value);
}

function atualizaIMC() {
    var peso =stringToFloat($("#peso").val());
    var altura = stringToFloat($("#altura").val());
    var imc = "";
    altura *= altura;

    if (peso && altura) {
        imc = Math.round(peso / altura * 100) / 100;
    }
    return $("#imc").val(number_format(imc, 2, ",", "."));
}