$(function(){
    $("#div_add_posto").hide();
    $("#div_add_controlados").hide();
    $("#div_add_externo").hide();

    $(".buscar").each(function () {
        var rel = $(this).attr("rel");
        $(this).buscar({
            url: baseUrl + "/produto/medicamento-" + rel,
            template: function (ul, item) {
                $("#pro_codigo_" + rel).val("");
                return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
            },
            callback: function (event, ui) {
                if (ui.item.id > 0) {
                    $("#rec_" + rel + "_pro_codigo").val(ui.item.data['pro_codigo']);
                    var umed = "Não classificado";
                    if(ui.item.data['umed_nome']){
                        umed = ui.item.data['umed_nome'] + " (S)";
                    }
                    $("#umed_"+rel).html(umed);
                    $("#rec_"+ rel + "_quantidade").select();
                    return true;
                }
                return false;
            }
        });
    });
    verificaHistoricos();
    adicionaValidacoes();
});

function adicionaValidacoes() {
    //Validações
    $("#form_rec_posto").validate({
        rules: {
            rec_posto_medicamento: {required: true},
            rec_posto_quantidade: {required: true},
            rec_posto_validade: {required: true},
        },
        messages :{
            rec_posto_medicamento: {required: "Campo obrigatório"},
            rec_posto_quantidade: {required: "Campo obrigatório"},
            rec_posto_validade: {required: "Campo obrigatório"}
        }
    });

    $("#form_rec_controlados").validate({
        rules: {
            rec_controlados_medicamento: {required: true},
            rec_controlados_quantidade: {required: true},
            rec_controlados_validade: {required: true},
        },
        messages :{
            rec_controlados_medicamento: {required: "Campo obrigatório"},
            rec_controlados_quantidade: {required: "Campo obrigatório"},
            rec_controlados_validade: {required: "Campo obrigatório"}
        }
    });

    $("#form_rec_externo").validate({
        rules: {
            rec_externo_medicamento: {required: true},
            rec_externo_quantidade: {required: true},
            rec_externo_validade: {required: true},
        },
        messages :{
            rec_externo_medicamento: {required: "Campo obrigatório"},
            rec_externo_quantidade: {required: "Campo obrigatório"},
            rec_externo_validade: {required: "Campo obrigatório"}
        }
    });
}

function verificaHistoricos() {
    $.ajax({
        url: baseUrl + "/prontuario/receita-medica/verifica-historico?usu_codigo=" + $("#usu_codigo").val(),
        success: function(ret){
            $("#hist-posto").css("display", (ret.hist_p ? "" : "none"));
            $("#hist-controlados").css("display", (ret.hist_c ? "" : "none"));
        }
    })
}

//Gera id's aleatórios
function makeid() {
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < 25; i++)
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    return text;
}

function adicionarMedicamentos(id){
    if($("#form_rec_" + id).valid()){
        if($("#rec_" + id + "_pro_codigo").val() == ""){
            mensagem("Erro", "Produto adicionado incorretamente.", 350, 150);
            limpaForm(id);
            return;
        }
        var trId = "tr_" + id + "_" + makeid();
        var tr = "<tr id='" + trId + "'>"
            + "  <td hidden>" +$("#rec_" + id + "_pro_codigo").val() +"</td>"
            + "  <td class='ui-state-default'>" +$("#rec_" + id + "_medicamento").val() +"</td>"
            + "  <td class='ui-state-default c'>" +$("#rec_" + id + "_quantidade").val() +"</td>"
            + "  <td class='ui-state-default'>" +$("#rec_" + id + "_recomendacao").val() +"</td>"
            + "  <td class='ui-state-default c'>"
            + "     <a onclick='removeItem(\""+ trId +"\", \""+ id +"\")' class='button'>"
            + "         <img src='/WebSocialSaude/zf/public/images/icons/excluir.png' alt='Remover' title='Remover Item'/>"
            + "     </a>"
            + "  </td>"
            + "</tr>";
        limpaForm(id);
        $("#tb_add_" + id + " tbody").append(tr);
        $("#div_add_" + id).show();
    }
}

function adicionarMedicamentosExterno(){
    if($("#form_rec_externo").valid()){
        var trId = "tr_externo_" + makeid();
        var pro_descricao = $("#rec_externo_medicamento").val()
            + ($("#rec_externo_descricao").val() != "" ? " / " + $("#rec_externo_descricao").val() : "");
        var tr = "<tr id='" + trId + "'>"
            + "  <td hidden></td>"
            + "  <td class='ui-state-default'>" + pro_descricao.toUpperCase() + "</td>"
            + "  <td class='ui-state-default c'>" +$("#rec_externo_quantidade").val() +"</td>"
            + "  <td class='ui-state-default'>" +$("#rec_externo_recomendacao").val() +"</td>"
            + "  <td class='ui-state-default c'>"
            + "     <a onclick='removeItem(\""+ trId +"\", \"externo\")' class='button'>"
            + "         <img src='/WebSocialSaude/zf/public/images/icons/excluir.png' alt='Remover' title='Remover Item'/>"
            + "     </a>"
            + "  </td>"
            + "  <td hidden>" + $("#rec_externo_medicamento").val() + "</td>"
            + "  <td hidden>" + $("#rec_externo_descricao").val() + "</td>"
            + "</tr>";
        limpaForm("externo");
        $("#tb_add_externo tbody").append(tr);
        $("#div_add_externo").show();
    }
}

function limpaForm(id) {
    $("#rec_" + id + "_pro_codigo").val("");
    $("#rec_" + id + "_medicamento").val("");
    if(id == "externo"){
        $("#rec_" + id + "_descricao").val("");
    }
    $("#rec_" + id + "_quantidade").val("");
    $("#rec_" + id + "_recomendacao").val("");
    $("#umed_" + id).html("");
    $("#rec_" + id + "_medicamento").select();
}

function removeItem(id, tipo){
    confirme("Atenção", "Deseja remover este item da receita? ", 320, 130, function(){
        $("#" + id).remove();
        var tb = $("#tb_add_" + tipo + " tbody tr");
        if(tb.length == 0){
            $("#div_add_" + tipo).hide();
        }
    });
}

function salvarMedicamentos(tipo){
    var itens = [];
    $("#tb_add_" + tipo +" tbody tr").each(function(){
        var pro_codigo = this.cells[0].innerHTML;
        var qtde = this.cells[2].innerHTML;
        var recomendacao = this.cells[3].innerHTML;
        var pro_nome = (tipo == "externo" ? this.cells[5].innerHTML : null);
        var pro_descricao = (tipo == "externo" ? this.cells[6].innerHTML : null);
        itens.push(new Item(pro_codigo, qtde, recomendacao, pro_nome, pro_descricao));
    });
    mensagemSemOk("carregando-med", "Aguarde", "Carregando...", 280, 80);
    $.ajax({
        url: baseUrl + "/prontuario/receita-medica/salvar-medicamento",
        type: "POST",
        data: {
            tipo: tipo,
            receita: {
                ate_codigo: $("#ate_codigo").val(),
                rec_validade: $("#rec_" + tipo + "_validade").val()
            },
            itens: itens
        },
        success: function(ret){
            fecharMensagemSemOk("carregando-med");
            if(ret.error){
                mensagem("Erro", ret.mensagem, 350, 'auto');
            }else{
                mensagem("Sucesso", "Receita salva com sucesso!", 330, 150, function () {
                    carregaReceita(tipo, ret.itens);
                    limpaDados(tipo);
                });

            }
        }
    });
}

function carregaReceita(tipo, itens) {
    var table = $("#tb_item_" + tipo + " tbody");
    table.empty();
    var tr = "";
    if(itens.length > 0){
        $.each(itens, function(i, e){
            var pro_nome = (tipo == "externo" ? (e.irec_produto + " / " + e.desc_produto) : e.pro_nome);
            tr += "<tr>"
                + "  <td class='ui-state-default c'>"
                + "      <input type='hidden' id='irec_codigo' value='" + e.irec_codigo + "'/>"
                + "      <input type='checkbox' id='" + e.irec_codigo + "'  class='produto' value='" + e.irec_codigo + "' name='imprimir'/>"
                + "  </td>"
                + "  <td class='ui-state-default c'>" + pro_nome + "</td>"
                + "  <td class='ui-state-default c'>" + e.irec_quantidade + "</td>"
                + "  <td class='ui-state-default escape'>" + e.irec_recomendacao + "</td>"
                + "  <td class='ui-state-default c'>"
                + "    <a onclick='excluirItemReceita(" + e.irec_codigo + ", \"" + tipo + "\")' class='button'>"
                + "        <img src='/WebSocialSaude/zf/public/images/icons/excluir.png' alt='Excluir' title='Excluir Item " + e.pro_nome + "'/>"
                + "    </a>"
                + "  </td>"
                + "</tr>";
        });
        $("#imprime-" + tipo).css("display", "");
    }else{
        tr = "<tr><td colspan='5' class='ui-state-default c'>Não há itens na receita</td></tr>";
        $("#imprime-" + tipo).css("display", "none");
    }
    table.html(tr);
    verificaHistoricos();
}

function limpaDados(tipo) {
    $("#tb_add_" + tipo + " tbody").empty();
    $("#div_add_" + tipo).hide();
}

function inicializarModal() {
    $(".buscar").each(function () {
        var rel = $(this).attr("rel");
        $(this).buscar({
            url: baseUrl + "/produto/medicamento-" + rel,
            template: function (ul, item) {
                $("#pro_codigo_" + rel).val("");
                return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
            },
            callback: function (event, ui) {
                if (ui.item.id > 0) {
                    $("#rec_" + rel + "_pro_codigo").val(ui.item.data['pro_codigo']);
                    $("#umed_"+rel).html(ui.item.data['umed_nome'] + " (S)");
                    $("#rec_"+ rel + "_quantidade").select();
                    return true;
                }
                return false;
            }
        });
    });
}

function excluirItemReceita(irec_codigo, tipo){
    confirme("Atenção", "Deseja realmente excluir este item? ", 320, 130, function(){
        mensagemSemOk("carregando-del-item", "Aguarde", "Carregando...", 280, 80);
        $.ajax({
            url: baseUrl + "/prontuario/receita-medica/excluir-item-receita",
            data: {
                irec_codigo: irec_codigo,
                tipo: tipo,
                usuario: $("#usu_codigo").val()
            },
            success: function(ret){
                fecharMensagemSemOk("carregando-del-item");
                if(ret.error){
                    mensagem("Erro", ret.mensagem, 350, 'auto');
                }else{
                    mensagem("Sucesso", "Item excluído!", 330, 150, function () {
                        carregaReceita(tipo, ret.itens);
                    });
                }
            }
        });
    })
}

function Item(pro_codigo, qtde, recomendacao, pro_nome, pro_descricao){
    this.pro_codigo = pro_codigo;
    this.irec_quantidade = qtde;
    this.irec_recomendacao = recomendacao;
    this.irec_produto = pro_nome;
    this.desc_produto = pro_descricao;
}

//Funções do modal de histórico de medicamentos
function abrirHistorico(tipo){
    var usu_codigo = $("#usu_codigo").val();
    $("body").append("<div id='historico_medicamento_modal' title='Histórico de medicamentos'></div>");
    $("#historico_medicamento_modal")
        .html("<img src='" + baseUrl + "/public/images/load.gif' alt='Carregando' \n\ title='Carregando dados ...' />")
        .dialog({
            modal: true,
            resizable: false,
            position: ['center'],
            width: 750,
            height: 500,
            open: function(){
                inicializarModal();
            },
            buttons: {
                "Prescrever": function(){
                    var nao_adicionados = [];
                    $("#table-historico").find("input[name*=ck_]").each(function(){
                        if($(this).is(":checked")){
                            var pro_codigo = $(this).closest("tr").find("input[name=pro_codigo_]").val();
                            var pro_nome = $(this).closest("tr").find("input[name=pro_nome_]").val();
                            var qtde = $(this).closest("tr").find("input[name=qtde_]").val();
                            var recomendacao = $(this).closest("tbody").find("#rec_" + $(this).attr('id')).val();

                            var adicionar = true;

                            $("#tb_add_" + tipo + " tbody tr").find("td:hidden").each(function(){
                                console.log($(this).html() + " == " + pro_codigo);
                                if($(this).html() == pro_codigo){
                                    adicionar = false;
                                    nao_adicionados.push(pro_nome);
                                }
                            });

                            if(adicionar){
                                var trId = "tr_" + tipo + "_" + makeid();
                                var tr = "<tr id='" + trId + "'>"
                                    + "  <td hidden>" + pro_codigo +"</td>"
                                    + "  <td class='ui-state-default'>" + pro_nome +"</td>"
                                    + "  <td class='ui-state-default c'>" + qtde +"</td>"
                                    + "  <td class='ui-state-default'>" + recomendacao +"</td>"
                                    + "  <td class='ui-state-default c'>"
                                    + "     <a onclick='removeItem(\""+ trId +"\", \""+ tipo +"\")' class='button'>"
                                    + "         <img src='/WebSocialSaude/zf/public/images/icons/excluir.png' alt='Remover' title='Remover Item'/>"
                                    + "     </a>"
                                    + "  </td>"
                                    + "</tr>";
                                $("#tb_add_" + tipo + " tbody").append(tr);
                                $("#div_add_" + tipo).show();
                            }

                        }
                    });
                    $(this).dialog("destroy");
                    $("#historico_medicamento_modal").remove();
                    if(nao_adicionados.length > 0){
                        mensagem("Atenção", "O(s) produto(s) <b>" + nao_adicionados + "</b> já foi(foram) adicionado(s)!", 400, 180);
                    }
                },
                Fechar: function(){
                    $(this).dialog("destroy");
                    $("#historico_medicamento_modal").remove();
                }
            }
        })
        .load(baseUrl + "/prontuario/receita-medica/historico-medicamento/tipo/" + tipo + "/usu_codigo/" + usu_codigo);
}

function procurar(){
    var value = $("#pro_nome_historico").val();
    $("td.pro_nome").css("color", "#2e6e9e");
    $("td.pro_nome:contains('" + value.toUpperCase() + "')").css( "color", "red" );
}

function checaReceita(tb){
    $("#tb_" + tb).find("input[type=checkbox]").each(function(){
        $(this).prop("checked", $("#ckpai_" + tb).prop("checked"));
    });
}

function alteraCheck(idPai){
    var qtdeTotal = 0;
    var qtdeSelecionado = 0;
    var checkpai = $("#ckpai_" + idPai);
    $("#tb_" + idPai).find("input[name=ck_]").each(function () {
        qtdeTotal++;
        if ($(this).is(":checked")) {
            qtdeSelecionado++;
        }
    });
    checkpai.prop("indeterminate", false);
    if (qtdeTotal == qtdeSelecionado) {
        checkpai.prop("checked", true);
    } else if (qtdeSelecionado == 0) {
        checkpai.prop("checked", false);
    } else {
        checkpai.prop("indeterminate", true);
    }
}

function imprimir(duasVias, tipoMedicamento, tipoImpressao, io_codigo) {
    var rec_codigo = $("#rec_codigo_" + tipoMedicamento).val();
    var usu_codigo = $("#usu_codigo").val();
    var _arraySelecinados = new Array();
    $("#tb_item_" + tipoMedicamento).find("input[type=checkbox]:checked").each(function(){
        if($(this).is(":checked")){
            _arraySelecinados.push($(this).val());
        }
    });

    if(_arraySelecinados.length == 0){
        _arraySelecinados = null;
    }

    if (io_codigo > 0 ) {
        popup(baseUrl + '/prontuario/receita-medica/' + tipoImpressao + '/caminhoTipo/' + tipoMedicamento + '/selecionados/' + _arraySelecinados + '/rec_codigo/' + rec_codigo + '/seg/' + duasVias + '/io_codigo/'+ io_codigo + '/usu_codigo/' + usu_codigo , 'medicamentos', 1400, 600);
    } else {
        popup(baseUrl + '/prontuario/receita-medica/' + tipoImpressao + '/caminhoTipo/' + tipoMedicamento + '/selecionados/' + _arraySelecinados + '/rec_codigo/' + rec_codigo + '/seg/' + duasVias, 'medicamentos', 1400, 600);
    }
}
