$(function () {
    $("#condutas")
        .bind('dblclick', selecionarConduta)
        .bind('keydown', selecionarConduta);

    $("#condutas-selecionadas")
        .bind('dblclick', deselecionarConduta)
        .bind('keydown', deselecionarConduta);

    $("#condutas-odonto")
        .bind('dblclick', selecionarConduta)
        .bind('keydown', selecionarConduta);

    $("#condutas-odonto-selecionadas")
        .bind('dblclick', deselecionarConduta)
        .bind('keydown', deselecionarConduta);

    $("#form").validate({
        rules: {
            data_inicial: {
                required: true
            },
            data_final: {
                required: true
            }
        },
        messages: {
            data_inicial: {
                required: "Preencha a data inicial",
            },
            data_final: {
                required: "Preencha a data final",
            }
        }
    });
    
    $("#formsetor").validate({
        rules: {
            set_nome: {
                required: true
            }
        },
        messages: {
            set_nome: {
                required: "Campo obrigatorio setor",
            }
        }
    });

    $("#form_prestador").validate({
        rules: {
            prestador_nome: {
                required: true
            }
        },
        messages: {
            prestador_nome: {
                required: "Selecione um prestador",
            }
        }
    });


    $("#form-balanco-prod-set").validate({
        rules: {
            set_nome: {
                required: true
            },
            data_inicial: {
                required: true
            },
            data_final: {
                required: true
            }
        },
        messages: {
            set_nome: {
                required: "Campo obrigatorio setor",
            },
            data_inicial: {
                required: "Preencha a data inicial",
            },
            data_final: {
                required: "Preencha a data final",
            }
        }
    });
    
    


    $("#buscar5").buscar({
        url: baseUrl + '/default/usuarios/buscar/externo/1',
        categoria: 'categoria',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            return true;
        }
    });

    $("#set_nome").buscar({
        url: baseUrl + "/setor/buscar/set_logado/1",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });

    $("#set_nome_destino").buscar({
        url: baseUrl + "/setor/buscar-destino/set_logado/1",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
    
    $("#for_nome").buscar({
        url: baseUrl + "/fornecedor/buscar/for_logado/1",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });

    $("#uni_desc").buscar({
        url: baseUrl + "/unidade/buscar",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });

    $('#uni_desc').change(function () {
        if ($('#uni_desc').val() === "") {
            $("#ine_codigo").html("<option value=''>--SELECIONE UMA UNIDADE--</option>");
        }
    });

    $("#usu_nome").buscar({
        url: baseUrl + "/paciente/buscar-usuario-relatorio"
    });

    $("#pro_nome").buscar({
        url: baseUrl + "/produto/medicamento-controlados",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
    
    $("#proc_nome").buscar({
        url: baseUrl + "/default/procedimento/buscar",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });

    $("#usr_nome").buscar({
        url: baseUrl + "/default/usuarios/buscar/externo/1",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
    
    $("#prestador_nome").buscar({
        url: baseUrl + "/default/medico-externo/buscar-prestador",
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });



    $("#cid").buscar({
        url: baseUrl + '/prontuario/cid/buscar/',
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (event, ui) {
            return true;
        }
    });

    $("#usr_nome").change(function () {
        if ($("#usr_nome").length == 0)
            $("#usr_codigo").val("");
    });


    $("#usu_nome").change(function () {
        if ($("#usu_nome").length == 0)
            $("#usu_codigo").val("");
    });




});

function buscaUnidade() {
    $("#uni_desc").buscar({
            url: baseUrl + "/unidade/buscar",
            minLength: 3,
            template: function (ul, item) {
                return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
            }, callback: function () {
                carregaEquipeIne();
            }
        }
    );
}

function carregaEquipeIne() {
    var uni_codigo = $("#uni_codigo").val();
    $.ajax({
        url: baseUrl + '/relatorio/visita-domiciliar/preenche-equipes',
        type: "POST",
        data: {
            uni_codigo: uni_codigo
        },
        success: function (json) {
            $("#ine_codigo").html("");
            $("#ine_codigo").append("<option value=''>--SELECIONE--</option>");
            $.each(json, function (key, value) {
                $("#ine_codigo").append("<option title=\"" + value['no_equipe'] + "\"  value=\"" + value['nu_ine'] + "\" " + ">" + value['nu_ine'] + " - " + value['no_equipe'] + "</option>");
            });
        }
    });
}

function carregaMicroArea(nu_ine) {
    $.ajax({
        url: baseUrl + '/relatorio/visita-domiciliar/preenche-microarea/nu_ine/' + nu_ine,
        success: function (json) {
            $("#mic_codigo").html("");
            $("#mic_codigo").append("<option value=''>--SELECIONE--</option>");
            $.each(json, function (key, value) {
                $("#mic_codigo").append("<option title=\"" + value['mic_descricao'] + "\"  value=\"" + value['mic_codigo'] + "\" " + ">" + value['mic_descricao'] + " - " + value['usr_nome'] + "</option>");
            });
        }
    });
}

function buscaProdutos() {
    var set_codigo = $("#set_codigo").val();
    $(".pro_nome").buscar({
        url: baseUrl + "/produto/buscar-produtos/setor/" + set_codigo,
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function validarFiltrosRelatorioProducaoDiaria() {

    $("#relatorioProducaoDiaria").validate({
        rules: {
            data_inicial: {
                required: true
            },
            data_final: {required: true}
        },
        messages: {
            data_inicial: {
                required: "Campo Obrigatório!"
            },
            data_final: {
                required: "Campo Obrigatório!"
            }
        }
    });

}

function validarFiltros() {

    $("#relatorioAtendimentoPorNivel").validate({
        rules: {
            data_inicial: {
                required: true
            },
            data_final: {
                required: true
            }
        },
        messages: {
            data_inicial: {
                required: "Campo Obrigatório!"
            },
            data_final: {
                required: "Campo Obrigatório!"
            }
        }
    });

}

function selecionarConduta(e){

    if ($("#tipo_conduta:checked").val() == 'A') {
        // só pode ser a tecla 39 (seta para direita)
        if (e.keyCode && e.keyCode != 39 || e.charCode)
            return;

        if (!$("#condutas option:selected").size())
            return;

        // se o primeiro for 0, limpar select
        if ($("#condutas-selecionadas option:first").val() == "0") {
            $("#condutas-selecionadas").empty();
        }

        // add
        $("#condutas-selecionadas").append(
            $("#condutas option:selected")
        );
    }

    if ($("#tipo_conduta:checked").val() == 'O') {
        // só pode ser a tecla 39 (seta para direita)
        if (e.keyCode && e.keyCode != 39 || e.charCode)
            return;

        if (!$("#condutas-odonto option:selected").size())
            return;

        // se o primeiro for 0, limpar select
        if ($("#condutas-odonto-selecionadas option:first").val() == "0") {
            $("#condutas-odonto-selecionadas").empty();
        }

        // add
        $("#condutas-odonto-selecionadas").append(
            $("#condutas-odonto option:selected")
        );
    }

}


function deselecionarConduta(e){

    if ($("#tipo_conduta:checked").val() == 'A') {
        // só pode ser a tecla 39 (seta para esquerda)
        if(e.keyCode && e.keyCode != 37 || e.charCode)
            return;

        // remover
        $("#condutas-selecionadas option:selected").appendTo("#condutas");

        // se não houver mais opções, add "Nenhum"
        if($("#condutas-selecionadas option").size() == 0){
            $("#condutas-selecionadas").empty().append('<option value="0" disabled="disabled">Nenhuma Conduta Selecionada</option>');
        }
        // $("#seleciona_condutas").show();
    }

    if ($("#tipo_conduta:checked").val() == 'O') {

        // só pode ser a tecla 39 (seta para esquerda)
        if (e.keyCode && e.keyCode != 37 || e.charCode)
            return;

        // remover
        $("#condutas-odonto-selecionadas option:selected").appendTo("#condutas-odonto");

        // se não houver mais opções, add "Nenhum"
        if ($("#condutas-odonto-selecionadas option").size() == 0) {
            $("#condutas-odonto-selecionadas").empty().append('<option value="0" disabled="disabled">Nenhuma Conduta Selecionada</option>');
        }
        // $("#seleciona_condutas").show();
    }

}