$(function() {
    $("#uni_desc").focus();
    
    $("#ds_ciap").buscar({
        url: baseUrl+'/prontuario/atendimento/buscar-ciap/',
        suffix: '_2',
        search: function(){
            $("#ciap").empty();
        },
        template : function(ul, item) {
            ul.hide();			
            $("<option />").val(item.id).html(item.label).appendTo("#ciap");
            return false;
        },
        callback: function(event, ui){
            $("#ciap").focus();
        }
    });
    
    $("#ciap")
	.bind('dblclick', selecionarCiap)
	.bind('keydown', selecionarCiap);
	
    $("#ciap-selecionados")
    .bind('dblclick', deselecionarCiap)
    .bind('keydown', deselecionarCiap);
    
});

function buscaProfissional() {
   var tipo_atend = $("#tipo_atendimento").val();
   var uni_codigo = $("#uni_codigo").val();
    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar/tipo/'+tipo_atend+'/unidade/'+uni_codigo+'/',
        template: function(ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });

}


function selecionarTodosOsCiapSelecionados(){
    var optionlist = document.getElementById('ciap-selecionados').options;
    validaData();

    for (var option = 0; option < optionlist.length; option++ ) {
        if (option == 1) {
            $("#conf_ciap").val("1");
        }
        optionlist[option].selected = true;     
    }
}


function selecionarCiap(e){
    $("#conf_ciap").val("1");
    // só pode ser a tecla 39 (seta para direita)
    if (e.keyCode && e.keyCode != 39 || e.charCode)
        return;

    if (!$("#ciap option:selected").size())
        return;

    // se o primeiro for 0, limpar select
    if ($("#ciap-selecionados option:first").val() == "0") {
        $("#ciap-selecionados").empty();
    }

    $("#ciap-selecionados").append(
        $("#ciap option:selected")
    );
}

function deselecionarCiap(e){
    // só pode ser a tecla 39 (seta para esquerda)
    if (e.keyCode && e.keyCode != 37 || e.charCode)
        return;

    $("#ciap-selecionados option:selected").remove();

    if ($("#ciap-selecionados option").size() == 0) {
        $("#ciap-selecionados").empty().append('<option value="0" disabled="disabled">Nenhum ciap selecionado</option>');
        $("#conf_ciap").val("");
    }
}


function buscaUnidade() {
    $("#uni_desc").buscar({
        url: baseUrl + "/unidade/buscar",
        minLength: 3,
        template: function (ul, item) {
            return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
        }
    });
}

function buscarCiap(){
    selecionarTodos();
    $("#ciap_busca").buscar({
        url: baseUrl+'/prontuario/atendimento/novo-buscar-ciap/selecionados/'+$("#ciap-selecionados").val()+'/',
        template : function(ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                    "<a><strong>"+item.codigoCiap+" - "+item.label+"</strong><br>\n\
                        <font size=\"1\"> Inlc: "+item.ds_inclusao+" \n\
                        <br>\n\
                        Excl: "+item.ds_exclusao+"  \n\
                        <br>\n\
                        </font></a>").appendTo(ul);
        },
        callback: function(event,ui){
            if(ui.item.id != 0){
                if($("#ciap-selecionados option:first").val() == "0"){
                    $("#ciap-selecionados").empty();
                    $("#conf_ciap").val("1");
                }
                $('#ciap-selecionados').append("<option select=\"selected\" value="+ui.item.id+">"+ui.item.label+"</option>");
            }
            $('#ciap_busca').val("");
            selecionarTodos();
        }
    });
}

function selecionarTodos(){
    $("#ciap-selecionados option").each(function(){
        $(this).attr('selected', 'selected')
    });
}

function validaData(){
    var data = $("#data_atendimento").val();
    var dataFormatada = data.split('/');
    var dataFormatada = new Date(dataFormatada[2],dataFormatada[1]-1,dataFormatada[0]);
    var dataHoje = new Date();
    
    if(dataFormatada <= dataHoje){
        $("#data_valida").val(true);
    }else{
        $("#data_valida").val('');
    }
}