function carregaProfissionaisPorUnidade(uni_codigo){
    $.ajax({
        url: baseUrl + "/relatorio/agendamento/lista-profissionais-por-unidade/uni_codigo/" + uni_codigo,
        success: function(ret){
            var tpl = "<option value=''>Todos</option>";
            $.each(ret, function(k, v){
                tpl += "<option value='" + v.usr_codigo + "'>" + v.usr_nome + "</option>";
            })

            $("#cb_profissional")
                .html("")
                .append(tpl);
        }
    })
}

function adicionaFaixaEtaria(){
    var filtro = $("#filtro").val();
    var texto = $("#filtro option:selected").text().toLowerCase();

    var index = $("#count_filtros").val();
    if(filtro !== ""){
        var tpl =  "<div id='div-filtro-" + index + "'>";
            tpl += "    <input type='hidden' id='filtro_tipo_" + index + "' value='" + filtro + "'/>";
            tpl += "    <input type='hidden' name='filtro_index[]' value='" + index + "'/>";
            tpl += "    <label>Idade " + texto + ": </label>";

        if(filtro === '><'){
            tpl += "<input type='text' class='ui-state-default entre' id='filtro_" + index + "_inicio' style='width: 140px !important;' onkeypress='return onlyNumber(event, " + index + ");'/>";
            tpl += " e ";
            tpl += "<input type='text' class='ui-state-default entre' id='filtro_" + index + "_fim' style='width: 140px !important;' onkeypress='return onlyNumber(event, " + index + ");'/>";
        }else if(filtro === '<<'){
            tpl += "<input type='text' class='ui-state-default entre' id='filtro_" + index + "_meses' style='width: 140px !important;' onkeypress='return onlyNumber(event, " + index + ");'/>";
        }else{
            tpl += "<input type='text' id='filtro_" + index + "' name='filtro_" + index + "' class='ui-state-default' onkeypress='return onlyNumber(event, " + index + ");'/>";
        }

        tpl += "<a style='cursor: pointer' id='excluir' onclick='removeBotao(\"" + index + "\")'>" +
               "    <img src='"+ baseUrl + "/public/images/icons/excluir.png' alt='Excluir' title='Excluir' />" +
               "</a>";
        tpl += "<span id='errmsg_" +index+ "'></span>"
        $("#filtros").append(tpl + "</div>");
        $("#count_filtros").val(parseInt(index) + 1);

        $("#filtro").val("");
    }else{
        mensagem("Erro","Um filtro deve ser selecionado!",300,150);
    }
}

function onlyNumber(e, i){
    if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
        //display error message
        $("#errmsg_" + i).html("<small style='color: red'>  Somente números!</small>").show().fadeOut("slow");
        return false;
    }
}

function removeBotao(indice) {
    $( "#div-filtro-" + indice ).remove();
}


function gerarRelatorio(e) {
    if(validaForm(e)){
        var unidade = $("#unidade :selected").val();
        var profissional = $("#cb_profissional :selected").val();
        var procedimento = $("#proc_codigo").val();
        var proc_sus = $("#proc_codigo_sus").val();
        var data_inicial = formataDataBD($("#data_inicial").val());
        var data_final = formataDataBD($("#data_final").val());
        var tp_rel = $("#tp_rel:checked").val();

        var faixa_etaria = [];
        $('input[name^="filtro_index"]').each(function() {
            var index = $(this).val();
            var tipo = $("#filtro_tipo_" + index).val();
            var f = "";
            if(tipo === '><'){
                f += "' BETWEEN " + $("#filtro_" + index + "_inicio").val() + " AND " + $("#filtro_" + index + "_fim").val() + "'";
            }else{
                f += "' " + tipo + " " + $("#filtro_" + index).val() + "'";
            }
            faixa_etaria.push(f);
        }, faixa_etaria);

        callGenerateReport(
            baseUrl + "/relatorio/bpa/gerar-relatorio-procedimentos-gerais",
            {
                "unidade": unidade,
                "profissional": profissional,
                "procedimento": procedimento,
                "proc_sus": proc_sus,
                "data_inicial": data_inicial,
                "data_final": data_final,
                "faixa_etaria": faixa_etaria,
                "tp_rel": tp_rel
            }
        );
    }else{
        event.preventDefault();
    }
}

function validaForm(event){
    var data_inicial = $("#data_inicial").val();
    var data_final = $("#data_final").val();
    if(data_inicial != "" && data_final != ""){
        var dataInicial = brToSql(data_inicial);
        var dataFinal = brToSql(data_final);
        if (dataInicial > dataFinal) {
            mensagem("Erro", "Data Inicial não pode ser maior que Data final", 350, 120);
            event.preventDefault();
            return false;
        }
    }else{
        mensagem("Atenção", "Data Inicial e Data Final devem ser preenchidos!");
        return false;
    }


    var retorno = 0;

    $('input[name^="filtro_index"]').each(function() {
        var index = $(this).val();
        var tipo = $("#filtro_tipo_" + index).val();
        if(tipo === '><'){
            var inicio = parseInt($("#filtro_" + index + "_inicio").val());
            var fim = parseInt($("#filtro_" + index + "_fim").val());
            if(isNaN(inicio) || isNaN(fim)){
                mensagem("Erro", "Há faixas não preenchidas e/ou com valores inválidos!", 350, 120);
                retorno++;
                event.preventDefault();
                return false;
            }else{
                if(inicio === 0 || fim === 0){
                    mensagem("Erro", "Faixa inicial não pode ser maior que faixa final!", 350, 120);
                    retorno++;
                    event.preventDefault();
                    return false;
                }
                if(inicio >= fim){
                    mensagem("Erro", "Faixa inicial não pode ser maior que faixa final!", 350, 120);
                    retorno++;
                    event.preventDefault();
                    return false;
                }
            }
        }else{
            valor = parseInt($("#filtro_" + index).val());
            if(isNaN(valor)){
                mensagem("Erro","Há faixas não preenchidas e/ou com valores inválidos!",300,120);
                retorno++;
                event.preventDefault();
                return false;
            }
        }
        $('input[name^="filtro_index"]').each(function(index) {
            var index2 = $(this).val();
            if(index !== index2){
                if(!checaSobreposicao(index2, index, event)){
                    retorno++;
                    event.preventDefault();
                    return false;
                }
            }
        }, [index]);
    });

    return (retorno === 0);
}

function checaSobreposicao(x, y, event){
    var campo_x = $('#div-filtro-'+ x).length;
    var campo_y = $('#div-filtro-'+ y).length;
    if( !campo_x || !campo_y ){
        event.preventDefault();
        return false;
    }
    [x_inicio, x_fim] = getLimites(x);
    [y_inicio, y_fim] = getLimites(y);

    var tipo_x = $("#filtro_tipo_" + x).val();
    var tipo_y = $("#filtro_tipo_" + y).val();

    var cond;
    if((tipo_x === '><' || tipo_x === '=') && (tipo_y === '><' || tipo_y === '=')) {
        cond = (Math.max(x_inicio, y_inicio) <= Math.min(x_fim, y_fim));
    } else {
        cond = (x_fim > y_inicio && x_inicio < y_fim);
    }
    if(cond) {
        var erro = "Existem sobreposições entre os filtros:<br/>("
            + mensagemErro(x) + ") e (" + mensagemErro(y) + ").";
        mensagem("Erro", erro, 300, 150);
        event.preventDefault();
        return false;
    }
    return true;
}

function mensagemErro(id) {
    var tipo = $("#filtro_tipo_"+id).val();
    if(tipo ==='><') {
        return $("#filtro_" + id + "_inicio").val() + " <= Idade <=" + $("#filtro_" + id + "_fim").val();
    } else{
        return "Idade "+ tipo + " " + $("#filtro_" + id).val();
    }
}

function getLimites(id) {
    min = NaN;
    max = NaN;
    var valor = $("#filtro_" + id).val();
    switch($("#filtro_tipo_" + id).val()) {
        case '><':
            min = parseInt($("#filtro_" + id + "_inicio").val());
            max = parseInt($("#filtro_" + id + "_fim").val());
            break;
        case '<':
            min = Number.MIN_VALUE;
            max = parseInt(valor);
            break;
        case '>':
            min = parseInt(valor);
            max = Number.MAX_VALUE;
            break;
        case '=':
            min = parseInt(valor);
            max = parseInt(valor);
            break;
        default:
            break;
    }
    return [min, max];
}

function limpaProcedimento(){
    $("#proc_nome").val("");
    $("#proc_codigo").val("");
    $("#proc_codigo_sus").val("");
}