$(function(){
    jQuery.validator.addMethod("dataInicialMaiorFinal", function(value, element) {
        var dtFinal = $("#data_final").val();
        return this.optional(element) || (compararDatas(value, dtFinal) !== 1);
    }, "Data Inicial não pode ser maior que Data Final");

    jQuery.validator.addMethod("dataFinalMenorInicial", function(value, element) {
        var dtInicial = $("#data_inicial").val();
        return this.optional(element) || (compararDatas(dtInicial, value) !== 1);
    }, "Data Final não pode ser menor que Data Inicial");

   $("#form-rel-movimento-saida").validate({
      rules: {
          data_inicial: { required: true, dataInicialMaiorFinal: true },
          data_final: { required: true, dataFinalMenorInicial: true }
      },
       messages:{
           data_inicial: { required: "Campo Obrigatório" },
           data_final: { required: "Campo Obrigatório" }
       }
   });
});

function gerarRelatorio() {
    if($("#form-rel-movimento-saida").valid()){
        var setor = $("#set_codigo").val();
        var produto = $("#pro_codigo").val();
        var data_inicial = $("#data_inicial").val();
        if (data_inicial) {
            data_inicial = formataDataBD(data_inicial);
        }
        var data_final = $("#data_final").val();
        if (data_final) {
            data_final = formataDataBD(data_final);
        }
        var tp_saida = $("#mov_saida :selected").val();
        callGenerateReport(
            baseUrl + "/relatorio/materiais/gerar-relatorio-movimento-saida",
            {
                "setor": setor,
                "produto": produto,
                "data_inicial": data_inicial,
                "data_final": data_final,
                "tp_saida": tp_saida
            }
        );
    }
}

function limpaProduto(){
    $("#pro_codigo").val("");
    $("#pro_nome").val("");
}

function limpaSetor(){
    $("#set_nome").val("");
    $("#set_codigo").val("");
}