$(document).ready(function () {
  $('#divEquipe').hide();
  $('#divComplemento').hide();
  $('#divPaciente').hide();

  $('input[name=complemento]').attr("disabled", true);
  $('input[name=complemento]').attr("checked", false);

  $('#uni_desc').change(function () {
    if ($('#uni_desc').val() !== "") {
      $('#divEquipe').show();
    } else {
      $('#divEquipe').hide();
      $("#ine_codigo").html("<option value=''>--SELECIONE UMA UNIDADE--</option>");
    }
  });

  $('input[name=complemento]').click(function () {
    if($('input[name=complemento]:checked').val() == "S"){
      $('#divPaciente').show();
    }else{
      $('#divPaciente').hide();
      $('#pac_part_nome').val("");
      $('#usu_codigo').val("");
      $('#dom_codigo').val("");
    }
  })

  $('input[name=tipo_relatorio]').click(function () {
    if ($('input[name=tipo_relatorio]:checked').val() == "SINTETICO") {
      $('#divComplemento').hide();
      $('#divPaciente').hide();

      $('#usu_nome').val("");
      $('#usu_codigo').val("");
      $('#pac_part_nome').val("");
      $('#dom_codigo').val("");
      $('input[name=complemento]').attr("disabled", true);
      $('input[name=complemento]').attr("checked", false);
    } else {
      $('#pac_part_nome').val("");
      $('#usu_codigo').val("");
      $('#dom_codigo').val("");
      $('#divComplemento').show();
      $('input[name=complemento]').attr("disabled", false);
      $('input[name=complemento]').attr("checked", true);
    }
  });
});

function buscaUnidade() {
  $("#uni_desc").buscar({
    url: baseUrl + "/unidade/buscar",
    minLength: 3,
    template: function (ul, item) {
      return jQuery("<li></li>").data("item.autocomplete", item).append(
        "<a>" + item.label + "</a>").appendTo(ul);
      }, callback: function () {
        carregaEquipeIne();
      }
    }
  );
}

function carregaEquipeIne() {
  var uni_codigo = $("#uni_codigo").val();
  $.ajax({
    url: baseUrl + '/relatorio/visita-domiciliar/preenche-equipes',
    type: "POST",
    data: {
      uni_codigo: uni_codigo
    },
    success: function (json) {
      $("#ine_codigo").html("");
      $("#ine_codigo").append("<option value=''>--SELECIONE--</option>");
      $.each(json, function (key, value) {
        $("#ine_codigo").append("<option title=\"" + value['no_equipe'] + "\"  value=\"" + value['nu_ine'] + "\" " + ">" + value['nu_ine'] + " - " + value['no_equipe'] + "</option>");
      });
    }
  });
}

function carregaDomicilioPaciente() {
  var usu_codigo = $("#usu_codigo").val();
  $.ajax({
    url: baseUrl + '/relatorio/usuario/busca-domicilio-paciente',
    type: "POST",
    data: {
      usu_codigo: usu_codigo
    },
    success: function (json) {
      $("#dom_codigo").val(json['dom_codigo']);
    }
  });
}

function buscaPaciente() {
  var tipo_busca = $("#tipo_busca").val();

  $("#pac_part_nome").buscar({
    delay: 10,
    minLength: 3,
    url: baseUrl + '/paciente/buscar/tipo_busca/' + tipo_busca,
    template : function(ul, item) {
      return $("<li/>").data("item.autocomplete", item).append(
        "<a>" + item.label + "</a>").appendTo(ul);
      },
      callback: function(event, ui){
        carregaDomicilioPaciente();
        return true;
      }
    });
  }

function gerarRelatorio(evt){
  var uni_codigo = $('#uni_codigo').val();
  var ine_codigo = $('#ine_codigo option:selected').val();
  var usr_codigo = $('#usr_codigo').val();
  var data_inicial = $('#data_inicial').val();
  var data_final = $('#data_final').val();
  var tp_rel = $('#tipo_relatorio:checked').val();
  var complemento = $('#complemento:checked').val();
  var usu_codigo = $('#usu_codigo').val();

  if (data_final == "") {
    alert('A data final é obrigatória!');
    evt.preventDefault();
    return false;
  }

  data_final = brToSql(data_final);
  if (data_inicial != "") {
    data_inicial = brToSql(data_inicial);
    if (data_final < data_inicial) {
      alert('A data inicial não pode ser maior que a data final!');
      evt.preventDefault();
      return false;
    }
  }

  callGenerateReport(
    baseUrl + "/relatorio/visita-domiciliar/gerar-relatorio-domicilio-vinculado-por-usuario",
    {
      "unidade": uni_codigo,
      "equipe": ine_codigo,
      "profissional": usr_codigo,
      "dataInicial": data_inicial,
      "dataFinal": data_final,
      "tpRel": tp_rel,
      "paciente": usu_codigo,
      "complemento": complemento
    }
  );
}
