$( function () {
    $('#divEquipe').hide();

});


function buscaUnidade() {
    $("#uni_desc").buscar({
            url: baseUrl + "/unidade/buscar",
            minLength: 3,
            template: function (ul, item) {
                return jQuery("<li></li>").data("item.autocomplete", item).append(
                    "<a>" + item.label + "</a>").appendTo(ul);
            }, callback: function () {
            $('#divEquipe').show();
                carregaEquipeIne();
            }
        }
    );
}

function carregaEquipeIne() {
    var uni_codigo = $("#uni_codigo").val();
    $.ajax({
        url: baseUrl + '/relatorio/visita-domiciliar/preenche-equipes',
        type: "POST",
        data: {
            uni_codigo: uni_codigo
        },
        success: function (json) {
            $("#ine_codigo").html("");
            $("#ine_codigo").append("<option value=''>--SELECIONE--</option>");
            $.each(json, function (key, value) {
                $("#ine_codigo").append("<option title=\"" + value['nu_ine'] + "\"  value=\"" + value['co_seq_equipe'] + "\" " + ">" + value['nu_ine'] + " - " + value['no_equipe'] + "</option>");
            });
        }
    });
}

function buscaProfissionais() {
    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar-profissionais-equipes/acs/1',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (event, ui) {
            return true;
        }
    });
}

function gerarRelatorioBuscaAtiva(evt) {
    var dataInicial = $('#dataInicial').val();
    var dataFinal = $('#dataFinal').val();
    var unidade = $('#uni_codigo').val();
    var profissional = $('#usr_codigo').val();
    var tpRel = $('#tpRel:checked').val();
    var equipe = $('#ine_codigo option:selected').val();

    
    if (dataInicial == "") {
        alert('A data inicial é obrigatória!');
        evt.preventDefault();
        return false;
    }
    if (dataFinal == "") {
        alert('A data final é obrigatória!');
        evt.preventDefault();
        return false;
    }
    dataInicial = brToSql(dataInicial);
    dataFinal = brToSql(dataFinal)
    if (dataFinal < dataInicial) {
        alert('A data inicial não pode ser maior que a data final!');
        evt.preventDefault();
        return false;
    }

    callGenerateReport(
        baseUrl + "/relatorio/visita-domiciliar/gerar-relatorio-busca-ativa",
        {
            "dataInicial": dataInicial,
            "dataFinal": dataFinal,
            "unidade": unidade,
            "equipe": equipe,
            "profissional": profissional,
            "tpRel": tpRel,
        }
    );
}