$(function () {

    $("#formViagem").validate({
        rules: {
            usu_nome: {
                required: true
            },
            busca1: {
                required: true
            },
            busca2: {
                required: true
            },
        },
        messages: {
            usu_nome: {
                required: "Campo Obrigatório"
            },
            busca1: {
                required: "Campo Obrigatório"
            },
            busca2: {
                required: "Campo Obrigatório"
            },
        }
    });
    $("#usu_nome").buscar({
        url: baseUrl + '/paciente/buscar/',
        callback: function (event, ui) {
            return true;
        }
    });

    $("#busca1").buscar({
        url: baseUrl + '/cidade/buscar/',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (event, ui) {
            return true;
        }
    });

    $("#busca2").buscar({
        url: baseUrl + '/cidade/buscar/',
        suffix: '_2',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (event, ui) {
            return true;
        }
    });
    if ($("#viausu_codigo").val()) {
        $.ajax({
            url: baseUrl + "/transporte/usuario-acompanhante/get-acompanhante",
            type: "POST",
            data: {
                viausu_codigo: $("#viausu_codigo").val()
            },
            success: function (txt) {
                var total = $(".buscaAcom").size();
                for (var i in txt) {
                    $("#usu_nome_" + total + "").val(txt[i].usu_nome_);
                    $("#usu_codigo_" + total + "").val(txt[i].usu_codigo_);
                    $("#usu_nome_" + total + "").addClass("buscaAcom");
                    $("#usu_nome_" + total + "").show();

                    total = $(".buscaAcom").size() + 1;

                }
            }
        });
    }

    $("#addPac").click(function () {
        var total = $(".buscaAcom").size() + 1;
        var total_anterior = $(".buscaAcom").size();
        //  alert("#usu_nome_"+total+"");
        if ($("#usu_codigo_" + total_anterior + "").val() != "") {
            if (total >= $("#disponivel").val()) {
                mensagem("Erro", "Erro ao inserir acompanhante!.<br/>" + "Já excedeu a quantidade de pacientes por veículo!", 300, 150);
                return false;
            }
            $("#usu_nome_" + total + "").addClass("buscaAcom");
            $("#usu_nome_" + total + "").show();
        }

    });


    for (var i = 1; i <= 4; i++) {
        $("#usu_nome_" + i).buscar({
            suffix: '_' + i,
            url: baseUrl + '/paciente/buscar/',
            callback: function (event, ui) {
                return true;
            }
        });
    }

    $(".pacienteNovo").click(function () {
        var usu_codigo = $("#usu_codigo").val();
        if (usu_codigo > 1) {
            var link = baseUrl + "/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
        } else {
            link = baseUrl + "/default/paciente/form-paciente/poupup/1";
        }
        window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
    });


});

function retornaPac(usu_codigo, usu_nome) {
    $("#usu_codigo").val(usu_codigo);
    $("#usu_nome").val(usu_nome);
}

function validaSalvar(id){
    if($("#formViagem").valid()){
        validaVagas(id)
    }
}

function capacidadeSolicitada(qtd){
    var acomp = $('#table-acompanhantes tr').length;
    return parseInt(qtd) - acomp;
}

function validaVagas(id){
    $.ajax({
        url: baseUrl+"/transporte/veiculo/verifica-cota",
        type: "POST",
        data: {
            id: id
        },
        success: function(txt){
            if(capacidadeSolicitada(txt) > 0){
                salvar();
            }else{
                $("body").append("<div id=\"mensagem-dialog\" title=\"Erro\">Veículo com capacidade esgotada</div>")
                $("#mensagem-dialog").dialog({
                    modal: true,
                    close: function(){
                        $(this).remove();
                    },
                    buttons: {
                        "Ok": function(){
                            $(this).dialog('close');
                        }
                    }
                });
            }
        }
    });
}

function salvar(){
    $.ajax({
        url: baseUrl+"/transporte/viagem-usuario/salvar",
        type: "POST",
        data: $("#formViagem").serialize(),
        success: function(txt){
            window.location.href = baseUrl + "/transporte/viagem-usuario"
        },
        error: function(error){
            mensagem("Erro", "Erro ao salvar a viagem");
        }
    });
}

function insereAcompanhante(){
    var codigo = $('#usu_codigo_1').val();
    var nome = $('#usu_nome_1').val();
    var cont = parseInt($("#total-acompanhantes").val()) + 1;
    var insere = true;

    if(codigo != "" && nome !=""){
        if($('#usu_codigo').val() == codigo){
            mensagem("Atenção","Paciente não pode ser igual o acompanhante.",300,150, function () {
                $('#usu_nome_1').val("");
                $('#usu_codigo_1').val("");
            });
            return false;
        }
        $('#table-acompanhantes').find('tr').each(function (indice) {
            $(this).find('input[type="hidden"]').each(function (indice) {
                if (codigo == $(this).val()) {
                    insere = false;
                }
            });
        });

        if(insere){
            $("#table-acompanhantes").append(
                '<tr id="acomp_codigo_' + cont + '">' +
                "   <input type='hidden' name='acomp["+cont+"][acom_codigo]' value=''/>" +
                "   <input type='hidden' name='acomp["+cont+"][usu_codigo]' value='"+codigo+"'/>" +
                "  <td class='ui-state-default'>"+nome+"</td>"+
                "  <td class=\"ui-state-default c\"><a onclick='excluirAcompanhante("+cont+")'><img src='"+ baseUrl +"/public/images/icons/excluir.png' alt='Excluir' title='Excluir'/></a></td>" +
                "</tr>");
            $('#usu_nome_1').val("");
            $('#usu_codigo_1').val("");
            $("#total-acompanhantes").val(cont);
        } else {
            mensagem("Atenção","Acompanhante já cadastrado.",300,150, function () {
                $('#usu_nome_1').val("");
                $('#usu_codigo_1').val("");
            });
            return false;
        }
    } else{
        return false;
    }

}
function excluirAcompanhante(codigo, acom_codigo){
    if (acom_codigo){
        $.ajax({
            url: baseUrl+"/transporte/viagem-usuario/excluir-acompanhante/cod/"+acom_codigo,
            type: "GET",
            success: function(txt){
              if(txt.success){
                  $("#acomp_codigo_"+codigo).remove();
                  return true;
              } else {
                  mensagem("Erro",txt.mensagem,300,150);
              }
            },
        });
    } else {
        $("#acomp_codigo_"+codigo).remove();
    }
}
    