<?php

include_once('../class/tcpdf/tcpdf.php');
include_once("../class/PHPJasperXML.inc.php");
include_once('../setting.php');
include_once("../parametros_db.php");

ob_end_clean();

$server = $host;
$user = $usuario;
$pass = $senha;
$db = $banco;
$port = $porta;

$bai_codigo = $_GET["bai_codigo"];
$where = "";

if ($bai_codigo) {
    $where .= "WHERE rua.bai_codigo = $bai_codigo and aspu.aspsu_ativo = true";
}else{
    $where .= "";
}

$sql="  SELECT DISTINCT 
            bai_nome, 
            usu_resp,
            aspsch_tipo_residencia, 
            chefe_familia_mulher, 
            SUM(adolescente) as qtd_adolescente, 
            SUM(pcd) as qtd_pcd, 
            SUM(idoso) as qtd_idoso, 
            uni_desc, 
            aspscf_anos_municipio
        FROM
        (
            SELECT DISTINCT 
                UPPER(bai.bai_nome) AS bai_nome,
                resp.usu_nome AS usu_resp,
                usu.usu_nome,
                COALESCE(ach.aspsch_tipo_residencia, 'NÃO INFORMADO') AS aspsch_tipo_residencia,
                CASE
                  WHEN resp.usu_sexo = 'F' THEN 'SIM'
                  WHEN resp.usu_sexo = 'M' THEN 'NÃO'
                  ELSE 'NÃO INFORMADO'
                END AS chefe_familia_mulher,
                CASE 
                  WHEN EXTRACT(year FROM Age(usu.usu_datanasc)) <= 18 THEN 1 
                  ELSE 0 
                END AS adolescente, 
                CASE 
                  WHEN usu.usu_deficiencia = true THEN 1 
                  ELSE 0 
                END AS pcd, 
                CASE 
                  WHEN (
                  (usu.usu_sexo = 'F' AND EXTRACT(year FROM Age(usu.usu_datanasc)) >= 60 ) 
                  OR 
                  (usu.usu_sexo = 'M' AND EXTRACT(year FROM Age(usu.usu_datanasc)) >= 65 )
                  ) THEN 1 
                  ELSE 0 
                END AS idoso,
                uni.uni_desc AS uni_desc,
                aspscf_anos_municipio
            FROM as_prontuario_suas asps
            INNER JOIN as_prontuario_suas_usuario aspu ON aspu.asps_codigo = asps.asps_codigo
            LEFT JOIN asps_convivencia_familiar ascf ON ascf.asps_codigo = aspu.asps_codigo
            LEFT JOIN asps_condicoes_habitacionais ach ON ach.asps_codigo = aspu.asps_codigo
            INNER JOIN as_prontuario_suas_unidade acu ON acu.asps_codigo = aspu.asps_codigo
            INNER JOIN usuario usu ON usu.usu_codigo = aspu.usu_codigo
            INNER JOIN unidade uni ON uni.uni_codigo = acu.uni_codigo
            INNER JOIN domicilio dom ON dom.dom_codigo = usu.dom_codigo
            INNER JOIN rua rua ON rua.rua_codigo = dom.rua_codigo
            INNER JOIN bairro bai ON bai.bai_codigo = rua.bai_codigo
            INNER JOIN usuario resp ON resp.usu_codigo = (SELECT usu2.usu_codigo
                                                            FROM   usuario usu2
                                                            INNER JOIN as_prontuario_suas_usuario aspu2 ON aspu2.usu_codigo = usu2.usu_codigo
                                                          WHERE  usu2.dom_codigo = dom.dom_codigo AND aspu2.aspsu_parentesco = 1
                                                          LIMIT  1)
            $where
            GROUP BY bai.bai_nome, resp.usu_codigo, resp.usu_nome, dom.dom_codigo, usu.usu_nome, ach.aspsch_tipo_residencia, resp.usu_sexo, uni.uni_desc, usu.usu_datanasc, usu.usu_deficiencia, usu.usu_sexo, aspscf_anos_municipio
            ORDER BY usu_resp
        ) as resultado
        GROUP BY bai_nome, usu_resp, aspsch_tipo_residencia, chefe_familia_mulher, uni_desc, aspscf_anos_municipio
        ORDER BY usu_resp";

//die($sql);

$PHPJasperXML = new PHPJasperXML();
$PHPJasperXML->connect($server, $user, $pass, $db, $port, $cndriver = "psql");

$sqlDados = "SELECT uni_desc,
                        uni_cnpj,
                        uni_endereco,
                        uni_numero,
                        uni_cep,
                        c.cid_nome
                 FROM logon l
                 LEFT JOIN unidade u ON u.uni_codigo = l.uni_codigo
                 LEFT JOIN cidade c ON c.cid_codigo_ibge = u.uni_codigo_ibge
                 WHERE id_login = ( SELECT id_login FROM logon ORDER BY dt_entrada DESC LIMIT 1 )";

$queryDados = pg_query($sqlDados);
$reg_dados = pg_fetch_array($queryDados);

$caminho = "../../zf/public/images/brasao.jpg";

$sqlSecretaria = "SELECT 
                            sec.nome_secretaria,
                            sec.cnpj_secretaria,
                            sec.endereco_secretaria,
                            sec.numero_end_secretaria,
                            sec.sec_bairro,
                            sec.telefone_secretaria,
                            sec.nome_cidade
                      FROM  secretaria AS sec
                      WHERE sec.sec_as = 't'";

$querySecretaria = pg_query($sqlSecretaria);
$regSecretaria = pg_fetch_array($querySecretaria);

$sqlParametro = "SELECT conf_valor_bool FROM config WHERE conf_chave = 'MOSTRA_VALOR_BENEFICIO' LIMIT 1";
$queryParametro = pg_query($sqlParametro);
$valor = pg_fetch_row($queryParametro)[0];


$rodape = $regSecretaria[endereco_secretaria] . ', ' . $regSecretaria[numero_end_secretaria] . " - " . $regSecretaria[sec_bairro] . ", " . $regSecretaria[nome_cidade] . ", CNPJ: " . $regSecretaria[cnpj_secretaria];

$PHPJasperXML->arrayParameter = array(
    "uni_desc" => $reg_dados[uni_desc],
    "cidade_pref" => $reg_dados[cid_nome],
    "caminho_img" => $caminho,
    "nome_secretaria" => $regSecretaria[nome_secretaria],
    "rodape" => $rodape,
    "valor" => $valor == 'f' ? 0 : 1,
    "sql" => $sql
);

$PHPJasperXML->load_xml_file("RelatorioBairros.jrxml");

$PHPJasperXML->transferDBtoArray($server, $user, $pass, $db, $cndriver = "psql");

$PHPJasperXML->outpage("I");
?>


