<?php
    include_once('../class/tcpdf/tcpdf.php');
    include_once("../class/PHPJasperXML.inc.php");
    include_once('../setting.php');
    include_once("../parametros_db.php");

    $server = $host;
    $user = $usuario;
    $pass = $senha;
    $db = $banco;
    $port = $porta;

    $data_inicial = $_GET["dt_inicial"];
    $data_final = $_GET["dt_final"];

    $PHPJasperXML = new PHPJasperXML();
    $PHPJasperXML->connect($server, $user, $pass, $db, $port, $cndriver = "psql");

    $sql = " SELECT 
                asbd.asbd_dtentrega, 
                asbd.asbd_dtcadastro, 
                uni.uni_desc, 
                usr.usr_nome as atendente, 
                ase.ase_nome as estabelecimento 
            FROM as_beneficios_dados AS asbd 
            INNER JOIN unidade AS uni  ON asbd.uni_codigo = uni.uni_codigo 
            INNER JOIN usuario AS usu  ON asbd.usu_codigo = usu.usu_codigo 
            INNER JOIN usuarios AS usr ON asbd.usr_codigo = usr.usr_codigo 
            INNER JOIN as_estabelecimentos AS ase ON asbd.ase_codigo = ase.ase_codigo ";
    
    if ($data_inicial) {
        $date = str_replace('/', '-', $data_inicial);
        $data_inicial = date('Y-m-d', strtotime($date));
        $sql .= "AND asbd.asbd_dtcadastro >= '$data_inicial'";
    }

    if ($data_final) {
        $date = str_replace('/', '-', $data_final);
        $data_final = date('Y-m-d', strtotime($date));
        $sql .= "AND asbd.asbd_dtcadastro <= '$data_final'";
    }
    
    $sql .= " ORDER BY usr.usr_nome ";
    
    $result = pg_query($sql);
    $registro = pg_fetch_array($result);
    
    if (count($registro) == 1 ) {
        die(("Relatório não possui dados para o(s) filtro(s) selecionado(s)!"));
    }

    $sqlDados = "SELECT u.uni_desc, 
                            u.uni_cnpj, 
                            u.uni_endereco, uni_numero,
                            u.uni_cep,
                            c.cid_nome
                     FROM logon l 
                     LEFT JOIN unidade u on u.uni_codigo = l.uni_codigo
                     LEFT JOIN cidade c on c.cid_codigo_ibge = u.uni_codigo_ibge
                     WHERE l.id_login = ( SELECT id_login FROM logon ORDER BY dt_entrada DESC LIMIT 1 )";

    $queryDados = pg_query($sqlDados);
    $reg_dados = pg_fetch_array($queryDados);

    $caminho = "../../zf/public/images/brasao.jpg";

    $sqlSecretaria = "SELECT 
                            sec.nome_secretaria,
                            sec.cnpj_secretaria,
                            sec.endereco_secretaria,
                            sec.numero_end_secretaria,
                            sec.sec_bairro,
                            sec.telefone_secretaria,
                            sec.nome_cidade
                      FROM  secretaria AS sec
                      WHERE sec.sec_as = 't'";

    $querySecretaria = pg_query($sqlSecretaria);
    $regSecretaria = pg_fetch_array($querySecretaria);

    $rodape = $regSecretaria[endereco_secretaria].', '.$regSecretaria[numero_end_secretaria]." - ".$regSecretaria[sec_bairro] .", ".$regSecretaria[nome_cidade] .", CNPJ: " .$regSecretaria[cnpj_secretaria] ;
    
    $PHPJasperXML->arrayParameter = array("uni_desc"        => $reg_dados[uni_desc],
                                          "cidade_pref"     => $reg_dados[cid_nome],
                                          "caminho_img"     => $caminho,
                                          "nome_secretaria" => $regSecretaria[nome_secretaria],
                                          "rodape"          => $rodape,
                                          "sql"             => $sql);

    $PHPJasperXML->load_xml_file("RelatorioBeneficioPorAtendente.jrxml");

    $PHPJasperXML->transferDBtoArray($server, $user, $pass, $db, $cndriver = "psql");
    $PHPJasperXML->outpage("I");
?>


