<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 20/03/2018
 * Time: 08:25
 */

require_once __DIR__."/../../../WebSocialComum/library/php/db.inc.php";
require_once __DIR__ . "/src/EloPDF.php";

$sqlAtendimentoBasico = "SELECT
                                u.uni_desc as unidade,
                                aat.asat_nome as nome,
                                us.usr_nome AS profissional,
                                ab.asab_data as data,
                                UPPER(ab.asab_descricao) AS descricao
                           FROM as_atendimento_basicocras ab
                           JOIN unidade 			  u ON u.uni_codigo = ab.uni_codigo
                           JOIN usuarios 		     us ON us.usr_codigo = ab.usr_codigo
			    		   JOIN as_atendimento_tipo aat ON aat.asat_codigo = ab.asat_codigo
			    		   limit 50";

$result = pg_query($sqlAtendimentoBasico);
$colunas = [
	"Unidade"       => "width: 10%; text-align: center",
	"Nome"          => "width: 25%; text-align: left",
	"Profissional"  => "width: 25%; text-align: left",
	"Data"          => "width: 10%; text-align: center",
	"Descrição"     => "width: 30%; text-align: left"
];
while ($row = pg_fetch_array($result, NULL, PGSQL_ASSOC)) {
	$dados[] = $row;
};

$pdf = new EloPDF([
	'titulo' => 'SECRETARIA MUNICIPAL DE ASSISTENCIA SOCIAL',
	'subtitulo' => 'Relatório Geral',
	'orientacao' => 'P'
]);
$html = $pdf->createTable($colunas, $dados, "Atendimento Básico");
echo $pdf->printHtml($html);
?>