<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 20/03/2018
 * Time: 08:35
 */
require_once __DIR__ . "/../vendor/autoload.php";

define('_MPDF_URI','../');
define('_MPDF_PATH','../');
use Mpdf\Mpdf;
use Mpdf\MpdfException;

class EloPDF extends Mpdf {

	private $img_path;

	/**
	 * EloPDF constructor.
	 * @param $titulo
	 * @param $subtitulo
	 * @param $orientacao
	 */
	public function __construct($titulo, $cidade, $rodape, $subtitulo, $filtro = NULL, $orientacao="P") {
		try {
			parent::__construct([
				'margin_left'   => 10,
				'margin_right'  => 10,
				'margin_top'    => 38,
				'margin_bottom' => 10,
				'margin_header' => 10,
				'margin_footer' => 10,
				'default_font_size' => 7
			]);
			$this->debug = true;
			$this->showImageErrors = true;
			$this->useOnlyCoreFonts = true;
			$this->ignore_table_percents = FALSE;
			$css = file_get_contents(__DIR__ . "/style.css");

			//Logo
			$LOGO = __DIR__."/../../../zf/public/images/brasao.jpg";
			$NOIMG = $_SESSION['linkroot'].$_SESSION['modulo']."zf/public/images/noimage.png";
			$this->imageVars['logo'] = (file_exists($LOGO) ? file_get_contents($LOGO) : file_get_contents($NOIMG));

			$this->SetProtection(['copy','print','print-highres']);
			$this->WriteHTML($css, 1);
			$this->SetAutoPageBreak($this->autoPageBreak, 15);
			$this->addHeader($titulo, $cidade, $subtitulo, $filtro);
			$this->SetTitle($subtitulo);
			$this->addFooter($rodape);
			$this->AddPage($orientacao);
			$this->SetDisplayMode('fullpage', 'tworight');
		} catch (MpdfException $e) {
			die($e->getMessage());
		}
	}

	public function printHtml($html) {
		try {
			$this->WriteHTML($html);
			$this->Output();
		} catch (MpdfException $e) {
			return $e->getMessage();
		}
	}

	public function addHeader($titulo, $cidade, $subtitulo, $filtro) {
		$header = "
			<table class='tb-h'>
				<tr>
					<td class='tb-logo'><img src='var:logo' alt='Município de "  .ucwords(strtolower($cidade)). "' height='85'></td>
					<td class='report-title'>
						<h4>Município de " .ucwords(strtolower($cidade)). "</h4>
						<h2>$titulo</h2>
						<h2>$subtitulo</h2>
					</td>
				</tr>
			</table>
			<small><b>Filtros: </b>$filtro</small>";
		$this->SetHTMLHeader($header);
	}

	/**
	 * @param array $header
	 * @param array $dados
	 * @param null $titulo
	 * @param string $status_true
	 * @param string $status_false
	 * @return null|string
	 *
	 * Tipos
	 *  s_ = string
	 *  d_ = data
	 *  i_ = integer
	 *  f_ = float ou double
	 *  b_ = boolean (caso não informe o texto do boolean o mesmo assumira Sim/Não)
	 */
	public function createTable(array $header, $dados = array(), $types, $titulo=null, $mostrar_total = false, $total=null, $status_true="Sim", $status_false="Não") {
		$table = "<div class='table-principal'>";
		if(count($dados) > 0) {
			$table .= "<table class='tb-body'><thead><tr>";
			if(isset($titulo)){
				$table .= "<th class='th-title' colspan='".count($header)."'>$titulo</th></tr><tr>";
			}
			foreach ($header as $key => $value){
				$table .= "<th style='$value'>$key</th>";
			}
			foreach ($dados as $dado){
				$table .= "<tr></thead><tbody>";
				foreach ($dado as $key => $info){
					switch ($types[$key]){
						case 'bool':
							$info = (($info == 't' || $info == 1 ? $status_true : $status_false));
							$style = "text-align: center";
							break;
						case 'date':
							$date = DateTime::createFromFormat('Y-m-d', $info);
							if ($date !== FALSE) {
								$info = $date->format('d/m/Y');
							}
							$style = "text-align: center";
							break;
						case 'timestamp':
							$datetime = DateTime::createFromFormat('Y-m-d H:i:s', $info);
							if ($datetime !== FALSE) {
								$info = $datetime->format('d/m/Y H:i:s');
							}
							$style = "text-align: center";
							break;
						case 'varchar' || 'text':
							$style = "text-align: left";
							$date = DateTime::createFromFormat('Y-m-d', $info);
							if ($date !== FALSE) {
								$info = $date->format('d/m/Y');
								$style = "text-align: center";
							}
							$datetime = DateTime::createFromFormat('Y-m-d H:i:s', $info);
							if ($datetime !== FALSE) {
								$info = $datetime->format('d/m/Y H:i:s');
								$style = "text-align: center";
							}
							if(is_numeric($info)){
								$style = "text-align: center";
							}
							break;
						case 'decimal' || 'real'|| 'double' || 'numeric';
							$style = "text-align: right";
							break;
						default:
							$style = "text-align: center";
							break;
					}
					$table .= "<td style='$style'>$info</td>";
				}
				$table .= "</tr>";
			}
			if($mostrar_total){
				$total = isset($total) ? $total : count($dados);
				$table .= "<tr>
								<td colspan='" . count($header). "' 
									class='td-total'>
									<b>Total: </b> $total
								</td>
						   </tr>";
			}
			$table .= "</tbody></table>";
		}else{
			$table .= "<table class='tb-body'>
							<tr><th class='th-title'>$titulo</th></tr>
							<tr><td>Registros não encontrados!</td></tr>
						</table>";
		}

		return $table."</div>";
	}

	public function addFooter($rodape) {
		$footer = "
			<table class='footer'>
				<tr>
					<td class='left'></td>
					<td class='center'>$rodape</td>
					<td class='right'>{DATE j/m/Y H:i} - <b>Pág. {PAGENO} / {nbpg}</b></td>
				</tr>
			</table>
		";
//		"<div class='footer'>{DATE j/m/Y H:i} - <b>Pág. {PAGENO} / {nbpg}</b></div>"
		$this->SetHTMLFooter($footer);
	}
}