<?php

include_once('../class/tcpdf/tcpdf.php');
include_once("../class/PHPJasperXML.inc.php");
include_once("../parametros_db.php");

$server = $host;
$user = $usuario;
$pass = $senha;
$db = $banco;
$port = $porta;

$tipo = $_GET["tipo"];
$programa = $_GET["programa"];

$PHPJasperXML = new PHPJasperXML();
$PHPJasperXML->connect($server, $user, $pass, $db, $port, $cndriver = "psql");

$caminho = "../../zf/public/images/brasao.jpg";

$programas = array("", "paif", "paefi", "bpc", "bolsa família", "scfv", "outros");
$programaNome = $programas[$programa];

$sqlSecretaria = "SELECT 
					sec.nome_secretaria,
					sec.cnpj_secretaria,
					sec.endereco_secretaria,
					sec.numero_end_secretaria,
					sec.sec_bairro,
					sec.telefone_secretaria,
					sec.nome_cidade
				  FROM 
					secretaria AS sec
				  WHERE
					sec.sec_as = 't'";
$querySecretaria = pg_query($sqlSecretaria);
$regSecretaria = pg_fetch_array($querySecretaria);

if($programaNome != "") {
    if($programaNome == "outros") {
        $case = "CASE apa.aspt_outros WHEN true THEN 'OUTROS' || COALESCE(': ' || aspt_prog_prioritarios, '') ELSE null END";
    } else {
        $nome = str_replace(" ", "_", $programaNome);
        // remove 'í' de bolsa família
        $nome = str_replace("í", "i", $nome);
        $programaNome = strtoupper($programaNome);
        $case = "CASE apa.aspt_{$nome} WHEN true THEN '{$programaNome}' ELSE null END";
    }
} else {
$case = "CASE apa.aspt_paif WHEN true THEN 'PAIF' ELSE null END,
        CASE apa.aspt_paefi WHEN true THEN 'PAEFI' ELSE null END,
        CASE apa.aspt_bpc WHEN true THEN 'BPC' ELSE null END,
        CASE apa.aspt_bolsa_familia WHEN true THEN 'BOLSA FAMÍLIA' ELSE null END,
        CASE apa.aspt_peti WHEN true THEN 'PETI' ELSE null END,
        CASE apa.aspt_outros WHEN true THEN 'OUTROS' || COALESCE(': ' || aspt_prog_prioritarios, '') ELSE null END";
}

if($tipo=="sintetico") {
    $select = "programa, count(*) as participantes";
    $group_by = "GROUP BY programa";
} else {
    $tipo = "analitico";
    $select = "*";
    $group_by = "";
}
$tipo = ucwords($tipo);

$sql = "SELECT {$select} FROM (
        SELECT 
            unnest(array[{$case}]) AS programa,
            u.usu_nome AS cidadao 
        FROM asps_primeiro_atendimento apa
        JOIN as_prontuario_suas_usuario apsu
        ON apa.asps_codigo=apsu.asps_codigo
        JOIN usuario u
        ON apsu.usu_codigo=u.usu_codigo
    ) AS sub
    WHERE sub.programa IS NOT NULL
    {$group_by}
    ORDER BY 1,2";

$PHPJasperXML->arrayParameter = array(
    "caminho_img" => $caminho,
    "nome_secretaria" => $regSecretaria['nome_secretaria'],
    "nome_cidade" => $regSecretaria['nome_cidade'],
    "sql" => $sql
);

$PHPJasperXML->load_xml_file("RelatorioProgramasSociais{$tipo}.jrxml");

$PHPJasperXML->transferDBtoArray($server, $user, $pass, $db, $cndriver = "psql");
$PHPJasperXML->outpage("I");    //page output method I:standard output  D:Download file

?>
