<?php
include_once('../class/tcpdf/tcpdf.php');
include_once("../class/PHPJasperXML.inc.php");
//include_once('../setting.php');
include_once("../parametros_db.php");
//include_once("../pdf_report/src/EloPDF.php");

use DateTime;

define("RESPONSAVEL", 'responsavel');

$server = $host;
$user = $usuario;
$pass = $senha;
$db = $banco;
$port = $porta;

$data_inicial = $_GET["dt_inicial"];
$data_final = $_GET["dt_final"];
$tipo = $_GET["tipo"];
$tipo_rel = $_GET["tipo_rel"];

$PHPJasperXML = new PHPJasperXML();
$PHPJasperXML->connect($server, $user, $pass, $db, $port, "psql");

$sqlAtendimentoBasico = "SELECT 
                                u.uni_desc as unidesc,
                                aat.asat_nome as asat_nome,
                                us.usr_nome AS profissional,
                                ab.asab_data as asab_data,
                                UPPER(ab.asab_descricao) AS asab_descricao
                           FROM as_atendimento_basicocras ab
                           JOIN unidade 			  u ON u.uni_codigo = ab.uni_codigo
                           JOIN usuarios 		     us ON us.usr_codigo = ab.usr_codigo
			    		   JOIN as_atendimento_tipo aat ON aat.asat_codigo = ab.asat_codigo";

$sqlAtendimentoColetivo = "SELECT 
                                asag.asag_titulo as asag_titulo, 
                                to_char(asae.asae_dtinicio, 'YYYY-MM-DD') AS asag_data, 
								(
                                  SELECT count(*)
                                    FROM as_atendimentocol_participantes asapar 
                                    JOIN as_atendimentocol_grupo asag2 ON asapar.asag_codigo = asag2.asag_codigo
                                   WHERE asapar.asag_codigo = asag.asag_codigo 
                                     AND asapar.asapar_status = 't'
                                   GROUP BY asag2.asag_titulo
                                 ) AS quantidade_do_grupo,
                                CAST(asag.asag_quantidade_grupo AS text) AS asag_quantidade_grupo,
                                asag.asag_status as asag_status
                            FROM as_atendimentocol_grupo asag
							INNER JOIN as_atendimentocol_encontros asae on asae.asag_codigo = asag.asag_codigo";

$sqlBeneficios = "SELECT 
                        asbd.asbd_dtcadastro,
                        ben.beneficio AS beneficio, 
                        uni.uni_desc, 
                        usr.usr_nome  AS atendente
                    FROM as_beneficios_dados asbd 
                    JOIN unidade uni  					ON asbd.uni_codigo = uni.uni_codigo 
                    JOIN usuario usu  					ON asbd.usu_codigo = usu.usu_codigo 
                    JOIN usuarios usr 					ON asbd.usr_codigo = usr.usr_codigo 
                    JOIN as_beneficios_dados_itens abdi ON asbd.asbd_codigo = abdi.asbd_codigo
                    JOIN beneficios ben 				ON abdi.cod_ben=ben.cod_ben";

$dateIni = str_replace('/', '-', $data_inicial);
$data_inicial = date('Y-m-d', strtotime($dateIni));
$sqlAtendimentoBasico .= " WHERE ab.asab_data >= '$data_inicial'";
$sqlAtendimentoColetivo .= " WHERE asag_data >= '$data_inicial'";
$sqlBeneficios .= " WHERE asbd.asbd_dtcadastro >= '$data_inicial'";

$dateFim = str_replace('/', '-', $data_final);
$data_final = date('Y-m-d', strtotime($dateFim));
$sqlAtendimentoBasico .= " AND ab.asab_data <= '$data_final'";
$sqlAtendimentoColetivo .= " AND asag_data <= '$data_final'";
$sqlBeneficios .= " AND asbd.asbd_dtcadastro <= '$data_final'";

$sqlBeneficios .= " GROUP BY asbd_dtcadastro, beneficio, uni_desc, atendente ORDER BY asbd_dtcadastro DESC LIMIT 33";
$sqlAtendimentoBasico .= " ORDER BY uni_desc";

if ($tipo !== '') {
	$resultAtendimentoBasico = pg_query($sqlAtendimentoBasico);
	$registroAtendimentoBasico = pg_fetch_array($resultAtendimentoBasico);

	while ($registroAtendimentoBasico) {
		$dadosRetornoAtendBasico[] = $registroAtendimentoBasico;
		$registroAtendimentoBasico = pg_fetch_assoc($resultAtendimentoBasico);
	}

	$resultAtendimentoColetivo = pg_query($sqlAtendimentoColetivo);
	$registroAtendimentoColetivo = pg_fetch_array($resultAtendimentoColetivo);

	$resultBeneficios = pg_query($sqlBeneficios);
	$registroBeneficios = pg_fetch_array($resultBeneficios);

	if (pg_num_rows($resultAtendimentoBasico) == 0 && $tipo == 1) {
		die(("Relatório de Atendimento Básico não possui dados para o(s) filtro(s) selecionado(s)!"));
	}


	if (pg_num_rows($resultBeneficios) == 0 && $tipo == 2) {
		die(("Relatório de Benefícios ofertados não possui dados para o(s) filtro(s) selecionado(s)!"));
	}

	if (pg_num_rows($resultAtendimentoColetivo) == 0 && $tipo == 3) {
		die(("Relatório de Atividade Coletiva não possui dados para o(s) filtro(s) selecionado(s)!"));
	}
}


$sqlDados = "SELECT 
				   u.uni_desc, 
	               u.uni_cnpj, 
	               u.uni_endereco, uni_numero,
	               u.uni_cep,
	               c.cid_nome
               FROM logon l 
               LEFT JOIN unidade u on u.uni_codigo = l.uni_codigo
               LEFT JOIN cidade c on c.cid_codigo_ibge = u.uni_codigo_ibge
              WHERE l.id_login = ( SELECT id_login FROM logon ORDER BY dt_entrada DESC LIMIT 1 )";

$queryDados = pg_query($sqlDados);
$reg_dados = pg_fetch_array($queryDados);

$caminho = "../../zf/public/images/brasao.jpg";

$sqlSecretaria = "SELECT 
                        sec.nome_secretaria,
                        sec.cnpj_secretaria,
                        sec.endereco_secretaria,
                        sec.numero_end_secretaria,
                        sec.sec_bairro,
                        sec.telefone_secretaria,
                        sec.nome_cidade
                  FROM  secretaria sec
                  WHERE sec.sec_as = 't'";

$querySecretaria = pg_query($sqlSecretaria);
$regSecretaria = pg_fetch_array($querySecretaria);

$sqlParametro = "SELECT conf_valor_bool FROM config WHERE conf_chave = 'MOSTRA_ATENDIMENTO_RELATORIO' LIMIT 1";
$queryParametro = pg_query($sqlParametro);
$valor = pg_fetch_row($queryParametro)[0];

$rodape = $regSecretaria['endereco_secretaria'] . ', '
	. $regSecretaria['numero_end_secretaria'] . " - "
	. $regSecretaria['sec_bairro'] . ", "
	. $regSecretaria['nome_cidade'] . ", CNPJ: "
	. $regSecretaria['cnpj_secretaria'];
$PHPJasperXML->arrayParameter = array("uni_desc" => $reg_dados['uni_desc'],
	"cidade_pref" => $reg_dados['cid_nome'],
	"caminho_img" => $caminho,
	"nome_secretaria" => $regSecretaria['nome_secretaria'],
	"rodape" => $rodape,
	"sqlAtendimentoBasico" => $sqlAtendimentoBasico, //$dadosRetornoAtendBasico,
	"sqlAtendimentoColetivo" => $sqlAtendimentoColetivo,
	"sqlBeneficios" => $sqlBeneficios,
	"dataInicial" => $data_inicial,
	"dataFinal" => $data_final,
	"valor" => $valor == 'f' ? 0 : 1
);


function montaRelatorioGeral($filtro, $secretaria, $cidade, $rodape, $responsavel) {
	set_time_limit(180);
	$tipo = $responsavel == RESPONSAVEL ? "Responsável" : "Cidadão";

	$compl = ($responsavel == RESPONSAVEL ? " AND (usu_asps_ref = 't')" : "");

	$sqlResponsavel = "SELECT DISTINCT
						  usu.usu_codigo,
						  usu.usu_nome
						FROM usuario usu
						  LEFT JOIN as_prontuario_suas_usuario   aspsu ON usu.usu_codigo = aspsu.usu_codigo
						  LEFT JOIN as_prontuario_suas 			  asps ON aspsu.asps_codigo = asps.asps_codigo
						  LEFT JOIN as_prontuario_suas_unidade aspsuni ON asps.asps_codigo = aspsuni.asps_codigo
						  LEFT JOIN unidade 					   uni ON aspsuni.uni_codigo = uni.uni_codigo
						  LEFT JOIN as_atendimento_basicocras ab ON ab.usu_codigo = usu.usu_codigo
						  LEFT JOIN as_beneficios_dados asbd ON asbd.usu_codigo = usu.usu_codigo
						  LEFT JOIN as_encaminhamento asenc ON asenc.usu_codigo = usu.usu_codigo
						WHERE (aspsuni_dtfinal IS NULL) $compl
						AND (
							ab.usu_codigo IS NOT NULL 
							OR 
							asbd.usu_codigo IS NOT NULL 
							OR 
							asenc.usu_codigo IS NOT NULL
     						)
						AND (
							ab.asab_data BETWEEN '$filtro[dt_inicial]' AND '$filtro[dt_final]'  OR 
							asbd.asbd_dtcadastro BETWEEN '$filtro[dt_inicial]' AND '$filtro[dt_final]'  OR 
							asenc.asenc_data BETWEEN '$filtro[dt_inicial]' AND '$filtro[dt_final]'
    						)
						ORDER BY usu_nome";

	$result = pg_query($sqlResponsavel);
	$count_resp = pg_num_rows($result);
	if ($count_resp > 0) {
		while ($resp = pg_fetch_array($result, NULL, PGSQL_ASSOC)) {
			$dados[$resp['usu_codigo']] = ['responsavel' => $resp['usu_nome']];

			//Atendimentos
			$sqlAtendimento = "SELECT
                                u.uni_desc 				 AS unidade,
                                aat.asat_nome 			 AS tipo_atend,
                                us.usr_nome 			 AS profissional,
                                (SELECT array_to_string(array_agg(DISTINCT aam.asam_nome),', ')
								   FROM as_atendimento_basicocras_motivo aabm
								   JOIN as_atendimento_motivo aam ON aabm.asam_codigo = aam.asam_codigo
								   WHERE aabm.asab_codigo = ab.asab_codigo) AS motivos,
	                            ab.asab_data 			 AS data
                           FROM as_atendimento_basicocras ab
                           JOIN unidade 			  u ON u.uni_codigo = ab.uni_codigo
                           JOIN usuarios 		     us ON us.usr_codigo = ab.usr_codigo
			    		   JOIN as_atendimento_tipo aat ON aat.asat_codigo = ab.asat_codigo
			    		   WHERE ab.usu_codigo = $resp[usu_codigo]
			    		     AND ab.asab_data BETWEEN '$filtro[dt_inicial]' AND '$filtro[dt_final]'";
			$resAte = pg_query($sqlAtendimento);

			while ($atendimento = pg_fetch_array($resAte, NULL, PGSQL_ASSOC)) {
				$dados[$resp['usu_codigo']]['atendimentos'][] = $atendimento;
			}
			$dados[$resp['usu_codigo']]['qtd_total_ate'] = count($dados[$resp['usu_codigo']]['atendimentos']);

			//Beneficios
			$sqlBeneficio = "SELECT
						     ben.beneficio 			AS beneficio,
						     usr.usr_nome  			AS atendente,
						     asbd.asbd_dtcadastro 	AS data_cadastro,
						     asbd.asbd_dtentrega 	AS data_entrega,
						     sum(abdi.asbdi_qtd) 	AS quantidade
						  FROM as_beneficios_dados asbd
						  JOIN unidade uni  					ON asbd.uni_codigo = uni.uni_codigo
						  JOIN usuarios usr 					ON asbd.usr_codigo = usr.usr_codigo
						  JOIN as_beneficios_dados_itens abdi ON asbd.asbd_codigo = abdi.asbd_codigo
						  JOIN beneficios ben 				ON abdi.cod_ben=ben.cod_ben
						  WHERE asbd.usu_codigo = $resp[usu_codigo]
						    AND asbd.asbd_dtcadastro BETWEEN '$filtro[dt_inicial]' AND '$filtro[dt_final]'
						  GROUP BY 1,2,3,4
						  ORDER BY 1,2,3,4";

			$resBen = pg_query($sqlBeneficio);
			while ($beneficio = pg_fetch_array($resBen, NULL, PGSQL_ASSOC)) {
				$dados[$resp['usu_codigo']]['beneficios'][] = $beneficio;
				$dados[$resp['usu_codigo']]['qtd_total_ben'] += $beneficio['quantidade'];
			}

			//Encaminhamentos
			$sqlEncaminhamento = "SELECT
							  	  ase.ase_nome 		 AS origem,
							  	  uni.uni_desc 		 AS destino,
							  	  asec.asec_titulo 	 AS titulo,
							  	  asenc.asenc_motivo AS motivo,
							  	  cast(asenc.asenc_data as DATE ) AS data,
							  	  usr.usr_nome 		 AS profissional
							   FROM as_encaminhamento asenc
							  INNER JOIN as_encaminhamento_codigos asec ON asenc.asec_codigo = asec.asec_codigo
							  INNER JOIN unidade uni 					ON asenc.uni_codigo  = uni.uni_codigo
							  INNER JOIN as_estabelecimentos ase 		ON asenc.ase_codigo  = ase.ase_codigo
							  INNER JOIN usuarios usr 					ON asenc.usr_codigo  = usr.usr_codigo
							  WHERE asenc.usu_codigo = $resp[usu_codigo]
							    AND asenc.asenc_data BETWEEN '$filtro[dt_inicial]' AND '$filtro[dt_final]'";
			$resEnca = pg_query($sqlEncaminhamento);
			while ($encaminhamento = pg_fetch_array($resEnca, NULL, PGSQL_ASSOC)) {
				$dados[$resp['usu_codigo']]['encaminhamentos'][] = $encaminhamento;
			}
			$dados[$resp['usu_codigo']]['qtd_total_enc'] = count($dados[$resp['usu_codigo']]['encaminhamentos']);

			//Atividade Coletiva
			$sqlGrupo = "SELECT
						  DISTINCT
						  atg.asag_codigo as codigo,
						  atg.asag_titulo as grupo,
						  uni.uni_desc as unidade
					   FROM as_atendimentocol_participantes atp
					   JOIN as_atendimentocol_grupo atg ON atp.asag_codigo = atg.asag_codigo
					   JOIN unidade uni ON atg.uni_codigo = uni.uni_codigo
					   WHERE usu_codigo = $resp[usu_codigo]";
			$resGrupo = pg_query($sqlGrupo);
			$rows_grupo = pg_num_rows($resGrupo);
			while ($grupo = pg_fetch_array($resGrupo, NULL, PGSQL_ASSOC)) {
				$dados[$resp['usu_codigo']]['grupos'][$grupo['codigo']] = $grupo;
				$dados[$resp['usu_codigo']]['grupos'][$grupo['codigo']]['encontros'] = [];
				if ($rows_grupo > 0) {
					$sqlEncontros = "SELECT
							     ate.asae_titulo as titulo,
							     ate.asae_descricao as descricao,
							     ate.asae_dtinicio as dt_inicio,
							     ate.asae_dtfinal as dt_final
							   FROM as_atendimentocol_encontros ate
							  WHERE ate.asag_codigo = $grupo[codigo]";
					$resEncontros = pg_query($sqlEncontros);
					while ($encontros = pg_fetch_array($resEncontros, NULL, PGSQL_ASSOC)) {
						$dados[$resp['usu_codigo']]['grupos'][$grupo['codigo']]['encontros'][] = $encontros;
					}
				}
			}
		}
		$dt_i = date('d/m/Y', strtotime($filtro['dt_inicial']));
		$dt_f = date('d/m/Y', strtotime($filtro['dt_final']));
		$filtro = "Período: $dt_i à $dt_f | Por $tipo";
		//$pdf = new EloPDF($secretaria, $cidade, $rodape, "Relatório Geral", $filtro);
		//$pdf->printHtml(geraHtmlRelGeral($pdf, $tipo, $dados));

	} else {
		echo "<style>
				.no-reg {
					display: flex; 
					width: 100vw; 
					height: 100vh; 
					align-items: center; 
					justify-content: center;
				}
			  </style>
			  <div class='no-reg'>
				<h4>Registros não encontrados</h4>
			  </div>";
	}

}

function geraHtmlRelGeral($pdf, $tipo, $dados) {
	$html = "<style> .table-principal {margin-left: 10px !important;}</style>";
	foreach ($dados as $dado) {
		$html .= "<div class='tb-title'>$tipo: $dado[responsavel]</div>";
		$h_atendimento = [
			"Unidade" => "width: 20%;",
			"Tipo Atend." => "width: 20%;",
			"Profissional" => "width: 15%;",
			"Motivos" => "width: 35%;",
			"Data" => "width: 10%;"
		];
		$types_atendimento = [
			'unidade' => 'varchar',
			'tipo' => 'varchar',
			'profissional' => 'varchar',
			'motivos' => 'varchar',
			'data' => 'date'
		];
		$html .= $pdf->createTable($h_atendimento, $dado['atendimentos'], $types_atendimento, 'Atendimentos', true);
		//Beneficios
		$h_beneficios = [
			"Benefício" => "width: 45%;",
			"Atendente" => "width: 25%;",
			"Dt.Cadastro" => "width: 10%;",
			"Dt.Entrega" => "width: 10%;",
			"Quantidade" => "width: 10%;"
		];
		$types_beneficios = [
			'beneficio' => 'varchar',
			'atendente' => 'varchar',
			'data_cadastro' => 'date',
			'data_entrega' => 'date',
			'quantidade' => 'integer',
		];
		$html .= $pdf->createTable($h_beneficios, $dado['beneficios'], $types_beneficios, 'Benefícios', true, $dado['qtd_total_ben']);
		//Encaminhamentos
		$h_encaminhamento = [
			"Origem" => "width: 15%;",
			"Destino" => "width: 15%;",
			"Título" => "width: 20%;",
			"Motivo" => "width: 25%;",
			"Data" => "width: 10%;",
			"Profissional" => "width: 15%;",
		];
		$types_encaminhamento = [
			'origem' => 'varchar',
			'destino' => 'varchar',
			'titulo' => 'varchar',
			'motivo' => 'varchar',
			'data' => 'date',
			'profissional' => 'varchar'
		];
		$html .= "<style> .table-principal {margin-left: 10px !important;}</style>";
		$html .= $pdf->createTable($h_encaminhamento, $dado['encaminhamentos'], $types_encaminhamento, 'Encaminhamentos', true);

		//Atividade Coletiva
		$html .= "<div class='table-principal'>";
		if (count($dado['grupos']) > 0) {
			$html .= "<table class='tb-body'>
						<thead>
							<tr>
								<th class='th-title' colspan='4'>Atividade Coletiva</th>
							</tr>";
			foreach ($dado['grupos'] as $grupo) {
				$html .= "<tr>
							<th class='sub-header'>Unidade</th>
						  	<th class='sub-header' colspan='3'>Grupo</th>
						  </tr>
						  <tr>
							 <th class='th-title-atividade'>$grupo[unidade]</th>
							 <th class='th-title-atividade' colspan='3'>$grupo[grupo]  </th>
						  </tr>
						  <tr>
						 	 <th colspan='4' class='th-title' style='text-align: center; font-size: 10px;'>Reunião</th>
						  </tr>
						  <tr>
						     <th style='width: 35%'>Título</th>
							 <th style='width: 35%'>Descrição</th>
							 <th style='width: 15%;'>Data/Hora Inicial</th>
							 <th style='width: 15%;'>Data/Hora Final</th>
						  </tr>
					      </thead><tbody>";
				if (count($grupo['encontros']) > 0) {
					foreach ($grupo['encontros'] as $encontro) {
						$html .= "<tr>
											<td>$encontro[titulo]</td>
											<td>$encontro[descricao]</td>
											<td style=' text-align: center;'>" . date('d/m/Y H:i', strtotime($encontro['dt_inicio'])) . "</td>
											<td style=' text-align: center;'>" . date('d/m/Y H:i', strtotime($encontro['dt_final'])) . "</td>
										  </tr>";
					}
				} else {
					$html .= "<tr><td colspan='4'>Registros não encontrados!</td></tr>";
				}
			}
			$html .= "</tbody></table><br/></div>";
		} else {
			$html .= "<table class='tb-body'>
							<tr><th class='th-title'>Atividade Coletiva</th></tr>
							<tr><td>Registros não encontrados!</td></tr>
					  </table></div>";
		}
	}
	return $html;
}

try {
	switch ($tipo) {
		case 'atendimento_basico':
			die($sqlAtendimentoBasico);
			$PHPJasperXML->load_xml_file("RelatorioResumoGeralAtendBasico.jrxml");
			$PHPJasperXML->transferDBtoArray($server, $user, $pass, $db, "psql");
			$PHPJasperXML->outpage("I");
			break;
		case 'beneficios_ofertados':
			$PHPJasperXML->load_xml_file("RelatorioResumoGeralBeneficios.jrxml");
			$PHPJasperXML->transferDBtoArray($server, $user, $pass, $db, "psql");
			$PHPJasperXML->outpage("I");
			break;
		case 'atividade_coletiva':
			$PHPJasperXML->load_xml_file("RelatorioResumoGeralAtivCol.jrxml");
			$PHPJasperXML->transferDBtoArray($server, $user, $pass, $db, "psql");
			$PHPJasperXML->outpage("I");
			break;
		default:
			$filtro = [
				"dt_inicial" => $data_inicial,
				"dt_final" => $data_final
			];
			montaRelatorioGeral($filtro, $regSecretaria['nome_secretaria'], $regSecretaria['nome_cidade'], $rodape, $tipo_rel);
			break;
	}
} catch (Exception $e) {
	die("Erro ao gerar o relatório: \n" . $e->getMessage());
}
?>


