var baseUrl = 'WebSocialSocial/zf';
$(function () {
    var timerID = null;
    var timerRunning = false;

    function stopclock() {
        if (timerRunning)
            clearTimeout(timerID)
        timerRunning = false;
    }

    function startclock() {
        stopclock();
        showtime();
    }

    function showtime() {
        var now = new Date();
        var hours = now.getHours();
        var minutes = now.getMinutes();
        var seconds = now.getSeconds();
        var timeValue = "" + ((hours > 12) ? hours - 12 : hours);
        timeValue += ((minutes < 10) ? ":0" : ":") + minutes;
        timeValue += ((seconds < 10) ? ":0" : ":") + seconds;
        timeValue += (hours >= 12) ? " P.M." : " A.M.";
        document.clock.face.value = timeValue;
        timerID = setTimeout("showtime()", 1000);
        timerRunning = true;
    }

    function data() {
        hoje = new Date()
        dia = hoje.getDate()
        dias = hoje.getDay()
        mes = hoje.getMonth()
        ano = hoje.getFullYear();
        if (dia < 10)
            dia = "0" + dia

        function CriaArray(n) {
            this.length = n
        }

        NomeDia = new CriaArray(7)
        NomeDia[0] = "Domingo"
        NomeDia[1] = "Segunda-feira"
        NomeDia[2] = "Ter&ccedil;a-feira"
        NomeDia[3] = "Quarta-feira"
        NomeDia[4] = "Quinta-feira"
        NomeDia[5] = "Sexta-feira"
        NomeDia[6] = "S&aacute;bado"

        NomeMes = new CriaArray(12)
        NomeMes[0] = "Janeiro"
        NomeMes[1] = "Fevereiro"
        NomeMes[2] = "Mar&ccedil;o"
        NomeMes[3] = "Abril"
        NomeMes[4] = "Maio"
        NomeMes[5] = "Junho"
        NomeMes[6] = "Julho"
        NomeMes[7] = "Agosto"
        NomeMes[8] = "Setembro"
        NomeMes[9] = "Outubro"
        NomeMes[10] = "Novembro"
        NomeMes[11] = "Dezembro"

        document.write(NomeDia[dias] + ", " + dia + " de " + NomeMes[mes] + " de " + ano)
    }
});

function visualizaSenha(checkbox, input){
    $('#'+input).get(0).type = (checkbox.checked ? 'text' : 'password');
}

function mensagemSemOk(id, titulo, mensagem, x, y) {
    $("body").append("<div id=\"" + id + "\" title=\"" + titulo + "\"><div class=\"c\">" + mensagem + "</div>" + imgCarregando() + "</div>");
    $("#" + id).dialog({
        modal: true,
        position: ['center', 'center'],
        resizable: false,
        closeOnEscape: false,
        open: function (event, ui) {
            $('button.ui-dialog-titlebar-close').remove();
        },
        beforeClose: function () {
            return false
        }
    });
}

function fecharMensagemSemOk(id) {
    $("#" + id).remove();
}

function imgCarregando() {
    return "<div class='c'><img class='loading' src='../WebSocialComum/imgs/load.gif' alt='Carregando...' title='Carregando...' /></div>";
}

function mensagem(titulo, mensagem, x, y, callback) {
    $("body").append("<div id=\"mensagem-dialog\" title=\"" + titulo + "\">" + mensagem + "</div>")
    $("#mensagem-dialog").dialog({
        modal: true,
        width: x,
        height: y,
        position: 'top+25',
        closeOnEscape: false,
        open: function (event, ui) {
            $('button.ui-dialog-titlebar-close').remove();
        },
        buttons: {
            "Ok": {
                click: function () {
                    if (typeof(callback) != "undefined")
                        callback();
                    $(this).remove();
                },
                text: 'OK',
                class: 'btn btn-success'
            }
        }
    });
}