<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Acesso extends Elotech_Db_Table_Abstract {

    protected $_name = 'acesso';
    protected $_primary = 'ace_codigo';

    public function salvar(array $data) {
		//throw new Zend_Validate_Exception( "Este método ainda não possui validações", 1000);
        return parent::salvar($data);
    }
	

    public function buscar($term=false){
        $where = $this->select()
                      ->setIntegrityCheck(FALSE)
                      ->from("acesso",array("ace_codigo","ace_descricao"))
                      ->where("ace_descricao ilike '%$term%'")
                      ->order("ace_descricao");
        
        $all = $this->fetchAll($where);
        $out = array();
        foreach ($all as $ace) {
                $out [] = array(
                        "id" => $ace->ace_codigo,
                        "label" => $ace->ace_descricao,
                        "data" => $ace->toArray()
                );
        }
        if(empty($out)){
            $out [] = array("id"=>"","label"=>"Nenhum Item Encontrado");
        }
        return $out;
    }
  
    
    
    
    public function excluir($ace_codigo=FALSE) {
            $item = $this->fetchRow("ace_codigo=$ace_codigo");
            if ($item) {
                    $item->delete();
            }
    }
    
    public function getAcessos(){
        $where = $this->select(FALSE)
                      ->distinct()
                      ->setIntegrityCheck(FALSE)
                      ->from(array("a1"=>"acesso"),array("ace_descricao","ace_codigo","ace_pai","ace_caminho","ace_item_menu"))
                      ->joinLeft(array("a2"=>"acesso"),"a1.ace_pai = a2.ace_codigo",array("ace_descricao as ace_descricao_pai"))
                      ->order("a1.ace_codigo");
        return $this->fetchAll($where);
    }
    
    public function getAcesso($ace_codigo=FALSE,$ace_caminho=FALSE){
        $where = $this->select(FALSE)
                      ->distinct()
                      ->setIntegrityCheck(FALSE)
                      ->from(array("a1"=>"acesso"),array("ace_descricao","ace_codigo","ace_pai","ace_caminho","ace_item_menu"))
                      ->joinLeft(array("a2"=>"acesso"),"a1.ace_pai = a2.ace_codigo",array("ace_descricao as ace_descricao_pai"));
        
        if($ace_codigo)
            $where->where("a1.ace_codigo=$ace_codigo");
        
        if($ace_caminho)
            $where->where("a1.ace_caminho='$ace_caminho'");
            
        return $this->fetchRow($where);
    }
    
    public function verificaTodosVinculos($ace_codigo=FALSE){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("ace"=>"acesso"),"count(ace_codigo)")
                      ->joinLeft(array("acu"=>"acesso_usuarios"),"acu.ace_codigo=ace.ace_codigo","")
                      ->joinLeft(array("grap"=>"grupo_acesso_permissoes"),"grap.ace_codigo=ace.ace_codigo","")
                      ->where("ace_codigo=$ace_codigo");
        
        die($where);
        return $this->fetchRow($where);
    }
    
    public function pesquisar($dados=NULL){
        $where = $this->select(FALSE)
                      ->distinct()
                      ->setIntegrityCheck(FALSE)
                      ->from(array("a1"=>"acesso"),array("ace_descricao","ace_codigo","ace_pai","ace_caminho","ace_item_menu"))
                      ->joinLeft(array("a2"=>"acesso"),"a1.ace_pai = a2.ace_codigo",array("ace_descricao as ace_descricao_pai"))
                      ->order("a1.ace_codigo");
        
        if (is_string($dados)){
            $where->where("a1.ace_descricao ilike '%$dados%' or a2.ace_descricao ilike '%$dados%' or a1.ace_caminho ilike '%$dados%' ");
        }
        //die($where);
        return $this->fetchAll($where);
    }
    
    public function verificaAcesso($usr_codigo=FALSE,$ace_caminho=FALSE){
        if($usr_codigo){
            $where = $this->select(FALSE)
                          ->setIntegrityCheck(FALSE)
                          ->from(array("ace"=>"acesso"),"count(*) as qtde")
                          ->where("ace_codigo IN (SELECT ace_codigo 
                                                    FROM acesso_usuarios
                                                    WHERE usr_codigo = $usr_codigo)
                                   OR ace_codigo in (SELECT ace_codigo
                                                       FROM grupo_acesso ga
                                                       JOIN grupo_acesso_usuarios gau
                                                         ON ga.grac_codigo=gau.grac_codigo
                                                       JOIN grupo_acesso_permissoes gap
                                                         ON gap.grac_codigo = ga.grac_codigo
                                                      WHERE gau.usr_codigo = $usr_codigo)")
                          ->where("ace_caminho='$ace_caminho'");
            return $this->fetchRow($where);
        }else{
            return false;
        }
        
    }
}
