<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AcessoUsuarios extends Elotech_Db_Table_Abstract
{

    protected $_name = 'acesso_usuarios';
    protected $_primary = 'acu_codigo';

    public function salvar(array $data)
    {
        //throw new Zend_Validate_Exception( "Este método ainda não possui validações", 1000);
        return parent::salvar($data);
    }


    public function excluir($acu_codigo = FALSE)
    {
        $item = $this->fetchRow("acu_codigo=$acu_codigo");
        if ($item) {
            $item->delete();
        }
    }

    public function getPermissoesById($usr_codigo, $term = FALSE)
    {
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(["acu" => "acesso_usuarios"], "acu_codigo")
            ->join(["usr" => "usuarios"], "acu.usr_codigo = usr.usr_codigo", ["usr_codigo", "usr_nome"])
            ->join(["ace" => "acesso"], "acu.ace_codigo=ace.ace_codigo", ["ace_codigo", "ace_descricao", "ace_caminho"])
            ->where("acu.usr_codigo = $usr_codigo");
        if ($term) {
            $where->where("ace_descricao ILIKE '%$term%'");
        }
        $where->order("ace_descricao");
        return $this->fetchAll($where);
    }

}
