<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAspectosSociaisFamilia extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_aspectos_sociais_familia';
    protected $_primary = 'assofa_codigo';
    //protected $_sequence = 'seq_assofa_codigo';

    
         /**
    * Retorna a composição familiar do prontuário SUAS
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDadosComposicaoFamiliarHabitacional($aspsCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asps"=>"as_prontuario_suas"),array())
                    ->joinLeft(array("assofa"=>"as_aspectos_sociais_familia"),"asps.asps_codigo=assofa.asps_codigo")
                    ->joinLeft(array("conmoratu"=>"as_condicao_moradia_atual"),"asps.asps_codigo=conmoratu.asps_codigo",array())
                    ->joinLeft(array("asproc"=>"as_procedencia"),"asps.asps_codigo=asproc.asps_codigo",array())
                    ->joinLeft(array("aspsu"=>"as_prontuario_suas_usuario"),"asps.asps_codigo=aspsu.asps_codigo",array("aspsu_codigo","aspsu_parentesco","aspsu_num_ordem","aspsu_ativo"))
                    ->joinLeft(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_nome","usu_sexo","usu_datanasc","usu_asdoc_teprov",
                        "usu_asdeficiencia","usu_cpf","usu_asdoc_cnprov","usu_asdoc_rgprov","usu_asdoc_ctpsprov","usu_asdoc_cpfprov","usu_codigo",
                        "as_cond_ocupacao","as_possui_qualificacao","as_possui_qualificacao","as_possui_qualificacao_qual","as_renda_mensal",
                        "as_usu_alfabetizado","as_usu_estuda","as_usu_escolaridade","usu_as_aposentado","usu_as_bpc","usu_as_tipo_deficiencia","usu_as_cuidado_constante",
                        "usu_as_resp_cuidado","usu_as_doenca_grava","usu_as_remedio_controlado","usu_as_alcoolatra","usu_as_drogado"))
                    ->where("asps.asps_codigo =?",$aspsCodigo)
                    ->order("assofa.assofa_codigo DESC")
                    ->limit(1);
        return $this->fetchRow($sql);
    }
    
    /**
     * Salva os dados do atendimento básico
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToNull($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar Aspectos Sociais da Família: " . $ex->getMessage());
        }
    }

}
