<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentoBasicoCras extends Elotech_Db_Table_Abstract {

	protected $_name = 'as_atendimento_basicocras';
	protected $_primary = 'asab_codigo';
	protected $_sequence = 'seq_asab_codigo';

	/**
	 * Salva os dados do atendimento básico
	 */
	public function salvar($data) {
		try {
			// Limpando dados em branco
			$this->emptyToUnset($data);
			return parent::salvar($data);
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception(
				"Falha ao salvar Atendimento: " . $ex->getMessage());
		}
	}

	/**
	 * Retorna os dados dos atendimentos
	 */
	public function getDados($tipoUnidade, $usr_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asab" => "as_atendimento_basicocras"), array("asab_data", "asab_codigo"))
			->join(array("uni" => "unidade"), "asab.uni_codigo=uni.uni_codigo", array("uni_desc"))
			->join(array("usr" => "usuarios"), "asab.usr_codigo=usr.usr_codigo", array("usr_nome"))
			->join(array("usu" => "usuario"), "asab.usu_codigo=usu.usu_codigo", array("usu_nome"))
			->join(array("asat" => "as_atendimento_tipo"), "asab.asat_codigo=asat.asat_codigo", array("asat_nome"))
			->where("uni.uni_astipo = '$tipoUnidade'")
            ->where("usr.usr_codigo = $usr_codigo")
			->order("asab.asab_data DESC")
			->limit(500);
		return $this->fetchAll($sql);
	}

	/**
	 * Retorna os dados do atendimento por código
	 */
	public function getDadosPorId($asabCodigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asab" => "as_atendimento_basicocras"))
			->join(array("uni" => "unidade"), "asab.uni_codigo=uni.uni_codigo", array("uni_desc"))
			->join(array("usr" => "usuarios"), "asab.usr_codigo=usr.usr_codigo", array("usr_nome"))
			->join(array("usu" => "usuario"), "asab.usu_codigo=usu.usu_codigo", array("usu_nome"))
			->join(array("asat" => "as_atendimento_tipo"), "asab.asat_codigo=asat.asat_codigo", array("asat_nome", "asat_codigo"))
      ->where("asab.asab_codigo =?", $asabCodigo)
      ->order("asab.asab_data DESC");
		return $this->fetchRow($sql);
	}

    public function getDadosPorProntuarioSuas($aspsCodigo = FALSE) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asab" => "as_atendimento_basicocras"))
            ->join(array("uni" => "unidade"), "asab.uni_codigo=uni.uni_codigo", array("uni_desc"))
            ->join(array("usr" => "usuarios"), "asab.usr_codigo=usr.usr_codigo", array("usr_nome"))
            ->join(array("usu" => "usuario"), "asab.usu_codigo=usu.usu_codigo", array("usu_nome"))
            ->join(array("aspsu" => "as_prontuario_suas_usuario"), "aspsu.usu_codigo=usu.usu_codigo", "")
            ->join(array("asat" => "as_atendimento_tipo"), "asab.asat_codigo=asat.asat_codigo", array("asat_nome", "asat_codigo"))
            ->where("aspsu.asps_codigo =?", $aspsCodigo)
            ->order("asab.asab_data DESC");
        return $this->fetchAll($sql);
    }

	/**
	 * Exclui os dados do estabelecimento
	 * @return SQL
	 */
	public function excluir($aseCodigo = FALSE) {
		$item = $this->fetchRow("ase_codigo=$aseCodigo");
		if ($item)
			$item->delete();

		return true;
	}

	/**
	 * Retorna os dados dos atendimentos
	 * @return SQL
	 */
	public function pesquisaDados($busca = FALSE, $tipoUnidade, $usr_codigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asab" => "as_atendimento_basicocras"), array("asab_data", "asab_codigo"))
			->join(array("uni" => "unidade"), "asab.uni_codigo=uni.uni_codigo", array("uni_desc"))
			->join(array("usr" => "usuarios"), "asab.usr_codigo=usr.usr_codigo", array("usr_nome"))
			->join(array("usu" => "usuario"), "asab.usu_codigo=usu.usu_codigo", array("usu_nome"))
			->join(array("asat" => "as_atendimento_tipo"), "asab.asat_codigo=asat.asat_codigo", array("asat_nome"))
			->where("uni.uni_astipo = '$tipoUnidade'")
            ->where("usr.usr_codigo = $usr_codigo")
			->order("asab.asab_data DESC");

		$tbFun = new Application_Model_Funcoes();
		if ($tbFun->ValidaData($busca) == 1) {
			$sql->where("to_char(asab_data,'DD/MM/YYYY') ='$busca'");
		} else {
			$sql->where("uni.uni_desc ILIKE '%$busca%' OR usu.usu_nome ILIKE '%$busca%' OR usr.usr_nome ILIKE '%$busca%'");
		}

		return $this->fetchAll($sql);
  }

  public function getAtendimentoDaConcessaoDeBeneficio($asbd_codigo = false){

    if($asbd_codigo){
      return $this->fetchRow("asbd_codigo=$asbd_codigo");
    }else{
      return false;
    }
  }

}
